/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.synthetics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.synthetics.model.RunType;
import software.amazon.awssdk.services.synthetics.model.SyntheticsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCanaryRunsRequest
extends SyntheticsRequest
implements ToCopyableBuilder<Builder, GetCanaryRunsRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetCanaryRunsRequest.getter(GetCanaryRunsRequest::name)).setter(GetCanaryRunsRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetCanaryRunsRequest.getter(GetCanaryRunsRequest::nextToken)).setter(GetCanaryRunsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetCanaryRunsRequest.getter(GetCanaryRunsRequest::maxResults)).setter(GetCanaryRunsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> DRY_RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DryRunId").getter(GetCanaryRunsRequest.getter(GetCanaryRunsRequest::dryRunId)).setter(GetCanaryRunsRequest.setter(Builder::dryRunId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRunId").build()}).build();
    private static final SdkField<String> RUN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RunType").getter(GetCanaryRunsRequest.getter(GetCanaryRunsRequest::runTypeAsString)).setter(GetCanaryRunsRequest.setter(Builder::runType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, DRY_RUN_ID_FIELD, RUN_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetCanaryRunsRequest.memberNameToFieldInitializer();
    private final String name;
    private final String nextToken;
    private final Integer maxResults;
    private final String dryRunId;
    private final String runType;

    private GetCanaryRunsRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.dryRunId = builder.dryRunId;
        this.runType = builder.runType;
    }

    public final String name() {
        return this.name;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String dryRunId() {
        return this.dryRunId;
    }

    public final RunType runType() {
        return RunType.fromValue(this.runType);
    }

    public final String runTypeAsString() {
        return this.runType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRunId());
        hashCode = 31 * hashCode + Objects.hashCode(this.runTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCanaryRunsRequest)) {
            return false;
        }
        GetCanaryRunsRequest other = (GetCanaryRunsRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.dryRunId(), other.dryRunId()) && Objects.equals(this.runTypeAsString(), other.runTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetCanaryRunsRequest").add("Name", (Object)this.name()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("DryRunId", (Object)this.dryRunId()).add("RunType", (Object)this.runTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "DryRunId": {
                return Optional.ofNullable(clazz.cast(this.dryRunId()));
            }
            case "RunType": {
                return Optional.ofNullable(clazz.cast(this.runTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("DryRunId", DRY_RUN_ID_FIELD);
        map.put("RunType", RUN_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCanaryRunsRequest, T> g) {
        return obj -> g.apply((GetCanaryRunsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SyntheticsRequest.BuilderImpl
    implements Builder {
        private String name;
        private String nextToken;
        private Integer maxResults;
        private String dryRunId;
        private String runType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCanaryRunsRequest model) {
            super(model);
            this.name(model.name);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.dryRunId(model.dryRunId);
            this.runType(model.runType);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getDryRunId() {
            return this.dryRunId;
        }

        public final void setDryRunId(String dryRunId) {
            this.dryRunId = dryRunId;
        }

        @Override
        public final Builder dryRunId(String dryRunId) {
            this.dryRunId = dryRunId;
            return this;
        }

        public final String getRunType() {
            return this.runType;
        }

        public final void setRunType(String runType) {
            this.runType = runType;
        }

        @Override
        public final Builder runType(String runType) {
            this.runType = runType;
            return this;
        }

        @Override
        public final Builder runType(RunType runType) {
            this.runType(runType == null ? null : runType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCanaryRunsRequest build() {
            return new GetCanaryRunsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SyntheticsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCanaryRunsRequest> {
        public Builder name(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder dryRunId(String var1);

        public Builder runType(String var1);

        public Builder runType(RunType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

