/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.synthetics.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BrowserType {
    CHROME("CHROME"),
    FIREFOX("FIREFOX"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BrowserType> VALUE_MAP;
    private final String value;

    private BrowserType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BrowserType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BrowserType> knownValues() {
        EnumSet<BrowserType> knownValues = EnumSet.allOf(BrowserType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BrowserType.class, BrowserType::toString);
    }
}

