/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Additional tax information associated with your TRN in Kenya.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KenyaAdditionalInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<KenyaAdditionalInfo.Builder, KenyaAdditionalInfo> {
    private static final SdkField<String> PERSON_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("personType").getter(getter(KenyaAdditionalInfo::personTypeAsString)).setter(setter(Builder::personType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("personType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERSON_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String personType;

    private KenyaAdditionalInfo(BuilderImpl builder) {
        this.personType = builder.personType;
    }

    /**
     * <p>
     * The legal person or physical person assigned to this TRN in Kenya.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #personType} will
     * return {@link PersonType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #personTypeAsString}.
     * </p>
     * 
     * @return The legal person or physical person assigned to this TRN in Kenya.
     * @see PersonType
     */
    public final PersonType personType() {
        return PersonType.fromValue(personType);
    }

    /**
     * <p>
     * The legal person or physical person assigned to this TRN in Kenya.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #personType} will
     * return {@link PersonType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #personTypeAsString}.
     * </p>
     * 
     * @return The legal person or physical person assigned to this TRN in Kenya.
     * @see PersonType
     */
    public final String personTypeAsString() {
        return personType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(personTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KenyaAdditionalInfo)) {
            return false;
        }
        KenyaAdditionalInfo other = (KenyaAdditionalInfo) obj;
        return Objects.equals(personTypeAsString(), other.personTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KenyaAdditionalInfo").add("PersonType", personTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "personType":
            return Optional.ofNullable(clazz.cast(personTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KenyaAdditionalInfo, T> g) {
        return obj -> g.apply((KenyaAdditionalInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KenyaAdditionalInfo> {
        /**
         * <p>
         * The legal person or physical person assigned to this TRN in Kenya.
         * </p>
         * 
         * @param personType
         *        The legal person or physical person assigned to this TRN in Kenya.
         * @see PersonType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PersonType
         */
        Builder personType(String personType);

        /**
         * <p>
         * The legal person or physical person assigned to this TRN in Kenya.
         * </p>
         * 
         * @param personType
         *        The legal person or physical person assigned to this TRN in Kenya.
         * @see PersonType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PersonType
         */
        Builder personType(PersonType personType);
    }

    static final class BuilderImpl implements Builder {
        private String personType;

        private BuilderImpl() {
        }

        private BuilderImpl(KenyaAdditionalInfo model) {
            personType(model.personType);
        }

        public final String getPersonType() {
            return personType;
        }

        public final void setPersonType(String personType) {
            this.personType = personType;
        }

        @Override
        public final Builder personType(String personType) {
            this.personType = personType;
            return this;
        }

        @Override
        public final Builder personType(PersonType personType) {
            this.personType(personType == null ? null : personType.toString());
            return this;
        }

        @Override
        public KenyaAdditionalInfo build() {
            return new KenyaAdditionalInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
