/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Additional tax information associated with your TRN in Malaysia.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MalaysiaAdditionalInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<MalaysiaAdditionalInfo.Builder, MalaysiaAdditionalInfo> {
    private static final SdkField<List<String>> SERVICE_TAX_CODES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("serviceTaxCodes")
            .getter(getter(MalaysiaAdditionalInfo::serviceTaxCodesAsStrings))
            .setter(setter(Builder::serviceTaxCodesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceTaxCodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_TAX_CODES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> serviceTaxCodes;

    private MalaysiaAdditionalInfo(BuilderImpl builder) {
        this.serviceTaxCodes = builder.serviceTaxCodes;
    }

    /**
     * <p>
     * List of service tax codes for your TRN in Malaysia.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServiceTaxCodes} method.
     * </p>
     * 
     * @return List of service tax codes for your TRN in Malaysia.
     */
    public final List<MalaysiaServiceTaxCode> serviceTaxCodes() {
        return MalaysiaServiceTaxCodesListCopier.copyStringToEnum(serviceTaxCodes);
    }

    /**
     * For responses, this returns true if the service returned a value for the ServiceTaxCodes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasServiceTaxCodes() {
        return serviceTaxCodes != null && !(serviceTaxCodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of service tax codes for your TRN in Malaysia.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServiceTaxCodes} method.
     * </p>
     * 
     * @return List of service tax codes for your TRN in Malaysia.
     */
    public final List<String> serviceTaxCodesAsStrings() {
        return serviceTaxCodes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasServiceTaxCodes() ? serviceTaxCodesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MalaysiaAdditionalInfo)) {
            return false;
        }
        MalaysiaAdditionalInfo other = (MalaysiaAdditionalInfo) obj;
        return hasServiceTaxCodes() == other.hasServiceTaxCodes()
                && Objects.equals(serviceTaxCodesAsStrings(), other.serviceTaxCodesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MalaysiaAdditionalInfo")
                .add("ServiceTaxCodes", hasServiceTaxCodes() ? serviceTaxCodesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceTaxCodes":
            return Optional.ofNullable(clazz.cast(serviceTaxCodesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MalaysiaAdditionalInfo, T> g) {
        return obj -> g.apply((MalaysiaAdditionalInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MalaysiaAdditionalInfo> {
        /**
         * <p>
         * List of service tax codes for your TRN in Malaysia.
         * </p>
         * 
         * @param serviceTaxCodes
         *        List of service tax codes for your TRN in Malaysia.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceTaxCodesWithStrings(Collection<String> serviceTaxCodes);

        /**
         * <p>
         * List of service tax codes for your TRN in Malaysia.
         * </p>
         * 
         * @param serviceTaxCodes
         *        List of service tax codes for your TRN in Malaysia.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceTaxCodesWithStrings(String... serviceTaxCodes);

        /**
         * <p>
         * List of service tax codes for your TRN in Malaysia.
         * </p>
         * 
         * @param serviceTaxCodes
         *        List of service tax codes for your TRN in Malaysia.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceTaxCodes(Collection<MalaysiaServiceTaxCode> serviceTaxCodes);

        /**
         * <p>
         * List of service tax codes for your TRN in Malaysia.
         * </p>
         * 
         * @param serviceTaxCodes
         *        List of service tax codes for your TRN in Malaysia.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceTaxCodes(MalaysiaServiceTaxCode... serviceTaxCodes);
    }

    static final class BuilderImpl implements Builder {
        private List<String> serviceTaxCodes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MalaysiaAdditionalInfo model) {
            serviceTaxCodesWithStrings(model.serviceTaxCodes);
        }

        public final Collection<String> getServiceTaxCodes() {
            if (serviceTaxCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return serviceTaxCodes;
        }

        public final void setServiceTaxCodes(Collection<String> serviceTaxCodes) {
            this.serviceTaxCodes = MalaysiaServiceTaxCodesListCopier.copy(serviceTaxCodes);
        }

        @Override
        public final Builder serviceTaxCodesWithStrings(Collection<String> serviceTaxCodes) {
            this.serviceTaxCodes = MalaysiaServiceTaxCodesListCopier.copy(serviceTaxCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceTaxCodesWithStrings(String... serviceTaxCodes) {
            serviceTaxCodesWithStrings(Arrays.asList(serviceTaxCodes));
            return this;
        }

        @Override
        public final Builder serviceTaxCodes(Collection<MalaysiaServiceTaxCode> serviceTaxCodes) {
            this.serviceTaxCodes = MalaysiaServiceTaxCodesListCopier.copyEnumToString(serviceTaxCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceTaxCodes(MalaysiaServiceTaxCode... serviceTaxCodes) {
            serviceTaxCodes(Arrays.asList(serviceTaxCodes));
            return this;
        }

        @Override
        public MalaysiaAdditionalInfo build() {
            return new MalaysiaAdditionalInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
