/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Additional tax information associated with your TRN in Poland.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PolandAdditionalInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<PolandAdditionalInfo.Builder, PolandAdditionalInfo> {
    private static final SdkField<String> INDIVIDUAL_REGISTRATION_NUMBER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("individualRegistrationNumber")
            .getter(getter(PolandAdditionalInfo::individualRegistrationNumber))
            .setter(setter(Builder::individualRegistrationNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("individualRegistrationNumber")
                    .build()).build();

    private static final SdkField<Boolean> IS_GROUP_VAT_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isGroupVatEnabled").getter(getter(PolandAdditionalInfo::isGroupVatEnabled))
            .setter(setter(Builder::isGroupVatEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isGroupVatEnabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INDIVIDUAL_REGISTRATION_NUMBER_FIELD, IS_GROUP_VAT_ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String individualRegistrationNumber;

    private final Boolean isGroupVatEnabled;

    private PolandAdditionalInfo(BuilderImpl builder) {
        this.individualRegistrationNumber = builder.individualRegistrationNumber;
        this.isGroupVatEnabled = builder.isGroupVatEnabled;
    }

    /**
     * <p>
     * The individual tax registration number (NIP). Individual NIP is valid for other taxes excluding VAT purposes.
     * </p>
     * 
     * @return The individual tax registration number (NIP). Individual NIP is valid for other taxes excluding VAT
     *         purposes.
     */
    public final String individualRegistrationNumber() {
        return individualRegistrationNumber;
    }

    /**
     * <p>
     * True if your business is a member of a VAT group with a NIP active for VAT purposes. Otherwise, this is false.
     * </p>
     * 
     * @return True if your business is a member of a VAT group with a NIP active for VAT purposes. Otherwise, this is
     *         false.
     */
    public final Boolean isGroupVatEnabled() {
        return isGroupVatEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(individualRegistrationNumber());
        hashCode = 31 * hashCode + Objects.hashCode(isGroupVatEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolandAdditionalInfo)) {
            return false;
        }
        PolandAdditionalInfo other = (PolandAdditionalInfo) obj;
        return Objects.equals(individualRegistrationNumber(), other.individualRegistrationNumber())
                && Objects.equals(isGroupVatEnabled(), other.isGroupVatEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PolandAdditionalInfo").add("IndividualRegistrationNumber", individualRegistrationNumber())
                .add("IsGroupVatEnabled", isGroupVatEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "individualRegistrationNumber":
            return Optional.ofNullable(clazz.cast(individualRegistrationNumber()));
        case "isGroupVatEnabled":
            return Optional.ofNullable(clazz.cast(isGroupVatEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PolandAdditionalInfo, T> g) {
        return obj -> g.apply((PolandAdditionalInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PolandAdditionalInfo> {
        /**
         * <p>
         * The individual tax registration number (NIP). Individual NIP is valid for other taxes excluding VAT purposes.
         * </p>
         * 
         * @param individualRegistrationNumber
         *        The individual tax registration number (NIP). Individual NIP is valid for other taxes excluding VAT
         *        purposes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder individualRegistrationNumber(String individualRegistrationNumber);

        /**
         * <p>
         * True if your business is a member of a VAT group with a NIP active for VAT purposes. Otherwise, this is
         * false.
         * </p>
         * 
         * @param isGroupVatEnabled
         *        True if your business is a member of a VAT group with a NIP active for VAT purposes. Otherwise, this
         *        is false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isGroupVatEnabled(Boolean isGroupVatEnabled);
    }

    static final class BuilderImpl implements Builder {
        private String individualRegistrationNumber;

        private Boolean isGroupVatEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(PolandAdditionalInfo model) {
            individualRegistrationNumber(model.individualRegistrationNumber);
            isGroupVatEnabled(model.isGroupVatEnabled);
        }

        public final String getIndividualRegistrationNumber() {
            return individualRegistrationNumber;
        }

        public final void setIndividualRegistrationNumber(String individualRegistrationNumber) {
            this.individualRegistrationNumber = individualRegistrationNumber;
        }

        @Override
        public final Builder individualRegistrationNumber(String individualRegistrationNumber) {
            this.individualRegistrationNumber = individualRegistrationNumber;
            return this;
        }

        public final Boolean getIsGroupVatEnabled() {
            return isGroupVatEnabled;
        }

        public final void setIsGroupVatEnabled(Boolean isGroupVatEnabled) {
            this.isGroupVatEnabled = isGroupVatEnabled;
        }

        @Override
        public final Builder isGroupVatEnabled(Boolean isGroupVatEnabled) {
            this.isGroupVatEnabled = isGroupVatEnabled;
            return this;
        }

        @Override
        public PolandAdditionalInfo build() {
            return new PolandAdditionalInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
