/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Additional tax information associated with your TRN in Ukraine.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UkraineAdditionalInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<UkraineAdditionalInfo.Builder, UkraineAdditionalInfo> {
    private static final SdkField<String> UKRAINE_TRN_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ukraineTrnType").getter(getter(UkraineAdditionalInfo::ukraineTrnTypeAsString))
            .setter(setter(Builder::ukraineTrnType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ukraineTrnType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UKRAINE_TRN_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ukraineTrnType;

    private UkraineAdditionalInfo(BuilderImpl builder) {
        this.ukraineTrnType = builder.ukraineTrnType;
    }

    /**
     * <p>
     * The tax registration type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ukraineTrnType}
     * will return {@link UkraineTrnType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ukraineTrnTypeAsString}.
     * </p>
     * 
     * @return The tax registration type.
     * @see UkraineTrnType
     */
    public final UkraineTrnType ukraineTrnType() {
        return UkraineTrnType.fromValue(ukraineTrnType);
    }

    /**
     * <p>
     * The tax registration type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ukraineTrnType}
     * will return {@link UkraineTrnType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ukraineTrnTypeAsString}.
     * </p>
     * 
     * @return The tax registration type.
     * @see UkraineTrnType
     */
    public final String ukraineTrnTypeAsString() {
        return ukraineTrnType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ukraineTrnTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UkraineAdditionalInfo)) {
            return false;
        }
        UkraineAdditionalInfo other = (UkraineAdditionalInfo) obj;
        return Objects.equals(ukraineTrnTypeAsString(), other.ukraineTrnTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UkraineAdditionalInfo").add("UkraineTrnType", ukraineTrnTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ukraineTrnType":
            return Optional.ofNullable(clazz.cast(ukraineTrnTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UkraineAdditionalInfo, T> g) {
        return obj -> g.apply((UkraineAdditionalInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UkraineAdditionalInfo> {
        /**
         * <p>
         * The tax registration type.
         * </p>
         * 
         * @param ukraineTrnType
         *        The tax registration type.
         * @see UkraineTrnType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UkraineTrnType
         */
        Builder ukraineTrnType(String ukraineTrnType);

        /**
         * <p>
         * The tax registration type.
         * </p>
         * 
         * @param ukraineTrnType
         *        The tax registration type.
         * @see UkraineTrnType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UkraineTrnType
         */
        Builder ukraineTrnType(UkraineTrnType ukraineTrnType);
    }

    static final class BuilderImpl implements Builder {
        private String ukraineTrnType;

        private BuilderImpl() {
        }

        private BuilderImpl(UkraineAdditionalInfo model) {
            ukraineTrnType(model.ukraineTrnType);
        }

        public final String getUkraineTrnType() {
            return ukraineTrnType;
        }

        public final void setUkraineTrnType(String ukraineTrnType) {
            this.ukraineTrnType = ukraineTrnType;
        }

        @Override
        public final Builder ukraineTrnType(String ukraineTrnType) {
            this.ukraineTrnType = ukraineTrnType;
            return this;
        }

        @Override
        public final Builder ukraineTrnType(UkraineTrnType ukraineTrnType) {
            this.ukraineTrnType(ukraineTrnType == null ? null : ukraineTrnType.toString());
            return this;
        }

        @Override
        public UkraineAdditionalInfo build() {
            return new UkraineAdditionalInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
