/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Required information to verify your TRN.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VerificationDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<VerificationDetails.Builder, VerificationDetails> {
    private static final SdkField<String> DATE_OF_BIRTH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dateOfBirth").getter(getter(VerificationDetails::dateOfBirth)).setter(setter(Builder::dateOfBirth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateOfBirth").build()).build();

    private static final SdkField<List<TaxRegistrationDocument>> TAX_REGISTRATION_DOCUMENTS_FIELD = SdkField
            .<List<TaxRegistrationDocument>> builder(MarshallingType.LIST)
            .memberName("taxRegistrationDocuments")
            .getter(getter(VerificationDetails::taxRegistrationDocuments))
            .setter(setter(Builder::taxRegistrationDocuments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taxRegistrationDocuments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TaxRegistrationDocument> builder(MarshallingType.SDK_POJO)
                                            .constructor(TaxRegistrationDocument::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATE_OF_BIRTH_FIELD,
            TAX_REGISTRATION_DOCUMENTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dateOfBirth;

    private final List<TaxRegistrationDocument> taxRegistrationDocuments;

    private VerificationDetails(BuilderImpl builder) {
        this.dateOfBirth = builder.dateOfBirth;
        this.taxRegistrationDocuments = builder.taxRegistrationDocuments;
    }

    /**
     * <p>
     * Date of birth to verify your submitted TRN. Use the <code>YYYY-MM-DD</code> format.
     * </p>
     * 
     * @return Date of birth to verify your submitted TRN. Use the <code>YYYY-MM-DD</code> format.
     */
    public final String dateOfBirth() {
        return dateOfBirth;
    }

    /**
     * For responses, this returns true if the service returned a value for the TaxRegistrationDocuments property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTaxRegistrationDocuments() {
        return taxRegistrationDocuments != null && !(taxRegistrationDocuments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tax registration document, which is required for specific countries such as Bangladesh, Kenya, South Korea
     * and Spain.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTaxRegistrationDocuments} method.
     * </p>
     * 
     * @return The tax registration document, which is required for specific countries such as Bangladesh, Kenya, South
     *         Korea and Spain.
     */
    public final List<TaxRegistrationDocument> taxRegistrationDocuments() {
        return taxRegistrationDocuments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dateOfBirth());
        hashCode = 31 * hashCode + Objects.hashCode(hasTaxRegistrationDocuments() ? taxRegistrationDocuments() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerificationDetails)) {
            return false;
        }
        VerificationDetails other = (VerificationDetails) obj;
        return Objects.equals(dateOfBirth(), other.dateOfBirth())
                && hasTaxRegistrationDocuments() == other.hasTaxRegistrationDocuments()
                && Objects.equals(taxRegistrationDocuments(), other.taxRegistrationDocuments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VerificationDetails").add("DateOfBirth", dateOfBirth())
                .add("TaxRegistrationDocuments", hasTaxRegistrationDocuments() ? taxRegistrationDocuments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dateOfBirth":
            return Optional.ofNullable(clazz.cast(dateOfBirth()));
        case "taxRegistrationDocuments":
            return Optional.ofNullable(clazz.cast(taxRegistrationDocuments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VerificationDetails, T> g) {
        return obj -> g.apply((VerificationDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VerificationDetails> {
        /**
         * <p>
         * Date of birth to verify your submitted TRN. Use the <code>YYYY-MM-DD</code> format.
         * </p>
         * 
         * @param dateOfBirth
         *        Date of birth to verify your submitted TRN. Use the <code>YYYY-MM-DD</code> format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateOfBirth(String dateOfBirth);

        /**
         * <p>
         * The tax registration document, which is required for specific countries such as Bangladesh, Kenya, South
         * Korea and Spain.
         * </p>
         * 
         * @param taxRegistrationDocuments
         *        The tax registration document, which is required for specific countries such as Bangladesh, Kenya,
         *        South Korea and Spain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taxRegistrationDocuments(Collection<TaxRegistrationDocument> taxRegistrationDocuments);

        /**
         * <p>
         * The tax registration document, which is required for specific countries such as Bangladesh, Kenya, South
         * Korea and Spain.
         * </p>
         * 
         * @param taxRegistrationDocuments
         *        The tax registration document, which is required for specific countries such as Bangladesh, Kenya,
         *        South Korea and Spain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taxRegistrationDocuments(TaxRegistrationDocument... taxRegistrationDocuments);

        /**
         * <p>
         * The tax registration document, which is required for specific countries such as Bangladesh, Kenya, South
         * Korea and Spain.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.taxsettings.model.TaxRegistrationDocument.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.taxsettings.model.TaxRegistrationDocument#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.taxsettings.model.TaxRegistrationDocument.Builder#build()} is called
         * immediately and its result is passed to {@link #taxRegistrationDocuments(List<TaxRegistrationDocument>)}.
         * 
         * @param taxRegistrationDocuments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.taxsettings.model.TaxRegistrationDocument.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taxRegistrationDocuments(java.util.Collection<TaxRegistrationDocument>)
         */
        Builder taxRegistrationDocuments(Consumer<TaxRegistrationDocument.Builder>... taxRegistrationDocuments);
    }

    static final class BuilderImpl implements Builder {
        private String dateOfBirth;

        private List<TaxRegistrationDocument> taxRegistrationDocuments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VerificationDetails model) {
            dateOfBirth(model.dateOfBirth);
            taxRegistrationDocuments(model.taxRegistrationDocuments);
        }

        public final String getDateOfBirth() {
            return dateOfBirth;
        }

        public final void setDateOfBirth(String dateOfBirth) {
            this.dateOfBirth = dateOfBirth;
        }

        @Override
        public final Builder dateOfBirth(String dateOfBirth) {
            this.dateOfBirth = dateOfBirth;
            return this;
        }

        public final List<TaxRegistrationDocument.Builder> getTaxRegistrationDocuments() {
            List<TaxRegistrationDocument.Builder> result = TaxRegistrationDocumentsCopier
                    .copyToBuilder(this.taxRegistrationDocuments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTaxRegistrationDocuments(Collection<TaxRegistrationDocument.BuilderImpl> taxRegistrationDocuments) {
            this.taxRegistrationDocuments = TaxRegistrationDocumentsCopier.copyFromBuilder(taxRegistrationDocuments);
        }

        @Override
        public final Builder taxRegistrationDocuments(Collection<TaxRegistrationDocument> taxRegistrationDocuments) {
            this.taxRegistrationDocuments = TaxRegistrationDocumentsCopier.copy(taxRegistrationDocuments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taxRegistrationDocuments(TaxRegistrationDocument... taxRegistrationDocuments) {
            taxRegistrationDocuments(Arrays.asList(taxRegistrationDocuments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taxRegistrationDocuments(Consumer<TaxRegistrationDocument.Builder>... taxRegistrationDocuments) {
            taxRegistrationDocuments(Stream.of(taxRegistrationDocuments)
                    .map(c -> TaxRegistrationDocument.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public VerificationDetails build() {
            return new VerificationDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
