/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The meta data information associated with the account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountMetaData implements SdkPojo, Serializable, ToCopyableBuilder<AccountMetaData.Builder, AccountMetaData> {
    private static final SdkField<String> ACCOUNT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountName").getter(getter(AccountMetaData::accountName)).setter(setter(Builder::accountName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountName").build()).build();

    private static final SdkField<Address> ADDRESS_FIELD = SdkField.<Address> builder(MarshallingType.SDK_POJO)
            .memberName("address").getter(getter(AccountMetaData::address)).setter(setter(Builder::address))
            .constructor(Address::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("address").build()).build();

    private static final SdkField<Map<String, Jurisdiction>> ADDRESS_ROLE_MAP_FIELD = SdkField
            .<Map<String, Jurisdiction>> builder(MarshallingType.MAP)
            .memberName("addressRoleMap")
            .getter(getter(AccountMetaData::addressRoleMapAsStrings))
            .setter(setter(Builder::addressRoleMapWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addressRoleMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Jurisdiction> builder(MarshallingType.SDK_POJO)
                                            .constructor(Jurisdiction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ADDRESS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("addressType").getter(getter(AccountMetaData::addressTypeAsString)).setter(setter(Builder::addressType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addressType").build()).build();

    private static final SdkField<String> SELLER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("seller")
            .getter(getter(AccountMetaData::seller)).setter(setter(Builder::seller))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("seller").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_NAME_FIELD,
            ADDRESS_FIELD, ADDRESS_ROLE_MAP_FIELD, ADDRESS_TYPE_FIELD, SELLER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountName;

    private final Address address;

    private final Map<String, Jurisdiction> addressRoleMap;

    private final String addressType;

    private final String seller;

    private AccountMetaData(BuilderImpl builder) {
        this.accountName = builder.accountName;
        this.address = builder.address;
        this.addressRoleMap = builder.addressRoleMap;
        this.addressType = builder.addressType;
        this.seller = builder.seller;
    }

    /**
     * <p>
     * The Amazon Web Services accounts name.
     * </p>
     * 
     * @return The Amazon Web Services accounts name.
     */
    public final String accountName() {
        return accountName;
    }

    /**
     * Returns the value of the Address property for this object.
     * 
     * @return The value of the Address property for this object.
     */
    public final Address address() {
        return address;
    }

    /**
     * <p>
     * Address roles associated with the account containing country code information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddressRoleMap} method.
     * </p>
     * 
     * @return Address roles associated with the account containing country code information.
     */
    public final Map<AddressRoleType, Jurisdiction> addressRoleMap() {
        return AddressRoleMapCopier.copyStringToEnum(addressRoleMap);
    }

    /**
     * For responses, this returns true if the service returned a value for the AddressRoleMap property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAddressRoleMap() {
        return addressRoleMap != null && !(addressRoleMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Address roles associated with the account containing country code information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddressRoleMap} method.
     * </p>
     * 
     * @return Address roles associated with the account containing country code information.
     */
    public final Map<String, Jurisdiction> addressRoleMapAsStrings() {
        return addressRoleMap;
    }

    /**
     * <p>
     * The type of address associated with the legal profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #addressType} will
     * return {@link AddressRoleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #addressTypeAsString}.
     * </p>
     * 
     * @return The type of address associated with the legal profile.
     * @see AddressRoleType
     */
    public final AddressRoleType addressType() {
        return AddressRoleType.fromValue(addressType);
    }

    /**
     * <p>
     * The type of address associated with the legal profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #addressType} will
     * return {@link AddressRoleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #addressTypeAsString}.
     * </p>
     * 
     * @return The type of address associated with the legal profile.
     * @see AddressRoleType
     */
    public final String addressTypeAsString() {
        return addressType;
    }

    /**
     * <p>
     * Seller information associated with the account.
     * </p>
     * 
     * @return Seller information associated with the account.
     */
    public final String seller() {
        return seller;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountName());
        hashCode = 31 * hashCode + Objects.hashCode(address());
        hashCode = 31 * hashCode + Objects.hashCode(hasAddressRoleMap() ? addressRoleMapAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(addressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(seller());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountMetaData)) {
            return false;
        }
        AccountMetaData other = (AccountMetaData) obj;
        return Objects.equals(accountName(), other.accountName()) && Objects.equals(address(), other.address())
                && hasAddressRoleMap() == other.hasAddressRoleMap()
                && Objects.equals(addressRoleMapAsStrings(), other.addressRoleMapAsStrings())
                && Objects.equals(addressTypeAsString(), other.addressTypeAsString()) && Objects.equals(seller(), other.seller());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountMetaData").add("AccountName", accountName()).add("Address", address())
                .add("AddressRoleMap", hasAddressRoleMap() ? addressRoleMapAsStrings() : null)
                .add("AddressType", addressTypeAsString()).add("Seller", seller()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountName":
            return Optional.ofNullable(clazz.cast(accountName()));
        case "address":
            return Optional.ofNullable(clazz.cast(address()));
        case "addressRoleMap":
            return Optional.ofNullable(clazz.cast(addressRoleMapAsStrings()));
        case "addressType":
            return Optional.ofNullable(clazz.cast(addressTypeAsString()));
        case "seller":
            return Optional.ofNullable(clazz.cast(seller()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccountMetaData, T> g) {
        return obj -> g.apply((AccountMetaData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountMetaData> {
        /**
         * <p>
         * The Amazon Web Services accounts name.
         * </p>
         * 
         * @param accountName
         *        The Amazon Web Services accounts name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountName(String accountName);

        /**
         * Sets the value of the Address property for this object.
         *
         * @param address
         *        The new value for the Address property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(Address address);

        /**
         * Sets the value of the Address property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Address.Builder} avoiding the need to
         * create one manually via {@link Address#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Address.Builder#build()} is called immediately and its result is
         * passed to {@link #address(Address)}.
         * 
         * @param address
         *        a consumer that will call methods on {@link Address.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #address(Address)
         */
        default Builder address(Consumer<Address.Builder> address) {
            return address(Address.builder().applyMutation(address).build());
        }

        /**
         * <p>
         * Address roles associated with the account containing country code information.
         * </p>
         * 
         * @param addressRoleMap
         *        Address roles associated with the account containing country code information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressRoleMapWithStrings(Map<String, Jurisdiction> addressRoleMap);

        /**
         * <p>
         * Address roles associated with the account containing country code information.
         * </p>
         * 
         * @param addressRoleMap
         *        Address roles associated with the account containing country code information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressRoleMap(Map<AddressRoleType, Jurisdiction> addressRoleMap);

        /**
         * <p>
         * The type of address associated with the legal profile.
         * </p>
         * 
         * @param addressType
         *        The type of address associated with the legal profile.
         * @see AddressRoleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AddressRoleType
         */
        Builder addressType(String addressType);

        /**
         * <p>
         * The type of address associated with the legal profile.
         * </p>
         * 
         * @param addressType
         *        The type of address associated with the legal profile.
         * @see AddressRoleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AddressRoleType
         */
        Builder addressType(AddressRoleType addressType);

        /**
         * <p>
         * Seller information associated with the account.
         * </p>
         * 
         * @param seller
         *        Seller information associated with the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder seller(String seller);
    }

    static final class BuilderImpl implements Builder {
        private String accountName;

        private Address address;

        private Map<String, Jurisdiction> addressRoleMap = DefaultSdkAutoConstructMap.getInstance();

        private String addressType;

        private String seller;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountMetaData model) {
            accountName(model.accountName);
            address(model.address);
            addressRoleMapWithStrings(model.addressRoleMap);
            addressType(model.addressType);
            seller(model.seller);
        }

        public final String getAccountName() {
            return accountName;
        }

        public final void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        @Override
        public final Builder accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        public final Address.Builder getAddress() {
            return address != null ? address.toBuilder() : null;
        }

        public final void setAddress(Address.BuilderImpl address) {
            this.address = address != null ? address.build() : null;
        }

        @Override
        public final Builder address(Address address) {
            this.address = address;
            return this;
        }

        public final Map<String, Jurisdiction.Builder> getAddressRoleMap() {
            Map<String, Jurisdiction.Builder> result = AddressRoleMapCopier.copyToBuilder(this.addressRoleMap);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAddressRoleMap(Map<String, Jurisdiction.BuilderImpl> addressRoleMap) {
            this.addressRoleMap = AddressRoleMapCopier.copyFromBuilder(addressRoleMap);
        }

        @Override
        public final Builder addressRoleMapWithStrings(Map<String, Jurisdiction> addressRoleMap) {
            this.addressRoleMap = AddressRoleMapCopier.copy(addressRoleMap);
            return this;
        }

        @Override
        public final Builder addressRoleMap(Map<AddressRoleType, Jurisdiction> addressRoleMap) {
            this.addressRoleMap = AddressRoleMapCopier.copyEnumToString(addressRoleMap);
            return this;
        }

        public final String getAddressType() {
            return addressType;
        }

        public final void setAddressType(String addressType) {
            this.addressType = addressType;
        }

        @Override
        public final Builder addressType(String addressType) {
            this.addressType = addressType;
            return this;
        }

        @Override
        public final Builder addressType(AddressRoleType addressType) {
            this.addressType(addressType == null ? null : addressType.toString());
            return this;
        }

        public final String getSeller() {
            return seller;
        }

        public final void setSeller(String seller) {
            this.seller = seller;
        }

        @Override
        public final Builder seller(String seller) {
            this.seller = seller;
            return this;
        }

        @Override
        public AccountMetaData build() {
            return new AccountMetaData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
