/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Additional tax information associated with your TRN. The Tax Settings API returns country-specific information in the
 * response when any additional information is present with your TRN for the following countries.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdditionalInfoResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<AdditionalInfoResponse.Builder, AdditionalInfoResponse> {
    private static final SdkField<BrazilAdditionalInfo> BRAZIL_ADDITIONAL_INFO_FIELD = SdkField
            .<BrazilAdditionalInfo> builder(MarshallingType.SDK_POJO).memberName("brazilAdditionalInfo")
            .getter(getter(AdditionalInfoResponse::brazilAdditionalInfo)).setter(setter(Builder::brazilAdditionalInfo))
            .constructor(BrazilAdditionalInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brazilAdditionalInfo").build())
            .build();

    private static final SdkField<CanadaAdditionalInfo> CANADA_ADDITIONAL_INFO_FIELD = SdkField
            .<CanadaAdditionalInfo> builder(MarshallingType.SDK_POJO).memberName("canadaAdditionalInfo")
            .getter(getter(AdditionalInfoResponse::canadaAdditionalInfo)).setter(setter(Builder::canadaAdditionalInfo))
            .constructor(CanadaAdditionalInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canadaAdditionalInfo").build())
            .build();

    private static final SdkField<EstoniaAdditionalInfo> ESTONIA_ADDITIONAL_INFO_FIELD = SdkField
            .<EstoniaAdditionalInfo> builder(MarshallingType.SDK_POJO).memberName("estoniaAdditionalInfo")
            .getter(getter(AdditionalInfoResponse::estoniaAdditionalInfo)).setter(setter(Builder::estoniaAdditionalInfo))
            .constructor(EstoniaAdditionalInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estoniaAdditionalInfo").build())
            .build();

    private static final SdkField<GeorgiaAdditionalInfo> GEORGIA_ADDITIONAL_INFO_FIELD = SdkField
            .<GeorgiaAdditionalInfo> builder(MarshallingType.SDK_POJO).memberName("georgiaAdditionalInfo")
            .getter(getter(AdditionalInfoResponse::georgiaAdditionalInfo)).setter(setter(Builder::georgiaAdditionalInfo))
            .constructor(GeorgiaAdditionalInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("georgiaAdditionalInfo").build())
            .build();

    private static final SdkField<IndiaAdditionalInfo> INDIA_ADDITIONAL_INFO_FIELD = SdkField
            .<IndiaAdditionalInfo> builder(MarshallingType.SDK_POJO).memberName("indiaAdditionalInfo")
            .getter(getter(AdditionalInfoResponse::indiaAdditionalInfo)).setter(setter(Builder::indiaAdditionalInfo))
            .constructor(IndiaAdditionalInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indiaAdditionalInfo").build())
            .build();

    private static final SdkField<IsraelAdditionalInfo> ISRAEL_ADDITIONAL_INFO_FIELD = SdkField
            .<IsraelAdditionalInfo> builder(MarshallingType.SDK_POJO).memberName("israelAdditionalInfo")
            .getter(getter(AdditionalInfoResponse::israelAdditionalInfo)).setter(setter(Builder::israelAdditionalInfo))
            .constructor(IsraelAdditionalInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("israelAdditionalInfo").build())
            .build();

    private static final SdkField<ItalyAdditionalInfo> ITALY_ADDITIONAL_INFO_FIELD = SdkField
            .<ItalyAdditionalInfo> builder(MarshallingType.SDK_POJO).memberName("italyAdditionalInfo")
            .getter(getter(AdditionalInfoResponse::italyAdditionalInfo)).setter(setter(Builder::italyAdditionalInfo))
            .constructor(ItalyAdditionalInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("italyAdditionalInfo").build())
            .build();

    private static final SdkField<KenyaAdditionalInfo> KENYA_ADDITIONAL_INFO_FIELD = SdkField
            .<KenyaAdditionalInfo> builder(MarshallingType.SDK_POJO).memberName("kenyaAdditionalInfo")
            .getter(getter(AdditionalInfoResponse::kenyaAdditionalInfo)).setter(setter(Builder::kenyaAdditionalInfo))
            .constructor(KenyaAdditionalInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kenyaAdditionalInfo").build())
            .build();

    private static final SdkField<MalaysiaAdditionalInfo> MALAYSIA_ADDITIONAL_INFO_FIELD = SdkField
            .<MalaysiaAdditionalInfo> builder(MarshallingType.SDK_POJO).memberName("malaysiaAdditionalInfo")
            .getter(getter(AdditionalInfoResponse::malaysiaAdditionalInfo)).setter(setter(Builder::malaysiaAdditionalInfo))
            .constructor(MalaysiaAdditionalInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("malaysiaAdditionalInfo").build())
            .build();

    private static final SdkField<PolandAdditionalInfo> POLAND_ADDITIONAL_INFO_FIELD = SdkField
            .<PolandAdditionalInfo> builder(MarshallingType.SDK_POJO).memberName("polandAdditionalInfo")
            .getter(getter(AdditionalInfoResponse::polandAdditionalInfo)).setter(setter(Builder::polandAdditionalInfo))
            .constructor(PolandAdditionalInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("polandAdditionalInfo").build())
            .build();

    private static final SdkField<RomaniaAdditionalInfo> ROMANIA_ADDITIONAL_INFO_FIELD = SdkField
            .<RomaniaAdditionalInfo> builder(MarshallingType.SDK_POJO).memberName("romaniaAdditionalInfo")
            .getter(getter(AdditionalInfoResponse::romaniaAdditionalInfo)).setter(setter(Builder::romaniaAdditionalInfo))
            .constructor(RomaniaAdditionalInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("romaniaAdditionalInfo").build())
            .build();

    private static final SdkField<SaudiArabiaAdditionalInfo> SAUDI_ARABIA_ADDITIONAL_INFO_FIELD = SdkField
            .<SaudiArabiaAdditionalInfo> builder(MarshallingType.SDK_POJO).memberName("saudiArabiaAdditionalInfo")
            .getter(getter(AdditionalInfoResponse::saudiArabiaAdditionalInfo)).setter(setter(Builder::saudiArabiaAdditionalInfo))
            .constructor(SaudiArabiaAdditionalInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("saudiArabiaAdditionalInfo").build())
            .build();

    private static final SdkField<SouthKoreaAdditionalInfo> SOUTH_KOREA_ADDITIONAL_INFO_FIELD = SdkField
            .<SouthKoreaAdditionalInfo> builder(MarshallingType.SDK_POJO).memberName("southKoreaAdditionalInfo")
            .getter(getter(AdditionalInfoResponse::southKoreaAdditionalInfo)).setter(setter(Builder::southKoreaAdditionalInfo))
            .constructor(SouthKoreaAdditionalInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("southKoreaAdditionalInfo").build())
            .build();

    private static final SdkField<SpainAdditionalInfo> SPAIN_ADDITIONAL_INFO_FIELD = SdkField
            .<SpainAdditionalInfo> builder(MarshallingType.SDK_POJO).memberName("spainAdditionalInfo")
            .getter(getter(AdditionalInfoResponse::spainAdditionalInfo)).setter(setter(Builder::spainAdditionalInfo))
            .constructor(SpainAdditionalInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spainAdditionalInfo").build())
            .build();

    private static final SdkField<TurkeyAdditionalInfo> TURKEY_ADDITIONAL_INFO_FIELD = SdkField
            .<TurkeyAdditionalInfo> builder(MarshallingType.SDK_POJO).memberName("turkeyAdditionalInfo")
            .getter(getter(AdditionalInfoResponse::turkeyAdditionalInfo)).setter(setter(Builder::turkeyAdditionalInfo))
            .constructor(TurkeyAdditionalInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("turkeyAdditionalInfo").build())
            .build();

    private static final SdkField<UkraineAdditionalInfo> UKRAINE_ADDITIONAL_INFO_FIELD = SdkField
            .<UkraineAdditionalInfo> builder(MarshallingType.SDK_POJO).memberName("ukraineAdditionalInfo")
            .getter(getter(AdditionalInfoResponse::ukraineAdditionalInfo)).setter(setter(Builder::ukraineAdditionalInfo))
            .constructor(UkraineAdditionalInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ukraineAdditionalInfo").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRAZIL_ADDITIONAL_INFO_FIELD,
            CANADA_ADDITIONAL_INFO_FIELD, ESTONIA_ADDITIONAL_INFO_FIELD, GEORGIA_ADDITIONAL_INFO_FIELD,
            INDIA_ADDITIONAL_INFO_FIELD, ISRAEL_ADDITIONAL_INFO_FIELD, ITALY_ADDITIONAL_INFO_FIELD, KENYA_ADDITIONAL_INFO_FIELD,
            MALAYSIA_ADDITIONAL_INFO_FIELD, POLAND_ADDITIONAL_INFO_FIELD, ROMANIA_ADDITIONAL_INFO_FIELD,
            SAUDI_ARABIA_ADDITIONAL_INFO_FIELD, SOUTH_KOREA_ADDITIONAL_INFO_FIELD, SPAIN_ADDITIONAL_INFO_FIELD,
            TURKEY_ADDITIONAL_INFO_FIELD, UKRAINE_ADDITIONAL_INFO_FIELD));

    private static final long serialVersionUID = 1L;

    private final BrazilAdditionalInfo brazilAdditionalInfo;

    private final CanadaAdditionalInfo canadaAdditionalInfo;

    private final EstoniaAdditionalInfo estoniaAdditionalInfo;

    private final GeorgiaAdditionalInfo georgiaAdditionalInfo;

    private final IndiaAdditionalInfo indiaAdditionalInfo;

    private final IsraelAdditionalInfo israelAdditionalInfo;

    private final ItalyAdditionalInfo italyAdditionalInfo;

    private final KenyaAdditionalInfo kenyaAdditionalInfo;

    private final MalaysiaAdditionalInfo malaysiaAdditionalInfo;

    private final PolandAdditionalInfo polandAdditionalInfo;

    private final RomaniaAdditionalInfo romaniaAdditionalInfo;

    private final SaudiArabiaAdditionalInfo saudiArabiaAdditionalInfo;

    private final SouthKoreaAdditionalInfo southKoreaAdditionalInfo;

    private final SpainAdditionalInfo spainAdditionalInfo;

    private final TurkeyAdditionalInfo turkeyAdditionalInfo;

    private final UkraineAdditionalInfo ukraineAdditionalInfo;

    private AdditionalInfoResponse(BuilderImpl builder) {
        this.brazilAdditionalInfo = builder.brazilAdditionalInfo;
        this.canadaAdditionalInfo = builder.canadaAdditionalInfo;
        this.estoniaAdditionalInfo = builder.estoniaAdditionalInfo;
        this.georgiaAdditionalInfo = builder.georgiaAdditionalInfo;
        this.indiaAdditionalInfo = builder.indiaAdditionalInfo;
        this.israelAdditionalInfo = builder.israelAdditionalInfo;
        this.italyAdditionalInfo = builder.italyAdditionalInfo;
        this.kenyaAdditionalInfo = builder.kenyaAdditionalInfo;
        this.malaysiaAdditionalInfo = builder.malaysiaAdditionalInfo;
        this.polandAdditionalInfo = builder.polandAdditionalInfo;
        this.romaniaAdditionalInfo = builder.romaniaAdditionalInfo;
        this.saudiArabiaAdditionalInfo = builder.saudiArabiaAdditionalInfo;
        this.southKoreaAdditionalInfo = builder.southKoreaAdditionalInfo;
        this.spainAdditionalInfo = builder.spainAdditionalInfo;
        this.turkeyAdditionalInfo = builder.turkeyAdditionalInfo;
        this.ukraineAdditionalInfo = builder.ukraineAdditionalInfo;
    }

    /**
     * <p>
     * Additional tax information associated with your TRN in Brazil. The Tax Settings API returns this information in
     * your response when any additional information is present with your TRN in Brazil.
     * </p>
     * 
     * @return Additional tax information associated with your TRN in Brazil. The Tax Settings API returns this
     *         information in your response when any additional information is present with your TRN in Brazil.
     */
    public final BrazilAdditionalInfo brazilAdditionalInfo() {
        return brazilAdditionalInfo;
    }

    /**
     * <p>
     * Additional tax information associated with your TRN in Canada.
     * </p>
     * 
     * @return Additional tax information associated with your TRN in Canada.
     */
    public final CanadaAdditionalInfo canadaAdditionalInfo() {
        return canadaAdditionalInfo;
    }

    /**
     * <p>
     * Additional tax information associated with your TRN in Estonia.
     * </p>
     * 
     * @return Additional tax information associated with your TRN in Estonia.
     */
    public final EstoniaAdditionalInfo estoniaAdditionalInfo() {
        return estoniaAdditionalInfo;
    }

    /**
     * <p>
     * Additional tax information associated with your TRN in Georgia.
     * </p>
     * 
     * @return Additional tax information associated with your TRN in Georgia.
     */
    public final GeorgiaAdditionalInfo georgiaAdditionalInfo() {
        return georgiaAdditionalInfo;
    }

    /**
     * <p>
     * Additional tax information in India.
     * </p>
     * 
     * @return Additional tax information in India.
     */
    public final IndiaAdditionalInfo indiaAdditionalInfo() {
        return indiaAdditionalInfo;
    }

    /**
     * <p>
     * Additional tax information associated with your TRN in Israel.
     * </p>
     * 
     * @return Additional tax information associated with your TRN in Israel.
     */
    public final IsraelAdditionalInfo israelAdditionalInfo() {
        return israelAdditionalInfo;
    }

    /**
     * <p>
     * Additional tax information associated with your TRN in Italy.
     * </p>
     * 
     * @return Additional tax information associated with your TRN in Italy.
     */
    public final ItalyAdditionalInfo italyAdditionalInfo() {
        return italyAdditionalInfo;
    }

    /**
     * <p>
     * Additional tax information associated with your TRN in Kenya.
     * </p>
     * 
     * @return Additional tax information associated with your TRN in Kenya.
     */
    public final KenyaAdditionalInfo kenyaAdditionalInfo() {
        return kenyaAdditionalInfo;
    }

    /**
     * <p>
     * Additional tax information associated with your TRN in Malaysia.
     * </p>
     * 
     * @return Additional tax information associated with your TRN in Malaysia.
     */
    public final MalaysiaAdditionalInfo malaysiaAdditionalInfo() {
        return malaysiaAdditionalInfo;
    }

    /**
     * <p>
     * Additional tax information associated with your TRN in Poland.
     * </p>
     * 
     * @return Additional tax information associated with your TRN in Poland.
     */
    public final PolandAdditionalInfo polandAdditionalInfo() {
        return polandAdditionalInfo;
    }

    /**
     * <p>
     * Additional tax information to specify for a TRN in Romania.
     * </p>
     * 
     * @return Additional tax information to specify for a TRN in Romania.
     */
    public final RomaniaAdditionalInfo romaniaAdditionalInfo() {
        return romaniaAdditionalInfo;
    }

    /**
     * <p>
     * Additional tax information associated with your TRN in Saudi Arabia.
     * </p>
     * 
     * @return Additional tax information associated with your TRN in Saudi Arabia.
     */
    public final SaudiArabiaAdditionalInfo saudiArabiaAdditionalInfo() {
        return saudiArabiaAdditionalInfo;
    }

    /**
     * <p>
     * Additional tax information associated with your TRN in South Korea.
     * </p>
     * 
     * @return Additional tax information associated with your TRN in South Korea.
     */
    public final SouthKoreaAdditionalInfo southKoreaAdditionalInfo() {
        return southKoreaAdditionalInfo;
    }

    /**
     * <p>
     * Additional tax information associated with your TRN in Spain.
     * </p>
     * 
     * @return Additional tax information associated with your TRN in Spain.
     */
    public final SpainAdditionalInfo spainAdditionalInfo() {
        return spainAdditionalInfo;
    }

    /**
     * <p>
     * Additional tax information associated with your TRN in Turkey.
     * </p>
     * 
     * @return Additional tax information associated with your TRN in Turkey.
     */
    public final TurkeyAdditionalInfo turkeyAdditionalInfo() {
        return turkeyAdditionalInfo;
    }

    /**
     * <p>
     * Additional tax information associated with your TRN in Ukraine.
     * </p>
     * 
     * @return Additional tax information associated with your TRN in Ukraine.
     */
    public final UkraineAdditionalInfo ukraineAdditionalInfo() {
        return ukraineAdditionalInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(brazilAdditionalInfo());
        hashCode = 31 * hashCode + Objects.hashCode(canadaAdditionalInfo());
        hashCode = 31 * hashCode + Objects.hashCode(estoniaAdditionalInfo());
        hashCode = 31 * hashCode + Objects.hashCode(georgiaAdditionalInfo());
        hashCode = 31 * hashCode + Objects.hashCode(indiaAdditionalInfo());
        hashCode = 31 * hashCode + Objects.hashCode(israelAdditionalInfo());
        hashCode = 31 * hashCode + Objects.hashCode(italyAdditionalInfo());
        hashCode = 31 * hashCode + Objects.hashCode(kenyaAdditionalInfo());
        hashCode = 31 * hashCode + Objects.hashCode(malaysiaAdditionalInfo());
        hashCode = 31 * hashCode + Objects.hashCode(polandAdditionalInfo());
        hashCode = 31 * hashCode + Objects.hashCode(romaniaAdditionalInfo());
        hashCode = 31 * hashCode + Objects.hashCode(saudiArabiaAdditionalInfo());
        hashCode = 31 * hashCode + Objects.hashCode(southKoreaAdditionalInfo());
        hashCode = 31 * hashCode + Objects.hashCode(spainAdditionalInfo());
        hashCode = 31 * hashCode + Objects.hashCode(turkeyAdditionalInfo());
        hashCode = 31 * hashCode + Objects.hashCode(ukraineAdditionalInfo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdditionalInfoResponse)) {
            return false;
        }
        AdditionalInfoResponse other = (AdditionalInfoResponse) obj;
        return Objects.equals(brazilAdditionalInfo(), other.brazilAdditionalInfo())
                && Objects.equals(canadaAdditionalInfo(), other.canadaAdditionalInfo())
                && Objects.equals(estoniaAdditionalInfo(), other.estoniaAdditionalInfo())
                && Objects.equals(georgiaAdditionalInfo(), other.georgiaAdditionalInfo())
                && Objects.equals(indiaAdditionalInfo(), other.indiaAdditionalInfo())
                && Objects.equals(israelAdditionalInfo(), other.israelAdditionalInfo())
                && Objects.equals(italyAdditionalInfo(), other.italyAdditionalInfo())
                && Objects.equals(kenyaAdditionalInfo(), other.kenyaAdditionalInfo())
                && Objects.equals(malaysiaAdditionalInfo(), other.malaysiaAdditionalInfo())
                && Objects.equals(polandAdditionalInfo(), other.polandAdditionalInfo())
                && Objects.equals(romaniaAdditionalInfo(), other.romaniaAdditionalInfo())
                && Objects.equals(saudiArabiaAdditionalInfo(), other.saudiArabiaAdditionalInfo())
                && Objects.equals(southKoreaAdditionalInfo(), other.southKoreaAdditionalInfo())
                && Objects.equals(spainAdditionalInfo(), other.spainAdditionalInfo())
                && Objects.equals(turkeyAdditionalInfo(), other.turkeyAdditionalInfo())
                && Objects.equals(ukraineAdditionalInfo(), other.ukraineAdditionalInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AdditionalInfoResponse").add("BrazilAdditionalInfo", brazilAdditionalInfo())
                .add("CanadaAdditionalInfo", canadaAdditionalInfo()).add("EstoniaAdditionalInfo", estoniaAdditionalInfo())
                .add("GeorgiaAdditionalInfo", georgiaAdditionalInfo()).add("IndiaAdditionalInfo", indiaAdditionalInfo())
                .add("IsraelAdditionalInfo", israelAdditionalInfo()).add("ItalyAdditionalInfo", italyAdditionalInfo())
                .add("KenyaAdditionalInfo", kenyaAdditionalInfo()).add("MalaysiaAdditionalInfo", malaysiaAdditionalInfo())
                .add("PolandAdditionalInfo", polandAdditionalInfo()).add("RomaniaAdditionalInfo", romaniaAdditionalInfo())
                .add("SaudiArabiaAdditionalInfo", saudiArabiaAdditionalInfo())
                .add("SouthKoreaAdditionalInfo", southKoreaAdditionalInfo()).add("SpainAdditionalInfo", spainAdditionalInfo())
                .add("TurkeyAdditionalInfo", turkeyAdditionalInfo()).add("UkraineAdditionalInfo", ukraineAdditionalInfo())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "brazilAdditionalInfo":
            return Optional.ofNullable(clazz.cast(brazilAdditionalInfo()));
        case "canadaAdditionalInfo":
            return Optional.ofNullable(clazz.cast(canadaAdditionalInfo()));
        case "estoniaAdditionalInfo":
            return Optional.ofNullable(clazz.cast(estoniaAdditionalInfo()));
        case "georgiaAdditionalInfo":
            return Optional.ofNullable(clazz.cast(georgiaAdditionalInfo()));
        case "indiaAdditionalInfo":
            return Optional.ofNullable(clazz.cast(indiaAdditionalInfo()));
        case "israelAdditionalInfo":
            return Optional.ofNullable(clazz.cast(israelAdditionalInfo()));
        case "italyAdditionalInfo":
            return Optional.ofNullable(clazz.cast(italyAdditionalInfo()));
        case "kenyaAdditionalInfo":
            return Optional.ofNullable(clazz.cast(kenyaAdditionalInfo()));
        case "malaysiaAdditionalInfo":
            return Optional.ofNullable(clazz.cast(malaysiaAdditionalInfo()));
        case "polandAdditionalInfo":
            return Optional.ofNullable(clazz.cast(polandAdditionalInfo()));
        case "romaniaAdditionalInfo":
            return Optional.ofNullable(clazz.cast(romaniaAdditionalInfo()));
        case "saudiArabiaAdditionalInfo":
            return Optional.ofNullable(clazz.cast(saudiArabiaAdditionalInfo()));
        case "southKoreaAdditionalInfo":
            return Optional.ofNullable(clazz.cast(southKoreaAdditionalInfo()));
        case "spainAdditionalInfo":
            return Optional.ofNullable(clazz.cast(spainAdditionalInfo()));
        case "turkeyAdditionalInfo":
            return Optional.ofNullable(clazz.cast(turkeyAdditionalInfo()));
        case "ukraineAdditionalInfo":
            return Optional.ofNullable(clazz.cast(ukraineAdditionalInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdditionalInfoResponse, T> g) {
        return obj -> g.apply((AdditionalInfoResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AdditionalInfoResponse> {
        /**
         * <p>
         * Additional tax information associated with your TRN in Brazil. The Tax Settings API returns this information
         * in your response when any additional information is present with your TRN in Brazil.
         * </p>
         * 
         * @param brazilAdditionalInfo
         *        Additional tax information associated with your TRN in Brazil. The Tax Settings API returns this
         *        information in your response when any additional information is present with your TRN in Brazil.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brazilAdditionalInfo(BrazilAdditionalInfo brazilAdditionalInfo);

        /**
         * <p>
         * Additional tax information associated with your TRN in Brazil. The Tax Settings API returns this information
         * in your response when any additional information is present with your TRN in Brazil.
         * </p>
         * This is a convenience method that creates an instance of the {@link BrazilAdditionalInfo.Builder} avoiding
         * the need to create one manually via {@link BrazilAdditionalInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BrazilAdditionalInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #brazilAdditionalInfo(BrazilAdditionalInfo)}.
         * 
         * @param brazilAdditionalInfo
         *        a consumer that will call methods on {@link BrazilAdditionalInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #brazilAdditionalInfo(BrazilAdditionalInfo)
         */
        default Builder brazilAdditionalInfo(Consumer<BrazilAdditionalInfo.Builder> brazilAdditionalInfo) {
            return brazilAdditionalInfo(BrazilAdditionalInfo.builder().applyMutation(brazilAdditionalInfo).build());
        }

        /**
         * <p>
         * Additional tax information associated with your TRN in Canada.
         * </p>
         * 
         * @param canadaAdditionalInfo
         *        Additional tax information associated with your TRN in Canada.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canadaAdditionalInfo(CanadaAdditionalInfo canadaAdditionalInfo);

        /**
         * <p>
         * Additional tax information associated with your TRN in Canada.
         * </p>
         * This is a convenience method that creates an instance of the {@link CanadaAdditionalInfo.Builder} avoiding
         * the need to create one manually via {@link CanadaAdditionalInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CanadaAdditionalInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #canadaAdditionalInfo(CanadaAdditionalInfo)}.
         * 
         * @param canadaAdditionalInfo
         *        a consumer that will call methods on {@link CanadaAdditionalInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #canadaAdditionalInfo(CanadaAdditionalInfo)
         */
        default Builder canadaAdditionalInfo(Consumer<CanadaAdditionalInfo.Builder> canadaAdditionalInfo) {
            return canadaAdditionalInfo(CanadaAdditionalInfo.builder().applyMutation(canadaAdditionalInfo).build());
        }

        /**
         * <p>
         * Additional tax information associated with your TRN in Estonia.
         * </p>
         * 
         * @param estoniaAdditionalInfo
         *        Additional tax information associated with your TRN in Estonia.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estoniaAdditionalInfo(EstoniaAdditionalInfo estoniaAdditionalInfo);

        /**
         * <p>
         * Additional tax information associated with your TRN in Estonia.
         * </p>
         * This is a convenience method that creates an instance of the {@link EstoniaAdditionalInfo.Builder} avoiding
         * the need to create one manually via {@link EstoniaAdditionalInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EstoniaAdditionalInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #estoniaAdditionalInfo(EstoniaAdditionalInfo)}.
         * 
         * @param estoniaAdditionalInfo
         *        a consumer that will call methods on {@link EstoniaAdditionalInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #estoniaAdditionalInfo(EstoniaAdditionalInfo)
         */
        default Builder estoniaAdditionalInfo(Consumer<EstoniaAdditionalInfo.Builder> estoniaAdditionalInfo) {
            return estoniaAdditionalInfo(EstoniaAdditionalInfo.builder().applyMutation(estoniaAdditionalInfo).build());
        }

        /**
         * <p>
         * Additional tax information associated with your TRN in Georgia.
         * </p>
         * 
         * @param georgiaAdditionalInfo
         *        Additional tax information associated with your TRN in Georgia.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder georgiaAdditionalInfo(GeorgiaAdditionalInfo georgiaAdditionalInfo);

        /**
         * <p>
         * Additional tax information associated with your TRN in Georgia.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeorgiaAdditionalInfo.Builder} avoiding
         * the need to create one manually via {@link GeorgiaAdditionalInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeorgiaAdditionalInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #georgiaAdditionalInfo(GeorgiaAdditionalInfo)}.
         * 
         * @param georgiaAdditionalInfo
         *        a consumer that will call methods on {@link GeorgiaAdditionalInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #georgiaAdditionalInfo(GeorgiaAdditionalInfo)
         */
        default Builder georgiaAdditionalInfo(Consumer<GeorgiaAdditionalInfo.Builder> georgiaAdditionalInfo) {
            return georgiaAdditionalInfo(GeorgiaAdditionalInfo.builder().applyMutation(georgiaAdditionalInfo).build());
        }

        /**
         * <p>
         * Additional tax information in India.
         * </p>
         * 
         * @param indiaAdditionalInfo
         *        Additional tax information in India.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indiaAdditionalInfo(IndiaAdditionalInfo indiaAdditionalInfo);

        /**
         * <p>
         * Additional tax information in India.
         * </p>
         * This is a convenience method that creates an instance of the {@link IndiaAdditionalInfo.Builder} avoiding the
         * need to create one manually via {@link IndiaAdditionalInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IndiaAdditionalInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #indiaAdditionalInfo(IndiaAdditionalInfo)}.
         * 
         * @param indiaAdditionalInfo
         *        a consumer that will call methods on {@link IndiaAdditionalInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #indiaAdditionalInfo(IndiaAdditionalInfo)
         */
        default Builder indiaAdditionalInfo(Consumer<IndiaAdditionalInfo.Builder> indiaAdditionalInfo) {
            return indiaAdditionalInfo(IndiaAdditionalInfo.builder().applyMutation(indiaAdditionalInfo).build());
        }

        /**
         * <p>
         * Additional tax information associated with your TRN in Israel.
         * </p>
         * 
         * @param israelAdditionalInfo
         *        Additional tax information associated with your TRN in Israel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder israelAdditionalInfo(IsraelAdditionalInfo israelAdditionalInfo);

        /**
         * <p>
         * Additional tax information associated with your TRN in Israel.
         * </p>
         * This is a convenience method that creates an instance of the {@link IsraelAdditionalInfo.Builder} avoiding
         * the need to create one manually via {@link IsraelAdditionalInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IsraelAdditionalInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #israelAdditionalInfo(IsraelAdditionalInfo)}.
         * 
         * @param israelAdditionalInfo
         *        a consumer that will call methods on {@link IsraelAdditionalInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #israelAdditionalInfo(IsraelAdditionalInfo)
         */
        default Builder israelAdditionalInfo(Consumer<IsraelAdditionalInfo.Builder> israelAdditionalInfo) {
            return israelAdditionalInfo(IsraelAdditionalInfo.builder().applyMutation(israelAdditionalInfo).build());
        }

        /**
         * <p>
         * Additional tax information associated with your TRN in Italy.
         * </p>
         * 
         * @param italyAdditionalInfo
         *        Additional tax information associated with your TRN in Italy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder italyAdditionalInfo(ItalyAdditionalInfo italyAdditionalInfo);

        /**
         * <p>
         * Additional tax information associated with your TRN in Italy.
         * </p>
         * This is a convenience method that creates an instance of the {@link ItalyAdditionalInfo.Builder} avoiding the
         * need to create one manually via {@link ItalyAdditionalInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ItalyAdditionalInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #italyAdditionalInfo(ItalyAdditionalInfo)}.
         * 
         * @param italyAdditionalInfo
         *        a consumer that will call methods on {@link ItalyAdditionalInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #italyAdditionalInfo(ItalyAdditionalInfo)
         */
        default Builder italyAdditionalInfo(Consumer<ItalyAdditionalInfo.Builder> italyAdditionalInfo) {
            return italyAdditionalInfo(ItalyAdditionalInfo.builder().applyMutation(italyAdditionalInfo).build());
        }

        /**
         * <p>
         * Additional tax information associated with your TRN in Kenya.
         * </p>
         * 
         * @param kenyaAdditionalInfo
         *        Additional tax information associated with your TRN in Kenya.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kenyaAdditionalInfo(KenyaAdditionalInfo kenyaAdditionalInfo);

        /**
         * <p>
         * Additional tax information associated with your TRN in Kenya.
         * </p>
         * This is a convenience method that creates an instance of the {@link KenyaAdditionalInfo.Builder} avoiding the
         * need to create one manually via {@link KenyaAdditionalInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KenyaAdditionalInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #kenyaAdditionalInfo(KenyaAdditionalInfo)}.
         * 
         * @param kenyaAdditionalInfo
         *        a consumer that will call methods on {@link KenyaAdditionalInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kenyaAdditionalInfo(KenyaAdditionalInfo)
         */
        default Builder kenyaAdditionalInfo(Consumer<KenyaAdditionalInfo.Builder> kenyaAdditionalInfo) {
            return kenyaAdditionalInfo(KenyaAdditionalInfo.builder().applyMutation(kenyaAdditionalInfo).build());
        }

        /**
         * <p>
         * Additional tax information associated with your TRN in Malaysia.
         * </p>
         * 
         * @param malaysiaAdditionalInfo
         *        Additional tax information associated with your TRN in Malaysia.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder malaysiaAdditionalInfo(MalaysiaAdditionalInfo malaysiaAdditionalInfo);

        /**
         * <p>
         * Additional tax information associated with your TRN in Malaysia.
         * </p>
         * This is a convenience method that creates an instance of the {@link MalaysiaAdditionalInfo.Builder} avoiding
         * the need to create one manually via {@link MalaysiaAdditionalInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MalaysiaAdditionalInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #malaysiaAdditionalInfo(MalaysiaAdditionalInfo)}.
         * 
         * @param malaysiaAdditionalInfo
         *        a consumer that will call methods on {@link MalaysiaAdditionalInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #malaysiaAdditionalInfo(MalaysiaAdditionalInfo)
         */
        default Builder malaysiaAdditionalInfo(Consumer<MalaysiaAdditionalInfo.Builder> malaysiaAdditionalInfo) {
            return malaysiaAdditionalInfo(MalaysiaAdditionalInfo.builder().applyMutation(malaysiaAdditionalInfo).build());
        }

        /**
         * <p>
         * Additional tax information associated with your TRN in Poland.
         * </p>
         * 
         * @param polandAdditionalInfo
         *        Additional tax information associated with your TRN in Poland.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder polandAdditionalInfo(PolandAdditionalInfo polandAdditionalInfo);

        /**
         * <p>
         * Additional tax information associated with your TRN in Poland.
         * </p>
         * This is a convenience method that creates an instance of the {@link PolandAdditionalInfo.Builder} avoiding
         * the need to create one manually via {@link PolandAdditionalInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PolandAdditionalInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #polandAdditionalInfo(PolandAdditionalInfo)}.
         * 
         * @param polandAdditionalInfo
         *        a consumer that will call methods on {@link PolandAdditionalInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #polandAdditionalInfo(PolandAdditionalInfo)
         */
        default Builder polandAdditionalInfo(Consumer<PolandAdditionalInfo.Builder> polandAdditionalInfo) {
            return polandAdditionalInfo(PolandAdditionalInfo.builder().applyMutation(polandAdditionalInfo).build());
        }

        /**
         * <p>
         * Additional tax information to specify for a TRN in Romania.
         * </p>
         * 
         * @param romaniaAdditionalInfo
         *        Additional tax information to specify for a TRN in Romania.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder romaniaAdditionalInfo(RomaniaAdditionalInfo romaniaAdditionalInfo);

        /**
         * <p>
         * Additional tax information to specify for a TRN in Romania.
         * </p>
         * This is a convenience method that creates an instance of the {@link RomaniaAdditionalInfo.Builder} avoiding
         * the need to create one manually via {@link RomaniaAdditionalInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RomaniaAdditionalInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #romaniaAdditionalInfo(RomaniaAdditionalInfo)}.
         * 
         * @param romaniaAdditionalInfo
         *        a consumer that will call methods on {@link RomaniaAdditionalInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #romaniaAdditionalInfo(RomaniaAdditionalInfo)
         */
        default Builder romaniaAdditionalInfo(Consumer<RomaniaAdditionalInfo.Builder> romaniaAdditionalInfo) {
            return romaniaAdditionalInfo(RomaniaAdditionalInfo.builder().applyMutation(romaniaAdditionalInfo).build());
        }

        /**
         * <p>
         * Additional tax information associated with your TRN in Saudi Arabia.
         * </p>
         * 
         * @param saudiArabiaAdditionalInfo
         *        Additional tax information associated with your TRN in Saudi Arabia.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder saudiArabiaAdditionalInfo(SaudiArabiaAdditionalInfo saudiArabiaAdditionalInfo);

        /**
         * <p>
         * Additional tax information associated with your TRN in Saudi Arabia.
         * </p>
         * This is a convenience method that creates an instance of the {@link SaudiArabiaAdditionalInfo.Builder}
         * avoiding the need to create one manually via {@link SaudiArabiaAdditionalInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SaudiArabiaAdditionalInfo.Builder#build()} is called immediately
         * and its result is passed to {@link #saudiArabiaAdditionalInfo(SaudiArabiaAdditionalInfo)}.
         * 
         * @param saudiArabiaAdditionalInfo
         *        a consumer that will call methods on {@link SaudiArabiaAdditionalInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #saudiArabiaAdditionalInfo(SaudiArabiaAdditionalInfo)
         */
        default Builder saudiArabiaAdditionalInfo(Consumer<SaudiArabiaAdditionalInfo.Builder> saudiArabiaAdditionalInfo) {
            return saudiArabiaAdditionalInfo(SaudiArabiaAdditionalInfo.builder().applyMutation(saudiArabiaAdditionalInfo).build());
        }

        /**
         * <p>
         * Additional tax information associated with your TRN in South Korea.
         * </p>
         * 
         * @param southKoreaAdditionalInfo
         *        Additional tax information associated with your TRN in South Korea.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder southKoreaAdditionalInfo(SouthKoreaAdditionalInfo southKoreaAdditionalInfo);

        /**
         * <p>
         * Additional tax information associated with your TRN in South Korea.
         * </p>
         * This is a convenience method that creates an instance of the {@link SouthKoreaAdditionalInfo.Builder}
         * avoiding the need to create one manually via {@link SouthKoreaAdditionalInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SouthKoreaAdditionalInfo.Builder#build()} is called immediately
         * and its result is passed to {@link #southKoreaAdditionalInfo(SouthKoreaAdditionalInfo)}.
         * 
         * @param southKoreaAdditionalInfo
         *        a consumer that will call methods on {@link SouthKoreaAdditionalInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #southKoreaAdditionalInfo(SouthKoreaAdditionalInfo)
         */
        default Builder southKoreaAdditionalInfo(Consumer<SouthKoreaAdditionalInfo.Builder> southKoreaAdditionalInfo) {
            return southKoreaAdditionalInfo(SouthKoreaAdditionalInfo.builder().applyMutation(southKoreaAdditionalInfo).build());
        }

        /**
         * <p>
         * Additional tax information associated with your TRN in Spain.
         * </p>
         * 
         * @param spainAdditionalInfo
         *        Additional tax information associated with your TRN in Spain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spainAdditionalInfo(SpainAdditionalInfo spainAdditionalInfo);

        /**
         * <p>
         * Additional tax information associated with your TRN in Spain.
         * </p>
         * This is a convenience method that creates an instance of the {@link SpainAdditionalInfo.Builder} avoiding the
         * need to create one manually via {@link SpainAdditionalInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SpainAdditionalInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #spainAdditionalInfo(SpainAdditionalInfo)}.
         * 
         * @param spainAdditionalInfo
         *        a consumer that will call methods on {@link SpainAdditionalInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spainAdditionalInfo(SpainAdditionalInfo)
         */
        default Builder spainAdditionalInfo(Consumer<SpainAdditionalInfo.Builder> spainAdditionalInfo) {
            return spainAdditionalInfo(SpainAdditionalInfo.builder().applyMutation(spainAdditionalInfo).build());
        }

        /**
         * <p>
         * Additional tax information associated with your TRN in Turkey.
         * </p>
         * 
         * @param turkeyAdditionalInfo
         *        Additional tax information associated with your TRN in Turkey.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder turkeyAdditionalInfo(TurkeyAdditionalInfo turkeyAdditionalInfo);

        /**
         * <p>
         * Additional tax information associated with your TRN in Turkey.
         * </p>
         * This is a convenience method that creates an instance of the {@link TurkeyAdditionalInfo.Builder} avoiding
         * the need to create one manually via {@link TurkeyAdditionalInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TurkeyAdditionalInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #turkeyAdditionalInfo(TurkeyAdditionalInfo)}.
         * 
         * @param turkeyAdditionalInfo
         *        a consumer that will call methods on {@link TurkeyAdditionalInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #turkeyAdditionalInfo(TurkeyAdditionalInfo)
         */
        default Builder turkeyAdditionalInfo(Consumer<TurkeyAdditionalInfo.Builder> turkeyAdditionalInfo) {
            return turkeyAdditionalInfo(TurkeyAdditionalInfo.builder().applyMutation(turkeyAdditionalInfo).build());
        }

        /**
         * <p>
         * Additional tax information associated with your TRN in Ukraine.
         * </p>
         * 
         * @param ukraineAdditionalInfo
         *        Additional tax information associated with your TRN in Ukraine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ukraineAdditionalInfo(UkraineAdditionalInfo ukraineAdditionalInfo);

        /**
         * <p>
         * Additional tax information associated with your TRN in Ukraine.
         * </p>
         * This is a convenience method that creates an instance of the {@link UkraineAdditionalInfo.Builder} avoiding
         * the need to create one manually via {@link UkraineAdditionalInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UkraineAdditionalInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #ukraineAdditionalInfo(UkraineAdditionalInfo)}.
         * 
         * @param ukraineAdditionalInfo
         *        a consumer that will call methods on {@link UkraineAdditionalInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ukraineAdditionalInfo(UkraineAdditionalInfo)
         */
        default Builder ukraineAdditionalInfo(Consumer<UkraineAdditionalInfo.Builder> ukraineAdditionalInfo) {
            return ukraineAdditionalInfo(UkraineAdditionalInfo.builder().applyMutation(ukraineAdditionalInfo).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private BrazilAdditionalInfo brazilAdditionalInfo;

        private CanadaAdditionalInfo canadaAdditionalInfo;

        private EstoniaAdditionalInfo estoniaAdditionalInfo;

        private GeorgiaAdditionalInfo georgiaAdditionalInfo;

        private IndiaAdditionalInfo indiaAdditionalInfo;

        private IsraelAdditionalInfo israelAdditionalInfo;

        private ItalyAdditionalInfo italyAdditionalInfo;

        private KenyaAdditionalInfo kenyaAdditionalInfo;

        private MalaysiaAdditionalInfo malaysiaAdditionalInfo;

        private PolandAdditionalInfo polandAdditionalInfo;

        private RomaniaAdditionalInfo romaniaAdditionalInfo;

        private SaudiArabiaAdditionalInfo saudiArabiaAdditionalInfo;

        private SouthKoreaAdditionalInfo southKoreaAdditionalInfo;

        private SpainAdditionalInfo spainAdditionalInfo;

        private TurkeyAdditionalInfo turkeyAdditionalInfo;

        private UkraineAdditionalInfo ukraineAdditionalInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(AdditionalInfoResponse model) {
            brazilAdditionalInfo(model.brazilAdditionalInfo);
            canadaAdditionalInfo(model.canadaAdditionalInfo);
            estoniaAdditionalInfo(model.estoniaAdditionalInfo);
            georgiaAdditionalInfo(model.georgiaAdditionalInfo);
            indiaAdditionalInfo(model.indiaAdditionalInfo);
            israelAdditionalInfo(model.israelAdditionalInfo);
            italyAdditionalInfo(model.italyAdditionalInfo);
            kenyaAdditionalInfo(model.kenyaAdditionalInfo);
            malaysiaAdditionalInfo(model.malaysiaAdditionalInfo);
            polandAdditionalInfo(model.polandAdditionalInfo);
            romaniaAdditionalInfo(model.romaniaAdditionalInfo);
            saudiArabiaAdditionalInfo(model.saudiArabiaAdditionalInfo);
            southKoreaAdditionalInfo(model.southKoreaAdditionalInfo);
            spainAdditionalInfo(model.spainAdditionalInfo);
            turkeyAdditionalInfo(model.turkeyAdditionalInfo);
            ukraineAdditionalInfo(model.ukraineAdditionalInfo);
        }

        public final BrazilAdditionalInfo.Builder getBrazilAdditionalInfo() {
            return brazilAdditionalInfo != null ? brazilAdditionalInfo.toBuilder() : null;
        }

        public final void setBrazilAdditionalInfo(BrazilAdditionalInfo.BuilderImpl brazilAdditionalInfo) {
            this.brazilAdditionalInfo = brazilAdditionalInfo != null ? brazilAdditionalInfo.build() : null;
        }

        @Override
        public final Builder brazilAdditionalInfo(BrazilAdditionalInfo brazilAdditionalInfo) {
            this.brazilAdditionalInfo = brazilAdditionalInfo;
            return this;
        }

        public final CanadaAdditionalInfo.Builder getCanadaAdditionalInfo() {
            return canadaAdditionalInfo != null ? canadaAdditionalInfo.toBuilder() : null;
        }

        public final void setCanadaAdditionalInfo(CanadaAdditionalInfo.BuilderImpl canadaAdditionalInfo) {
            this.canadaAdditionalInfo = canadaAdditionalInfo != null ? canadaAdditionalInfo.build() : null;
        }

        @Override
        public final Builder canadaAdditionalInfo(CanadaAdditionalInfo canadaAdditionalInfo) {
            this.canadaAdditionalInfo = canadaAdditionalInfo;
            return this;
        }

        public final EstoniaAdditionalInfo.Builder getEstoniaAdditionalInfo() {
            return estoniaAdditionalInfo != null ? estoniaAdditionalInfo.toBuilder() : null;
        }

        public final void setEstoniaAdditionalInfo(EstoniaAdditionalInfo.BuilderImpl estoniaAdditionalInfo) {
            this.estoniaAdditionalInfo = estoniaAdditionalInfo != null ? estoniaAdditionalInfo.build() : null;
        }

        @Override
        public final Builder estoniaAdditionalInfo(EstoniaAdditionalInfo estoniaAdditionalInfo) {
            this.estoniaAdditionalInfo = estoniaAdditionalInfo;
            return this;
        }

        public final GeorgiaAdditionalInfo.Builder getGeorgiaAdditionalInfo() {
            return georgiaAdditionalInfo != null ? georgiaAdditionalInfo.toBuilder() : null;
        }

        public final void setGeorgiaAdditionalInfo(GeorgiaAdditionalInfo.BuilderImpl georgiaAdditionalInfo) {
            this.georgiaAdditionalInfo = georgiaAdditionalInfo != null ? georgiaAdditionalInfo.build() : null;
        }

        @Override
        public final Builder georgiaAdditionalInfo(GeorgiaAdditionalInfo georgiaAdditionalInfo) {
            this.georgiaAdditionalInfo = georgiaAdditionalInfo;
            return this;
        }

        public final IndiaAdditionalInfo.Builder getIndiaAdditionalInfo() {
            return indiaAdditionalInfo != null ? indiaAdditionalInfo.toBuilder() : null;
        }

        public final void setIndiaAdditionalInfo(IndiaAdditionalInfo.BuilderImpl indiaAdditionalInfo) {
            this.indiaAdditionalInfo = indiaAdditionalInfo != null ? indiaAdditionalInfo.build() : null;
        }

        @Override
        public final Builder indiaAdditionalInfo(IndiaAdditionalInfo indiaAdditionalInfo) {
            this.indiaAdditionalInfo = indiaAdditionalInfo;
            return this;
        }

        public final IsraelAdditionalInfo.Builder getIsraelAdditionalInfo() {
            return israelAdditionalInfo != null ? israelAdditionalInfo.toBuilder() : null;
        }

        public final void setIsraelAdditionalInfo(IsraelAdditionalInfo.BuilderImpl israelAdditionalInfo) {
            this.israelAdditionalInfo = israelAdditionalInfo != null ? israelAdditionalInfo.build() : null;
        }

        @Override
        public final Builder israelAdditionalInfo(IsraelAdditionalInfo israelAdditionalInfo) {
            this.israelAdditionalInfo = israelAdditionalInfo;
            return this;
        }

        public final ItalyAdditionalInfo.Builder getItalyAdditionalInfo() {
            return italyAdditionalInfo != null ? italyAdditionalInfo.toBuilder() : null;
        }

        public final void setItalyAdditionalInfo(ItalyAdditionalInfo.BuilderImpl italyAdditionalInfo) {
            this.italyAdditionalInfo = italyAdditionalInfo != null ? italyAdditionalInfo.build() : null;
        }

        @Override
        public final Builder italyAdditionalInfo(ItalyAdditionalInfo italyAdditionalInfo) {
            this.italyAdditionalInfo = italyAdditionalInfo;
            return this;
        }

        public final KenyaAdditionalInfo.Builder getKenyaAdditionalInfo() {
            return kenyaAdditionalInfo != null ? kenyaAdditionalInfo.toBuilder() : null;
        }

        public final void setKenyaAdditionalInfo(KenyaAdditionalInfo.BuilderImpl kenyaAdditionalInfo) {
            this.kenyaAdditionalInfo = kenyaAdditionalInfo != null ? kenyaAdditionalInfo.build() : null;
        }

        @Override
        public final Builder kenyaAdditionalInfo(KenyaAdditionalInfo kenyaAdditionalInfo) {
            this.kenyaAdditionalInfo = kenyaAdditionalInfo;
            return this;
        }

        public final MalaysiaAdditionalInfo.Builder getMalaysiaAdditionalInfo() {
            return malaysiaAdditionalInfo != null ? malaysiaAdditionalInfo.toBuilder() : null;
        }

        public final void setMalaysiaAdditionalInfo(MalaysiaAdditionalInfo.BuilderImpl malaysiaAdditionalInfo) {
            this.malaysiaAdditionalInfo = malaysiaAdditionalInfo != null ? malaysiaAdditionalInfo.build() : null;
        }

        @Override
        public final Builder malaysiaAdditionalInfo(MalaysiaAdditionalInfo malaysiaAdditionalInfo) {
            this.malaysiaAdditionalInfo = malaysiaAdditionalInfo;
            return this;
        }

        public final PolandAdditionalInfo.Builder getPolandAdditionalInfo() {
            return polandAdditionalInfo != null ? polandAdditionalInfo.toBuilder() : null;
        }

        public final void setPolandAdditionalInfo(PolandAdditionalInfo.BuilderImpl polandAdditionalInfo) {
            this.polandAdditionalInfo = polandAdditionalInfo != null ? polandAdditionalInfo.build() : null;
        }

        @Override
        public final Builder polandAdditionalInfo(PolandAdditionalInfo polandAdditionalInfo) {
            this.polandAdditionalInfo = polandAdditionalInfo;
            return this;
        }

        public final RomaniaAdditionalInfo.Builder getRomaniaAdditionalInfo() {
            return romaniaAdditionalInfo != null ? romaniaAdditionalInfo.toBuilder() : null;
        }

        public final void setRomaniaAdditionalInfo(RomaniaAdditionalInfo.BuilderImpl romaniaAdditionalInfo) {
            this.romaniaAdditionalInfo = romaniaAdditionalInfo != null ? romaniaAdditionalInfo.build() : null;
        }

        @Override
        public final Builder romaniaAdditionalInfo(RomaniaAdditionalInfo romaniaAdditionalInfo) {
            this.romaniaAdditionalInfo = romaniaAdditionalInfo;
            return this;
        }

        public final SaudiArabiaAdditionalInfo.Builder getSaudiArabiaAdditionalInfo() {
            return saudiArabiaAdditionalInfo != null ? saudiArabiaAdditionalInfo.toBuilder() : null;
        }

        public final void setSaudiArabiaAdditionalInfo(SaudiArabiaAdditionalInfo.BuilderImpl saudiArabiaAdditionalInfo) {
            this.saudiArabiaAdditionalInfo = saudiArabiaAdditionalInfo != null ? saudiArabiaAdditionalInfo.build() : null;
        }

        @Override
        public final Builder saudiArabiaAdditionalInfo(SaudiArabiaAdditionalInfo saudiArabiaAdditionalInfo) {
            this.saudiArabiaAdditionalInfo = saudiArabiaAdditionalInfo;
            return this;
        }

        public final SouthKoreaAdditionalInfo.Builder getSouthKoreaAdditionalInfo() {
            return southKoreaAdditionalInfo != null ? southKoreaAdditionalInfo.toBuilder() : null;
        }

        public final void setSouthKoreaAdditionalInfo(SouthKoreaAdditionalInfo.BuilderImpl southKoreaAdditionalInfo) {
            this.southKoreaAdditionalInfo = southKoreaAdditionalInfo != null ? southKoreaAdditionalInfo.build() : null;
        }

        @Override
        public final Builder southKoreaAdditionalInfo(SouthKoreaAdditionalInfo southKoreaAdditionalInfo) {
            this.southKoreaAdditionalInfo = southKoreaAdditionalInfo;
            return this;
        }

        public final SpainAdditionalInfo.Builder getSpainAdditionalInfo() {
            return spainAdditionalInfo != null ? spainAdditionalInfo.toBuilder() : null;
        }

        public final void setSpainAdditionalInfo(SpainAdditionalInfo.BuilderImpl spainAdditionalInfo) {
            this.spainAdditionalInfo = spainAdditionalInfo != null ? spainAdditionalInfo.build() : null;
        }

        @Override
        public final Builder spainAdditionalInfo(SpainAdditionalInfo spainAdditionalInfo) {
            this.spainAdditionalInfo = spainAdditionalInfo;
            return this;
        }

        public final TurkeyAdditionalInfo.Builder getTurkeyAdditionalInfo() {
            return turkeyAdditionalInfo != null ? turkeyAdditionalInfo.toBuilder() : null;
        }

        public final void setTurkeyAdditionalInfo(TurkeyAdditionalInfo.BuilderImpl turkeyAdditionalInfo) {
            this.turkeyAdditionalInfo = turkeyAdditionalInfo != null ? turkeyAdditionalInfo.build() : null;
        }

        @Override
        public final Builder turkeyAdditionalInfo(TurkeyAdditionalInfo turkeyAdditionalInfo) {
            this.turkeyAdditionalInfo = turkeyAdditionalInfo;
            return this;
        }

        public final UkraineAdditionalInfo.Builder getUkraineAdditionalInfo() {
            return ukraineAdditionalInfo != null ? ukraineAdditionalInfo.toBuilder() : null;
        }

        public final void setUkraineAdditionalInfo(UkraineAdditionalInfo.BuilderImpl ukraineAdditionalInfo) {
            this.ukraineAdditionalInfo = ukraineAdditionalInfo != null ? ukraineAdditionalInfo.build() : null;
        }

        @Override
        public final Builder ukraineAdditionalInfo(UkraineAdditionalInfo ukraineAdditionalInfo) {
            this.ukraineAdditionalInfo = ukraineAdditionalInfo;
            return this;
        }

        @Override
        public AdditionalInfoResponse build() {
            return new AdditionalInfoResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
