/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the address associated with the TRN information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Address implements SdkPojo, Serializable, ToCopyableBuilder<Address.Builder, Address> {
    private static final SdkField<String> ADDRESS_LINE1_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("addressLine1").getter(getter(Address::addressLine1)).setter(setter(Builder::addressLine1))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addressLine1").build()).build();

    private static final SdkField<String> ADDRESS_LINE2_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("addressLine2").getter(getter(Address::addressLine2)).setter(setter(Builder::addressLine2))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addressLine2").build()).build();

    private static final SdkField<String> ADDRESS_LINE3_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("addressLine3").getter(getter(Address::addressLine3)).setter(setter(Builder::addressLine3))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addressLine3").build()).build();

    private static final SdkField<String> CITY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("city")
            .getter(getter(Address::city)).setter(setter(Builder::city))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("city").build()).build();

    private static final SdkField<String> COUNTRY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("countryCode").getter(getter(Address::countryCode)).setter(setter(Builder::countryCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("countryCode").build()).build();

    private static final SdkField<String> DISTRICT_OR_COUNTY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("districtOrCounty").getter(getter(Address::districtOrCounty)).setter(setter(Builder::districtOrCounty))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("districtOrCounty").build()).build();

    private static final SdkField<String> POSTAL_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("postalCode").getter(getter(Address::postalCode)).setter(setter(Builder::postalCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postalCode").build()).build();

    private static final SdkField<String> STATE_OR_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stateOrRegion").getter(getter(Address::stateOrRegion)).setter(setter(Builder::stateOrRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateOrRegion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_LINE1_FIELD,
            ADDRESS_LINE2_FIELD, ADDRESS_LINE3_FIELD, CITY_FIELD, COUNTRY_CODE_FIELD, DISTRICT_OR_COUNTY_FIELD,
            POSTAL_CODE_FIELD, STATE_OR_REGION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String addressLine1;

    private final String addressLine2;

    private final String addressLine3;

    private final String city;

    private final String countryCode;

    private final String districtOrCounty;

    private final String postalCode;

    private final String stateOrRegion;

    private Address(BuilderImpl builder) {
        this.addressLine1 = builder.addressLine1;
        this.addressLine2 = builder.addressLine2;
        this.addressLine3 = builder.addressLine3;
        this.city = builder.city;
        this.countryCode = builder.countryCode;
        this.districtOrCounty = builder.districtOrCounty;
        this.postalCode = builder.postalCode;
        this.stateOrRegion = builder.stateOrRegion;
    }

    /**
     * <p>
     * The first line of the address.
     * </p>
     * 
     * @return The first line of the address.
     */
    public final String addressLine1() {
        return addressLine1;
    }

    /**
     * <p>
     * The second line of the address, if applicable.
     * </p>
     * 
     * @return The second line of the address, if applicable.
     */
    public final String addressLine2() {
        return addressLine2;
    }

    /**
     * <p>
     * The third line of the address, if applicable. Currently, the Tax Settings API accepts the
     * <code>addressLine3</code> parameter only for Saudi Arabia. When you specify a TRN in Saudi Arabia, you must enter
     * the <code>addressLine3</code> and specify the building number for the address. For example, you might enter
     * <code>1234</code>.
     * </p>
     * 
     * @return The third line of the address, if applicable. Currently, the Tax Settings API accepts the
     *         <code>addressLine3</code> parameter only for Saudi Arabia. When you specify a TRN in Saudi Arabia, you
     *         must enter the <code>addressLine3</code> and specify the building number for the address. For example,
     *         you might enter <code>1234</code>.
     */
    public final String addressLine3() {
        return addressLine3;
    }

    /**
     * <p>
     * The city that the address is in.
     * </p>
     * 
     * @return The city that the address is in.
     */
    public final String city() {
        return city;
    }

    /**
     * <p>
     * The country code for the country that the address is in.
     * </p>
     * 
     * @return The country code for the country that the address is in.
     */
    public final String countryCode() {
        return countryCode;
    }

    /**
     * <p>
     * The district or county the address is located.
     * </p>
     * <note>
     * <p>
     * For addresses in Brazil, this parameter uses the name of the neighborhood. When you set a TRN in Brazil, use
     * <code>districtOrCounty</code> for the neighborhood name.
     * </p>
     * </note>
     * 
     * @return The district or county the address is located. </p> <note>
     *         <p>
     *         For addresses in Brazil, this parameter uses the name of the neighborhood. When you set a TRN in Brazil,
     *         use <code>districtOrCounty</code> for the neighborhood name.
     *         </p>
     */
    public final String districtOrCounty() {
        return districtOrCounty;
    }

    /**
     * <p>
     * The postal code associated with the address.
     * </p>
     * 
     * @return The postal code associated with the address.
     */
    public final String postalCode() {
        return postalCode;
    }

    /**
     * <p>
     * The state, region, or province that the address is located.
     * </p>
     * <p>
     * If this is required for tax settings, use the same name as shown on the <b>Tax Settings</b> page.
     * </p>
     * 
     * @return The state, region, or province that the address is located.</p>
     *         <p>
     *         If this is required for tax settings, use the same name as shown on the <b>Tax Settings</b> page.
     */
    public final String stateOrRegion() {
        return stateOrRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(addressLine1());
        hashCode = 31 * hashCode + Objects.hashCode(addressLine2());
        hashCode = 31 * hashCode + Objects.hashCode(addressLine3());
        hashCode = 31 * hashCode + Objects.hashCode(city());
        hashCode = 31 * hashCode + Objects.hashCode(countryCode());
        hashCode = 31 * hashCode + Objects.hashCode(districtOrCounty());
        hashCode = 31 * hashCode + Objects.hashCode(postalCode());
        hashCode = 31 * hashCode + Objects.hashCode(stateOrRegion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Address)) {
            return false;
        }
        Address other = (Address) obj;
        return Objects.equals(addressLine1(), other.addressLine1()) && Objects.equals(addressLine2(), other.addressLine2())
                && Objects.equals(addressLine3(), other.addressLine3()) && Objects.equals(city(), other.city())
                && Objects.equals(countryCode(), other.countryCode())
                && Objects.equals(districtOrCounty(), other.districtOrCounty())
                && Objects.equals(postalCode(), other.postalCode()) && Objects.equals(stateOrRegion(), other.stateOrRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Address").add("AddressLine1", addressLine1()).add("AddressLine2", addressLine2())
                .add("AddressLine3", addressLine3()).add("City", city()).add("CountryCode", countryCode())
                .add("DistrictOrCounty", districtOrCounty()).add("PostalCode", postalCode())
                .add("StateOrRegion", stateOrRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "addressLine1":
            return Optional.ofNullable(clazz.cast(addressLine1()));
        case "addressLine2":
            return Optional.ofNullable(clazz.cast(addressLine2()));
        case "addressLine3":
            return Optional.ofNullable(clazz.cast(addressLine3()));
        case "city":
            return Optional.ofNullable(clazz.cast(city()));
        case "countryCode":
            return Optional.ofNullable(clazz.cast(countryCode()));
        case "districtOrCounty":
            return Optional.ofNullable(clazz.cast(districtOrCounty()));
        case "postalCode":
            return Optional.ofNullable(clazz.cast(postalCode()));
        case "stateOrRegion":
            return Optional.ofNullable(clazz.cast(stateOrRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Address, T> g) {
        return obj -> g.apply((Address) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Address> {
        /**
         * <p>
         * The first line of the address.
         * </p>
         * 
         * @param addressLine1
         *        The first line of the address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressLine1(String addressLine1);

        /**
         * <p>
         * The second line of the address, if applicable.
         * </p>
         * 
         * @param addressLine2
         *        The second line of the address, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressLine2(String addressLine2);

        /**
         * <p>
         * The third line of the address, if applicable. Currently, the Tax Settings API accepts the
         * <code>addressLine3</code> parameter only for Saudi Arabia. When you specify a TRN in Saudi Arabia, you must
         * enter the <code>addressLine3</code> and specify the building number for the address. For example, you might
         * enter <code>1234</code>.
         * </p>
         * 
         * @param addressLine3
         *        The third line of the address, if applicable. Currently, the Tax Settings API accepts the
         *        <code>addressLine3</code> parameter only for Saudi Arabia. When you specify a TRN in Saudi Arabia, you
         *        must enter the <code>addressLine3</code> and specify the building number for the address. For example,
         *        you might enter <code>1234</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressLine3(String addressLine3);

        /**
         * <p>
         * The city that the address is in.
         * </p>
         * 
         * @param city
         *        The city that the address is in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder city(String city);

        /**
         * <p>
         * The country code for the country that the address is in.
         * </p>
         * 
         * @param countryCode
         *        The country code for the country that the address is in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countryCode(String countryCode);

        /**
         * <p>
         * The district or county the address is located.
         * </p>
         * <note>
         * <p>
         * For addresses in Brazil, this parameter uses the name of the neighborhood. When you set a TRN in Brazil, use
         * <code>districtOrCounty</code> for the neighborhood name.
         * </p>
         * </note>
         * 
         * @param districtOrCounty
         *        The district or county the address is located. </p> <note>
         *        <p>
         *        For addresses in Brazil, this parameter uses the name of the neighborhood. When you set a TRN in
         *        Brazil, use <code>districtOrCounty</code> for the neighborhood name.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder districtOrCounty(String districtOrCounty);

        /**
         * <p>
         * The postal code associated with the address.
         * </p>
         * 
         * @param postalCode
         *        The postal code associated with the address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postalCode(String postalCode);

        /**
         * <p>
         * The state, region, or province that the address is located.
         * </p>
         * <p>
         * If this is required for tax settings, use the same name as shown on the <b>Tax Settings</b> page.
         * </p>
         * 
         * @param stateOrRegion
         *        The state, region, or province that the address is located.</p>
         *        <p>
         *        If this is required for tax settings, use the same name as shown on the <b>Tax Settings</b> page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateOrRegion(String stateOrRegion);
    }

    static final class BuilderImpl implements Builder {
        private String addressLine1;

        private String addressLine2;

        private String addressLine3;

        private String city;

        private String countryCode;

        private String districtOrCounty;

        private String postalCode;

        private String stateOrRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(Address model) {
            addressLine1(model.addressLine1);
            addressLine2(model.addressLine2);
            addressLine3(model.addressLine3);
            city(model.city);
            countryCode(model.countryCode);
            districtOrCounty(model.districtOrCounty);
            postalCode(model.postalCode);
            stateOrRegion(model.stateOrRegion);
        }

        public final String getAddressLine1() {
            return addressLine1;
        }

        public final void setAddressLine1(String addressLine1) {
            this.addressLine1 = addressLine1;
        }

        @Override
        public final Builder addressLine1(String addressLine1) {
            this.addressLine1 = addressLine1;
            return this;
        }

        public final String getAddressLine2() {
            return addressLine2;
        }

        public final void setAddressLine2(String addressLine2) {
            this.addressLine2 = addressLine2;
        }

        @Override
        public final Builder addressLine2(String addressLine2) {
            this.addressLine2 = addressLine2;
            return this;
        }

        public final String getAddressLine3() {
            return addressLine3;
        }

        public final void setAddressLine3(String addressLine3) {
            this.addressLine3 = addressLine3;
        }

        @Override
        public final Builder addressLine3(String addressLine3) {
            this.addressLine3 = addressLine3;
            return this;
        }

        public final String getCity() {
            return city;
        }

        public final void setCity(String city) {
            this.city = city;
        }

        @Override
        public final Builder city(String city) {
            this.city = city;
            return this;
        }

        public final String getCountryCode() {
            return countryCode;
        }

        public final void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        @Override
        public final Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public final String getDistrictOrCounty() {
            return districtOrCounty;
        }

        public final void setDistrictOrCounty(String districtOrCounty) {
            this.districtOrCounty = districtOrCounty;
        }

        @Override
        public final Builder districtOrCounty(String districtOrCounty) {
            this.districtOrCounty = districtOrCounty;
            return this;
        }

        public final String getPostalCode() {
            return postalCode;
        }

        public final void setPostalCode(String postalCode) {
            this.postalCode = postalCode;
        }

        @Override
        public final Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public final String getStateOrRegion() {
            return stateOrRegion;
        }

        public final void setStateOrRegion(String stateOrRegion) {
            this.stateOrRegion = stateOrRegion;
        }

        @Override
        public final Builder stateOrRegion(String stateOrRegion) {
            this.stateOrRegion = stateOrRegion;
            return this;
        }

        @Override
        public Address build() {
            return new Address(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
