/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class AddressRoleMapCopier {
    static Map<String, Jurisdiction> copy(Map<String, ? extends Jurisdiction> addressRoleMapParam) {
        Map<String, Jurisdiction> map;
        if (addressRoleMapParam == null || addressRoleMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, Jurisdiction> modifiableMap = new LinkedHashMap<>(addressRoleMapParam.size());
            addressRoleMapParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, Jurisdiction> copyFromBuilder(Map<String, ? extends Jurisdiction.Builder> addressRoleMapParam) {
        Map<String, Jurisdiction> map;
        if (addressRoleMapParam == null || addressRoleMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, Jurisdiction> modifiableMap = new LinkedHashMap<>(addressRoleMapParam.size());
            addressRoleMapParam.forEach((key, value) -> {
                Jurisdiction member = value == null ? null : value.build();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, Jurisdiction.Builder> copyToBuilder(Map<String, ? extends Jurisdiction> addressRoleMapParam) {
        Map<String, Jurisdiction.Builder> map;
        if (addressRoleMapParam == null || addressRoleMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, Jurisdiction.Builder> modifiableMap = new LinkedHashMap<>(addressRoleMapParam.size());
            addressRoleMapParam.forEach((key, value) -> {
                Jurisdiction.Builder member = value == null ? null : value.toBuilder();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, Jurisdiction> copyEnumToString(Map<AddressRoleType, ? extends Jurisdiction> addressRoleMapParam) {
        Map<String, Jurisdiction> map;
        if (addressRoleMapParam == null || addressRoleMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, Jurisdiction> modifiableMap = new LinkedHashMap<>(addressRoleMapParam.size());
            addressRoleMapParam.forEach((key, value) -> {
                String result = key.toString();
                modifiableMap.put(result, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<AddressRoleType, Jurisdiction> copyStringToEnum(Map<String, ? extends Jurisdiction> addressRoleMapParam) {
        Map<AddressRoleType, Jurisdiction> map;
        if (addressRoleMapParam == null || addressRoleMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<AddressRoleType, Jurisdiction> modifiableMap = new LinkedHashMap<>(addressRoleMapParam.size());
            addressRoleMapParam.forEach((key, value) -> {
                AddressRoleType result = AddressRoleType.fromValue(key);
                if (result != AddressRoleType.UNKNOWN_TO_SDK_VERSION) {
                    modifiableMap.put(result, value);
                }
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
