/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Additional tax information associated with your TRN in Canada .
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CanadaAdditionalInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<CanadaAdditionalInfo.Builder, CanadaAdditionalInfo> {
    private static final SdkField<String> CANADA_QUEBEC_SALES_TAX_NUMBER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("canadaQuebecSalesTaxNumber")
            .getter(getter(CanadaAdditionalInfo::canadaQuebecSalesTaxNumber))
            .setter(setter(Builder::canadaQuebecSalesTaxNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canadaQuebecSalesTaxNumber").build())
            .build();

    private static final SdkField<String> CANADA_RETAIL_SALES_TAX_NUMBER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("canadaRetailSalesTaxNumber")
            .getter(getter(CanadaAdditionalInfo::canadaRetailSalesTaxNumber))
            .setter(setter(Builder::canadaRetailSalesTaxNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canadaRetailSalesTaxNumber").build())
            .build();

    private static final SdkField<Boolean> IS_RESELLER_ACCOUNT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isResellerAccount").getter(getter(CanadaAdditionalInfo::isResellerAccount))
            .setter(setter(Builder::isResellerAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isResellerAccount").build()).build();

    private static final SdkField<String> PROVINCIAL_SALES_TAX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("provincialSalesTaxId").getter(getter(CanadaAdditionalInfo::provincialSalesTaxId))
            .setter(setter(Builder::provincialSalesTaxId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provincialSalesTaxId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CANADA_QUEBEC_SALES_TAX_NUMBER_FIELD, CANADA_RETAIL_SALES_TAX_NUMBER_FIELD, IS_RESELLER_ACCOUNT_FIELD,
            PROVINCIAL_SALES_TAX_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String canadaQuebecSalesTaxNumber;

    private final String canadaRetailSalesTaxNumber;

    private final Boolean isResellerAccount;

    private final String provincialSalesTaxId;

    private CanadaAdditionalInfo(BuilderImpl builder) {
        this.canadaQuebecSalesTaxNumber = builder.canadaQuebecSalesTaxNumber;
        this.canadaRetailSalesTaxNumber = builder.canadaRetailSalesTaxNumber;
        this.isResellerAccount = builder.isResellerAccount;
        this.provincialSalesTaxId = builder.provincialSalesTaxId;
    }

    /**
     * <p>
     * The Quebec Sales Tax ID number. Leave blank if you do not have a Quebec Sales Tax ID number.
     * </p>
     * 
     * @return The Quebec Sales Tax ID number. Leave blank if you do not have a Quebec Sales Tax ID number.
     */
    public final String canadaQuebecSalesTaxNumber() {
        return canadaQuebecSalesTaxNumber;
    }

    /**
     * <p>
     * Manitoba Retail Sales Tax ID number. Customers purchasing Amazon Web Services for resale in Manitoba must provide
     * a valid Retail Sales Tax ID number for Manitoba. Leave this blank if you do not have a Retail Sales Tax ID number
     * in Manitoba or are not purchasing Amazon Web Services for resale.
     * </p>
     * 
     * @return Manitoba Retail Sales Tax ID number. Customers purchasing Amazon Web Services for resale in Manitoba must
     *         provide a valid Retail Sales Tax ID number for Manitoba. Leave this blank if you do not have a Retail
     *         Sales Tax ID number in Manitoba or are not purchasing Amazon Web Services for resale.
     */
    public final String canadaRetailSalesTaxNumber() {
        return canadaRetailSalesTaxNumber;
    }

    /**
     * <p>
     * The value for this parameter must be <code>true</code> if the <code>provincialSalesTaxId</code> value is provided
     * for a TRN in British Columbia, Saskatchewan, or Manitoba provinces.
     * </p>
     * <p>
     * To claim a provincial sales tax (PST) and retail sales tax (RST) reseller exemption, you must confirm that
     * purchases from this account were made for resale. Otherwise, remove the PST or RST number from the
     * <code>provincialSalesTaxId</code> parameter from your request.
     * </p>
     * 
     * @return The value for this parameter must be <code>true</code> if the <code>provincialSalesTaxId</code> value is
     *         provided for a TRN in British Columbia, Saskatchewan, or Manitoba provinces. </p>
     *         <p>
     *         To claim a provincial sales tax (PST) and retail sales tax (RST) reseller exemption, you must confirm
     *         that purchases from this account were made for resale. Otherwise, remove the PST or RST number from the
     *         <code>provincialSalesTaxId</code> parameter from your request.
     */
    public final Boolean isResellerAccount() {
        return isResellerAccount;
    }

    /**
     * <p>
     * The provincial sales tax ID for your TRN in Canada. This parameter can represent the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Provincial sales tax ID number for British Columbia and Saskatchewan provinces
     * </p>
     * </li>
     * <li>
     * <p>
     * Manitoba retail sales tax ID number for Manitoba province
     * </p>
     * </li>
     * <li>
     * <p>
     * Quebec sales tax ID number for Quebec province
     * </p>
     * </li>
     * </ul>
     * <p>
     * The Tax Setting API only accepts this parameter if the TRN is specified for the previous provinces. For other
     * provinces, the Tax Settings API doesn't accept this parameter.
     * </p>
     * 
     * @return The provincial sales tax ID for your TRN in Canada. This parameter can represent the following: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Provincial sales tax ID number for British Columbia and Saskatchewan provinces
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Manitoba retail sales tax ID number for Manitoba province
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Quebec sales tax ID number for Quebec province
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The Tax Setting API only accepts this parameter if the TRN is specified for the previous provinces. For
     *         other provinces, the Tax Settings API doesn't accept this parameter.
     */
    public final String provincialSalesTaxId() {
        return provincialSalesTaxId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(canadaQuebecSalesTaxNumber());
        hashCode = 31 * hashCode + Objects.hashCode(canadaRetailSalesTaxNumber());
        hashCode = 31 * hashCode + Objects.hashCode(isResellerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(provincialSalesTaxId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CanadaAdditionalInfo)) {
            return false;
        }
        CanadaAdditionalInfo other = (CanadaAdditionalInfo) obj;
        return Objects.equals(canadaQuebecSalesTaxNumber(), other.canadaQuebecSalesTaxNumber())
                && Objects.equals(canadaRetailSalesTaxNumber(), other.canadaRetailSalesTaxNumber())
                && Objects.equals(isResellerAccount(), other.isResellerAccount())
                && Objects.equals(provincialSalesTaxId(), other.provincialSalesTaxId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CanadaAdditionalInfo").add("CanadaQuebecSalesTaxNumber", canadaQuebecSalesTaxNumber())
                .add("CanadaRetailSalesTaxNumber", canadaRetailSalesTaxNumber()).add("IsResellerAccount", isResellerAccount())
                .add("ProvincialSalesTaxId", provincialSalesTaxId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "canadaQuebecSalesTaxNumber":
            return Optional.ofNullable(clazz.cast(canadaQuebecSalesTaxNumber()));
        case "canadaRetailSalesTaxNumber":
            return Optional.ofNullable(clazz.cast(canadaRetailSalesTaxNumber()));
        case "isResellerAccount":
            return Optional.ofNullable(clazz.cast(isResellerAccount()));
        case "provincialSalesTaxId":
            return Optional.ofNullable(clazz.cast(provincialSalesTaxId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CanadaAdditionalInfo, T> g) {
        return obj -> g.apply((CanadaAdditionalInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CanadaAdditionalInfo> {
        /**
         * <p>
         * The Quebec Sales Tax ID number. Leave blank if you do not have a Quebec Sales Tax ID number.
         * </p>
         * 
         * @param canadaQuebecSalesTaxNumber
         *        The Quebec Sales Tax ID number. Leave blank if you do not have a Quebec Sales Tax ID number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canadaQuebecSalesTaxNumber(String canadaQuebecSalesTaxNumber);

        /**
         * <p>
         * Manitoba Retail Sales Tax ID number. Customers purchasing Amazon Web Services for resale in Manitoba must
         * provide a valid Retail Sales Tax ID number for Manitoba. Leave this blank if you do not have a Retail Sales
         * Tax ID number in Manitoba or are not purchasing Amazon Web Services for resale.
         * </p>
         * 
         * @param canadaRetailSalesTaxNumber
         *        Manitoba Retail Sales Tax ID number. Customers purchasing Amazon Web Services for resale in Manitoba
         *        must provide a valid Retail Sales Tax ID number for Manitoba. Leave this blank if you do not have a
         *        Retail Sales Tax ID number in Manitoba or are not purchasing Amazon Web Services for resale.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canadaRetailSalesTaxNumber(String canadaRetailSalesTaxNumber);

        /**
         * <p>
         * The value for this parameter must be <code>true</code> if the <code>provincialSalesTaxId</code> value is
         * provided for a TRN in British Columbia, Saskatchewan, or Manitoba provinces.
         * </p>
         * <p>
         * To claim a provincial sales tax (PST) and retail sales tax (RST) reseller exemption, you must confirm that
         * purchases from this account were made for resale. Otherwise, remove the PST or RST number from the
         * <code>provincialSalesTaxId</code> parameter from your request.
         * </p>
         * 
         * @param isResellerAccount
         *        The value for this parameter must be <code>true</code> if the <code>provincialSalesTaxId</code> value
         *        is provided for a TRN in British Columbia, Saskatchewan, or Manitoba provinces. </p>
         *        <p>
         *        To claim a provincial sales tax (PST) and retail sales tax (RST) reseller exemption, you must confirm
         *        that purchases from this account were made for resale. Otherwise, remove the PST or RST number from
         *        the <code>provincialSalesTaxId</code> parameter from your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isResellerAccount(Boolean isResellerAccount);

        /**
         * <p>
         * The provincial sales tax ID for your TRN in Canada. This parameter can represent the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Provincial sales tax ID number for British Columbia and Saskatchewan provinces
         * </p>
         * </li>
         * <li>
         * <p>
         * Manitoba retail sales tax ID number for Manitoba province
         * </p>
         * </li>
         * <li>
         * <p>
         * Quebec sales tax ID number for Quebec province
         * </p>
         * </li>
         * </ul>
         * <p>
         * The Tax Setting API only accepts this parameter if the TRN is specified for the previous provinces. For other
         * provinces, the Tax Settings API doesn't accept this parameter.
         * </p>
         * 
         * @param provincialSalesTaxId
         *        The provincial sales tax ID for your TRN in Canada. This parameter can represent the following: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Provincial sales tax ID number for British Columbia and Saskatchewan provinces
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Manitoba retail sales tax ID number for Manitoba province
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Quebec sales tax ID number for Quebec province
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The Tax Setting API only accepts this parameter if the TRN is specified for the previous provinces.
         *        For other provinces, the Tax Settings API doesn't accept this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provincialSalesTaxId(String provincialSalesTaxId);
    }

    static final class BuilderImpl implements Builder {
        private String canadaQuebecSalesTaxNumber;

        private String canadaRetailSalesTaxNumber;

        private Boolean isResellerAccount;

        private String provincialSalesTaxId;

        private BuilderImpl() {
        }

        private BuilderImpl(CanadaAdditionalInfo model) {
            canadaQuebecSalesTaxNumber(model.canadaQuebecSalesTaxNumber);
            canadaRetailSalesTaxNumber(model.canadaRetailSalesTaxNumber);
            isResellerAccount(model.isResellerAccount);
            provincialSalesTaxId(model.provincialSalesTaxId);
        }

        public final String getCanadaQuebecSalesTaxNumber() {
            return canadaQuebecSalesTaxNumber;
        }

        public final void setCanadaQuebecSalesTaxNumber(String canadaQuebecSalesTaxNumber) {
            this.canadaQuebecSalesTaxNumber = canadaQuebecSalesTaxNumber;
        }

        @Override
        public final Builder canadaQuebecSalesTaxNumber(String canadaQuebecSalesTaxNumber) {
            this.canadaQuebecSalesTaxNumber = canadaQuebecSalesTaxNumber;
            return this;
        }

        public final String getCanadaRetailSalesTaxNumber() {
            return canadaRetailSalesTaxNumber;
        }

        public final void setCanadaRetailSalesTaxNumber(String canadaRetailSalesTaxNumber) {
            this.canadaRetailSalesTaxNumber = canadaRetailSalesTaxNumber;
        }

        @Override
        public final Builder canadaRetailSalesTaxNumber(String canadaRetailSalesTaxNumber) {
            this.canadaRetailSalesTaxNumber = canadaRetailSalesTaxNumber;
            return this;
        }

        public final Boolean getIsResellerAccount() {
            return isResellerAccount;
        }

        public final void setIsResellerAccount(Boolean isResellerAccount) {
            this.isResellerAccount = isResellerAccount;
        }

        @Override
        public final Builder isResellerAccount(Boolean isResellerAccount) {
            this.isResellerAccount = isResellerAccount;
            return this;
        }

        public final String getProvincialSalesTaxId() {
            return provincialSalesTaxId;
        }

        public final void setProvincialSalesTaxId(String provincialSalesTaxId) {
            this.provincialSalesTaxId = provincialSalesTaxId;
        }

        @Override
        public final Builder provincialSalesTaxId(String provincialSalesTaxId) {
            this.provincialSalesTaxId = provincialSalesTaxId;
            return this;
        }

        @Override
        public CanadaAdditionalInfo build() {
            return new CanadaAdditionalInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
