/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Additional tax information associated with your TRN in Israel.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IsraelAdditionalInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<IsraelAdditionalInfo.Builder, IsraelAdditionalInfo> {
    private static final SdkField<String> CUSTOMER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customerType").getter(getter(IsraelAdditionalInfo::customerTypeAsString))
            .setter(setter(Builder::customerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerType").build()).build();

    private static final SdkField<String> DEALER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dealerType").getter(getter(IsraelAdditionalInfo::dealerTypeAsString))
            .setter(setter(Builder::dealerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dealerType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_TYPE_FIELD,
            DEALER_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String customerType;

    private final String dealerType;

    private IsraelAdditionalInfo(BuilderImpl builder) {
        this.customerType = builder.customerType;
        this.dealerType = builder.dealerType;
    }

    /**
     * <p>
     * Customer type for your TRN in Israel. The value can be <code>Business</code> or <code>Individual</code>. Use
     * <code>Business</code>for entities such as not-for-profit and financial institutions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #customerType} will
     * return {@link IsraelCustomerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #customerTypeAsString}.
     * </p>
     * 
     * @return Customer type for your TRN in Israel. The value can be <code>Business</code> or <code>Individual</code>.
     *         Use <code>Business</code>for entities such as not-for-profit and financial institutions.
     * @see IsraelCustomerType
     */
    public final IsraelCustomerType customerType() {
        return IsraelCustomerType.fromValue(customerType);
    }

    /**
     * <p>
     * Customer type for your TRN in Israel. The value can be <code>Business</code> or <code>Individual</code>. Use
     * <code>Business</code>for entities such as not-for-profit and financial institutions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #customerType} will
     * return {@link IsraelCustomerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #customerTypeAsString}.
     * </p>
     * 
     * @return Customer type for your TRN in Israel. The value can be <code>Business</code> or <code>Individual</code>.
     *         Use <code>Business</code>for entities such as not-for-profit and financial institutions.
     * @see IsraelCustomerType
     */
    public final String customerTypeAsString() {
        return customerType;
    }

    /**
     * <p>
     * Dealer type for your TRN in Israel. If you're not a local authorized dealer with an Israeli VAT ID, specify your
     * tax identification number so that Amazon Web Services can send you a compliant tax invoice.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dealerType} will
     * return {@link IsraelDealerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dealerTypeAsString}.
     * </p>
     * 
     * @return Dealer type for your TRN in Israel. If you're not a local authorized dealer with an Israeli VAT ID,
     *         specify your tax identification number so that Amazon Web Services can send you a compliant tax invoice.
     * @see IsraelDealerType
     */
    public final IsraelDealerType dealerType() {
        return IsraelDealerType.fromValue(dealerType);
    }

    /**
     * <p>
     * Dealer type for your TRN in Israel. If you're not a local authorized dealer with an Israeli VAT ID, specify your
     * tax identification number so that Amazon Web Services can send you a compliant tax invoice.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dealerType} will
     * return {@link IsraelDealerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dealerTypeAsString}.
     * </p>
     * 
     * @return Dealer type for your TRN in Israel. If you're not a local authorized dealer with an Israeli VAT ID,
     *         specify your tax identification number so that Amazon Web Services can send you a compliant tax invoice.
     * @see IsraelDealerType
     */
    public final String dealerTypeAsString() {
        return dealerType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dealerTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IsraelAdditionalInfo)) {
            return false;
        }
        IsraelAdditionalInfo other = (IsraelAdditionalInfo) obj;
        return Objects.equals(customerTypeAsString(), other.customerTypeAsString())
                && Objects.equals(dealerTypeAsString(), other.dealerTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IsraelAdditionalInfo").add("CustomerType", customerTypeAsString())
                .add("DealerType", dealerTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "customerType":
            return Optional.ofNullable(clazz.cast(customerTypeAsString()));
        case "dealerType":
            return Optional.ofNullable(clazz.cast(dealerTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IsraelAdditionalInfo, T> g) {
        return obj -> g.apply((IsraelAdditionalInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IsraelAdditionalInfo> {
        /**
         * <p>
         * Customer type for your TRN in Israel. The value can be <code>Business</code> or <code>Individual</code>. Use
         * <code>Business</code>for entities such as not-for-profit and financial institutions.
         * </p>
         * 
         * @param customerType
         *        Customer type for your TRN in Israel. The value can be <code>Business</code> or
         *        <code>Individual</code>. Use <code>Business</code>for entities such as not-for-profit and financial
         *        institutions.
         * @see IsraelCustomerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IsraelCustomerType
         */
        Builder customerType(String customerType);

        /**
         * <p>
         * Customer type for your TRN in Israel. The value can be <code>Business</code> or <code>Individual</code>. Use
         * <code>Business</code>for entities such as not-for-profit and financial institutions.
         * </p>
         * 
         * @param customerType
         *        Customer type for your TRN in Israel. The value can be <code>Business</code> or
         *        <code>Individual</code>. Use <code>Business</code>for entities such as not-for-profit and financial
         *        institutions.
         * @see IsraelCustomerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IsraelCustomerType
         */
        Builder customerType(IsraelCustomerType customerType);

        /**
         * <p>
         * Dealer type for your TRN in Israel. If you're not a local authorized dealer with an Israeli VAT ID, specify
         * your tax identification number so that Amazon Web Services can send you a compliant tax invoice.
         * </p>
         * 
         * @param dealerType
         *        Dealer type for your TRN in Israel. If you're not a local authorized dealer with an Israeli VAT ID,
         *        specify your tax identification number so that Amazon Web Services can send you a compliant tax
         *        invoice.
         * @see IsraelDealerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IsraelDealerType
         */
        Builder dealerType(String dealerType);

        /**
         * <p>
         * Dealer type for your TRN in Israel. If you're not a local authorized dealer with an Israeli VAT ID, specify
         * your tax identification number so that Amazon Web Services can send you a compliant tax invoice.
         * </p>
         * 
         * @param dealerType
         *        Dealer type for your TRN in Israel. If you're not a local authorized dealer with an Israeli VAT ID,
         *        specify your tax identification number so that Amazon Web Services can send you a compliant tax
         *        invoice.
         * @see IsraelDealerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IsraelDealerType
         */
        Builder dealerType(IsraelDealerType dealerType);
    }

    static final class BuilderImpl implements Builder {
        private String customerType;

        private String dealerType;

        private BuilderImpl() {
        }

        private BuilderImpl(IsraelAdditionalInfo model) {
            customerType(model.customerType);
            dealerType(model.dealerType);
        }

        public final String getCustomerType() {
            return customerType;
        }

        public final void setCustomerType(String customerType) {
            this.customerType = customerType;
        }

        @Override
        public final Builder customerType(String customerType) {
            this.customerType = customerType;
            return this;
        }

        @Override
        public final Builder customerType(IsraelCustomerType customerType) {
            this.customerType(customerType == null ? null : customerType.toString());
            return this;
        }

        public final String getDealerType() {
            return dealerType;
        }

        public final void setDealerType(String dealerType) {
            this.dealerType = dealerType;
        }

        @Override
        public final Builder dealerType(String dealerType) {
            this.dealerType = dealerType;
            return this;
        }

        @Override
        public final Builder dealerType(IsraelDealerType dealerType) {
            this.dealerType(dealerType == null ? null : dealerType.toString());
            return this;
        }

        @Override
        public IsraelAdditionalInfo build() {
            return new IsraelAdditionalInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
