/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutTaxRegistrationRequest extends TaxSettingsRequest implements
        ToCopyableBuilder<PutTaxRegistrationRequest.Builder, PutTaxRegistrationRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(PutTaxRegistrationRequest::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<TaxRegistrationEntry> TAX_REGISTRATION_ENTRY_FIELD = SdkField
            .<TaxRegistrationEntry> builder(MarshallingType.SDK_POJO).memberName("taxRegistrationEntry")
            .getter(getter(PutTaxRegistrationRequest::taxRegistrationEntry)).setter(setter(Builder::taxRegistrationEntry))
            .constructor(TaxRegistrationEntry::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taxRegistrationEntry").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            TAX_REGISTRATION_ENTRY_FIELD));

    private final String accountId;

    private final TaxRegistrationEntry taxRegistrationEntry;

    private PutTaxRegistrationRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.taxRegistrationEntry = builder.taxRegistrationEntry;
    }

    /**
     * <p>
     * Your unique account identifier.
     * </p>
     * 
     * @return Your unique account identifier.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * Your TRN information that will be stored to the account mentioned in <code>accountId</code>.
     * </p>
     * 
     * @return Your TRN information that will be stored to the account mentioned in <code>accountId</code>.
     */
    public final TaxRegistrationEntry taxRegistrationEntry() {
        return taxRegistrationEntry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(taxRegistrationEntry());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutTaxRegistrationRequest)) {
            return false;
        }
        PutTaxRegistrationRequest other = (PutTaxRegistrationRequest) obj;
        return Objects.equals(accountId(), other.accountId())
                && Objects.equals(taxRegistrationEntry(), other.taxRegistrationEntry());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutTaxRegistrationRequest").add("AccountId", accountId())
                .add("TaxRegistrationEntry", taxRegistrationEntry() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "taxRegistrationEntry":
            return Optional.ofNullable(clazz.cast(taxRegistrationEntry()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutTaxRegistrationRequest, T> g) {
        return obj -> g.apply((PutTaxRegistrationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TaxSettingsRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutTaxRegistrationRequest> {
        /**
         * <p>
         * Your unique account identifier.
         * </p>
         * 
         * @param accountId
         *        Your unique account identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * Your TRN information that will be stored to the account mentioned in <code>accountId</code>.
         * </p>
         * 
         * @param taxRegistrationEntry
         *        Your TRN information that will be stored to the account mentioned in <code>accountId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taxRegistrationEntry(TaxRegistrationEntry taxRegistrationEntry);

        /**
         * <p>
         * Your TRN information that will be stored to the account mentioned in <code>accountId</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TaxRegistrationEntry.Builder} avoiding
         * the need to create one manually via {@link TaxRegistrationEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TaxRegistrationEntry.Builder#build()} is called immediately and
         * its result is passed to {@link #taxRegistrationEntry(TaxRegistrationEntry)}.
         * 
         * @param taxRegistrationEntry
         *        a consumer that will call methods on {@link TaxRegistrationEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taxRegistrationEntry(TaxRegistrationEntry)
         */
        default Builder taxRegistrationEntry(Consumer<TaxRegistrationEntry.Builder> taxRegistrationEntry) {
            return taxRegistrationEntry(TaxRegistrationEntry.builder().applyMutation(taxRegistrationEntry).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TaxSettingsRequest.BuilderImpl implements Builder {
        private String accountId;

        private TaxRegistrationEntry taxRegistrationEntry;

        private BuilderImpl() {
        }

        private BuilderImpl(PutTaxRegistrationRequest model) {
            super(model);
            accountId(model.accountId);
            taxRegistrationEntry(model.taxRegistrationEntry);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final TaxRegistrationEntry.Builder getTaxRegistrationEntry() {
            return taxRegistrationEntry != null ? taxRegistrationEntry.toBuilder() : null;
        }

        public final void setTaxRegistrationEntry(TaxRegistrationEntry.BuilderImpl taxRegistrationEntry) {
            this.taxRegistrationEntry = taxRegistrationEntry != null ? taxRegistrationEntry.build() : null;
        }

        @Override
        public final Builder taxRegistrationEntry(TaxRegistrationEntry taxRegistrationEntry) {
            this.taxRegistrationEntry = taxRegistrationEntry;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutTaxRegistrationRequest build() {
            return new PutTaxRegistrationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
