/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The metadata for your tax document.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TaxDocumentMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<TaxDocumentMetadata.Builder, TaxDocumentMetadata> {
    private static final SdkField<String> TAX_DOCUMENT_ACCESS_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taxDocumentAccessToken").getter(getter(TaxDocumentMetadata::taxDocumentAccessToken))
            .setter(setter(Builder::taxDocumentAccessToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taxDocumentAccessToken").build())
            .build();

    private static final SdkField<String> TAX_DOCUMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taxDocumentName").getter(getter(TaxDocumentMetadata::taxDocumentName))
            .setter(setter(Builder::taxDocumentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taxDocumentName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TAX_DOCUMENT_ACCESS_TOKEN_FIELD, TAX_DOCUMENT_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String taxDocumentAccessToken;

    private final String taxDocumentName;

    private TaxDocumentMetadata(BuilderImpl builder) {
        this.taxDocumentAccessToken = builder.taxDocumentAccessToken;
        this.taxDocumentName = builder.taxDocumentName;
    }

    /**
     * <p>
     * The tax document access token, which contains information that the Tax Settings API uses to locate the tax
     * document.
     * </p>
     * <note>
     * <p>
     * If you update your tax registration, the existing <code>taxDocumentAccessToken</code> won't be valid. To get the
     * latest token, call the <code>GetTaxRegistration</code> or <code>ListTaxRegistrations</code> API operation. This
     * token is valid for 24 hours.
     * </p>
     * </note>
     * 
     * @return The tax document access token, which contains information that the Tax Settings API uses to locate the
     *         tax document.</p> <note>
     *         <p>
     *         If you update your tax registration, the existing <code>taxDocumentAccessToken</code> won't be valid. To
     *         get the latest token, call the <code>GetTaxRegistration</code> or <code>ListTaxRegistrations</code> API
     *         operation. This token is valid for 24 hours.
     *         </p>
     */
    public final String taxDocumentAccessToken() {
        return taxDocumentAccessToken;
    }

    /**
     * <p>
     * The name of your tax document.
     * </p>
     * 
     * @return The name of your tax document.
     */
    public final String taxDocumentName() {
        return taxDocumentName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(taxDocumentAccessToken());
        hashCode = 31 * hashCode + Objects.hashCode(taxDocumentName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaxDocumentMetadata)) {
            return false;
        }
        TaxDocumentMetadata other = (TaxDocumentMetadata) obj;
        return Objects.equals(taxDocumentAccessToken(), other.taxDocumentAccessToken())
                && Objects.equals(taxDocumentName(), other.taxDocumentName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TaxDocumentMetadata").add("TaxDocumentAccessToken", taxDocumentAccessToken())
                .add("TaxDocumentName", taxDocumentName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taxDocumentAccessToken":
            return Optional.ofNullable(clazz.cast(taxDocumentAccessToken()));
        case "taxDocumentName":
            return Optional.ofNullable(clazz.cast(taxDocumentName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TaxDocumentMetadata, T> g) {
        return obj -> g.apply((TaxDocumentMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TaxDocumentMetadata> {
        /**
         * <p>
         * The tax document access token, which contains information that the Tax Settings API uses to locate the tax
         * document.
         * </p>
         * <note>
         * <p>
         * If you update your tax registration, the existing <code>taxDocumentAccessToken</code> won't be valid. To get
         * the latest token, call the <code>GetTaxRegistration</code> or <code>ListTaxRegistrations</code> API
         * operation. This token is valid for 24 hours.
         * </p>
         * </note>
         * 
         * @param taxDocumentAccessToken
         *        The tax document access token, which contains information that the Tax Settings API uses to locate the
         *        tax document.</p> <note>
         *        <p>
         *        If you update your tax registration, the existing <code>taxDocumentAccessToken</code> won't be valid.
         *        To get the latest token, call the <code>GetTaxRegistration</code> or <code>ListTaxRegistrations</code>
         *        API operation. This token is valid for 24 hours.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taxDocumentAccessToken(String taxDocumentAccessToken);

        /**
         * <p>
         * The name of your tax document.
         * </p>
         * 
         * @param taxDocumentName
         *        The name of your tax document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taxDocumentName(String taxDocumentName);
    }

    static final class BuilderImpl implements Builder {
        private String taxDocumentAccessToken;

        private String taxDocumentName;

        private BuilderImpl() {
        }

        private BuilderImpl(TaxDocumentMetadata model) {
            taxDocumentAccessToken(model.taxDocumentAccessToken);
            taxDocumentName(model.taxDocumentName);
        }

        public final String getTaxDocumentAccessToken() {
            return taxDocumentAccessToken;
        }

        public final void setTaxDocumentAccessToken(String taxDocumentAccessToken) {
            this.taxDocumentAccessToken = taxDocumentAccessToken;
        }

        @Override
        public final Builder taxDocumentAccessToken(String taxDocumentAccessToken) {
            this.taxDocumentAccessToken = taxDocumentAccessToken;
            return this;
        }

        public final String getTaxDocumentName() {
            return taxDocumentName;
        }

        public final void setTaxDocumentName(String taxDocumentName) {
            this.taxDocumentName = taxDocumentName;
        }

        @Override
        public final Builder taxDocumentName(String taxDocumentName) {
            this.taxDocumentName = taxDocumentName;
            return this;
        }

        @Override
        public TaxDocumentMetadata build() {
            return new TaxDocumentMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
