/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.taxsettings.model.AccountMetaData;
import software.amazon.awssdk.services.taxsettings.model.TaxInheritanceDetails;
import software.amazon.awssdk.services.taxsettings.model.TaxRegistrationWithJurisdiction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountDetails> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(AccountDetails.getter(AccountDetails::accountId)).setter(AccountDetails.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<AccountMetaData> ACCOUNT_META_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("accountMetaData").getter(AccountDetails.getter(AccountDetails::accountMetaData)).setter(AccountDetails.setter(Builder::accountMetaData)).constructor(AccountMetaData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountMetaData").build()}).build();
    private static final SdkField<TaxInheritanceDetails> TAX_INHERITANCE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("taxInheritanceDetails").getter(AccountDetails.getter(AccountDetails::taxInheritanceDetails)).setter(AccountDetails.setter(Builder::taxInheritanceDetails)).constructor(TaxInheritanceDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taxInheritanceDetails").build()}).build();
    private static final SdkField<TaxRegistrationWithJurisdiction> TAX_REGISTRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("taxRegistration").getter(AccountDetails.getter(AccountDetails::taxRegistration)).setter(AccountDetails.setter(Builder::taxRegistration)).constructor(TaxRegistrationWithJurisdiction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taxRegistration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, ACCOUNT_META_DATA_FIELD, TAX_INHERITANCE_DETAILS_FIELD, TAX_REGISTRATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("accountId", ACCOUNT_ID_FIELD);
            this.put("accountMetaData", ACCOUNT_META_DATA_FIELD);
            this.put("taxInheritanceDetails", TAX_INHERITANCE_DETAILS_FIELD);
            this.put("taxRegistration", TAX_REGISTRATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final AccountMetaData accountMetaData;
    private final TaxInheritanceDetails taxInheritanceDetails;
    private final TaxRegistrationWithJurisdiction taxRegistration;

    private AccountDetails(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.accountMetaData = builder.accountMetaData;
        this.taxInheritanceDetails = builder.taxInheritanceDetails;
        this.taxRegistration = builder.taxRegistration;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final AccountMetaData accountMetaData() {
        return this.accountMetaData;
    }

    public final TaxInheritanceDetails taxInheritanceDetails() {
        return this.taxInheritanceDetails;
    }

    public final TaxRegistrationWithJurisdiction taxRegistration() {
        return this.taxRegistration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountMetaData());
        hashCode = 31 * hashCode + Objects.hashCode(this.taxInheritanceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.taxRegistration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountDetails)) {
            return false;
        }
        AccountDetails other = (AccountDetails)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.accountMetaData(), other.accountMetaData()) && Objects.equals(this.taxInheritanceDetails(), other.taxInheritanceDetails()) && Objects.equals(this.taxRegistration(), other.taxRegistration());
    }

    public final String toString() {
        return ToString.builder((String)"AccountDetails").add("AccountId", (Object)this.accountId()).add("AccountMetaData", (Object)(this.accountMetaData() == null ? null : "*** Sensitive Data Redacted ***")).add("TaxInheritanceDetails", (Object)this.taxInheritanceDetails()).add("TaxRegistration", (Object)(this.taxRegistration() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "accountMetaData": {
                return Optional.ofNullable(clazz.cast(this.accountMetaData()));
            }
            case "taxInheritanceDetails": {
                return Optional.ofNullable(clazz.cast(this.taxInheritanceDetails()));
            }
            case "taxRegistration": {
                return Optional.ofNullable(clazz.cast(this.taxRegistration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AccountDetails, T> g) {
        return obj -> g.apply((AccountDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private AccountMetaData accountMetaData;
        private TaxInheritanceDetails taxInheritanceDetails;
        private TaxRegistrationWithJurisdiction taxRegistration;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountDetails model) {
            this.accountId(model.accountId);
            this.accountMetaData(model.accountMetaData);
            this.taxInheritanceDetails(model.taxInheritanceDetails);
            this.taxRegistration(model.taxRegistration);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final AccountMetaData.Builder getAccountMetaData() {
            return this.accountMetaData != null ? this.accountMetaData.toBuilder() : null;
        }

        public final void setAccountMetaData(AccountMetaData.BuilderImpl accountMetaData) {
            this.accountMetaData = accountMetaData != null ? accountMetaData.build() : null;
        }

        @Override
        public final Builder accountMetaData(AccountMetaData accountMetaData) {
            this.accountMetaData = accountMetaData;
            return this;
        }

        public final TaxInheritanceDetails.Builder getTaxInheritanceDetails() {
            return this.taxInheritanceDetails != null ? this.taxInheritanceDetails.toBuilder() : null;
        }

        public final void setTaxInheritanceDetails(TaxInheritanceDetails.BuilderImpl taxInheritanceDetails) {
            this.taxInheritanceDetails = taxInheritanceDetails != null ? taxInheritanceDetails.build() : null;
        }

        @Override
        public final Builder taxInheritanceDetails(TaxInheritanceDetails taxInheritanceDetails) {
            this.taxInheritanceDetails = taxInheritanceDetails;
            return this;
        }

        public final TaxRegistrationWithJurisdiction.Builder getTaxRegistration() {
            return this.taxRegistration != null ? this.taxRegistration.toBuilder() : null;
        }

        public final void setTaxRegistration(TaxRegistrationWithJurisdiction.BuilderImpl taxRegistration) {
            this.taxRegistration = taxRegistration != null ? taxRegistration.build() : null;
        }

        @Override
        public final Builder taxRegistration(TaxRegistrationWithJurisdiction taxRegistration) {
            this.taxRegistration = taxRegistration;
            return this;
        }

        public AccountDetails build() {
            return new AccountDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountDetails> {
        public Builder accountId(String var1);

        public Builder accountMetaData(AccountMetaData var1);

        default public Builder accountMetaData(Consumer<AccountMetaData.Builder> accountMetaData) {
            return this.accountMetaData((AccountMetaData)((AccountMetaData.Builder)AccountMetaData.builder().applyMutation(accountMetaData)).build());
        }

        public Builder taxInheritanceDetails(TaxInheritanceDetails var1);

        default public Builder taxInheritanceDetails(Consumer<TaxInheritanceDetails.Builder> taxInheritanceDetails) {
            return this.taxInheritanceDetails((TaxInheritanceDetails)((TaxInheritanceDetails.Builder)TaxInheritanceDetails.builder().applyMutation(taxInheritanceDetails)).build());
        }

        public Builder taxRegistration(TaxRegistrationWithJurisdiction var1);

        default public Builder taxRegistration(Consumer<TaxRegistrationWithJurisdiction.Builder> taxRegistration) {
            return this.taxRegistration((TaxRegistrationWithJurisdiction)((TaxRegistrationWithJurisdiction.Builder)TaxRegistrationWithJurisdiction.builder().applyMutation(taxRegistration)).build());
        }
    }
}

