/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.taxsettings.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.taxsettings.model.TaxRegistrationEntry;
import software.amazon.awssdk.services.taxsettings.model.TaxSettingsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutTaxRegistrationRequest
extends TaxSettingsRequest
implements ToCopyableBuilder<Builder, PutTaxRegistrationRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(PutTaxRegistrationRequest.getter(PutTaxRegistrationRequest::accountId)).setter(PutTaxRegistrationRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<TaxRegistrationEntry> TAX_REGISTRATION_ENTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("taxRegistrationEntry").getter(PutTaxRegistrationRequest.getter(PutTaxRegistrationRequest::taxRegistrationEntry)).setter(PutTaxRegistrationRequest.setter(Builder::taxRegistrationEntry)).constructor(TaxRegistrationEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taxRegistrationEntry").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, TAX_REGISTRATION_ENTRY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("accountId", ACCOUNT_ID_FIELD);
            this.put("taxRegistrationEntry", TAX_REGISTRATION_ENTRY_FIELD);
        }
    });
    private final String accountId;
    private final TaxRegistrationEntry taxRegistrationEntry;

    private PutTaxRegistrationRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.taxRegistrationEntry = builder.taxRegistrationEntry;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final TaxRegistrationEntry taxRegistrationEntry() {
        return this.taxRegistrationEntry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taxRegistrationEntry());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutTaxRegistrationRequest)) {
            return false;
        }
        PutTaxRegistrationRequest other = (PutTaxRegistrationRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.taxRegistrationEntry(), other.taxRegistrationEntry());
    }

    public final String toString() {
        return ToString.builder((String)"PutTaxRegistrationRequest").add("AccountId", (Object)this.accountId()).add("TaxRegistrationEntry", (Object)(this.taxRegistrationEntry() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "taxRegistrationEntry": {
                return Optional.ofNullable(clazz.cast(this.taxRegistrationEntry()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PutTaxRegistrationRequest, T> g) {
        return obj -> g.apply((PutTaxRegistrationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TaxSettingsRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private TaxRegistrationEntry taxRegistrationEntry;

        private BuilderImpl() {
        }

        private BuilderImpl(PutTaxRegistrationRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.taxRegistrationEntry(model.taxRegistrationEntry);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final TaxRegistrationEntry.Builder getTaxRegistrationEntry() {
            return this.taxRegistrationEntry != null ? this.taxRegistrationEntry.toBuilder() : null;
        }

        public final void setTaxRegistrationEntry(TaxRegistrationEntry.BuilderImpl taxRegistrationEntry) {
            this.taxRegistrationEntry = taxRegistrationEntry != null ? taxRegistrationEntry.build() : null;
        }

        @Override
        public final Builder taxRegistrationEntry(TaxRegistrationEntry taxRegistrationEntry) {
            this.taxRegistrationEntry = taxRegistrationEntry;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutTaxRegistrationRequest build() {
            return new PutTaxRegistrationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TaxSettingsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutTaxRegistrationRequest> {
        public Builder accountId(String var1);

        public Builder taxRegistrationEntry(TaxRegistrationEntry var1);

        default public Builder taxRegistrationEntry(Consumer<TaxRegistrationEntry.Builder> taxRegistrationEntry) {
            return this.taxRegistrationEntry((TaxRegistrationEntry)((TaxRegistrationEntry.Builder)TaxRegistrationEntry.builder().applyMutation(taxRegistrationEntry)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

