/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.taxsettings.model.Address;
import software.amazon.awssdk.services.taxsettings.model.SupplementalTaxRegistrationType;
import software.amazon.awssdk.services.taxsettings.model.TaxRegistrationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SupplementalTaxRegistration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SupplementalTaxRegistration> {
    private static final SdkField<Address> ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("address").getter(SupplementalTaxRegistration.getter(SupplementalTaxRegistration::address)).setter(SupplementalTaxRegistration.setter(Builder::address)).constructor(Address::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("address").build()}).build();
    private static final SdkField<String> AUTHORITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authorityId").getter(SupplementalTaxRegistration.getter(SupplementalTaxRegistration::authorityId)).setter(SupplementalTaxRegistration.setter(Builder::authorityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorityId").build()}).build();
    private static final SdkField<String> LEGAL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("legalName").getter(SupplementalTaxRegistration.getter(SupplementalTaxRegistration::legalName)).setter(SupplementalTaxRegistration.setter(Builder::legalName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("legalName").build()}).build();
    private static final SdkField<String> REGISTRATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registrationId").getter(SupplementalTaxRegistration.getter(SupplementalTaxRegistration::registrationId)).setter(SupplementalTaxRegistration.setter(Builder::registrationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registrationId").build()}).build();
    private static final SdkField<String> REGISTRATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registrationType").getter(SupplementalTaxRegistration.getter(SupplementalTaxRegistration::registrationTypeAsString)).setter(SupplementalTaxRegistration.setter(Builder::registrationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registrationType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(SupplementalTaxRegistration.getter(SupplementalTaxRegistration::statusAsString)).setter(SupplementalTaxRegistration.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_FIELD, AUTHORITY_ID_FIELD, LEGAL_NAME_FIELD, REGISTRATION_ID_FIELD, REGISTRATION_TYPE_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("address", ADDRESS_FIELD);
            this.put("authorityId", AUTHORITY_ID_FIELD);
            this.put("legalName", LEGAL_NAME_FIELD);
            this.put("registrationId", REGISTRATION_ID_FIELD);
            this.put("registrationType", REGISTRATION_TYPE_FIELD);
            this.put("status", STATUS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Address address;
    private final String authorityId;
    private final String legalName;
    private final String registrationId;
    private final String registrationType;
    private final String status;

    private SupplementalTaxRegistration(BuilderImpl builder) {
        this.address = builder.address;
        this.authorityId = builder.authorityId;
        this.legalName = builder.legalName;
        this.registrationId = builder.registrationId;
        this.registrationType = builder.registrationType;
        this.status = builder.status;
    }

    public final Address address() {
        return this.address;
    }

    public final String authorityId() {
        return this.authorityId;
    }

    public final String legalName() {
        return this.legalName;
    }

    public final String registrationId() {
        return this.registrationId;
    }

    public final SupplementalTaxRegistrationType registrationType() {
        return SupplementalTaxRegistrationType.fromValue(this.registrationType);
    }

    public final String registrationTypeAsString() {
        return this.registrationType;
    }

    public final TaxRegistrationStatus status() {
        return TaxRegistrationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.address());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.legalName());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SupplementalTaxRegistration)) {
            return false;
        }
        SupplementalTaxRegistration other = (SupplementalTaxRegistration)obj;
        return Objects.equals(this.address(), other.address()) && Objects.equals(this.authorityId(), other.authorityId()) && Objects.equals(this.legalName(), other.legalName()) && Objects.equals(this.registrationId(), other.registrationId()) && Objects.equals(this.registrationTypeAsString(), other.registrationTypeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SupplementalTaxRegistration").add("Address", (Object)this.address()).add("AuthorityId", (Object)this.authorityId()).add("LegalName", (Object)this.legalName()).add("RegistrationId", (Object)this.registrationId()).add("RegistrationType", (Object)this.registrationTypeAsString()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "address": {
                return Optional.ofNullable(clazz.cast(this.address()));
            }
            case "authorityId": {
                return Optional.ofNullable(clazz.cast(this.authorityId()));
            }
            case "legalName": {
                return Optional.ofNullable(clazz.cast(this.legalName()));
            }
            case "registrationId": {
                return Optional.ofNullable(clazz.cast(this.registrationId()));
            }
            case "registrationType": {
                return Optional.ofNullable(clazz.cast(this.registrationTypeAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SupplementalTaxRegistration, T> g) {
        return obj -> g.apply((SupplementalTaxRegistration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Address address;
        private String authorityId;
        private String legalName;
        private String registrationId;
        private String registrationType;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(SupplementalTaxRegistration model) {
            this.address(model.address);
            this.authorityId(model.authorityId);
            this.legalName(model.legalName);
            this.registrationId(model.registrationId);
            this.registrationType(model.registrationType);
            this.status(model.status);
        }

        public final Address.Builder getAddress() {
            return this.address != null ? this.address.toBuilder() : null;
        }

        public final void setAddress(Address.BuilderImpl address) {
            this.address = address != null ? address.build() : null;
        }

        @Override
        public final Builder address(Address address) {
            this.address = address;
            return this;
        }

        public final String getAuthorityId() {
            return this.authorityId;
        }

        public final void setAuthorityId(String authorityId) {
            this.authorityId = authorityId;
        }

        @Override
        public final Builder authorityId(String authorityId) {
            this.authorityId = authorityId;
            return this;
        }

        public final String getLegalName() {
            return this.legalName;
        }

        public final void setLegalName(String legalName) {
            this.legalName = legalName;
        }

        @Override
        public final Builder legalName(String legalName) {
            this.legalName = legalName;
            return this;
        }

        public final String getRegistrationId() {
            return this.registrationId;
        }

        public final void setRegistrationId(String registrationId) {
            this.registrationId = registrationId;
        }

        @Override
        public final Builder registrationId(String registrationId) {
            this.registrationId = registrationId;
            return this;
        }

        public final String getRegistrationType() {
            return this.registrationType;
        }

        public final void setRegistrationType(String registrationType) {
            this.registrationType = registrationType;
        }

        @Override
        public final Builder registrationType(String registrationType) {
            this.registrationType = registrationType;
            return this;
        }

        @Override
        public final Builder registrationType(SupplementalTaxRegistrationType registrationType) {
            this.registrationType(registrationType == null ? null : registrationType.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TaxRegistrationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public SupplementalTaxRegistration build() {
            return new SupplementalTaxRegistration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SupplementalTaxRegistration> {
        public Builder address(Address var1);

        default public Builder address(Consumer<Address.Builder> address) {
            return this.address((Address)((Address.Builder)Address.builder().applyMutation(address)).build());
        }

        public Builder authorityId(String var1);

        public Builder legalName(String var1);

        public Builder registrationId(String var1);

        public Builder registrationType(String var1);

        public Builder registrationType(SupplementalTaxRegistrationType var1);

        public Builder status(String var1);

        public Builder status(TaxRegistrationStatus var1);
    }
}

