/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.taxsettings.model.AdditionalInfoRequest;
import software.amazon.awssdk.services.taxsettings.model.Address;
import software.amazon.awssdk.services.taxsettings.model.Sector;
import software.amazon.awssdk.services.taxsettings.model.TaxRegistrationType;
import software.amazon.awssdk.services.taxsettings.model.VerificationDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TaxRegistrationEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TaxRegistrationEntry> {
    private static final SdkField<AdditionalInfoRequest> ADDITIONAL_TAX_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("additionalTaxInformation").getter(TaxRegistrationEntry.getter(TaxRegistrationEntry::additionalTaxInformation)).setter(TaxRegistrationEntry.setter(Builder::additionalTaxInformation)).constructor(AdditionalInfoRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalTaxInformation").build()}).build();
    private static final SdkField<String> CERTIFIED_EMAIL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("certifiedEmailId").getter(TaxRegistrationEntry.getter(TaxRegistrationEntry::certifiedEmailId)).setter(TaxRegistrationEntry.setter(Builder::certifiedEmailId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certifiedEmailId").build()}).build();
    private static final SdkField<Address> LEGAL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("legalAddress").getter(TaxRegistrationEntry.getter(TaxRegistrationEntry::legalAddress)).setter(TaxRegistrationEntry.setter(Builder::legalAddress)).constructor(Address::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("legalAddress").build()}).build();
    private static final SdkField<String> LEGAL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("legalName").getter(TaxRegistrationEntry.getter(TaxRegistrationEntry::legalName)).setter(TaxRegistrationEntry.setter(Builder::legalName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("legalName").build()}).build();
    private static final SdkField<String> REGISTRATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registrationId").getter(TaxRegistrationEntry.getter(TaxRegistrationEntry::registrationId)).setter(TaxRegistrationEntry.setter(Builder::registrationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registrationId").build()}).build();
    private static final SdkField<String> REGISTRATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registrationType").getter(TaxRegistrationEntry.getter(TaxRegistrationEntry::registrationTypeAsString)).setter(TaxRegistrationEntry.setter(Builder::registrationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registrationType").build()}).build();
    private static final SdkField<String> SECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sector").getter(TaxRegistrationEntry.getter(TaxRegistrationEntry::sectorAsString)).setter(TaxRegistrationEntry.setter(Builder::sector)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sector").build()}).build();
    private static final SdkField<VerificationDetails> VERIFICATION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("verificationDetails").getter(TaxRegistrationEntry.getter(TaxRegistrationEntry::verificationDetails)).setter(TaxRegistrationEntry.setter(Builder::verificationDetails)).constructor(VerificationDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("verificationDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_TAX_INFORMATION_FIELD, CERTIFIED_EMAIL_ID_FIELD, LEGAL_ADDRESS_FIELD, LEGAL_NAME_FIELD, REGISTRATION_ID_FIELD, REGISTRATION_TYPE_FIELD, SECTOR_FIELD, VERIFICATION_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("additionalTaxInformation", ADDITIONAL_TAX_INFORMATION_FIELD);
            this.put("certifiedEmailId", CERTIFIED_EMAIL_ID_FIELD);
            this.put("legalAddress", LEGAL_ADDRESS_FIELD);
            this.put("legalName", LEGAL_NAME_FIELD);
            this.put("registrationId", REGISTRATION_ID_FIELD);
            this.put("registrationType", REGISTRATION_TYPE_FIELD);
            this.put("sector", SECTOR_FIELD);
            this.put("verificationDetails", VERIFICATION_DETAILS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final AdditionalInfoRequest additionalTaxInformation;
    private final String certifiedEmailId;
    private final Address legalAddress;
    private final String legalName;
    private final String registrationId;
    private final String registrationType;
    private final String sector;
    private final VerificationDetails verificationDetails;

    private TaxRegistrationEntry(BuilderImpl builder) {
        this.additionalTaxInformation = builder.additionalTaxInformation;
        this.certifiedEmailId = builder.certifiedEmailId;
        this.legalAddress = builder.legalAddress;
        this.legalName = builder.legalName;
        this.registrationId = builder.registrationId;
        this.registrationType = builder.registrationType;
        this.sector = builder.sector;
        this.verificationDetails = builder.verificationDetails;
    }

    public final AdditionalInfoRequest additionalTaxInformation() {
        return this.additionalTaxInformation;
    }

    public final String certifiedEmailId() {
        return this.certifiedEmailId;
    }

    public final Address legalAddress() {
        return this.legalAddress;
    }

    public final String legalName() {
        return this.legalName;
    }

    public final String registrationId() {
        return this.registrationId;
    }

    public final TaxRegistrationType registrationType() {
        return TaxRegistrationType.fromValue(this.registrationType);
    }

    public final String registrationTypeAsString() {
        return this.registrationType;
    }

    public final Sector sector() {
        return Sector.fromValue(this.sector);
    }

    public final String sectorAsString() {
        return this.sector;
    }

    public final VerificationDetails verificationDetails() {
        return this.verificationDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalTaxInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.certifiedEmailId());
        hashCode = 31 * hashCode + Objects.hashCode(this.legalAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.legalName());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sectorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.verificationDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaxRegistrationEntry)) {
            return false;
        }
        TaxRegistrationEntry other = (TaxRegistrationEntry)obj;
        return Objects.equals(this.additionalTaxInformation(), other.additionalTaxInformation()) && Objects.equals(this.certifiedEmailId(), other.certifiedEmailId()) && Objects.equals(this.legalAddress(), other.legalAddress()) && Objects.equals(this.legalName(), other.legalName()) && Objects.equals(this.registrationId(), other.registrationId()) && Objects.equals(this.registrationTypeAsString(), other.registrationTypeAsString()) && Objects.equals(this.sectorAsString(), other.sectorAsString()) && Objects.equals(this.verificationDetails(), other.verificationDetails());
    }

    public final String toString() {
        return ToString.builder((String)"TaxRegistrationEntry").add("AdditionalTaxInformation", (Object)this.additionalTaxInformation()).add("CertifiedEmailId", (Object)this.certifiedEmailId()).add("LegalAddress", (Object)this.legalAddress()).add("LegalName", (Object)this.legalName()).add("RegistrationId", (Object)this.registrationId()).add("RegistrationType", (Object)this.registrationTypeAsString()).add("Sector", (Object)this.sectorAsString()).add("VerificationDetails", (Object)this.verificationDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "additionalTaxInformation": {
                return Optional.ofNullable(clazz.cast(this.additionalTaxInformation()));
            }
            case "certifiedEmailId": {
                return Optional.ofNullable(clazz.cast(this.certifiedEmailId()));
            }
            case "legalAddress": {
                return Optional.ofNullable(clazz.cast(this.legalAddress()));
            }
            case "legalName": {
                return Optional.ofNullable(clazz.cast(this.legalName()));
            }
            case "registrationId": {
                return Optional.ofNullable(clazz.cast(this.registrationId()));
            }
            case "registrationType": {
                return Optional.ofNullable(clazz.cast(this.registrationTypeAsString()));
            }
            case "sector": {
                return Optional.ofNullable(clazz.cast(this.sectorAsString()));
            }
            case "verificationDetails": {
                return Optional.ofNullable(clazz.cast(this.verificationDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TaxRegistrationEntry, T> g) {
        return obj -> g.apply((TaxRegistrationEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AdditionalInfoRequest additionalTaxInformation;
        private String certifiedEmailId;
        private Address legalAddress;
        private String legalName;
        private String registrationId;
        private String registrationType;
        private String sector;
        private VerificationDetails verificationDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(TaxRegistrationEntry model) {
            this.additionalTaxInformation(model.additionalTaxInformation);
            this.certifiedEmailId(model.certifiedEmailId);
            this.legalAddress(model.legalAddress);
            this.legalName(model.legalName);
            this.registrationId(model.registrationId);
            this.registrationType(model.registrationType);
            this.sector(model.sector);
            this.verificationDetails(model.verificationDetails);
        }

        public final AdditionalInfoRequest.Builder getAdditionalTaxInformation() {
            return this.additionalTaxInformation != null ? this.additionalTaxInformation.toBuilder() : null;
        }

        public final void setAdditionalTaxInformation(AdditionalInfoRequest.BuilderImpl additionalTaxInformation) {
            this.additionalTaxInformation = additionalTaxInformation != null ? additionalTaxInformation.build() : null;
        }

        @Override
        public final Builder additionalTaxInformation(AdditionalInfoRequest additionalTaxInformation) {
            this.additionalTaxInformation = additionalTaxInformation;
            return this;
        }

        public final String getCertifiedEmailId() {
            return this.certifiedEmailId;
        }

        public final void setCertifiedEmailId(String certifiedEmailId) {
            this.certifiedEmailId = certifiedEmailId;
        }

        @Override
        public final Builder certifiedEmailId(String certifiedEmailId) {
            this.certifiedEmailId = certifiedEmailId;
            return this;
        }

        public final Address.Builder getLegalAddress() {
            return this.legalAddress != null ? this.legalAddress.toBuilder() : null;
        }

        public final void setLegalAddress(Address.BuilderImpl legalAddress) {
            this.legalAddress = legalAddress != null ? legalAddress.build() : null;
        }

        @Override
        public final Builder legalAddress(Address legalAddress) {
            this.legalAddress = legalAddress;
            return this;
        }

        public final String getLegalName() {
            return this.legalName;
        }

        public final void setLegalName(String legalName) {
            this.legalName = legalName;
        }

        @Override
        public final Builder legalName(String legalName) {
            this.legalName = legalName;
            return this;
        }

        public final String getRegistrationId() {
            return this.registrationId;
        }

        public final void setRegistrationId(String registrationId) {
            this.registrationId = registrationId;
        }

        @Override
        public final Builder registrationId(String registrationId) {
            this.registrationId = registrationId;
            return this;
        }

        public final String getRegistrationType() {
            return this.registrationType;
        }

        public final void setRegistrationType(String registrationType) {
            this.registrationType = registrationType;
        }

        @Override
        public final Builder registrationType(String registrationType) {
            this.registrationType = registrationType;
            return this;
        }

        @Override
        public final Builder registrationType(TaxRegistrationType registrationType) {
            this.registrationType(registrationType == null ? null : registrationType.toString());
            return this;
        }

        public final String getSector() {
            return this.sector;
        }

        public final void setSector(String sector) {
            this.sector = sector;
        }

        @Override
        public final Builder sector(String sector) {
            this.sector = sector;
            return this;
        }

        @Override
        public final Builder sector(Sector sector) {
            this.sector(sector == null ? null : sector.toString());
            return this;
        }

        public final VerificationDetails.Builder getVerificationDetails() {
            return this.verificationDetails != null ? this.verificationDetails.toBuilder() : null;
        }

        public final void setVerificationDetails(VerificationDetails.BuilderImpl verificationDetails) {
            this.verificationDetails = verificationDetails != null ? verificationDetails.build() : null;
        }

        @Override
        public final Builder verificationDetails(VerificationDetails verificationDetails) {
            this.verificationDetails = verificationDetails;
            return this;
        }

        public TaxRegistrationEntry build() {
            return new TaxRegistrationEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TaxRegistrationEntry> {
        public Builder additionalTaxInformation(AdditionalInfoRequest var1);

        default public Builder additionalTaxInformation(Consumer<AdditionalInfoRequest.Builder> additionalTaxInformation) {
            return this.additionalTaxInformation((AdditionalInfoRequest)((AdditionalInfoRequest.Builder)AdditionalInfoRequest.builder().applyMutation(additionalTaxInformation)).build());
        }

        public Builder certifiedEmailId(String var1);

        public Builder legalAddress(Address var1);

        default public Builder legalAddress(Consumer<Address.Builder> legalAddress) {
            return this.legalAddress((Address)((Address.Builder)Address.builder().applyMutation(legalAddress)).build());
        }

        public Builder legalName(String var1);

        public Builder registrationId(String var1);

        public Builder registrationType(String var1);

        public Builder registrationType(TaxRegistrationType var1);

        public Builder sector(String var1);

        public Builder sector(Sector var1);

        public Builder verificationDetails(VerificationDetails var1);

        default public Builder verificationDetails(Consumer<VerificationDetails.Builder> verificationDetails) {
            return this.verificationDetails((VerificationDetails)((VerificationDetails.Builder)VerificationDetails.builder().applyMutation(verificationDetails)).build());
        }
    }
}

