/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetTaxExemptionsResponse extends TaxSettingsResponse implements
        ToCopyableBuilder<BatchGetTaxExemptionsResponse.Builder, BatchGetTaxExemptionsResponse> {
    private static final SdkField<List<String>> FAILED_ACCOUNTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("failedAccounts")
            .getter(getter(BatchGetTaxExemptionsResponse::failedAccounts))
            .setter(setter(Builder::failedAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedAccounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, TaxExemptionDetails>> TAX_EXEMPTION_DETAILS_MAP_FIELD = SdkField
            .<Map<String, TaxExemptionDetails>> builder(MarshallingType.MAP)
            .memberName("taxExemptionDetailsMap")
            .getter(getter(BatchGetTaxExemptionsResponse::taxExemptionDetailsMap))
            .setter(setter(Builder::taxExemptionDetailsMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taxExemptionDetailsMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<TaxExemptionDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(TaxExemptionDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_ACCOUNTS_FIELD,
            TAX_EXEMPTION_DETAILS_MAP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> failedAccounts;

    private final Map<String, TaxExemptionDetails> taxExemptionDetailsMap;

    private BatchGetTaxExemptionsResponse(BuilderImpl builder) {
        super(builder);
        this.failedAccounts = builder.failedAccounts;
        this.taxExemptionDetailsMap = builder.taxExemptionDetailsMap;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailedAccounts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFailedAccounts() {
        return failedAccounts != null && !(failedAccounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of accounts that failed to get tax exemptions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailedAccounts} method.
     * </p>
     * 
     * @return The list of accounts that failed to get tax exemptions.
     */
    public final List<String> failedAccounts() {
        return failedAccounts;
    }

    /**
     * For responses, this returns true if the service returned a value for the TaxExemptionDetailsMap property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTaxExemptionDetailsMap() {
        return taxExemptionDetailsMap != null && !(taxExemptionDetailsMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tax exemption details map of accountId and tax exemption details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTaxExemptionDetailsMap} method.
     * </p>
     * 
     * @return The tax exemption details map of accountId and tax exemption details.
     */
    public final Map<String, TaxExemptionDetails> taxExemptionDetailsMap() {
        return taxExemptionDetailsMap;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFailedAccounts() ? failedAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTaxExemptionDetailsMap() ? taxExemptionDetailsMap() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetTaxExemptionsResponse)) {
            return false;
        }
        BatchGetTaxExemptionsResponse other = (BatchGetTaxExemptionsResponse) obj;
        return hasFailedAccounts() == other.hasFailedAccounts() && Objects.equals(failedAccounts(), other.failedAccounts())
                && hasTaxExemptionDetailsMap() == other.hasTaxExemptionDetailsMap()
                && Objects.equals(taxExemptionDetailsMap(), other.taxExemptionDetailsMap());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetTaxExemptionsResponse")
                .add("FailedAccounts", hasFailedAccounts() ? failedAccounts() : null)
                .add("TaxExemptionDetailsMap", hasTaxExemptionDetailsMap() ? taxExemptionDetailsMap() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "failedAccounts":
            return Optional.ofNullable(clazz.cast(failedAccounts()));
        case "taxExemptionDetailsMap":
            return Optional.ofNullable(clazz.cast(taxExemptionDetailsMap()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("failedAccounts", FAILED_ACCOUNTS_FIELD);
        map.put("taxExemptionDetailsMap", TAX_EXEMPTION_DETAILS_MAP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetTaxExemptionsResponse, T> g) {
        return obj -> g.apply((BatchGetTaxExemptionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TaxSettingsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetTaxExemptionsResponse> {
        /**
         * <p>
         * The list of accounts that failed to get tax exemptions.
         * </p>
         * 
         * @param failedAccounts
         *        The list of accounts that failed to get tax exemptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedAccounts(Collection<String> failedAccounts);

        /**
         * <p>
         * The list of accounts that failed to get tax exemptions.
         * </p>
         * 
         * @param failedAccounts
         *        The list of accounts that failed to get tax exemptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedAccounts(String... failedAccounts);

        /**
         * <p>
         * The tax exemption details map of accountId and tax exemption details.
         * </p>
         * 
         * @param taxExemptionDetailsMap
         *        The tax exemption details map of accountId and tax exemption details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taxExemptionDetailsMap(Map<String, TaxExemptionDetails> taxExemptionDetailsMap);
    }

    static final class BuilderImpl extends TaxSettingsResponse.BuilderImpl implements Builder {
        private List<String> failedAccounts = DefaultSdkAutoConstructList.getInstance();

        private Map<String, TaxExemptionDetails> taxExemptionDetailsMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetTaxExemptionsResponse model) {
            super(model);
            failedAccounts(model.failedAccounts);
            taxExemptionDetailsMap(model.taxExemptionDetailsMap);
        }

        public final Collection<String> getFailedAccounts() {
            if (failedAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return failedAccounts;
        }

        public final void setFailedAccounts(Collection<String> failedAccounts) {
            this.failedAccounts = AccountIdsCopier.copy(failedAccounts);
        }

        @Override
        public final Builder failedAccounts(Collection<String> failedAccounts) {
            this.failedAccounts = AccountIdsCopier.copy(failedAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedAccounts(String... failedAccounts) {
            failedAccounts(Arrays.asList(failedAccounts));
            return this;
        }

        public final Map<String, TaxExemptionDetails.Builder> getTaxExemptionDetailsMap() {
            Map<String, TaxExemptionDetails.Builder> result = TaxExemptionDetailsMapCopier
                    .copyToBuilder(this.taxExemptionDetailsMap);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setTaxExemptionDetailsMap(Map<String, TaxExemptionDetails.BuilderImpl> taxExemptionDetailsMap) {
            this.taxExemptionDetailsMap = TaxExemptionDetailsMapCopier.copyFromBuilder(taxExemptionDetailsMap);
        }

        @Override
        public final Builder taxExemptionDetailsMap(Map<String, TaxExemptionDetails> taxExemptionDetailsMap) {
            this.taxExemptionDetailsMap = TaxExemptionDetailsMapCopier.copy(taxExemptionDetailsMap);
            return this;
        }

        @Override
        public BatchGetTaxExemptionsResponse build() {
            return new BatchGetTaxExemptionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
