/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchPutTaxRegistrationRequest extends TaxSettingsRequest implements
        ToCopyableBuilder<BatchPutTaxRegistrationRequest.Builder, BatchPutTaxRegistrationRequest> {
    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("accountIds")
            .getter(getter(BatchPutTaxRegistrationRequest::accountIds))
            .setter(setter(Builder::accountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TaxRegistrationEntry> TAX_REGISTRATION_ENTRY_FIELD = SdkField
            .<TaxRegistrationEntry> builder(MarshallingType.SDK_POJO).memberName("taxRegistrationEntry")
            .getter(getter(BatchPutTaxRegistrationRequest::taxRegistrationEntry)).setter(setter(Builder::taxRegistrationEntry))
            .constructor(TaxRegistrationEntry::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taxRegistrationEntry").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_IDS_FIELD,
            TAX_REGISTRATION_ENTRY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> accountIds;

    private final TaxRegistrationEntry taxRegistrationEntry;

    private BatchPutTaxRegistrationRequest(BuilderImpl builder) {
        super(builder);
        this.accountIds = builder.accountIds;
        this.taxRegistrationEntry = builder.taxRegistrationEntry;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAccountIds() {
        return accountIds != null && !(accountIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of unique account identifiers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountIds} method.
     * </p>
     * 
     * @return List of unique account identifiers.
     */
    public final List<String> accountIds() {
        return accountIds;
    }

    /**
     * <p>
     * Your TRN information that will be stored to the accounts mentioned in <code>putEntries</code>.
     * </p>
     * 
     * @return Your TRN information that will be stored to the accounts mentioned in <code>putEntries</code>.
     */
    public final TaxRegistrationEntry taxRegistrationEntry() {
        return taxRegistrationEntry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountIds() ? accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(taxRegistrationEntry());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPutTaxRegistrationRequest)) {
            return false;
        }
        BatchPutTaxRegistrationRequest other = (BatchPutTaxRegistrationRequest) obj;
        return hasAccountIds() == other.hasAccountIds() && Objects.equals(accountIds(), other.accountIds())
                && Objects.equals(taxRegistrationEntry(), other.taxRegistrationEntry());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchPutTaxRegistrationRequest").add("AccountIds", hasAccountIds() ? accountIds() : null)
                .add("TaxRegistrationEntry", taxRegistrationEntry() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountIds":
            return Optional.ofNullable(clazz.cast(accountIds()));
        case "taxRegistrationEntry":
            return Optional.ofNullable(clazz.cast(taxRegistrationEntry()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountIds", ACCOUNT_IDS_FIELD);
        map.put("taxRegistrationEntry", TAX_REGISTRATION_ENTRY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchPutTaxRegistrationRequest, T> g) {
        return obj -> g.apply((BatchPutTaxRegistrationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TaxSettingsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchPutTaxRegistrationRequest> {
        /**
         * <p>
         * List of unique account identifiers.
         * </p>
         * 
         * @param accountIds
         *        List of unique account identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(Collection<String> accountIds);

        /**
         * <p>
         * List of unique account identifiers.
         * </p>
         * 
         * @param accountIds
         *        List of unique account identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(String... accountIds);

        /**
         * <p>
         * Your TRN information that will be stored to the accounts mentioned in <code>putEntries</code>.
         * </p>
         * 
         * @param taxRegistrationEntry
         *        Your TRN information that will be stored to the accounts mentioned in <code>putEntries</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taxRegistrationEntry(TaxRegistrationEntry taxRegistrationEntry);

        /**
         * <p>
         * Your TRN information that will be stored to the accounts mentioned in <code>putEntries</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TaxRegistrationEntry.Builder} avoiding
         * the need to create one manually via {@link TaxRegistrationEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TaxRegistrationEntry.Builder#build()} is called immediately and
         * its result is passed to {@link #taxRegistrationEntry(TaxRegistrationEntry)}.
         * 
         * @param taxRegistrationEntry
         *        a consumer that will call methods on {@link TaxRegistrationEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taxRegistrationEntry(TaxRegistrationEntry)
         */
        default Builder taxRegistrationEntry(Consumer<TaxRegistrationEntry.Builder> taxRegistrationEntry) {
            return taxRegistrationEntry(TaxRegistrationEntry.builder().applyMutation(taxRegistrationEntry).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TaxSettingsRequest.BuilderImpl implements Builder {
        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();

        private TaxRegistrationEntry taxRegistrationEntry;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchPutTaxRegistrationRequest model) {
            super(model);
            accountIds(model.accountIds);
            taxRegistrationEntry(model.taxRegistrationEntry);
        }

        public final Collection<String> getAccountIds() {
            if (accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return accountIds;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsCopier.copy(accountIds);
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String... accountIds) {
            accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final TaxRegistrationEntry.Builder getTaxRegistrationEntry() {
            return taxRegistrationEntry != null ? taxRegistrationEntry.toBuilder() : null;
        }

        public final void setTaxRegistrationEntry(TaxRegistrationEntry.BuilderImpl taxRegistrationEntry) {
            this.taxRegistrationEntry = taxRegistrationEntry != null ? taxRegistrationEntry.build() : null;
        }

        @Override
        public final Builder taxRegistrationEntry(TaxRegistrationEntry taxRegistrationEntry) {
            this.taxRegistrationEntry = taxRegistrationEntry;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchPutTaxRegistrationRequest build() {
            return new BatchPutTaxRegistrationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
