/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The exemption certificate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExemptionCertificate implements SdkPojo, Serializable,
        ToCopyableBuilder<ExemptionCertificate.Builder, ExemptionCertificate> {
    private static final SdkField<SdkBytes> DOCUMENT_FILE_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("documentFile").getter(getter(ExemptionCertificate::documentFile)).setter(setter(Builder::documentFile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentFile").build()).build();

    private static final SdkField<String> DOCUMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("documentName").getter(getter(ExemptionCertificate::documentName)).setter(setter(Builder::documentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_FILE_FIELD,
            DOCUMENT_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SdkBytes documentFile;

    private final String documentName;

    private ExemptionCertificate(BuilderImpl builder) {
        this.documentFile = builder.documentFile;
        this.documentName = builder.documentName;
    }

    /**
     * <p>
     * The exemption certificate file content.
     * </p>
     * 
     * @return The exemption certificate file content.
     */
    public final SdkBytes documentFile() {
        return documentFile;
    }

    /**
     * <p>
     * The exemption certificate file name.
     * </p>
     * 
     * @return The exemption certificate file name.
     */
    public final String documentName() {
        return documentName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(documentFile());
        hashCode = 31 * hashCode + Objects.hashCode(documentName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExemptionCertificate)) {
            return false;
        }
        ExemptionCertificate other = (ExemptionCertificate) obj;
        return Objects.equals(documentFile(), other.documentFile()) && Objects.equals(documentName(), other.documentName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExemptionCertificate").add("DocumentFile", documentFile()).add("DocumentName", documentName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "documentFile":
            return Optional.ofNullable(clazz.cast(documentFile()));
        case "documentName":
            return Optional.ofNullable(clazz.cast(documentName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("documentFile", DOCUMENT_FILE_FIELD);
        map.put("documentName", DOCUMENT_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExemptionCertificate, T> g) {
        return obj -> g.apply((ExemptionCertificate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExemptionCertificate> {
        /**
         * <p>
         * The exemption certificate file content.
         * </p>
         * 
         * @param documentFile
         *        The exemption certificate file content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentFile(SdkBytes documentFile);

        /**
         * <p>
         * The exemption certificate file name.
         * </p>
         * 
         * @param documentName
         *        The exemption certificate file name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentName(String documentName);
    }

    static final class BuilderImpl implements Builder {
        private SdkBytes documentFile;

        private String documentName;

        private BuilderImpl() {
        }

        private BuilderImpl(ExemptionCertificate model) {
            documentFile(model.documentFile);
            documentName(model.documentName);
        }

        public final ByteBuffer getDocumentFile() {
            return documentFile == null ? null : documentFile.asByteBuffer();
        }

        public final void setDocumentFile(ByteBuffer documentFile) {
            documentFile(documentFile == null ? null : SdkBytes.fromByteBuffer(documentFile));
        }

        @Override
        public final Builder documentFile(SdkBytes documentFile) {
            this.documentFile = documentFile;
            return this;
        }

        public final String getDocumentName() {
            return documentName;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        @Override
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        @Override
        public ExemptionCertificate build() {
            return new ExemptionCertificate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
