/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTaxRegistrationDocumentRequest extends TaxSettingsRequest implements
        ToCopyableBuilder<GetTaxRegistrationDocumentRequest.Builder, GetTaxRegistrationDocumentRequest> {
    private static final SdkField<DestinationS3Location> DESTINATION_S3_LOCATION_FIELD = SdkField
            .<DestinationS3Location> builder(MarshallingType.SDK_POJO).memberName("destinationS3Location")
            .getter(getter(GetTaxRegistrationDocumentRequest::destinationS3Location))
            .setter(setter(Builder::destinationS3Location)).constructor(DestinationS3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationS3Location").build())
            .build();

    private static final SdkField<TaxDocumentMetadata> TAX_DOCUMENT_METADATA_FIELD = SdkField
            .<TaxDocumentMetadata> builder(MarshallingType.SDK_POJO).memberName("taxDocumentMetadata")
            .getter(getter(GetTaxRegistrationDocumentRequest::taxDocumentMetadata)).setter(setter(Builder::taxDocumentMetadata))
            .constructor(TaxDocumentMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taxDocumentMetadata").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_S3_LOCATION_FIELD,
            TAX_DOCUMENT_METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final DestinationS3Location destinationS3Location;

    private final TaxDocumentMetadata taxDocumentMetadata;

    private GetTaxRegistrationDocumentRequest(BuilderImpl builder) {
        super(builder);
        this.destinationS3Location = builder.destinationS3Location;
        this.taxDocumentMetadata = builder.taxDocumentMetadata;
    }

    /**
     * <p>
     * The Amazon S3 bucket that you specify to download your tax documents to.
     * </p>
     * 
     * @return The Amazon S3 bucket that you specify to download your tax documents to.
     */
    public final DestinationS3Location destinationS3Location() {
        return destinationS3Location;
    }

    /**
     * <p>
     * The metadata for your tax document.
     * </p>
     * 
     * @return The metadata for your tax document.
     */
    public final TaxDocumentMetadata taxDocumentMetadata() {
        return taxDocumentMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(destinationS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(taxDocumentMetadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTaxRegistrationDocumentRequest)) {
            return false;
        }
        GetTaxRegistrationDocumentRequest other = (GetTaxRegistrationDocumentRequest) obj;
        return Objects.equals(destinationS3Location(), other.destinationS3Location())
                && Objects.equals(taxDocumentMetadata(), other.taxDocumentMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTaxRegistrationDocumentRequest").add("DestinationS3Location", destinationS3Location())
                .add("TaxDocumentMetadata", taxDocumentMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "destinationS3Location":
            return Optional.ofNullable(clazz.cast(destinationS3Location()));
        case "taxDocumentMetadata":
            return Optional.ofNullable(clazz.cast(taxDocumentMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("destinationS3Location", DESTINATION_S3_LOCATION_FIELD);
        map.put("taxDocumentMetadata", TAX_DOCUMENT_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTaxRegistrationDocumentRequest, T> g) {
        return obj -> g.apply((GetTaxRegistrationDocumentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TaxSettingsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetTaxRegistrationDocumentRequest> {
        /**
         * <p>
         * The Amazon S3 bucket that you specify to download your tax documents to.
         * </p>
         * 
         * @param destinationS3Location
         *        The Amazon S3 bucket that you specify to download your tax documents to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationS3Location(DestinationS3Location destinationS3Location);

        /**
         * <p>
         * The Amazon S3 bucket that you specify to download your tax documents to.
         * </p>
         * This is a convenience method that creates an instance of the {@link DestinationS3Location.Builder} avoiding
         * the need to create one manually via {@link DestinationS3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DestinationS3Location.Builder#build()} is called immediately and
         * its result is passed to {@link #destinationS3Location(DestinationS3Location)}.
         * 
         * @param destinationS3Location
         *        a consumer that will call methods on {@link DestinationS3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationS3Location(DestinationS3Location)
         */
        default Builder destinationS3Location(Consumer<DestinationS3Location.Builder> destinationS3Location) {
            return destinationS3Location(DestinationS3Location.builder().applyMutation(destinationS3Location).build());
        }

        /**
         * <p>
         * The metadata for your tax document.
         * </p>
         * 
         * @param taxDocumentMetadata
         *        The metadata for your tax document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taxDocumentMetadata(TaxDocumentMetadata taxDocumentMetadata);

        /**
         * <p>
         * The metadata for your tax document.
         * </p>
         * This is a convenience method that creates an instance of the {@link TaxDocumentMetadata.Builder} avoiding the
         * need to create one manually via {@link TaxDocumentMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TaxDocumentMetadata.Builder#build()} is called immediately and
         * its result is passed to {@link #taxDocumentMetadata(TaxDocumentMetadata)}.
         * 
         * @param taxDocumentMetadata
         *        a consumer that will call methods on {@link TaxDocumentMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taxDocumentMetadata(TaxDocumentMetadata)
         */
        default Builder taxDocumentMetadata(Consumer<TaxDocumentMetadata.Builder> taxDocumentMetadata) {
            return taxDocumentMetadata(TaxDocumentMetadata.builder().applyMutation(taxDocumentMetadata).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TaxSettingsRequest.BuilderImpl implements Builder {
        private DestinationS3Location destinationS3Location;

        private TaxDocumentMetadata taxDocumentMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTaxRegistrationDocumentRequest model) {
            super(model);
            destinationS3Location(model.destinationS3Location);
            taxDocumentMetadata(model.taxDocumentMetadata);
        }

        public final DestinationS3Location.Builder getDestinationS3Location() {
            return destinationS3Location != null ? destinationS3Location.toBuilder() : null;
        }

        public final void setDestinationS3Location(DestinationS3Location.BuilderImpl destinationS3Location) {
            this.destinationS3Location = destinationS3Location != null ? destinationS3Location.build() : null;
        }

        @Override
        public final Builder destinationS3Location(DestinationS3Location destinationS3Location) {
            this.destinationS3Location = destinationS3Location;
            return this;
        }

        public final TaxDocumentMetadata.Builder getTaxDocumentMetadata() {
            return taxDocumentMetadata != null ? taxDocumentMetadata.toBuilder() : null;
        }

        public final void setTaxDocumentMetadata(TaxDocumentMetadata.BuilderImpl taxDocumentMetadata) {
            this.taxDocumentMetadata = taxDocumentMetadata != null ? taxDocumentMetadata.build() : null;
        }

        @Override
        public final Builder taxDocumentMetadata(TaxDocumentMetadata taxDocumentMetadata) {
            this.taxDocumentMetadata = taxDocumentMetadata;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTaxRegistrationDocumentRequest build() {
            return new GetTaxRegistrationDocumentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
