/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The jurisdiction details of the TRN information of the customers. This doesn't contain full legal address, and
 * contains only country code and state/region/province.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Jurisdiction implements SdkPojo, Serializable, ToCopyableBuilder<Jurisdiction.Builder, Jurisdiction> {
    private static final SdkField<String> COUNTRY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("countryCode").getter(getter(Jurisdiction::countryCode)).setter(setter(Builder::countryCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("countryCode").build()).build();

    private static final SdkField<String> STATE_OR_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stateOrRegion").getter(getter(Jurisdiction::stateOrRegion)).setter(setter(Builder::stateOrRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateOrRegion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNTRY_CODE_FIELD,
            STATE_OR_REGION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String countryCode;

    private final String stateOrRegion;

    private Jurisdiction(BuilderImpl builder) {
        this.countryCode = builder.countryCode;
        this.stateOrRegion = builder.stateOrRegion;
    }

    /**
     * <p>
     * The country code of the jurisdiction.
     * </p>
     * 
     * @return The country code of the jurisdiction.
     */
    public final String countryCode() {
        return countryCode;
    }

    /**
     * <p>
     * The state, region, or province associated with the country of the jurisdiction, if applicable.
     * </p>
     * 
     * @return The state, region, or province associated with the country of the jurisdiction, if applicable.
     */
    public final String stateOrRegion() {
        return stateOrRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(countryCode());
        hashCode = 31 * hashCode + Objects.hashCode(stateOrRegion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Jurisdiction)) {
            return false;
        }
        Jurisdiction other = (Jurisdiction) obj;
        return Objects.equals(countryCode(), other.countryCode()) && Objects.equals(stateOrRegion(), other.stateOrRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Jurisdiction").add("CountryCode", countryCode()).add("StateOrRegion", stateOrRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "countryCode":
            return Optional.ofNullable(clazz.cast(countryCode()));
        case "stateOrRegion":
            return Optional.ofNullable(clazz.cast(stateOrRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("countryCode", COUNTRY_CODE_FIELD);
        map.put("stateOrRegion", STATE_OR_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Jurisdiction, T> g) {
        return obj -> g.apply((Jurisdiction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Jurisdiction> {
        /**
         * <p>
         * The country code of the jurisdiction.
         * </p>
         * 
         * @param countryCode
         *        The country code of the jurisdiction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countryCode(String countryCode);

        /**
         * <p>
         * The state, region, or province associated with the country of the jurisdiction, if applicable.
         * </p>
         * 
         * @param stateOrRegion
         *        The state, region, or province associated with the country of the jurisdiction, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateOrRegion(String stateOrRegion);
    }

    static final class BuilderImpl implements Builder {
        private String countryCode;

        private String stateOrRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(Jurisdiction model) {
            countryCode(model.countryCode);
            stateOrRegion(model.stateOrRegion);
        }

        public final String getCountryCode() {
            return countryCode;
        }

        public final void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        @Override
        public final Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public final String getStateOrRegion() {
            return stateOrRegion;
        }

        public final void setStateOrRegion(String stateOrRegion) {
            this.stateOrRegion = stateOrRegion;
        }

        @Override
        public final Builder stateOrRegion(String stateOrRegion) {
            this.stateOrRegion = stateOrRegion;
            return this;
        }

        @Override
        public Jurisdiction build() {
            return new Jurisdiction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
