/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutSupplementalTaxRegistrationRequest extends TaxSettingsRequest implements
        ToCopyableBuilder<PutSupplementalTaxRegistrationRequest.Builder, PutSupplementalTaxRegistrationRequest> {
    private static final SdkField<SupplementalTaxRegistrationEntry> TAX_REGISTRATION_ENTRY_FIELD = SdkField
            .<SupplementalTaxRegistrationEntry> builder(MarshallingType.SDK_POJO).memberName("taxRegistrationEntry")
            .getter(getter(PutSupplementalTaxRegistrationRequest::taxRegistrationEntry))
            .setter(setter(Builder::taxRegistrationEntry)).constructor(SupplementalTaxRegistrationEntry::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taxRegistrationEntry").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAX_REGISTRATION_ENTRY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final SupplementalTaxRegistrationEntry taxRegistrationEntry;

    private PutSupplementalTaxRegistrationRequest(BuilderImpl builder) {
        super(builder);
        this.taxRegistrationEntry = builder.taxRegistrationEntry;
    }

    /**
     * <p>
     * The supplemental TRN information that will be stored for the caller account ID.
     * </p>
     * 
     * @return The supplemental TRN information that will be stored for the caller account ID.
     */
    public final SupplementalTaxRegistrationEntry taxRegistrationEntry() {
        return taxRegistrationEntry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(taxRegistrationEntry());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSupplementalTaxRegistrationRequest)) {
            return false;
        }
        PutSupplementalTaxRegistrationRequest other = (PutSupplementalTaxRegistrationRequest) obj;
        return Objects.equals(taxRegistrationEntry(), other.taxRegistrationEntry());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutSupplementalTaxRegistrationRequest")
                .add("TaxRegistrationEntry", taxRegistrationEntry() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taxRegistrationEntry":
            return Optional.ofNullable(clazz.cast(taxRegistrationEntry()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("taxRegistrationEntry", TAX_REGISTRATION_ENTRY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutSupplementalTaxRegistrationRequest, T> g) {
        return obj -> g.apply((PutSupplementalTaxRegistrationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TaxSettingsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutSupplementalTaxRegistrationRequest> {
        /**
         * <p>
         * The supplemental TRN information that will be stored for the caller account ID.
         * </p>
         * 
         * @param taxRegistrationEntry
         *        The supplemental TRN information that will be stored for the caller account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taxRegistrationEntry(SupplementalTaxRegistrationEntry taxRegistrationEntry);

        /**
         * <p>
         * The supplemental TRN information that will be stored for the caller account ID.
         * </p>
         * This is a convenience method that creates an instance of the {@link SupplementalTaxRegistrationEntry.Builder}
         * avoiding the need to create one manually via {@link SupplementalTaxRegistrationEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SupplementalTaxRegistrationEntry.Builder#build()} is called
         * immediately and its result is passed to {@link #taxRegistrationEntry(SupplementalTaxRegistrationEntry)}.
         * 
         * @param taxRegistrationEntry
         *        a consumer that will call methods on {@link SupplementalTaxRegistrationEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taxRegistrationEntry(SupplementalTaxRegistrationEntry)
         */
        default Builder taxRegistrationEntry(Consumer<SupplementalTaxRegistrationEntry.Builder> taxRegistrationEntry) {
            return taxRegistrationEntry(SupplementalTaxRegistrationEntry.builder().applyMutation(taxRegistrationEntry).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TaxSettingsRequest.BuilderImpl implements Builder {
        private SupplementalTaxRegistrationEntry taxRegistrationEntry;

        private BuilderImpl() {
        }

        private BuilderImpl(PutSupplementalTaxRegistrationRequest model) {
            super(model);
            taxRegistrationEntry(model.taxRegistrationEntry);
        }

        public final SupplementalTaxRegistrationEntry.Builder getTaxRegistrationEntry() {
            return taxRegistrationEntry != null ? taxRegistrationEntry.toBuilder() : null;
        }

        public final void setTaxRegistrationEntry(SupplementalTaxRegistrationEntry.BuilderImpl taxRegistrationEntry) {
            this.taxRegistrationEntry = taxRegistrationEntry != null ? taxRegistrationEntry.build() : null;
        }

        @Override
        public final Builder taxRegistrationEntry(SupplementalTaxRegistrationEntry taxRegistrationEntry) {
            this.taxRegistrationEntry = taxRegistrationEntry;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutSupplementalTaxRegistrationRequest build() {
            return new PutSupplementalTaxRegistrationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
