/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Additional tax information associated with your TRN in South Korea.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SouthKoreaAdditionalInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<SouthKoreaAdditionalInfo.Builder, SouthKoreaAdditionalInfo> {
    private static final SdkField<String> BUSINESS_REPRESENTATIVE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("businessRepresentativeName")
            .getter(getter(SouthKoreaAdditionalInfo::businessRepresentativeName))
            .setter(setter(Builder::businessRepresentativeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("businessRepresentativeName").build())
            .build();

    private static final SdkField<String> ITEM_OF_BUSINESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("itemOfBusiness").getter(getter(SouthKoreaAdditionalInfo::itemOfBusiness))
            .setter(setter(Builder::itemOfBusiness))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemOfBusiness").build()).build();

    private static final SdkField<String> LINE_OF_BUSINESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lineOfBusiness").getter(getter(SouthKoreaAdditionalInfo::lineOfBusiness))
            .setter(setter(Builder::lineOfBusiness))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lineOfBusiness").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            BUSINESS_REPRESENTATIVE_NAME_FIELD, ITEM_OF_BUSINESS_FIELD, LINE_OF_BUSINESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String businessRepresentativeName;

    private final String itemOfBusiness;

    private final String lineOfBusiness;

    private SouthKoreaAdditionalInfo(BuilderImpl builder) {
        this.businessRepresentativeName = builder.businessRepresentativeName;
        this.itemOfBusiness = builder.itemOfBusiness;
        this.lineOfBusiness = builder.lineOfBusiness;
    }

    /**
     * <p>
     * The business legal name based on the most recently uploaded tax registration certificate.
     * </p>
     * 
     * @return The business legal name based on the most recently uploaded tax registration certificate.
     */
    public final String businessRepresentativeName() {
        return businessRepresentativeName;
    }

    /**
     * <p>
     * Item of business based on the most recently uploaded tax registration certificate.
     * </p>
     * 
     * @return Item of business based on the most recently uploaded tax registration certificate.
     */
    public final String itemOfBusiness() {
        return itemOfBusiness;
    }

    /**
     * <p>
     * Line of business based on the most recently uploaded tax registration certificate.
     * </p>
     * 
     * @return Line of business based on the most recently uploaded tax registration certificate.
     */
    public final String lineOfBusiness() {
        return lineOfBusiness;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(businessRepresentativeName());
        hashCode = 31 * hashCode + Objects.hashCode(itemOfBusiness());
        hashCode = 31 * hashCode + Objects.hashCode(lineOfBusiness());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SouthKoreaAdditionalInfo)) {
            return false;
        }
        SouthKoreaAdditionalInfo other = (SouthKoreaAdditionalInfo) obj;
        return Objects.equals(businessRepresentativeName(), other.businessRepresentativeName())
                && Objects.equals(itemOfBusiness(), other.itemOfBusiness())
                && Objects.equals(lineOfBusiness(), other.lineOfBusiness());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SouthKoreaAdditionalInfo").add("BusinessRepresentativeName", businessRepresentativeName())
                .add("ItemOfBusiness", itemOfBusiness()).add("LineOfBusiness", lineOfBusiness()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "businessRepresentativeName":
            return Optional.ofNullable(clazz.cast(businessRepresentativeName()));
        case "itemOfBusiness":
            return Optional.ofNullable(clazz.cast(itemOfBusiness()));
        case "lineOfBusiness":
            return Optional.ofNullable(clazz.cast(lineOfBusiness()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("businessRepresentativeName", BUSINESS_REPRESENTATIVE_NAME_FIELD);
        map.put("itemOfBusiness", ITEM_OF_BUSINESS_FIELD);
        map.put("lineOfBusiness", LINE_OF_BUSINESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SouthKoreaAdditionalInfo, T> g) {
        return obj -> g.apply((SouthKoreaAdditionalInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SouthKoreaAdditionalInfo> {
        /**
         * <p>
         * The business legal name based on the most recently uploaded tax registration certificate.
         * </p>
         * 
         * @param businessRepresentativeName
         *        The business legal name based on the most recently uploaded tax registration certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder businessRepresentativeName(String businessRepresentativeName);

        /**
         * <p>
         * Item of business based on the most recently uploaded tax registration certificate.
         * </p>
         * 
         * @param itemOfBusiness
         *        Item of business based on the most recently uploaded tax registration certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemOfBusiness(String itemOfBusiness);

        /**
         * <p>
         * Line of business based on the most recently uploaded tax registration certificate.
         * </p>
         * 
         * @param lineOfBusiness
         *        Line of business based on the most recently uploaded tax registration certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineOfBusiness(String lineOfBusiness);
    }

    static final class BuilderImpl implements Builder {
        private String businessRepresentativeName;

        private String itemOfBusiness;

        private String lineOfBusiness;

        private BuilderImpl() {
        }

        private BuilderImpl(SouthKoreaAdditionalInfo model) {
            businessRepresentativeName(model.businessRepresentativeName);
            itemOfBusiness(model.itemOfBusiness);
            lineOfBusiness(model.lineOfBusiness);
        }

        public final String getBusinessRepresentativeName() {
            return businessRepresentativeName;
        }

        public final void setBusinessRepresentativeName(String businessRepresentativeName) {
            this.businessRepresentativeName = businessRepresentativeName;
        }

        @Override
        public final Builder businessRepresentativeName(String businessRepresentativeName) {
            this.businessRepresentativeName = businessRepresentativeName;
            return this;
        }

        public final String getItemOfBusiness() {
            return itemOfBusiness;
        }

        public final void setItemOfBusiness(String itemOfBusiness) {
            this.itemOfBusiness = itemOfBusiness;
        }

        @Override
        public final Builder itemOfBusiness(String itemOfBusiness) {
            this.itemOfBusiness = itemOfBusiness;
            return this;
        }

        public final String getLineOfBusiness() {
            return lineOfBusiness;
        }

        public final void setLineOfBusiness(String lineOfBusiness) {
            this.lineOfBusiness = lineOfBusiness;
        }

        @Override
        public final Builder lineOfBusiness(String lineOfBusiness) {
            this.lineOfBusiness = lineOfBusiness;
            return this;
        }

        @Override
        public SouthKoreaAdditionalInfo build() {
            return new SouthKoreaAdditionalInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
