/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Supplemental TRN details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SupplementalTaxRegistration implements SdkPojo, Serializable,
        ToCopyableBuilder<SupplementalTaxRegistration.Builder, SupplementalTaxRegistration> {
    private static final SdkField<Address> ADDRESS_FIELD = SdkField.<Address> builder(MarshallingType.SDK_POJO)
            .memberName("address").getter(getter(SupplementalTaxRegistration::address)).setter(setter(Builder::address))
            .constructor(Address::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("address").build()).build();

    private static final SdkField<String> AUTHORITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authorityId").getter(getter(SupplementalTaxRegistration::authorityId))
            .setter(setter(Builder::authorityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorityId").build()).build();

    private static final SdkField<String> LEGAL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("legalName").getter(getter(SupplementalTaxRegistration::legalName)).setter(setter(Builder::legalName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("legalName").build()).build();

    private static final SdkField<String> REGISTRATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registrationId").getter(getter(SupplementalTaxRegistration::registrationId))
            .setter(setter(Builder::registrationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registrationId").build()).build();

    private static final SdkField<String> REGISTRATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registrationType").getter(getter(SupplementalTaxRegistration::registrationTypeAsString))
            .setter(setter(Builder::registrationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registrationType").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(SupplementalTaxRegistration::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_FIELD,
            AUTHORITY_ID_FIELD, LEGAL_NAME_FIELD, REGISTRATION_ID_FIELD, REGISTRATION_TYPE_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Address address;

    private final String authorityId;

    private final String legalName;

    private final String registrationId;

    private final String registrationType;

    private final String status;

    private SupplementalTaxRegistration(BuilderImpl builder) {
        this.address = builder.address;
        this.authorityId = builder.authorityId;
        this.legalName = builder.legalName;
        this.registrationId = builder.registrationId;
        this.registrationType = builder.registrationType;
        this.status = builder.status;
    }

    /**
     * Returns the value of the Address property for this object.
     * 
     * @return The value of the Address property for this object.
     */
    public final Address address() {
        return address;
    }

    /**
     * <p>
     * Unique authority ID for the supplemental TRN.
     * </p>
     * 
     * @return Unique authority ID for the supplemental TRN.
     */
    public final String authorityId() {
        return authorityId;
    }

    /**
     * <p>
     * The legal name associated with your TRN registration.
     * </p>
     * 
     * @return The legal name associated with your TRN registration.
     */
    public final String legalName() {
        return legalName;
    }

    /**
     * <p>
     * The supplemental TRN unique identifier.
     * </p>
     * 
     * @return The supplemental TRN unique identifier.
     */
    public final String registrationId() {
        return registrationId;
    }

    /**
     * <p>
     * Type of supplemental TRN. Currently, this can only be VAT.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #registrationType}
     * will return {@link SupplementalTaxRegistrationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #registrationTypeAsString}.
     * </p>
     * 
     * @return Type of supplemental TRN. Currently, this can only be VAT.
     * @see SupplementalTaxRegistrationType
     */
    public final SupplementalTaxRegistrationType registrationType() {
        return SupplementalTaxRegistrationType.fromValue(registrationType);
    }

    /**
     * <p>
     * Type of supplemental TRN. Currently, this can only be VAT.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #registrationType}
     * will return {@link SupplementalTaxRegistrationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #registrationTypeAsString}.
     * </p>
     * 
     * @return Type of supplemental TRN. Currently, this can only be VAT.
     * @see SupplementalTaxRegistrationType
     */
    public final String registrationTypeAsString() {
        return registrationType;
    }

    /**
     * <p>
     * The status of your TRN.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TaxRegistrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of your TRN.
     * @see TaxRegistrationStatus
     */
    public final TaxRegistrationStatus status() {
        return TaxRegistrationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of your TRN.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TaxRegistrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of your TRN.
     * @see TaxRegistrationStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(address());
        hashCode = 31 * hashCode + Objects.hashCode(authorityId());
        hashCode = 31 * hashCode + Objects.hashCode(legalName());
        hashCode = 31 * hashCode + Objects.hashCode(registrationId());
        hashCode = 31 * hashCode + Objects.hashCode(registrationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SupplementalTaxRegistration)) {
            return false;
        }
        SupplementalTaxRegistration other = (SupplementalTaxRegistration) obj;
        return Objects.equals(address(), other.address()) && Objects.equals(authorityId(), other.authorityId())
                && Objects.equals(legalName(), other.legalName()) && Objects.equals(registrationId(), other.registrationId())
                && Objects.equals(registrationTypeAsString(), other.registrationTypeAsString())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SupplementalTaxRegistration").add("Address", address()).add("AuthorityId", authorityId())
                .add("LegalName", legalName()).add("RegistrationId", registrationId())
                .add("RegistrationType", registrationTypeAsString()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "address":
            return Optional.ofNullable(clazz.cast(address()));
        case "authorityId":
            return Optional.ofNullable(clazz.cast(authorityId()));
        case "legalName":
            return Optional.ofNullable(clazz.cast(legalName()));
        case "registrationId":
            return Optional.ofNullable(clazz.cast(registrationId()));
        case "registrationType":
            return Optional.ofNullable(clazz.cast(registrationTypeAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("address", ADDRESS_FIELD);
        map.put("authorityId", AUTHORITY_ID_FIELD);
        map.put("legalName", LEGAL_NAME_FIELD);
        map.put("registrationId", REGISTRATION_ID_FIELD);
        map.put("registrationType", REGISTRATION_TYPE_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SupplementalTaxRegistration, T> g) {
        return obj -> g.apply((SupplementalTaxRegistration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SupplementalTaxRegistration> {
        /**
         * Sets the value of the Address property for this object.
         *
         * @param address
         *        The new value for the Address property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(Address address);

        /**
         * Sets the value of the Address property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Address.Builder} avoiding the need to
         * create one manually via {@link Address#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Address.Builder#build()} is called immediately and its result is
         * passed to {@link #address(Address)}.
         * 
         * @param address
         *        a consumer that will call methods on {@link Address.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #address(Address)
         */
        default Builder address(Consumer<Address.Builder> address) {
            return address(Address.builder().applyMutation(address).build());
        }

        /**
         * <p>
         * Unique authority ID for the supplemental TRN.
         * </p>
         * 
         * @param authorityId
         *        Unique authority ID for the supplemental TRN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorityId(String authorityId);

        /**
         * <p>
         * The legal name associated with your TRN registration.
         * </p>
         * 
         * @param legalName
         *        The legal name associated with your TRN registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder legalName(String legalName);

        /**
         * <p>
         * The supplemental TRN unique identifier.
         * </p>
         * 
         * @param registrationId
         *        The supplemental TRN unique identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationId(String registrationId);

        /**
         * <p>
         * Type of supplemental TRN. Currently, this can only be VAT.
         * </p>
         * 
         * @param registrationType
         *        Type of supplemental TRN. Currently, this can only be VAT.
         * @see SupplementalTaxRegistrationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SupplementalTaxRegistrationType
         */
        Builder registrationType(String registrationType);

        /**
         * <p>
         * Type of supplemental TRN. Currently, this can only be VAT.
         * </p>
         * 
         * @param registrationType
         *        Type of supplemental TRN. Currently, this can only be VAT.
         * @see SupplementalTaxRegistrationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SupplementalTaxRegistrationType
         */
        Builder registrationType(SupplementalTaxRegistrationType registrationType);

        /**
         * <p>
         * The status of your TRN.
         * </p>
         * 
         * @param status
         *        The status of your TRN.
         * @see TaxRegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaxRegistrationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of your TRN.
         * </p>
         * 
         * @param status
         *        The status of your TRN.
         * @see TaxRegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaxRegistrationStatus
         */
        Builder status(TaxRegistrationStatus status);
    }

    static final class BuilderImpl implements Builder {
        private Address address;

        private String authorityId;

        private String legalName;

        private String registrationId;

        private String registrationType;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(SupplementalTaxRegistration model) {
            address(model.address);
            authorityId(model.authorityId);
            legalName(model.legalName);
            registrationId(model.registrationId);
            registrationType(model.registrationType);
            status(model.status);
        }

        public final Address.Builder getAddress() {
            return address != null ? address.toBuilder() : null;
        }

        public final void setAddress(Address.BuilderImpl address) {
            this.address = address != null ? address.build() : null;
        }

        @Override
        public final Builder address(Address address) {
            this.address = address;
            return this;
        }

        public final String getAuthorityId() {
            return authorityId;
        }

        public final void setAuthorityId(String authorityId) {
            this.authorityId = authorityId;
        }

        @Override
        public final Builder authorityId(String authorityId) {
            this.authorityId = authorityId;
            return this;
        }

        public final String getLegalName() {
            return legalName;
        }

        public final void setLegalName(String legalName) {
            this.legalName = legalName;
        }

        @Override
        public final Builder legalName(String legalName) {
            this.legalName = legalName;
            return this;
        }

        public final String getRegistrationId() {
            return registrationId;
        }

        public final void setRegistrationId(String registrationId) {
            this.registrationId = registrationId;
        }

        @Override
        public final Builder registrationId(String registrationId) {
            this.registrationId = registrationId;
            return this;
        }

        public final String getRegistrationType() {
            return registrationType;
        }

        public final void setRegistrationType(String registrationType) {
            this.registrationType = registrationType;
        }

        @Override
        public final Builder registrationType(String registrationType) {
            this.registrationType = registrationType;
            return this;
        }

        @Override
        public final Builder registrationType(SupplementalTaxRegistrationType registrationType) {
            this.registrationType(registrationType == null ? null : registrationType.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TaxRegistrationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public SupplementalTaxRegistration build() {
            return new SupplementalTaxRegistration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
