/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The tax exemption.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TaxExemption implements SdkPojo, Serializable, ToCopyableBuilder<TaxExemption.Builder, TaxExemption> {
    private static final SdkField<Authority> AUTHORITY_FIELD = SdkField.<Authority> builder(MarshallingType.SDK_POJO)
            .memberName("authority").getter(getter(TaxExemption::authority)).setter(setter(Builder::authority))
            .constructor(Authority::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authority").build()).build();

    private static final SdkField<Instant> EFFECTIVE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("effectiveDate").getter(getter(TaxExemption::effectiveDate)).setter(setter(Builder::effectiveDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effectiveDate").build()).build();

    private static final SdkField<Instant> EXPIRATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("expirationDate").getter(getter(TaxExemption::expirationDate)).setter(setter(Builder::expirationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expirationDate").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(TaxExemption::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> SYSTEM_EFFECTIVE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("systemEffectiveDate").getter(getter(TaxExemption::systemEffectiveDate))
            .setter(setter(Builder::systemEffectiveDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemEffectiveDate").build())
            .build();

    private static final SdkField<TaxExemptionType> TAX_EXEMPTION_TYPE_FIELD = SdkField
            .<TaxExemptionType> builder(MarshallingType.SDK_POJO).memberName("taxExemptionType")
            .getter(getter(TaxExemption::taxExemptionType)).setter(setter(Builder::taxExemptionType))
            .constructor(TaxExemptionType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taxExemptionType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORITY_FIELD,
            EFFECTIVE_DATE_FIELD, EXPIRATION_DATE_FIELD, STATUS_FIELD, SYSTEM_EFFECTIVE_DATE_FIELD, TAX_EXEMPTION_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Authority authority;

    private final Instant effectiveDate;

    private final Instant expirationDate;

    private final String status;

    private final Instant systemEffectiveDate;

    private final TaxExemptionType taxExemptionType;

    private TaxExemption(BuilderImpl builder) {
        this.authority = builder.authority;
        this.effectiveDate = builder.effectiveDate;
        this.expirationDate = builder.expirationDate;
        this.status = builder.status;
        this.systemEffectiveDate = builder.systemEffectiveDate;
        this.taxExemptionType = builder.taxExemptionType;
    }

    /**
     * <p>
     * The address domain associate with tax exemption.
     * </p>
     * 
     * @return The address domain associate with tax exemption.
     */
    public final Authority authority() {
        return authority;
    }

    /**
     * <p>
     * The tax exemption effective date.
     * </p>
     * 
     * @return The tax exemption effective date.
     */
    public final Instant effectiveDate() {
        return effectiveDate;
    }

    /**
     * <p>
     * The tax exemption expiration date.
     * </p>
     * 
     * @return The tax exemption expiration date.
     */
    public final Instant expirationDate() {
        return expirationDate;
    }

    /**
     * <p>
     * The tax exemption status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EntityExemptionAccountStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The tax exemption status.
     * @see EntityExemptionAccountStatus
     */
    public final EntityExemptionAccountStatus status() {
        return EntityExemptionAccountStatus.fromValue(status);
    }

    /**
     * <p>
     * The tax exemption status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EntityExemptionAccountStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The tax exemption status.
     * @see EntityExemptionAccountStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The tax exemption recording time in the <code>TaxSettings</code> system.
     * </p>
     * 
     * @return The tax exemption recording time in the <code>TaxSettings</code> system.
     */
    public final Instant systemEffectiveDate() {
        return systemEffectiveDate;
    }

    /**
     * <p>
     * The tax exemption type.
     * </p>
     * 
     * @return The tax exemption type.
     */
    public final TaxExemptionType taxExemptionType() {
        return taxExemptionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authority());
        hashCode = 31 * hashCode + Objects.hashCode(effectiveDate());
        hashCode = 31 * hashCode + Objects.hashCode(expirationDate());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(systemEffectiveDate());
        hashCode = 31 * hashCode + Objects.hashCode(taxExemptionType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaxExemption)) {
            return false;
        }
        TaxExemption other = (TaxExemption) obj;
        return Objects.equals(authority(), other.authority()) && Objects.equals(effectiveDate(), other.effectiveDate())
                && Objects.equals(expirationDate(), other.expirationDate())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(systemEffectiveDate(), other.systemEffectiveDate())
                && Objects.equals(taxExemptionType(), other.taxExemptionType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TaxExemption").add("Authority", authority()).add("EffectiveDate", effectiveDate())
                .add("ExpirationDate", expirationDate()).add("Status", statusAsString())
                .add("SystemEffectiveDate", systemEffectiveDate()).add("TaxExemptionType", taxExemptionType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authority":
            return Optional.ofNullable(clazz.cast(authority()));
        case "effectiveDate":
            return Optional.ofNullable(clazz.cast(effectiveDate()));
        case "expirationDate":
            return Optional.ofNullable(clazz.cast(expirationDate()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "systemEffectiveDate":
            return Optional.ofNullable(clazz.cast(systemEffectiveDate()));
        case "taxExemptionType":
            return Optional.ofNullable(clazz.cast(taxExemptionType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("authority", AUTHORITY_FIELD);
        map.put("effectiveDate", EFFECTIVE_DATE_FIELD);
        map.put("expirationDate", EXPIRATION_DATE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("systemEffectiveDate", SYSTEM_EFFECTIVE_DATE_FIELD);
        map.put("taxExemptionType", TAX_EXEMPTION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TaxExemption, T> g) {
        return obj -> g.apply((TaxExemption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TaxExemption> {
        /**
         * <p>
         * The address domain associate with tax exemption.
         * </p>
         * 
         * @param authority
         *        The address domain associate with tax exemption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authority(Authority authority);

        /**
         * <p>
         * The address domain associate with tax exemption.
         * </p>
         * This is a convenience method that creates an instance of the {@link Authority.Builder} avoiding the need to
         * create one manually via {@link Authority#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Authority.Builder#build()} is called immediately and its result
         * is passed to {@link #authority(Authority)}.
         * 
         * @param authority
         *        a consumer that will call methods on {@link Authority.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authority(Authority)
         */
        default Builder authority(Consumer<Authority.Builder> authority) {
            return authority(Authority.builder().applyMutation(authority).build());
        }

        /**
         * <p>
         * The tax exemption effective date.
         * </p>
         * 
         * @param effectiveDate
         *        The tax exemption effective date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectiveDate(Instant effectiveDate);

        /**
         * <p>
         * The tax exemption expiration date.
         * </p>
         * 
         * @param expirationDate
         *        The tax exemption expiration date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationDate(Instant expirationDate);

        /**
         * <p>
         * The tax exemption status.
         * </p>
         * 
         * @param status
         *        The tax exemption status.
         * @see EntityExemptionAccountStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityExemptionAccountStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The tax exemption status.
         * </p>
         * 
         * @param status
         *        The tax exemption status.
         * @see EntityExemptionAccountStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityExemptionAccountStatus
         */
        Builder status(EntityExemptionAccountStatus status);

        /**
         * <p>
         * The tax exemption recording time in the <code>TaxSettings</code> system.
         * </p>
         * 
         * @param systemEffectiveDate
         *        The tax exemption recording time in the <code>TaxSettings</code> system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder systemEffectiveDate(Instant systemEffectiveDate);

        /**
         * <p>
         * The tax exemption type.
         * </p>
         * 
         * @param taxExemptionType
         *        The tax exemption type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taxExemptionType(TaxExemptionType taxExemptionType);

        /**
         * <p>
         * The tax exemption type.
         * </p>
         * This is a convenience method that creates an instance of the {@link TaxExemptionType.Builder} avoiding the
         * need to create one manually via {@link TaxExemptionType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TaxExemptionType.Builder#build()} is called immediately and its
         * result is passed to {@link #taxExemptionType(TaxExemptionType)}.
         * 
         * @param taxExemptionType
         *        a consumer that will call methods on {@link TaxExemptionType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taxExemptionType(TaxExemptionType)
         */
        default Builder taxExemptionType(Consumer<TaxExemptionType.Builder> taxExemptionType) {
            return taxExemptionType(TaxExemptionType.builder().applyMutation(taxExemptionType).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Authority authority;

        private Instant effectiveDate;

        private Instant expirationDate;

        private String status;

        private Instant systemEffectiveDate;

        private TaxExemptionType taxExemptionType;

        private BuilderImpl() {
        }

        private BuilderImpl(TaxExemption model) {
            authority(model.authority);
            effectiveDate(model.effectiveDate);
            expirationDate(model.expirationDate);
            status(model.status);
            systemEffectiveDate(model.systemEffectiveDate);
            taxExemptionType(model.taxExemptionType);
        }

        public final Authority.Builder getAuthority() {
            return authority != null ? authority.toBuilder() : null;
        }

        public final void setAuthority(Authority.BuilderImpl authority) {
            this.authority = authority != null ? authority.build() : null;
        }

        @Override
        public final Builder authority(Authority authority) {
            this.authority = authority;
            return this;
        }

        public final Instant getEffectiveDate() {
            return effectiveDate;
        }

        public final void setEffectiveDate(Instant effectiveDate) {
            this.effectiveDate = effectiveDate;
        }

        @Override
        public final Builder effectiveDate(Instant effectiveDate) {
            this.effectiveDate = effectiveDate;
            return this;
        }

        public final Instant getExpirationDate() {
            return expirationDate;
        }

        public final void setExpirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
        }

        @Override
        public final Builder expirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EntityExemptionAccountStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getSystemEffectiveDate() {
            return systemEffectiveDate;
        }

        public final void setSystemEffectiveDate(Instant systemEffectiveDate) {
            this.systemEffectiveDate = systemEffectiveDate;
        }

        @Override
        public final Builder systemEffectiveDate(Instant systemEffectiveDate) {
            this.systemEffectiveDate = systemEffectiveDate;
            return this;
        }

        public final TaxExemptionType.Builder getTaxExemptionType() {
            return taxExemptionType != null ? taxExemptionType.toBuilder() : null;
        }

        public final void setTaxExemptionType(TaxExemptionType.BuilderImpl taxExemptionType) {
            this.taxExemptionType = taxExemptionType != null ? taxExemptionType.build() : null;
        }

        @Override
        public final Builder taxExemptionType(TaxExemptionType taxExemptionType) {
            this.taxExemptionType = taxExemptionType;
            return this;
        }

        @Override
        public TaxExemption build() {
            return new TaxExemption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
