/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The tax exemption details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TaxExemptionDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<TaxExemptionDetails.Builder, TaxExemptionDetails> {
    private static final SdkField<Boolean> HERITAGE_OBTAINED_DETAILS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("heritageObtainedDetails").getter(getter(TaxExemptionDetails::heritageObtainedDetails))
            .setter(setter(Builder::heritageObtainedDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("heritageObtainedDetails").build())
            .build();

    private static final SdkField<String> HERITAGE_OBTAINED_PARENT_ENTITY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("heritageObtainedParentEntity")
            .getter(getter(TaxExemptionDetails::heritageObtainedParentEntity))
            .setter(setter(Builder::heritageObtainedParentEntity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("heritageObtainedParentEntity")
                    .build()).build();

    private static final SdkField<String> HERITAGE_OBTAINED_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("heritageObtainedReason").getter(getter(TaxExemptionDetails::heritageObtainedReason))
            .setter(setter(Builder::heritageObtainedReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("heritageObtainedReason").build())
            .build();

    private static final SdkField<List<TaxExemption>> TAX_EXEMPTIONS_FIELD = SdkField
            .<List<TaxExemption>> builder(MarshallingType.LIST)
            .memberName("taxExemptions")
            .getter(getter(TaxExemptionDetails::taxExemptions))
            .setter(setter(Builder::taxExemptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taxExemptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TaxExemption> builder(MarshallingType.SDK_POJO)
                                            .constructor(TaxExemption::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            HERITAGE_OBTAINED_DETAILS_FIELD, HERITAGE_OBTAINED_PARENT_ENTITY_FIELD, HERITAGE_OBTAINED_REASON_FIELD,
            TAX_EXEMPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean heritageObtainedDetails;

    private final String heritageObtainedParentEntity;

    private final String heritageObtainedReason;

    private final List<TaxExemption> taxExemptions;

    private TaxExemptionDetails(BuilderImpl builder) {
        this.heritageObtainedDetails = builder.heritageObtainedDetails;
        this.heritageObtainedParentEntity = builder.heritageObtainedParentEntity;
        this.heritageObtainedReason = builder.heritageObtainedReason;
        this.taxExemptions = builder.taxExemptions;
    }

    /**
     * <p>
     * The indicator if the tax exemption is inherited from the consolidated billing family management account.
     * </p>
     * 
     * @return The indicator if the tax exemption is inherited from the consolidated billing family management account.
     */
    public final Boolean heritageObtainedDetails() {
        return heritageObtainedDetails;
    }

    /**
     * <p>
     * The consolidated billing family management account the tax exemption inherited from.
     * </p>
     * 
     * @return The consolidated billing family management account the tax exemption inherited from.
     */
    public final String heritageObtainedParentEntity() {
        return heritageObtainedParentEntity;
    }

    /**
     * <p>
     * The reason of the heritage inheritance.
     * </p>
     * 
     * @return The reason of the heritage inheritance.
     */
    public final String heritageObtainedReason() {
        return heritageObtainedReason;
    }

    /**
     * For responses, this returns true if the service returned a value for the TaxExemptions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTaxExemptions() {
        return taxExemptions != null && !(taxExemptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Tax exemptions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTaxExemptions} method.
     * </p>
     * 
     * @return Tax exemptions.
     */
    public final List<TaxExemption> taxExemptions() {
        return taxExemptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(heritageObtainedDetails());
        hashCode = 31 * hashCode + Objects.hashCode(heritageObtainedParentEntity());
        hashCode = 31 * hashCode + Objects.hashCode(heritageObtainedReason());
        hashCode = 31 * hashCode + Objects.hashCode(hasTaxExemptions() ? taxExemptions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaxExemptionDetails)) {
            return false;
        }
        TaxExemptionDetails other = (TaxExemptionDetails) obj;
        return Objects.equals(heritageObtainedDetails(), other.heritageObtainedDetails())
                && Objects.equals(heritageObtainedParentEntity(), other.heritageObtainedParentEntity())
                && Objects.equals(heritageObtainedReason(), other.heritageObtainedReason())
                && hasTaxExemptions() == other.hasTaxExemptions() && Objects.equals(taxExemptions(), other.taxExemptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TaxExemptionDetails").add("HeritageObtainedDetails", heritageObtainedDetails())
                .add("HeritageObtainedParentEntity", heritageObtainedParentEntity())
                .add("HeritageObtainedReason", heritageObtainedReason())
                .add("TaxExemptions", hasTaxExemptions() ? taxExemptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "heritageObtainedDetails":
            return Optional.ofNullable(clazz.cast(heritageObtainedDetails()));
        case "heritageObtainedParentEntity":
            return Optional.ofNullable(clazz.cast(heritageObtainedParentEntity()));
        case "heritageObtainedReason":
            return Optional.ofNullable(clazz.cast(heritageObtainedReason()));
        case "taxExemptions":
            return Optional.ofNullable(clazz.cast(taxExemptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("heritageObtainedDetails", HERITAGE_OBTAINED_DETAILS_FIELD);
        map.put("heritageObtainedParentEntity", HERITAGE_OBTAINED_PARENT_ENTITY_FIELD);
        map.put("heritageObtainedReason", HERITAGE_OBTAINED_REASON_FIELD);
        map.put("taxExemptions", TAX_EXEMPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TaxExemptionDetails, T> g) {
        return obj -> g.apply((TaxExemptionDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TaxExemptionDetails> {
        /**
         * <p>
         * The indicator if the tax exemption is inherited from the consolidated billing family management account.
         * </p>
         * 
         * @param heritageObtainedDetails
         *        The indicator if the tax exemption is inherited from the consolidated billing family management
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder heritageObtainedDetails(Boolean heritageObtainedDetails);

        /**
         * <p>
         * The consolidated billing family management account the tax exemption inherited from.
         * </p>
         * 
         * @param heritageObtainedParentEntity
         *        The consolidated billing family management account the tax exemption inherited from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder heritageObtainedParentEntity(String heritageObtainedParentEntity);

        /**
         * <p>
         * The reason of the heritage inheritance.
         * </p>
         * 
         * @param heritageObtainedReason
         *        The reason of the heritage inheritance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder heritageObtainedReason(String heritageObtainedReason);

        /**
         * <p>
         * Tax exemptions.
         * </p>
         * 
         * @param taxExemptions
         *        Tax exemptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taxExemptions(Collection<TaxExemption> taxExemptions);

        /**
         * <p>
         * Tax exemptions.
         * </p>
         * 
         * @param taxExemptions
         *        Tax exemptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taxExemptions(TaxExemption... taxExemptions);

        /**
         * <p>
         * Tax exemptions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.taxsettings.model.TaxExemption.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.taxsettings.model.TaxExemption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.taxsettings.model.TaxExemption.Builder#build()} is called immediately
         * and its result is passed to {@link #taxExemptions(List<TaxExemption>)}.
         * 
         * @param taxExemptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.taxsettings.model.TaxExemption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taxExemptions(java.util.Collection<TaxExemption>)
         */
        Builder taxExemptions(Consumer<TaxExemption.Builder>... taxExemptions);
    }

    static final class BuilderImpl implements Builder {
        private Boolean heritageObtainedDetails;

        private String heritageObtainedParentEntity;

        private String heritageObtainedReason;

        private List<TaxExemption> taxExemptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TaxExemptionDetails model) {
            heritageObtainedDetails(model.heritageObtainedDetails);
            heritageObtainedParentEntity(model.heritageObtainedParentEntity);
            heritageObtainedReason(model.heritageObtainedReason);
            taxExemptions(model.taxExemptions);
        }

        public final Boolean getHeritageObtainedDetails() {
            return heritageObtainedDetails;
        }

        public final void setHeritageObtainedDetails(Boolean heritageObtainedDetails) {
            this.heritageObtainedDetails = heritageObtainedDetails;
        }

        @Override
        public final Builder heritageObtainedDetails(Boolean heritageObtainedDetails) {
            this.heritageObtainedDetails = heritageObtainedDetails;
            return this;
        }

        public final String getHeritageObtainedParentEntity() {
            return heritageObtainedParentEntity;
        }

        public final void setHeritageObtainedParentEntity(String heritageObtainedParentEntity) {
            this.heritageObtainedParentEntity = heritageObtainedParentEntity;
        }

        @Override
        public final Builder heritageObtainedParentEntity(String heritageObtainedParentEntity) {
            this.heritageObtainedParentEntity = heritageObtainedParentEntity;
            return this;
        }

        public final String getHeritageObtainedReason() {
            return heritageObtainedReason;
        }

        public final void setHeritageObtainedReason(String heritageObtainedReason) {
            this.heritageObtainedReason = heritageObtainedReason;
        }

        @Override
        public final Builder heritageObtainedReason(String heritageObtainedReason) {
            this.heritageObtainedReason = heritageObtainedReason;
            return this;
        }

        public final List<TaxExemption.Builder> getTaxExemptions() {
            List<TaxExemption.Builder> result = TaxExemptionsCopier.copyToBuilder(this.taxExemptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTaxExemptions(Collection<TaxExemption.BuilderImpl> taxExemptions) {
            this.taxExemptions = TaxExemptionsCopier.copyFromBuilder(taxExemptions);
        }

        @Override
        public final Builder taxExemptions(Collection<TaxExemption> taxExemptions) {
            this.taxExemptions = TaxExemptionsCopier.copy(taxExemptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taxExemptions(TaxExemption... taxExemptions) {
            taxExemptions(Arrays.asList(taxExemptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taxExemptions(Consumer<TaxExemption.Builder>... taxExemptions) {
            taxExemptions(Stream.of(taxExemptions).map(c -> TaxExemption.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public TaxExemptionDetails build() {
            return new TaxExemptionDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
