/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Additional tax information associated with your TRN in Turkey.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TurkeyAdditionalInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<TurkeyAdditionalInfo.Builder, TurkeyAdditionalInfo> {
    private static final SdkField<String> INDUSTRIES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("industries").getter(getter(TurkeyAdditionalInfo::industriesAsString))
            .setter(setter(Builder::industries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("industries").build()).build();

    private static final SdkField<String> KEP_EMAIL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kepEmailId").getter(getter(TurkeyAdditionalInfo::kepEmailId)).setter(setter(Builder::kepEmailId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kepEmailId").build()).build();

    private static final SdkField<String> SECONDARY_TAX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("secondaryTaxId").getter(getter(TurkeyAdditionalInfo::secondaryTaxId))
            .setter(setter(Builder::secondaryTaxId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondaryTaxId").build()).build();

    private static final SdkField<String> TAX_OFFICE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taxOffice").getter(getter(TurkeyAdditionalInfo::taxOffice)).setter(setter(Builder::taxOffice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taxOffice").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDUSTRIES_FIELD,
            KEP_EMAIL_ID_FIELD, SECONDARY_TAX_ID_FIELD, TAX_OFFICE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String industries;

    private final String kepEmailId;

    private final String secondaryTaxId;

    private final String taxOffice;

    private TurkeyAdditionalInfo(BuilderImpl builder) {
        this.industries = builder.industries;
        this.kepEmailId = builder.kepEmailId;
        this.secondaryTaxId = builder.secondaryTaxId;
        this.taxOffice = builder.taxOffice;
    }

    /**
     * <p>
     * The industry information that tells the Tax Settings API if you're subject to additional withholding taxes. This
     * information required for business-to-business (B2B) customers. This information is conditionally mandatory for
     * B2B customers who are subject to KDV tax.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #industries} will
     * return {@link Industries#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #industriesAsString}.
     * </p>
     * 
     * @return The industry information that tells the Tax Settings API if you're subject to additional withholding
     *         taxes. This information required for business-to-business (B2B) customers. This information is
     *         conditionally mandatory for B2B customers who are subject to KDV tax.
     * @see Industries
     */
    public final Industries industries() {
        return Industries.fromValue(industries);
    }

    /**
     * <p>
     * The industry information that tells the Tax Settings API if you're subject to additional withholding taxes. This
     * information required for business-to-business (B2B) customers. This information is conditionally mandatory for
     * B2B customers who are subject to KDV tax.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #industries} will
     * return {@link Industries#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #industriesAsString}.
     * </p>
     * 
     * @return The industry information that tells the Tax Settings API if you're subject to additional withholding
     *         taxes. This information required for business-to-business (B2B) customers. This information is
     *         conditionally mandatory for B2B customers who are subject to KDV tax.
     * @see Industries
     */
    public final String industriesAsString() {
        return industries;
    }

    /**
     * <p>
     * The Registered Electronic Mail (REM) that is used to send notarized communication. This parameter is optional for
     * business-to-business (B2B) and business-to-government (B2G) customers. It's not required for business-to-consumer
     * (B2C) customers.
     * </p>
     * 
     * @return The Registered Electronic Mail (REM) that is used to send notarized communication. This parameter is
     *         optional for business-to-business (B2B) and business-to-government (B2G) customers. It's not required for
     *         business-to-consumer (B2C) customers.
     */
    public final String kepEmailId() {
        return kepEmailId;
    }

    /**
     * <p>
     * Secondary tax ID (“harcama birimi VKN”si”). If one isn't provided, we will use your VKN as the secondary ID.
     * </p>
     * 
     * @return Secondary tax ID (“harcama birimi VKN”si”). If one isn't provided, we will use your VKN as the secondary
     *         ID.
     */
    public final String secondaryTaxId() {
        return secondaryTaxId;
    }

    /**
     * <p>
     * The tax office where you're registered. You can enter this information as a string. The Tax Settings API will add
     * this information to your invoice. This parameter is required for business-to-business (B2B) and
     * business-to-government customers. It's not required for business-to-consumer (B2C) customers.
     * </p>
     * 
     * @return The tax office where you're registered. You can enter this information as a string. The Tax Settings API
     *         will add this information to your invoice. This parameter is required for business-to-business (B2B) and
     *         business-to-government customers. It's not required for business-to-consumer (B2C) customers.
     */
    public final String taxOffice() {
        return taxOffice;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(industriesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(kepEmailId());
        hashCode = 31 * hashCode + Objects.hashCode(secondaryTaxId());
        hashCode = 31 * hashCode + Objects.hashCode(taxOffice());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TurkeyAdditionalInfo)) {
            return false;
        }
        TurkeyAdditionalInfo other = (TurkeyAdditionalInfo) obj;
        return Objects.equals(industriesAsString(), other.industriesAsString())
                && Objects.equals(kepEmailId(), other.kepEmailId()) && Objects.equals(secondaryTaxId(), other.secondaryTaxId())
                && Objects.equals(taxOffice(), other.taxOffice());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TurkeyAdditionalInfo").add("Industries", industriesAsString()).add("KepEmailId", kepEmailId())
                .add("SecondaryTaxId", secondaryTaxId()).add("TaxOffice", taxOffice()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "industries":
            return Optional.ofNullable(clazz.cast(industriesAsString()));
        case "kepEmailId":
            return Optional.ofNullable(clazz.cast(kepEmailId()));
        case "secondaryTaxId":
            return Optional.ofNullable(clazz.cast(secondaryTaxId()));
        case "taxOffice":
            return Optional.ofNullable(clazz.cast(taxOffice()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("industries", INDUSTRIES_FIELD);
        map.put("kepEmailId", KEP_EMAIL_ID_FIELD);
        map.put("secondaryTaxId", SECONDARY_TAX_ID_FIELD);
        map.put("taxOffice", TAX_OFFICE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TurkeyAdditionalInfo, T> g) {
        return obj -> g.apply((TurkeyAdditionalInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TurkeyAdditionalInfo> {
        /**
         * <p>
         * The industry information that tells the Tax Settings API if you're subject to additional withholding taxes.
         * This information required for business-to-business (B2B) customers. This information is conditionally
         * mandatory for B2B customers who are subject to KDV tax.
         * </p>
         * 
         * @param industries
         *        The industry information that tells the Tax Settings API if you're subject to additional withholding
         *        taxes. This information required for business-to-business (B2B) customers. This information is
         *        conditionally mandatory for B2B customers who are subject to KDV tax.
         * @see Industries
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Industries
         */
        Builder industries(String industries);

        /**
         * <p>
         * The industry information that tells the Tax Settings API if you're subject to additional withholding taxes.
         * This information required for business-to-business (B2B) customers. This information is conditionally
         * mandatory for B2B customers who are subject to KDV tax.
         * </p>
         * 
         * @param industries
         *        The industry information that tells the Tax Settings API if you're subject to additional withholding
         *        taxes. This information required for business-to-business (B2B) customers. This information is
         *        conditionally mandatory for B2B customers who are subject to KDV tax.
         * @see Industries
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Industries
         */
        Builder industries(Industries industries);

        /**
         * <p>
         * The Registered Electronic Mail (REM) that is used to send notarized communication. This parameter is optional
         * for business-to-business (B2B) and business-to-government (B2G) customers. It's not required for
         * business-to-consumer (B2C) customers.
         * </p>
         * 
         * @param kepEmailId
         *        The Registered Electronic Mail (REM) that is used to send notarized communication. This parameter is
         *        optional for business-to-business (B2B) and business-to-government (B2G) customers. It's not required
         *        for business-to-consumer (B2C) customers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kepEmailId(String kepEmailId);

        /**
         * <p>
         * Secondary tax ID (“harcama birimi VKN”si”). If one isn't provided, we will use your VKN as the secondary ID.
         * </p>
         * 
         * @param secondaryTaxId
         *        Secondary tax ID (“harcama birimi VKN”si”). If one isn't provided, we will use your VKN as the
         *        secondary ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryTaxId(String secondaryTaxId);

        /**
         * <p>
         * The tax office where you're registered. You can enter this information as a string. The Tax Settings API will
         * add this information to your invoice. This parameter is required for business-to-business (B2B) and
         * business-to-government customers. It's not required for business-to-consumer (B2C) customers.
         * </p>
         * 
         * @param taxOffice
         *        The tax office where you're registered. You can enter this information as a string. The Tax Settings
         *        API will add this information to your invoice. This parameter is required for business-to-business
         *        (B2B) and business-to-government customers. It's not required for business-to-consumer (B2C)
         *        customers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taxOffice(String taxOffice);
    }

    static final class BuilderImpl implements Builder {
        private String industries;

        private String kepEmailId;

        private String secondaryTaxId;

        private String taxOffice;

        private BuilderImpl() {
        }

        private BuilderImpl(TurkeyAdditionalInfo model) {
            industries(model.industries);
            kepEmailId(model.kepEmailId);
            secondaryTaxId(model.secondaryTaxId);
            taxOffice(model.taxOffice);
        }

        public final String getIndustries() {
            return industries;
        }

        public final void setIndustries(String industries) {
            this.industries = industries;
        }

        @Override
        public final Builder industries(String industries) {
            this.industries = industries;
            return this;
        }

        @Override
        public final Builder industries(Industries industries) {
            this.industries(industries == null ? null : industries.toString());
            return this;
        }

        public final String getKepEmailId() {
            return kepEmailId;
        }

        public final void setKepEmailId(String kepEmailId) {
            this.kepEmailId = kepEmailId;
        }

        @Override
        public final Builder kepEmailId(String kepEmailId) {
            this.kepEmailId = kepEmailId;
            return this;
        }

        public final String getSecondaryTaxId() {
            return secondaryTaxId;
        }

        public final void setSecondaryTaxId(String secondaryTaxId) {
            this.secondaryTaxId = secondaryTaxId;
        }

        @Override
        public final Builder secondaryTaxId(String secondaryTaxId) {
            this.secondaryTaxId = secondaryTaxId;
            return this;
        }

        public final String getTaxOffice() {
            return taxOffice;
        }

        public final void setTaxOffice(String taxOffice) {
            this.taxOffice = taxOffice;
        }

        @Override
        public final Builder taxOffice(String taxOffice) {
            this.taxOffice = taxOffice;
            return this;
        }

        @Override
        public TurkeyAdditionalInfo build() {
            return new TurkeyAdditionalInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
