/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.taxsettings.model.AccessDeniedException;
import software.amazon.awssdk.services.taxsettings.model.AttachmentUploadException;
import software.amazon.awssdk.services.taxsettings.model.BatchDeleteTaxRegistrationRequest;
import software.amazon.awssdk.services.taxsettings.model.BatchDeleteTaxRegistrationResponse;
import software.amazon.awssdk.services.taxsettings.model.BatchGetTaxExemptionsRequest;
import software.amazon.awssdk.services.taxsettings.model.BatchGetTaxExemptionsResponse;
import software.amazon.awssdk.services.taxsettings.model.BatchPutTaxRegistrationRequest;
import software.amazon.awssdk.services.taxsettings.model.BatchPutTaxRegistrationResponse;
import software.amazon.awssdk.services.taxsettings.model.CaseCreationLimitExceededException;
import software.amazon.awssdk.services.taxsettings.model.ConflictException;
import software.amazon.awssdk.services.taxsettings.model.DeleteSupplementalTaxRegistrationRequest;
import software.amazon.awssdk.services.taxsettings.model.DeleteSupplementalTaxRegistrationResponse;
import software.amazon.awssdk.services.taxsettings.model.DeleteTaxRegistrationRequest;
import software.amazon.awssdk.services.taxsettings.model.DeleteTaxRegistrationResponse;
import software.amazon.awssdk.services.taxsettings.model.GetTaxExemptionTypesRequest;
import software.amazon.awssdk.services.taxsettings.model.GetTaxExemptionTypesResponse;
import software.amazon.awssdk.services.taxsettings.model.GetTaxInheritanceRequest;
import software.amazon.awssdk.services.taxsettings.model.GetTaxInheritanceResponse;
import software.amazon.awssdk.services.taxsettings.model.GetTaxRegistrationDocumentRequest;
import software.amazon.awssdk.services.taxsettings.model.GetTaxRegistrationDocumentResponse;
import software.amazon.awssdk.services.taxsettings.model.GetTaxRegistrationRequest;
import software.amazon.awssdk.services.taxsettings.model.GetTaxRegistrationResponse;
import software.amazon.awssdk.services.taxsettings.model.InternalServerException;
import software.amazon.awssdk.services.taxsettings.model.ListSupplementalTaxRegistrationsRequest;
import software.amazon.awssdk.services.taxsettings.model.ListSupplementalTaxRegistrationsResponse;
import software.amazon.awssdk.services.taxsettings.model.ListTaxExemptionsRequest;
import software.amazon.awssdk.services.taxsettings.model.ListTaxExemptionsResponse;
import software.amazon.awssdk.services.taxsettings.model.ListTaxRegistrationsRequest;
import software.amazon.awssdk.services.taxsettings.model.ListTaxRegistrationsResponse;
import software.amazon.awssdk.services.taxsettings.model.PutSupplementalTaxRegistrationRequest;
import software.amazon.awssdk.services.taxsettings.model.PutSupplementalTaxRegistrationResponse;
import software.amazon.awssdk.services.taxsettings.model.PutTaxExemptionRequest;
import software.amazon.awssdk.services.taxsettings.model.PutTaxExemptionResponse;
import software.amazon.awssdk.services.taxsettings.model.PutTaxInheritanceRequest;
import software.amazon.awssdk.services.taxsettings.model.PutTaxInheritanceResponse;
import software.amazon.awssdk.services.taxsettings.model.PutTaxRegistrationRequest;
import software.amazon.awssdk.services.taxsettings.model.PutTaxRegistrationResponse;
import software.amazon.awssdk.services.taxsettings.model.ResourceNotFoundException;
import software.amazon.awssdk.services.taxsettings.model.TaxSettingsException;
import software.amazon.awssdk.services.taxsettings.model.ValidationException;
import software.amazon.awssdk.services.taxsettings.paginators.ListSupplementalTaxRegistrationsIterable;
import software.amazon.awssdk.services.taxsettings.paginators.ListTaxExemptionsIterable;
import software.amazon.awssdk.services.taxsettings.paginators.ListTaxRegistrationsIterable;

/**
 * Service client for accessing Tax Settings. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * You can use the tax setting API to programmatically set, modify, and delete the tax registration number (TRN),
 * associated business legal name, and address (Collectively referred to as "TRN information"). You can also
 * programmatically view TRN information and tax addresses ("Tax profiles").
 * </p>
 * <p>
 * You can use this API to automate your TRN information settings instead of manually using the console.
 * </p>
 * <p>
 * Service Endpoint
 * </p>
 * <ul>
 * <li>
 * <p>
 * https://tax.us-east-1.amazonaws.com
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface TaxSettingsClient extends AwsClient {
    String SERVICE_NAME = "tax";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "tax";

    /**
     * <p>
     * Deletes tax registration for multiple accounts in batch. This can be used to delete tax registrations for up to
     * five accounts in one batch.
     * </p>
     * <note>
     * <p>
     * This API operation can't be used to delete your tax registration in Brazil. Use the <a
     * href="https://console.aws.amazon.com/billing/home#/paymentpreferences/paymentmethods">Payment preferences</a>
     * page in the Billing and Cost Management console instead.
     * </p>
     * </note>
     *
     * @param batchDeleteTaxRegistrationRequest
     * @return Result of the BatchDeleteTaxRegistration operation returned by the service.
     * @throws ValidationException
     *         The exception when the input doesn't pass validation for at least one of the input parameters.
     * @throws ConflictException
     *         The exception when the input is creating conflict with the given state.
     * @throws InternalServerException
     *         The exception thrown when an unexpected error occurs when processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TaxSettingsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TaxSettingsClient.BatchDeleteTaxRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/BatchDeleteTaxRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDeleteTaxRegistrationResponse batchDeleteTaxRegistration(
            BatchDeleteTaxRegistrationRequest batchDeleteTaxRegistrationRequest) throws ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, TaxSettingsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes tax registration for multiple accounts in batch. This can be used to delete tax registrations for up to
     * five accounts in one batch.
     * </p>
     * <note>
     * <p>
     * This API operation can't be used to delete your tax registration in Brazil. Use the <a
     * href="https://console.aws.amazon.com/billing/home#/paymentpreferences/paymentmethods">Payment preferences</a>
     * page in the Billing and Cost Management console instead.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteTaxRegistrationRequest.Builder} avoiding
     * the need to create one manually via {@link BatchDeleteTaxRegistrationRequest#builder()}
     * </p>
     *
     * @param batchDeleteTaxRegistrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.taxsettings.model.BatchDeleteTaxRegistrationRequest.Builder} to
     *        create a request.
     * @return Result of the BatchDeleteTaxRegistration operation returned by the service.
     * @throws ValidationException
     *         The exception when the input doesn't pass validation for at least one of the input parameters.
     * @throws ConflictException
     *         The exception when the input is creating conflict with the given state.
     * @throws InternalServerException
     *         The exception thrown when an unexpected error occurs when processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TaxSettingsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TaxSettingsClient.BatchDeleteTaxRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/BatchDeleteTaxRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDeleteTaxRegistrationResponse batchDeleteTaxRegistration(
            Consumer<BatchDeleteTaxRegistrationRequest.Builder> batchDeleteTaxRegistrationRequest) throws ValidationException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, TaxSettingsException {
        return batchDeleteTaxRegistration(BatchDeleteTaxRegistrationRequest.builder()
                .applyMutation(batchDeleteTaxRegistrationRequest).build());
    }

    /**
     * <p>
     * Get the active tax exemptions for a given list of accounts.
     * </p>
     *
     * @param batchGetTaxExemptionsRequest
     * @return Result of the BatchGetTaxExemptions operation returned by the service.
     * @throws ValidationException
     *         The exception when the input doesn't pass validation for at least one of the input parameters.
     * @throws ResourceNotFoundException
     *         The exception thrown when the input doesn't have a resource associated to it.
     * @throws InternalServerException
     *         The exception thrown when an unexpected error occurs when processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TaxSettingsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TaxSettingsClient.BatchGetTaxExemptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/BatchGetTaxExemptions"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetTaxExemptionsResponse batchGetTaxExemptions(BatchGetTaxExemptionsRequest batchGetTaxExemptionsRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, TaxSettingsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the active tax exemptions for a given list of accounts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetTaxExemptionsRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetTaxExemptionsRequest#builder()}
     * </p>
     *
     * @param batchGetTaxExemptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.taxsettings.model.BatchGetTaxExemptionsRequest.Builder} to create a
     *        request.
     * @return Result of the BatchGetTaxExemptions operation returned by the service.
     * @throws ValidationException
     *         The exception when the input doesn't pass validation for at least one of the input parameters.
     * @throws ResourceNotFoundException
     *         The exception thrown when the input doesn't have a resource associated to it.
     * @throws InternalServerException
     *         The exception thrown when an unexpected error occurs when processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TaxSettingsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TaxSettingsClient.BatchGetTaxExemptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/BatchGetTaxExemptions"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetTaxExemptionsResponse batchGetTaxExemptions(
            Consumer<BatchGetTaxExemptionsRequest.Builder> batchGetTaxExemptionsRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, TaxSettingsException {
        return batchGetTaxExemptions(BatchGetTaxExemptionsRequest.builder().applyMutation(batchGetTaxExemptionsRequest).build());
    }

    /**
     * <p>
     * Adds or updates tax registration for multiple accounts in batch. This can be used to add or update tax
     * registrations for up to five accounts in one batch. You can't set a TRN if there's a pending TRN. You'll need to
     * delete the pending TRN first.
     * </p>
     * <p>
     * To call this API operation for specific countries, see the following country-specific requirements.
     * </p>
     * <p>
     * <b>Bangladesh</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must specify the tax registration certificate document in the <code>taxRegistrationDocuments</code> field of
     * the <code>VerificationDetails</code> object.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Brazil</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must complete the tax registration process in the <a
     * href="https://console.aws.amazon.com/billing/home#/paymentpreferences/paymentmethods">Payment preferences</a>
     * page in the Billing and Cost Management console. After your TRN and billing address are verified, you can call
     * this API operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * For Amazon Web Services accounts created through Organizations, you can call this API operation when you don't
     * have a billing address.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Georgia</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * The valid <code>personType</code> values are <code>Physical Person</code> and <code>Business</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Kenya</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must specify the <code>personType</code> in the <code>kenyaAdditionalInfo</code> field of the
     * <code>additionalTaxInformation</code> object.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the <code>personType</code> is <code>Physical Person</code>, you must specify the tax registration certificate
     * document in the <code>taxRegistrationDocuments</code> field of the <code>VerificationDetails</code> object.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Malaysia</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * The sector valid values are <code>Business</code> and <code>Individual</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RegistrationType</code> valid values are <code>NRIC</code> for individual, and TIN and sales and service
     * tax (SST) for Business.
     * </p>
     * </li>
     * <li>
     * <p>
     * For individual, you can specify the <code>taxInformationNumber</code> in <code>MalaysiaAdditionalInfo</code> with
     * NRIC type, and a valid <code>MyKad</code> or NRIC number.
     * </p>
     * </li>
     * <li>
     * <p>
     * For business, you must specify a <code>businessRegistrationNumber</code> in <code>MalaysiaAdditionalInfo</code>
     * with a TIN type and tax identification number.
     * </p>
     * </li>
     * <li>
     * <p>
     * For business resellers, you must specify a <code>businessRegistrationNumber</code> and
     * <code>taxInformationNumber</code> in <code>MalaysiaAdditionalInfo</code> with a sales and service tax (SST) type
     * and a valid SST number.
     * </p>
     * </li>
     * <li>
     * <p>
     * For business resellers with service codes, you must specify <code>businessRegistrationNumber</code>,
     * <code>taxInformationNumber</code>, and distinct <code>serviceTaxCodes</code> in
     * <code>MalaysiaAdditionalInfo</code> with a SST type and valid sales and service tax (SST) number. By using this
     * API operation, Amazon Web Services registers your self-declaration that you’re an authorized business reseller
     * registered with the Royal Malaysia Customs Department (RMCD), and have a valid SST number.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services reserves the right to seek additional information and/or take other actions to support your
     * self-declaration as appropriate.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services is currently registered under the following service tax codes. You must include at least one
     * of the service tax codes in the service tax code strings to declare yourself as an authorized registered business
     * reseller.
     * </p>
     * <p>
     * Taxable service and service tax codes:
     * </p>
     * <p>
     * Consultancy - 9907061674
     * </p>
     * <p>
     * Training or coaching service - 9907071685
     * </p>
     * <p>
     * IT service - 9907101676
     * </p>
     * <p>
     * Digital services and electronic medium - 9907121690
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Nepal</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * The sector valid values are <code>Business</code> and <code>Individual</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Saudi Arabia</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * For <code>address</code>, you must specify <code>addressLine3</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>South Korea</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must specify the <code>certifiedEmailId</code> and <code>legalName</code> in the
     * <code>TaxRegistrationEntry</code> object. Use Korean characters for <code>legalName</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * You must specify the <code>businessRepresentativeName</code>, <code>itemOfBusiness</code>, and
     * <code>lineOfBusiness</code> in the <code>southKoreaAdditionalInfo</code> field of the
     * <code>additionalTaxInformation</code> object. Use Korean characters for these fields.
     * </p>
     * </li>
     * <li>
     * <p>
     * You must specify the tax registration certificate document in the <code>taxRegistrationDocuments</code> field of
     * the <code>VerificationDetails</code> object.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>address</code> object, use Korean characters for <code>addressLine1</code>,
     * <code>addressLine2</code> <code>city</code>, <code>postalCode</code>, and <code>stateOrRegion</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Spain</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must specify the <code>registrationType</code> in the <code>spainAdditionalInfo</code> field of the
     * <code>additionalTaxInformation</code> object.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the <code>registrationType</code> is <code>Local</code>, you must specify the tax registration certificate
     * document in the <code>taxRegistrationDocuments</code> field of the <code>VerificationDetails</code> object.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Turkey</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must specify the <code>sector</code> in the <code>taxRegistrationEntry</code> object.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your <code>sector</code> is <code>Business</code>, <code>Individual</code>, or <code>Government</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specify the <code>taxOffice</code>. If your <code>sector</code> is <code>Individual</code>, don't enter this
     * value.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) Specify the <code>kepEmailId</code>. If your <code>sector</code> is <code>Individual</code>, don't
     * enter this value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Note:</b> In the <b>Tax Settings</b> page of the Billing console, <code>Government</code> appears as <b>Public
     * institutions</b>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * If your <code>sector</code> is <code>Business</code> and you're subject to KDV tax, you must specify your
     * industry in the <code>industries</code> field.
     * </p>
     * </li>
     * <li>
     * <p>
     * For <code>address</code>, you must specify <code>districtOrCounty</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Ukraine</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * The sector valid values are <code>Business</code> and <code>Individual</code>.
     * </p>
     * </li>
     * </ul>
     *
     * @param batchPutTaxRegistrationRequest
     * @return Result of the BatchPutTaxRegistration operation returned by the service.
     * @throws ValidationException
     *         The exception when the input doesn't pass validation for at least one of the input parameters.
     * @throws ConflictException
     *         The exception when the input is creating conflict with the given state.
     * @throws InternalServerException
     *         The exception thrown when an unexpected error occurs when processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TaxSettingsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TaxSettingsClient.BatchPutTaxRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/BatchPutTaxRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchPutTaxRegistrationResponse batchPutTaxRegistration(BatchPutTaxRegistrationRequest batchPutTaxRegistrationRequest)
            throws ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException,
            TaxSettingsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or updates tax registration for multiple accounts in batch. This can be used to add or update tax
     * registrations for up to five accounts in one batch. You can't set a TRN if there's a pending TRN. You'll need to
     * delete the pending TRN first.
     * </p>
     * <p>
     * To call this API operation for specific countries, see the following country-specific requirements.
     * </p>
     * <p>
     * <b>Bangladesh</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must specify the tax registration certificate document in the <code>taxRegistrationDocuments</code> field of
     * the <code>VerificationDetails</code> object.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Brazil</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must complete the tax registration process in the <a
     * href="https://console.aws.amazon.com/billing/home#/paymentpreferences/paymentmethods">Payment preferences</a>
     * page in the Billing and Cost Management console. After your TRN and billing address are verified, you can call
     * this API operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * For Amazon Web Services accounts created through Organizations, you can call this API operation when you don't
     * have a billing address.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Georgia</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * The valid <code>personType</code> values are <code>Physical Person</code> and <code>Business</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Kenya</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must specify the <code>personType</code> in the <code>kenyaAdditionalInfo</code> field of the
     * <code>additionalTaxInformation</code> object.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the <code>personType</code> is <code>Physical Person</code>, you must specify the tax registration certificate
     * document in the <code>taxRegistrationDocuments</code> field of the <code>VerificationDetails</code> object.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Malaysia</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * The sector valid values are <code>Business</code> and <code>Individual</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RegistrationType</code> valid values are <code>NRIC</code> for individual, and TIN and sales and service
     * tax (SST) for Business.
     * </p>
     * </li>
     * <li>
     * <p>
     * For individual, you can specify the <code>taxInformationNumber</code> in <code>MalaysiaAdditionalInfo</code> with
     * NRIC type, and a valid <code>MyKad</code> or NRIC number.
     * </p>
     * </li>
     * <li>
     * <p>
     * For business, you must specify a <code>businessRegistrationNumber</code> in <code>MalaysiaAdditionalInfo</code>
     * with a TIN type and tax identification number.
     * </p>
     * </li>
     * <li>
     * <p>
     * For business resellers, you must specify a <code>businessRegistrationNumber</code> and
     * <code>taxInformationNumber</code> in <code>MalaysiaAdditionalInfo</code> with a sales and service tax (SST) type
     * and a valid SST number.
     * </p>
     * </li>
     * <li>
     * <p>
     * For business resellers with service codes, you must specify <code>businessRegistrationNumber</code>,
     * <code>taxInformationNumber</code>, and distinct <code>serviceTaxCodes</code> in
     * <code>MalaysiaAdditionalInfo</code> with a SST type and valid sales and service tax (SST) number. By using this
     * API operation, Amazon Web Services registers your self-declaration that you’re an authorized business reseller
     * registered with the Royal Malaysia Customs Department (RMCD), and have a valid SST number.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services reserves the right to seek additional information and/or take other actions to support your
     * self-declaration as appropriate.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services is currently registered under the following service tax codes. You must include at least one
     * of the service tax codes in the service tax code strings to declare yourself as an authorized registered business
     * reseller.
     * </p>
     * <p>
     * Taxable service and service tax codes:
     * </p>
     * <p>
     * Consultancy - 9907061674
     * </p>
     * <p>
     * Training or coaching service - 9907071685
     * </p>
     * <p>
     * IT service - 9907101676
     * </p>
     * <p>
     * Digital services and electronic medium - 9907121690
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Nepal</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * The sector valid values are <code>Business</code> and <code>Individual</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Saudi Arabia</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * For <code>address</code>, you must specify <code>addressLine3</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>South Korea</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must specify the <code>certifiedEmailId</code> and <code>legalName</code> in the
     * <code>TaxRegistrationEntry</code> object. Use Korean characters for <code>legalName</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * You must specify the <code>businessRepresentativeName</code>, <code>itemOfBusiness</code>, and
     * <code>lineOfBusiness</code> in the <code>southKoreaAdditionalInfo</code> field of the
     * <code>additionalTaxInformation</code> object. Use Korean characters for these fields.
     * </p>
     * </li>
     * <li>
     * <p>
     * You must specify the tax registration certificate document in the <code>taxRegistrationDocuments</code> field of
     * the <code>VerificationDetails</code> object.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>address</code> object, use Korean characters for <code>addressLine1</code>,
     * <code>addressLine2</code> <code>city</code>, <code>postalCode</code>, and <code>stateOrRegion</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Spain</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must specify the <code>registrationType</code> in the <code>spainAdditionalInfo</code> field of the
     * <code>additionalTaxInformation</code> object.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the <code>registrationType</code> is <code>Local</code>, you must specify the tax registration certificate
     * document in the <code>taxRegistrationDocuments</code> field of the <code>VerificationDetails</code> object.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Turkey</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must specify the <code>sector</code> in the <code>taxRegistrationEntry</code> object.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your <code>sector</code> is <code>Business</code>, <code>Individual</code>, or <code>Government</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specify the <code>taxOffice</code>. If your <code>sector</code> is <code>Individual</code>, don't enter this
     * value.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) Specify the <code>kepEmailId</code>. If your <code>sector</code> is <code>Individual</code>, don't
     * enter this value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Note:</b> In the <b>Tax Settings</b> page of the Billing console, <code>Government</code> appears as <b>Public
     * institutions</b>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * If your <code>sector</code> is <code>Business</code> and you're subject to KDV tax, you must specify your
     * industry in the <code>industries</code> field.
     * </p>
     * </li>
     * <li>
     * <p>
     * For <code>address</code>, you must specify <code>districtOrCounty</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Ukraine</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * The sector valid values are <code>Business</code> and <code>Individual</code>.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchPutTaxRegistrationRequest.Builder} avoiding
     * the need to create one manually via {@link BatchPutTaxRegistrationRequest#builder()}
     * </p>
     *
     * @param batchPutTaxRegistrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.taxsettings.model.BatchPutTaxRegistrationRequest.Builder} to create
     *        a request.
     * @return Result of the BatchPutTaxRegistration operation returned by the service.
     * @throws ValidationException
     *         The exception when the input doesn't pass validation for at least one of the input parameters.
     * @throws ConflictException
     *         The exception when the input is creating conflict with the given state.
     * @throws InternalServerException
     *         The exception thrown when an unexpected error occurs when processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TaxSettingsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TaxSettingsClient.BatchPutTaxRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/BatchPutTaxRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchPutTaxRegistrationResponse batchPutTaxRegistration(
            Consumer<BatchPutTaxRegistrationRequest.Builder> batchPutTaxRegistrationRequest) throws ValidationException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, TaxSettingsException {
        return batchPutTaxRegistration(BatchPutTaxRegistrationRequest.builder().applyMutation(batchPutTaxRegistrationRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a supplemental tax registration for a single account.
     * </p>
     *
     * @param deleteSupplementalTaxRegistrationRequest
     * @return Result of the DeleteSupplementalTaxRegistration operation returned by the service.
     * @throws ValidationException
     *         The exception when the input doesn't pass validation for at least one of the input parameters.
     * @throws ConflictException
     *         The exception when the input is creating conflict with the given state.
     * @throws ResourceNotFoundException
     *         The exception thrown when the input doesn't have a resource associated to it.
     * @throws InternalServerException
     *         The exception thrown when an unexpected error occurs when processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TaxSettingsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TaxSettingsClient.DeleteSupplementalTaxRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/DeleteSupplementalTaxRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSupplementalTaxRegistrationResponse deleteSupplementalTaxRegistration(
            DeleteSupplementalTaxRegistrationRequest deleteSupplementalTaxRegistrationRequest) throws ValidationException,
            ConflictException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            TaxSettingsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a supplemental tax registration for a single account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSupplementalTaxRegistrationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteSupplementalTaxRegistrationRequest#builder()}
     * </p>
     *
     * @param deleteSupplementalTaxRegistrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.taxsettings.model.DeleteSupplementalTaxRegistrationRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteSupplementalTaxRegistration operation returned by the service.
     * @throws ValidationException
     *         The exception when the input doesn't pass validation for at least one of the input parameters.
     * @throws ConflictException
     *         The exception when the input is creating conflict with the given state.
     * @throws ResourceNotFoundException
     *         The exception thrown when the input doesn't have a resource associated to it.
     * @throws InternalServerException
     *         The exception thrown when an unexpected error occurs when processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TaxSettingsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TaxSettingsClient.DeleteSupplementalTaxRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/DeleteSupplementalTaxRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSupplementalTaxRegistrationResponse deleteSupplementalTaxRegistration(
            Consumer<DeleteSupplementalTaxRegistrationRequest.Builder> deleteSupplementalTaxRegistrationRequest)
            throws ValidationException, ConflictException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, TaxSettingsException {
        return deleteSupplementalTaxRegistration(DeleteSupplementalTaxRegistrationRequest.builder()
                .applyMutation(deleteSupplementalTaxRegistrationRequest).build());
    }

    /**
     * <p>
     * Deletes tax registration for a single account.
     * </p>
     * <note>
     * <p>
     * This API operation can't be used to delete your tax registration in Brazil. Use the <a
     * href="https://console.aws.amazon.com/billing/home#/paymentpreferences/paymentmethods">Payment preferences</a>
     * page in the Billing and Cost Management console instead.
     * </p>
     * </note>
     *
     * @param deleteTaxRegistrationRequest
     * @return Result of the DeleteTaxRegistration operation returned by the service.
     * @throws ValidationException
     *         The exception when the input doesn't pass validation for at least one of the input parameters.
     * @throws ConflictException
     *         The exception when the input is creating conflict with the given state.
     * @throws ResourceNotFoundException
     *         The exception thrown when the input doesn't have a resource associated to it.
     * @throws InternalServerException
     *         The exception thrown when an unexpected error occurs when processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TaxSettingsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TaxSettingsClient.DeleteTaxRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/DeleteTaxRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTaxRegistrationResponse deleteTaxRegistration(DeleteTaxRegistrationRequest deleteTaxRegistrationRequest)
            throws ValidationException, ConflictException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, TaxSettingsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes tax registration for a single account.
     * </p>
     * <note>
     * <p>
     * This API operation can't be used to delete your tax registration in Brazil. Use the <a
     * href="https://console.aws.amazon.com/billing/home#/paymentpreferences/paymentmethods">Payment preferences</a>
     * page in the Billing and Cost Management console instead.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTaxRegistrationRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteTaxRegistrationRequest#builder()}
     * </p>
     *
     * @param deleteTaxRegistrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.taxsettings.model.DeleteTaxRegistrationRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteTaxRegistration operation returned by the service.
     * @throws ValidationException
     *         The exception when the input doesn't pass validation for at least one of the input parameters.
     * @throws ConflictException
     *         The exception when the input is creating conflict with the given state.
     * @throws ResourceNotFoundException
     *         The exception thrown when the input doesn't have a resource associated to it.
     * @throws InternalServerException
     *         The exception thrown when an unexpected error occurs when processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TaxSettingsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TaxSettingsClient.DeleteTaxRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/DeleteTaxRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTaxRegistrationResponse deleteTaxRegistration(
            Consumer<DeleteTaxRegistrationRequest.Builder> deleteTaxRegistrationRequest) throws ValidationException,
            ConflictException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            TaxSettingsException {
        return deleteTaxRegistration(DeleteTaxRegistrationRequest.builder().applyMutation(deleteTaxRegistrationRequest).build());
    }

    /**
     * <p>
     * Get supported tax exemption types.
     * </p>
     *
     * @param getTaxExemptionTypesRequest
     * @return Result of the GetTaxExemptionTypes operation returned by the service.
     * @throws ValidationException
     *         The exception when the input doesn't pass validation for at least one of the input parameters.
     * @throws ResourceNotFoundException
     *         The exception thrown when the input doesn't have a resource associated to it.
     * @throws InternalServerException
     *         The exception thrown when an unexpected error occurs when processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TaxSettingsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TaxSettingsClient.GetTaxExemptionTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/GetTaxExemptionTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTaxExemptionTypesResponse getTaxExemptionTypes(GetTaxExemptionTypesRequest getTaxExemptionTypesRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, TaxSettingsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get supported tax exemption types.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTaxExemptionTypesRequest.Builder} avoiding the
     * need to create one manually via {@link GetTaxExemptionTypesRequest#builder()}
     * </p>
     *
     * @param getTaxExemptionTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.taxsettings.model.GetTaxExemptionTypesRequest.Builder} to create a
     *        request.
     * @return Result of the GetTaxExemptionTypes operation returned by the service.
     * @throws ValidationException
     *         The exception when the input doesn't pass validation for at least one of the input parameters.
     * @throws ResourceNotFoundException
     *         The exception thrown when the input doesn't have a resource associated to it.
     * @throws InternalServerException
     *         The exception thrown when an unexpected error occurs when processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TaxSettingsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TaxSettingsClient.GetTaxExemptionTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/GetTaxExemptionTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTaxExemptionTypesResponse getTaxExemptionTypes(
            Consumer<GetTaxExemptionTypesRequest.Builder> getTaxExemptionTypesRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, TaxSettingsException {
        return getTaxExemptionTypes(GetTaxExemptionTypesRequest.builder().applyMutation(getTaxExemptionTypesRequest).build());
    }

    /**
     * <p>
     * The get account tax inheritance status.
     * </p>
     *
     * @param getTaxInheritanceRequest
     * @return Result of the GetTaxInheritance operation returned by the service.
     * @throws ValidationException
     *         The exception when the input doesn't pass validation for at least one of the input parameters.
     * @throws ResourceNotFoundException
     *         The exception thrown when the input doesn't have a resource associated to it.
     * @throws InternalServerException
     *         The exception thrown when an unexpected error occurs when processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TaxSettingsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TaxSettingsClient.GetTaxInheritance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/GetTaxInheritance" target="_top">AWS
     *      API Documentation</a>
     */
    default GetTaxInheritanceResponse getTaxInheritance(GetTaxInheritanceRequest getTaxInheritanceRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, TaxSettingsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The get account tax inheritance status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTaxInheritanceRequest.Builder} avoiding the need
     * to create one manually via {@link GetTaxInheritanceRequest#builder()}
     * </p>
     *
     * @param getTaxInheritanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.taxsettings.model.GetTaxInheritanceRequest.Builder} to create a
     *        request.
     * @return Result of the GetTaxInheritance operation returned by the service.
     * @throws ValidationException
     *         The exception when the input doesn't pass validation for at least one of the input parameters.
     * @throws ResourceNotFoundException
     *         The exception thrown when the input doesn't have a resource associated to it.
     * @throws InternalServerException
     *         The exception thrown when an unexpected error occurs when processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TaxSettingsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TaxSettingsClient.GetTaxInheritance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/GetTaxInheritance" target="_top">AWS
     *      API Documentation</a>
     */
    default GetTaxInheritanceResponse getTaxInheritance(Consumer<GetTaxInheritanceRequest.Builder> getTaxInheritanceRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, TaxSettingsException {
        return getTaxInheritance(GetTaxInheritanceRequest.builder().applyMutation(getTaxInheritanceRequest).build());
    }

    /**
     * <p>
     * Retrieves tax registration for a single account.
     * </p>
     *
     * @param getTaxRegistrationRequest
     * @return Result of the GetTaxRegistration operation returned by the service.
     * @throws ValidationException
     *         The exception when the input doesn't pass validation for at least one of the input parameters.
     * @throws ResourceNotFoundException
     *         The exception thrown when the input doesn't have a resource associated to it.
     * @throws InternalServerException
     *         The exception thrown when an unexpected error occurs when processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TaxSettingsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TaxSettingsClient.GetTaxRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/GetTaxRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTaxRegistrationResponse getTaxRegistration(GetTaxRegistrationRequest getTaxRegistrationRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, TaxSettingsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves tax registration for a single account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTaxRegistrationRequest.Builder} avoiding the
     * need to create one manually via {@link GetTaxRegistrationRequest#builder()}
     * </p>
     *
     * @param getTaxRegistrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.taxsettings.model.GetTaxRegistrationRequest.Builder} to create a
     *        request.
     * @return Result of the GetTaxRegistration operation returned by the service.
     * @throws ValidationException
     *         The exception when the input doesn't pass validation for at least one of the input parameters.
     * @throws ResourceNotFoundException
     *         The exception thrown when the input doesn't have a resource associated to it.
     * @throws InternalServerException
     *         The exception thrown when an unexpected error occurs when processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TaxSettingsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TaxSettingsClient.GetTaxRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/GetTaxRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTaxRegistrationResponse getTaxRegistration(Consumer<GetTaxRegistrationRequest.Builder> getTaxRegistrationRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, TaxSettingsException {
        return getTaxRegistration(GetTaxRegistrationRequest.builder().applyMutation(getTaxRegistrationRequest).build());
    }

    /**
     * <p>
     * Downloads your tax documents to the Amazon S3 bucket that you specify in your request.
     * </p>
     *
     * @param getTaxRegistrationDocumentRequest
     * @return Result of the GetTaxRegistrationDocument operation returned by the service.
     * @throws ValidationException
     *         The exception when the input doesn't pass validation for at least one of the input parameters.
     * @throws InternalServerException
     *         The exception thrown when an unexpected error occurs when processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TaxSettingsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TaxSettingsClient.GetTaxRegistrationDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/GetTaxRegistrationDocument"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTaxRegistrationDocumentResponse getTaxRegistrationDocument(
            GetTaxRegistrationDocumentRequest getTaxRegistrationDocumentRequest) throws ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, TaxSettingsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Downloads your tax documents to the Amazon S3 bucket that you specify in your request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTaxRegistrationDocumentRequest.Builder} avoiding
     * the need to create one manually via {@link GetTaxRegistrationDocumentRequest#builder()}
     * </p>
     *
     * @param getTaxRegistrationDocumentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.taxsettings.model.GetTaxRegistrationDocumentRequest.Builder} to
     *        create a request.
     * @return Result of the GetTaxRegistrationDocument operation returned by the service.
     * @throws ValidationException
     *         The exception when the input doesn't pass validation for at least one of the input parameters.
     * @throws InternalServerException
     *         The exception thrown when an unexpected error occurs when processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TaxSettingsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TaxSettingsClient.GetTaxRegistrationDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/GetTaxRegistrationDocument"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTaxRegistrationDocumentResponse getTaxRegistrationDocument(
            Consumer<GetTaxRegistrationDocumentRequest.Builder> getTaxRegistrationDocumentRequest) throws ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, TaxSettingsException {
        return getTaxRegistrationDocument(GetTaxRegistrationDocumentRequest.builder()
                .applyMutation(getTaxRegistrationDocumentRequest).build());
    }

    /**
     * <p>
     * Retrieves supplemental tax registrations for a single account.
     * </p>
     *
     * @param listSupplementalTaxRegistrationsRequest
     * @return Result of the ListSupplementalTaxRegistrations operation returned by the service.
     * @throws ValidationException
     *         The exception when the input doesn't pass validation for at least one of the input parameters.
     * @throws ResourceNotFoundException
     *         The exception thrown when the input doesn't have a resource associated to it.
     * @throws InternalServerException
     *         The exception thrown when an unexpected error occurs when processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TaxSettingsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TaxSettingsClient.ListSupplementalTaxRegistrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/ListSupplementalTaxRegistrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSupplementalTaxRegistrationsResponse listSupplementalTaxRegistrations(
            ListSupplementalTaxRegistrationsRequest listSupplementalTaxRegistrationsRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, TaxSettingsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves supplemental tax registrations for a single account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSupplementalTaxRegistrationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListSupplementalTaxRegistrationsRequest#builder()}
     * </p>
     *
     * @param listSupplementalTaxRegistrationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.taxsettings.model.ListSupplementalTaxRegistrationsRequest.Builder}
     *        to create a request.
     * @return Result of the ListSupplementalTaxRegistrations operation returned by the service.
     * @throws ValidationException
     *         The exception when the input doesn't pass validation for at least one of the input parameters.
     * @throws ResourceNotFoundException
     *         The exception thrown when the input doesn't have a resource associated to it.
     * @throws InternalServerException
     *         The exception thrown when an unexpected error occurs when processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TaxSettingsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TaxSettingsClient.ListSupplementalTaxRegistrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/ListSupplementalTaxRegistrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSupplementalTaxRegistrationsResponse listSupplementalTaxRegistrations(
            Consumer<ListSupplementalTaxRegistrationsRequest.Builder> listSupplementalTaxRegistrationsRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, TaxSettingsException {
        return listSupplementalTaxRegistrations(ListSupplementalTaxRegistrationsRequest.builder()
                .applyMutation(listSupplementalTaxRegistrationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSupplementalTaxRegistrations(software.amazon.awssdk.services.taxsettings.model.ListSupplementalTaxRegistrationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.taxsettings.paginators.ListSupplementalTaxRegistrationsIterable responses = client.listSupplementalTaxRegistrationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.taxsettings.paginators.ListSupplementalTaxRegistrationsIterable responses = client
     *             .listSupplementalTaxRegistrationsPaginator(request);
     *     for (software.amazon.awssdk.services.taxsettings.model.ListSupplementalTaxRegistrationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.taxsettings.paginators.ListSupplementalTaxRegistrationsIterable responses = client.listSupplementalTaxRegistrationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSupplementalTaxRegistrations(software.amazon.awssdk.services.taxsettings.model.ListSupplementalTaxRegistrationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSupplementalTaxRegistrationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The exception when the input doesn't pass validation for at least one of the input parameters.
     * @throws ResourceNotFoundException
     *         The exception thrown when the input doesn't have a resource associated to it.
     * @throws InternalServerException
     *         The exception thrown when an unexpected error occurs when processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TaxSettingsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TaxSettingsClient.ListSupplementalTaxRegistrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/ListSupplementalTaxRegistrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSupplementalTaxRegistrationsIterable listSupplementalTaxRegistrationsPaginator(
            ListSupplementalTaxRegistrationsRequest listSupplementalTaxRegistrationsRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, TaxSettingsException {
        return new ListSupplementalTaxRegistrationsIterable(this, listSupplementalTaxRegistrationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSupplementalTaxRegistrations(software.amazon.awssdk.services.taxsettings.model.ListSupplementalTaxRegistrationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.taxsettings.paginators.ListSupplementalTaxRegistrationsIterable responses = client.listSupplementalTaxRegistrationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.taxsettings.paginators.ListSupplementalTaxRegistrationsIterable responses = client
     *             .listSupplementalTaxRegistrationsPaginator(request);
     *     for (software.amazon.awssdk.services.taxsettings.model.ListSupplementalTaxRegistrationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.taxsettings.paginators.ListSupplementalTaxRegistrationsIterable responses = client.listSupplementalTaxRegistrationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSupplementalTaxRegistrations(software.amazon.awssdk.services.taxsettings.model.ListSupplementalTaxRegistrationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSupplementalTaxRegistrationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListSupplementalTaxRegistrationsRequest#builder()}
     * </p>
     *
     * @param listSupplementalTaxRegistrationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.taxsettings.model.ListSupplementalTaxRegistrationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The exception when the input doesn't pass validation for at least one of the input parameters.
     * @throws ResourceNotFoundException
     *         The exception thrown when the input doesn't have a resource associated to it.
     * @throws InternalServerException
     *         The exception thrown when an unexpected error occurs when processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TaxSettingsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TaxSettingsClient.ListSupplementalTaxRegistrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/ListSupplementalTaxRegistrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSupplementalTaxRegistrationsIterable listSupplementalTaxRegistrationsPaginator(
            Consumer<ListSupplementalTaxRegistrationsRequest.Builder> listSupplementalTaxRegistrationsRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, TaxSettingsException {
        return listSupplementalTaxRegistrationsPaginator(ListSupplementalTaxRegistrationsRequest.builder()
                .applyMutation(listSupplementalTaxRegistrationsRequest).build());
    }

    /**
     * <p>
     * Retrieves the tax exemption of accounts listed in a consolidated billing family.
     * </p>
     *
     * @param listTaxExemptionsRequest
     * @return Result of the ListTaxExemptions operation returned by the service.
     * @throws ValidationException
     *         The exception when the input doesn't pass validation for at least one of the input parameters.
     * @throws ResourceNotFoundException
     *         The exception thrown when the input doesn't have a resource associated to it.
     * @throws InternalServerException
     *         The exception thrown when an unexpected error occurs when processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TaxSettingsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TaxSettingsClient.ListTaxExemptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/ListTaxExemptions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTaxExemptionsResponse listTaxExemptions(ListTaxExemptionsRequest listTaxExemptionsRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, TaxSettingsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the tax exemption of accounts listed in a consolidated billing family.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTaxExemptionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListTaxExemptionsRequest#builder()}
     * </p>
     *
     * @param listTaxExemptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.taxsettings.model.ListTaxExemptionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListTaxExemptions operation returned by the service.
     * @throws ValidationException
     *         The exception when the input doesn't pass validation for at least one of the input parameters.
     * @throws ResourceNotFoundException
     *         The exception thrown when the input doesn't have a resource associated to it.
     * @throws InternalServerException
     *         The exception thrown when an unexpected error occurs when processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TaxSettingsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TaxSettingsClient.ListTaxExemptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/ListTaxExemptions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTaxExemptionsResponse listTaxExemptions(Consumer<ListTaxExemptionsRequest.Builder> listTaxExemptionsRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, TaxSettingsException {
        return listTaxExemptions(ListTaxExemptionsRequest.builder().applyMutation(listTaxExemptionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTaxExemptions(software.amazon.awssdk.services.taxsettings.model.ListTaxExemptionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.taxsettings.paginators.ListTaxExemptionsIterable responses = client.listTaxExemptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.taxsettings.paginators.ListTaxExemptionsIterable responses = client
     *             .listTaxExemptionsPaginator(request);
     *     for (software.amazon.awssdk.services.taxsettings.model.ListTaxExemptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.taxsettings.paginators.ListTaxExemptionsIterable responses = client.listTaxExemptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTaxExemptions(software.amazon.awssdk.services.taxsettings.model.ListTaxExemptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTaxExemptionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The exception when the input doesn't pass validation for at least one of the input parameters.
     * @throws ResourceNotFoundException
     *         The exception thrown when the input doesn't have a resource associated to it.
     * @throws InternalServerException
     *         The exception thrown when an unexpected error occurs when processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TaxSettingsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TaxSettingsClient.ListTaxExemptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/ListTaxExemptions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTaxExemptionsIterable listTaxExemptionsPaginator(ListTaxExemptionsRequest listTaxExemptionsRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, TaxSettingsException {
        return new ListTaxExemptionsIterable(this, listTaxExemptionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTaxExemptions(software.amazon.awssdk.services.taxsettings.model.ListTaxExemptionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.taxsettings.paginators.ListTaxExemptionsIterable responses = client.listTaxExemptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.taxsettings.paginators.ListTaxExemptionsIterable responses = client
     *             .listTaxExemptionsPaginator(request);
     *     for (software.amazon.awssdk.services.taxsettings.model.ListTaxExemptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.taxsettings.paginators.ListTaxExemptionsIterable responses = client.listTaxExemptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTaxExemptions(software.amazon.awssdk.services.taxsettings.model.ListTaxExemptionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTaxExemptionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListTaxExemptionsRequest#builder()}
     * </p>
     *
     * @param listTaxExemptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.taxsettings.model.ListTaxExemptionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The exception when the input doesn't pass validation for at least one of the input parameters.
     * @throws ResourceNotFoundException
     *         The exception thrown when the input doesn't have a resource associated to it.
     * @throws InternalServerException
     *         The exception thrown when an unexpected error occurs when processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TaxSettingsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TaxSettingsClient.ListTaxExemptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/ListTaxExemptions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTaxExemptionsIterable listTaxExemptionsPaginator(
            Consumer<ListTaxExemptionsRequest.Builder> listTaxExemptionsRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, TaxSettingsException {
        return listTaxExemptionsPaginator(ListTaxExemptionsRequest.builder().applyMutation(listTaxExemptionsRequest).build());
    }

    /**
     * <p>
     * Retrieves the tax registration of accounts listed in a consolidated billing family. This can be used to retrieve
     * up to 100 accounts' tax registrations in one call (default 50).
     * </p>
     *
     * @param listTaxRegistrationsRequest
     * @return Result of the ListTaxRegistrations operation returned by the service.
     * @throws ValidationException
     *         The exception when the input doesn't pass validation for at least one of the input parameters.
     * @throws ResourceNotFoundException
     *         The exception thrown when the input doesn't have a resource associated to it.
     * @throws InternalServerException
     *         The exception thrown when an unexpected error occurs when processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TaxSettingsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TaxSettingsClient.ListTaxRegistrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/ListTaxRegistrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTaxRegistrationsResponse listTaxRegistrations(ListTaxRegistrationsRequest listTaxRegistrationsRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, TaxSettingsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the tax registration of accounts listed in a consolidated billing family. This can be used to retrieve
     * up to 100 accounts' tax registrations in one call (default 50).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTaxRegistrationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTaxRegistrationsRequest#builder()}
     * </p>
     *
     * @param listTaxRegistrationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.taxsettings.model.ListTaxRegistrationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListTaxRegistrations operation returned by the service.
     * @throws ValidationException
     *         The exception when the input doesn't pass validation for at least one of the input parameters.
     * @throws ResourceNotFoundException
     *         The exception thrown when the input doesn't have a resource associated to it.
     * @throws InternalServerException
     *         The exception thrown when an unexpected error occurs when processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TaxSettingsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TaxSettingsClient.ListTaxRegistrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/ListTaxRegistrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTaxRegistrationsResponse listTaxRegistrations(
            Consumer<ListTaxRegistrationsRequest.Builder> listTaxRegistrationsRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, TaxSettingsException {
        return listTaxRegistrations(ListTaxRegistrationsRequest.builder().applyMutation(listTaxRegistrationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTaxRegistrations(software.amazon.awssdk.services.taxsettings.model.ListTaxRegistrationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.taxsettings.paginators.ListTaxRegistrationsIterable responses = client.listTaxRegistrationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.taxsettings.paginators.ListTaxRegistrationsIterable responses = client
     *             .listTaxRegistrationsPaginator(request);
     *     for (software.amazon.awssdk.services.taxsettings.model.ListTaxRegistrationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.taxsettings.paginators.ListTaxRegistrationsIterable responses = client.listTaxRegistrationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTaxRegistrations(software.amazon.awssdk.services.taxsettings.model.ListTaxRegistrationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTaxRegistrationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The exception when the input doesn't pass validation for at least one of the input parameters.
     * @throws ResourceNotFoundException
     *         The exception thrown when the input doesn't have a resource associated to it.
     * @throws InternalServerException
     *         The exception thrown when an unexpected error occurs when processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TaxSettingsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TaxSettingsClient.ListTaxRegistrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/ListTaxRegistrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTaxRegistrationsIterable listTaxRegistrationsPaginator(ListTaxRegistrationsRequest listTaxRegistrationsRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, TaxSettingsException {
        return new ListTaxRegistrationsIterable(this, listTaxRegistrationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTaxRegistrations(software.amazon.awssdk.services.taxsettings.model.ListTaxRegistrationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.taxsettings.paginators.ListTaxRegistrationsIterable responses = client.listTaxRegistrationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.taxsettings.paginators.ListTaxRegistrationsIterable responses = client
     *             .listTaxRegistrationsPaginator(request);
     *     for (software.amazon.awssdk.services.taxsettings.model.ListTaxRegistrationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.taxsettings.paginators.ListTaxRegistrationsIterable responses = client.listTaxRegistrationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTaxRegistrations(software.amazon.awssdk.services.taxsettings.model.ListTaxRegistrationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTaxRegistrationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTaxRegistrationsRequest#builder()}
     * </p>
     *
     * @param listTaxRegistrationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.taxsettings.model.ListTaxRegistrationsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The exception when the input doesn't pass validation for at least one of the input parameters.
     * @throws ResourceNotFoundException
     *         The exception thrown when the input doesn't have a resource associated to it.
     * @throws InternalServerException
     *         The exception thrown when an unexpected error occurs when processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TaxSettingsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TaxSettingsClient.ListTaxRegistrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/ListTaxRegistrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTaxRegistrationsIterable listTaxRegistrationsPaginator(
            Consumer<ListTaxRegistrationsRequest.Builder> listTaxRegistrationsRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, TaxSettingsException {
        return listTaxRegistrationsPaginator(ListTaxRegistrationsRequest.builder().applyMutation(listTaxRegistrationsRequest)
                .build());
    }

    /**
     * <p>
     * Stores supplemental tax registration for a single account.
     * </p>
     *
     * @param putSupplementalTaxRegistrationRequest
     * @return Result of the PutSupplementalTaxRegistration operation returned by the service.
     * @throws ValidationException
     *         The exception when the input doesn't pass validation for at least one of the input parameters.
     * @throws ConflictException
     *         The exception when the input is creating conflict with the given state.
     * @throws InternalServerException
     *         The exception thrown when an unexpected error occurs when processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TaxSettingsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TaxSettingsClient.PutSupplementalTaxRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/PutSupplementalTaxRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutSupplementalTaxRegistrationResponse putSupplementalTaxRegistration(
            PutSupplementalTaxRegistrationRequest putSupplementalTaxRegistrationRequest) throws ValidationException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, TaxSettingsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stores supplemental tax registration for a single account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutSupplementalTaxRegistrationRequest.Builder}
     * avoiding the need to create one manually via {@link PutSupplementalTaxRegistrationRequest#builder()}
     * </p>
     *
     * @param putSupplementalTaxRegistrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.taxsettings.model.PutSupplementalTaxRegistrationRequest.Builder} to
     *        create a request.
     * @return Result of the PutSupplementalTaxRegistration operation returned by the service.
     * @throws ValidationException
     *         The exception when the input doesn't pass validation for at least one of the input parameters.
     * @throws ConflictException
     *         The exception when the input is creating conflict with the given state.
     * @throws InternalServerException
     *         The exception thrown when an unexpected error occurs when processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TaxSettingsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TaxSettingsClient.PutSupplementalTaxRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/PutSupplementalTaxRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutSupplementalTaxRegistrationResponse putSupplementalTaxRegistration(
            Consumer<PutSupplementalTaxRegistrationRequest.Builder> putSupplementalTaxRegistrationRequest)
            throws ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException,
            TaxSettingsException {
        return putSupplementalTaxRegistration(PutSupplementalTaxRegistrationRequest.builder()
                .applyMutation(putSupplementalTaxRegistrationRequest).build());
    }

    /**
     * <p>
     * Adds the tax exemption for a single account or all accounts listed in a consolidated billing family.
     * </p>
     *
     * @param putTaxExemptionRequest
     * @return Result of the PutTaxExemption operation returned by the service.
     * @throws ValidationException
     *         The exception when the input doesn't pass validation for at least one of the input parameters.
     * @throws AccessDeniedException
     *         The access is denied for the Amazon Web Services Support API.
     * @throws CaseCreationLimitExceededException
     *         You've exceeded the Amazon Web Services Support case creation limit for your account.
     * @throws ResourceNotFoundException
     *         The exception thrown when the input doesn't have a resource associated to it.
     * @throws AttachmentUploadException
     *         Failed to upload the tax exemption document to Amazon Web Services Support case.
     * @throws InternalServerException
     *         The exception thrown when an unexpected error occurs when processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TaxSettingsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TaxSettingsClient.PutTaxExemption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/PutTaxExemption" target="_top">AWS
     *      API Documentation</a>
     */
    default PutTaxExemptionResponse putTaxExemption(PutTaxExemptionRequest putTaxExemptionRequest) throws ValidationException,
            AccessDeniedException, CaseCreationLimitExceededException, ResourceNotFoundException, AttachmentUploadException,
            InternalServerException, AwsServiceException, SdkClientException, TaxSettingsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the tax exemption for a single account or all accounts listed in a consolidated billing family.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutTaxExemptionRequest.Builder} avoiding the need
     * to create one manually via {@link PutTaxExemptionRequest#builder()}
     * </p>
     *
     * @param putTaxExemptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.taxsettings.model.PutTaxExemptionRequest.Builder} to create a
     *        request.
     * @return Result of the PutTaxExemption operation returned by the service.
     * @throws ValidationException
     *         The exception when the input doesn't pass validation for at least one of the input parameters.
     * @throws AccessDeniedException
     *         The access is denied for the Amazon Web Services Support API.
     * @throws CaseCreationLimitExceededException
     *         You've exceeded the Amazon Web Services Support case creation limit for your account.
     * @throws ResourceNotFoundException
     *         The exception thrown when the input doesn't have a resource associated to it.
     * @throws AttachmentUploadException
     *         Failed to upload the tax exemption document to Amazon Web Services Support case.
     * @throws InternalServerException
     *         The exception thrown when an unexpected error occurs when processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TaxSettingsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TaxSettingsClient.PutTaxExemption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/PutTaxExemption" target="_top">AWS
     *      API Documentation</a>
     */
    default PutTaxExemptionResponse putTaxExemption(Consumer<PutTaxExemptionRequest.Builder> putTaxExemptionRequest)
            throws ValidationException, AccessDeniedException, CaseCreationLimitExceededException, ResourceNotFoundException,
            AttachmentUploadException, InternalServerException, AwsServiceException, SdkClientException, TaxSettingsException {
        return putTaxExemption(PutTaxExemptionRequest.builder().applyMutation(putTaxExemptionRequest).build());
    }

    /**
     * <p>
     * The updated tax inheritance status.
     * </p>
     *
     * @param putTaxInheritanceRequest
     * @return Result of the PutTaxInheritance operation returned by the service.
     * @throws ValidationException
     *         The exception when the input doesn't pass validation for at least one of the input parameters.
     * @throws ConflictException
     *         The exception when the input is creating conflict with the given state.
     * @throws ResourceNotFoundException
     *         The exception thrown when the input doesn't have a resource associated to it.
     * @throws InternalServerException
     *         The exception thrown when an unexpected error occurs when processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TaxSettingsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TaxSettingsClient.PutTaxInheritance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/PutTaxInheritance" target="_top">AWS
     *      API Documentation</a>
     */
    default PutTaxInheritanceResponse putTaxInheritance(PutTaxInheritanceRequest putTaxInheritanceRequest)
            throws ValidationException, ConflictException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, TaxSettingsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The updated tax inheritance status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutTaxInheritanceRequest.Builder} avoiding the need
     * to create one manually via {@link PutTaxInheritanceRequest#builder()}
     * </p>
     *
     * @param putTaxInheritanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.taxsettings.model.PutTaxInheritanceRequest.Builder} to create a
     *        request.
     * @return Result of the PutTaxInheritance operation returned by the service.
     * @throws ValidationException
     *         The exception when the input doesn't pass validation for at least one of the input parameters.
     * @throws ConflictException
     *         The exception when the input is creating conflict with the given state.
     * @throws ResourceNotFoundException
     *         The exception thrown when the input doesn't have a resource associated to it.
     * @throws InternalServerException
     *         The exception thrown when an unexpected error occurs when processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TaxSettingsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TaxSettingsClient.PutTaxInheritance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/PutTaxInheritance" target="_top">AWS
     *      API Documentation</a>
     */
    default PutTaxInheritanceResponse putTaxInheritance(Consumer<PutTaxInheritanceRequest.Builder> putTaxInheritanceRequest)
            throws ValidationException, ConflictException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, TaxSettingsException {
        return putTaxInheritance(PutTaxInheritanceRequest.builder().applyMutation(putTaxInheritanceRequest).build());
    }

    /**
     * <p>
     * Adds or updates tax registration for a single account. You can't set a TRN if there's a pending TRN. You'll need
     * to delete the pending TRN first.
     * </p>
     * <p>
     * To call this API operation for specific countries, see the following country-specific requirements.
     * </p>
     * <p>
     * <b>Bangladesh</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must specify the tax registration certificate document in the <code>taxRegistrationDocuments</code> field of
     * the <code>VerificationDetails</code> object.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Brazil</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must complete the tax registration process in the <a
     * href="https://console.aws.amazon.com/billing/home#/paymentpreferences/paymentmethods">Payment preferences</a>
     * page in the Billing and Cost Management console. After your TRN and billing address are verified, you can call
     * this API operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * For Amazon Web Services accounts created through Organizations, you can call this API operation when you don't
     * have a billing address.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Georgia</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * The valid <code>personType</code> values are <code>Physical Person</code> and <code>Business</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Kenya</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must specify the <code>personType</code> in the <code>kenyaAdditionalInfo</code> field of the
     * <code>additionalTaxInformation</code> object.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the <code>personType</code> is <code>Physical Person</code>, you must specify the tax registration certificate
     * document in the <code>taxRegistrationDocuments</code> field of the <code>VerificationDetails</code> object.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Malaysia</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * The sector valid values are <code>Business</code> and <code>Individual</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RegistrationType</code> valid values are <code>NRIC</code> for individual, and TIN and sales and service
     * tax (SST) for Business.
     * </p>
     * </li>
     * <li>
     * <p>
     * For individual, you can specify the <code>taxInformationNumber</code> in <code>MalaysiaAdditionalInfo</code> with
     * NRIC type, and a valid <code>MyKad</code> or NRIC number.
     * </p>
     * </li>
     * <li>
     * <p>
     * For business, you must specify a <code>businessRegistrationNumber</code> in <code>MalaysiaAdditionalInfo</code>
     * with a TIN type and tax identification number.
     * </p>
     * </li>
     * <li>
     * <p>
     * For business resellers, you must specify a <code>businessRegistrationNumber</code> and
     * <code>taxInformationNumber</code> in <code>MalaysiaAdditionalInfo</code> with a sales and service tax (SST) type
     * and a valid SST number.
     * </p>
     * </li>
     * <li>
     * <p>
     * For business resellers with service codes, you must specify <code>businessRegistrationNumber</code>,
     * <code>taxInformationNumber</code>, and distinct <code>serviceTaxCodes</code> in
     * <code>MalaysiaAdditionalInfo</code> with a SST type and valid sales and service tax (SST) number. By using this
     * API operation, Amazon Web Services registers your self-declaration that you’re an authorized business reseller
     * registered with the Royal Malaysia Customs Department (RMCD), and have a valid SST number.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services reserves the right to seek additional information and/or take other actions to support your
     * self-declaration as appropriate.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services is currently registered under the following service tax codes. You must include at least one
     * of the service tax codes in the service tax code strings to declare yourself as an authorized registered business
     * reseller.
     * </p>
     * <p>
     * Taxable service and service tax codes:
     * </p>
     * <p>
     * Consultancy - 9907061674
     * </p>
     * <p>
     * Training or coaching service - 9907071685
     * </p>
     * <p>
     * IT service - 9907101676
     * </p>
     * <p>
     * Digital services and electronic medium - 9907121690
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Nepal</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * The sector valid values are <code>Business</code> and <code>Individual</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Saudi Arabia</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * For <code>address</code>, you must specify <code>addressLine3</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>South Korea</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must specify the <code>certifiedEmailId</code> and <code>legalName</code> in the
     * <code>TaxRegistrationEntry</code> object. Use Korean characters for <code>legalName</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * You must specify the <code>businessRepresentativeName</code>, <code>itemOfBusiness</code>, and
     * <code>lineOfBusiness</code> in the <code>southKoreaAdditionalInfo</code> field of the
     * <code>additionalTaxInformation</code> object. Use Korean characters for these fields.
     * </p>
     * </li>
     * <li>
     * <p>
     * You must specify the tax registration certificate document in the <code>taxRegistrationDocuments</code> field of
     * the <code>VerificationDetails</code> object.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>address</code> object, use Korean characters for <code>addressLine1</code>,
     * <code>addressLine2</code> <code>city</code>, <code>postalCode</code>, and <code>stateOrRegion</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Spain</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must specify the <code>registrationType</code> in the <code>spainAdditionalInfo</code> field of the
     * <code>additionalTaxInformation</code> object.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the <code>registrationType</code> is <code>Local</code>, you must specify the tax registration certificate
     * document in the <code>taxRegistrationDocuments</code> field of the <code>VerificationDetails</code> object.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Turkey</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must specify the <code>sector</code> in the <code>taxRegistrationEntry</code> object.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your <code>sector</code> is <code>Business</code>, <code>Individual</code>, or <code>Government</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specify the <code>taxOffice</code>. If your <code>sector</code> is <code>Individual</code>, don't enter this
     * value.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) Specify the <code>kepEmailId</code>. If your <code>sector</code> is <code>Individual</code>, don't
     * enter this value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Note:</b> In the <b>Tax Settings</b> page of the Billing console, <code>Government</code> appears as <b>Public
     * institutions</b>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * If your <code>sector</code> is <code>Business</code> and you're subject to KDV tax, you must specify your
     * industry in the <code>industries</code> field.
     * </p>
     * </li>
     * <li>
     * <p>
     * For <code>address</code>, you must specify <code>districtOrCounty</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Ukraine</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * The sector valid values are <code>Business</code> and <code>Individual</code>.
     * </p>
     * </li>
     * </ul>
     *
     * @param putTaxRegistrationRequest
     * @return Result of the PutTaxRegistration operation returned by the service.
     * @throws ValidationException
     *         The exception when the input doesn't pass validation for at least one of the input parameters.
     * @throws ConflictException
     *         The exception when the input is creating conflict with the given state.
     * @throws InternalServerException
     *         The exception thrown when an unexpected error occurs when processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TaxSettingsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TaxSettingsClient.PutTaxRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/PutTaxRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutTaxRegistrationResponse putTaxRegistration(PutTaxRegistrationRequest putTaxRegistrationRequest)
            throws ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException,
            TaxSettingsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or updates tax registration for a single account. You can't set a TRN if there's a pending TRN. You'll need
     * to delete the pending TRN first.
     * </p>
     * <p>
     * To call this API operation for specific countries, see the following country-specific requirements.
     * </p>
     * <p>
     * <b>Bangladesh</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must specify the tax registration certificate document in the <code>taxRegistrationDocuments</code> field of
     * the <code>VerificationDetails</code> object.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Brazil</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must complete the tax registration process in the <a
     * href="https://console.aws.amazon.com/billing/home#/paymentpreferences/paymentmethods">Payment preferences</a>
     * page in the Billing and Cost Management console. After your TRN and billing address are verified, you can call
     * this API operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * For Amazon Web Services accounts created through Organizations, you can call this API operation when you don't
     * have a billing address.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Georgia</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * The valid <code>personType</code> values are <code>Physical Person</code> and <code>Business</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Kenya</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must specify the <code>personType</code> in the <code>kenyaAdditionalInfo</code> field of the
     * <code>additionalTaxInformation</code> object.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the <code>personType</code> is <code>Physical Person</code>, you must specify the tax registration certificate
     * document in the <code>taxRegistrationDocuments</code> field of the <code>VerificationDetails</code> object.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Malaysia</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * The sector valid values are <code>Business</code> and <code>Individual</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RegistrationType</code> valid values are <code>NRIC</code> for individual, and TIN and sales and service
     * tax (SST) for Business.
     * </p>
     * </li>
     * <li>
     * <p>
     * For individual, you can specify the <code>taxInformationNumber</code> in <code>MalaysiaAdditionalInfo</code> with
     * NRIC type, and a valid <code>MyKad</code> or NRIC number.
     * </p>
     * </li>
     * <li>
     * <p>
     * For business, you must specify a <code>businessRegistrationNumber</code> in <code>MalaysiaAdditionalInfo</code>
     * with a TIN type and tax identification number.
     * </p>
     * </li>
     * <li>
     * <p>
     * For business resellers, you must specify a <code>businessRegistrationNumber</code> and
     * <code>taxInformationNumber</code> in <code>MalaysiaAdditionalInfo</code> with a sales and service tax (SST) type
     * and a valid SST number.
     * </p>
     * </li>
     * <li>
     * <p>
     * For business resellers with service codes, you must specify <code>businessRegistrationNumber</code>,
     * <code>taxInformationNumber</code>, and distinct <code>serviceTaxCodes</code> in
     * <code>MalaysiaAdditionalInfo</code> with a SST type and valid sales and service tax (SST) number. By using this
     * API operation, Amazon Web Services registers your self-declaration that you’re an authorized business reseller
     * registered with the Royal Malaysia Customs Department (RMCD), and have a valid SST number.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services reserves the right to seek additional information and/or take other actions to support your
     * self-declaration as appropriate.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services is currently registered under the following service tax codes. You must include at least one
     * of the service tax codes in the service tax code strings to declare yourself as an authorized registered business
     * reseller.
     * </p>
     * <p>
     * Taxable service and service tax codes:
     * </p>
     * <p>
     * Consultancy - 9907061674
     * </p>
     * <p>
     * Training or coaching service - 9907071685
     * </p>
     * <p>
     * IT service - 9907101676
     * </p>
     * <p>
     * Digital services and electronic medium - 9907121690
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Nepal</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * The sector valid values are <code>Business</code> and <code>Individual</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Saudi Arabia</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * For <code>address</code>, you must specify <code>addressLine3</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>South Korea</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must specify the <code>certifiedEmailId</code> and <code>legalName</code> in the
     * <code>TaxRegistrationEntry</code> object. Use Korean characters for <code>legalName</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * You must specify the <code>businessRepresentativeName</code>, <code>itemOfBusiness</code>, and
     * <code>lineOfBusiness</code> in the <code>southKoreaAdditionalInfo</code> field of the
     * <code>additionalTaxInformation</code> object. Use Korean characters for these fields.
     * </p>
     * </li>
     * <li>
     * <p>
     * You must specify the tax registration certificate document in the <code>taxRegistrationDocuments</code> field of
     * the <code>VerificationDetails</code> object.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>address</code> object, use Korean characters for <code>addressLine1</code>,
     * <code>addressLine2</code> <code>city</code>, <code>postalCode</code>, and <code>stateOrRegion</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Spain</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must specify the <code>registrationType</code> in the <code>spainAdditionalInfo</code> field of the
     * <code>additionalTaxInformation</code> object.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the <code>registrationType</code> is <code>Local</code>, you must specify the tax registration certificate
     * document in the <code>taxRegistrationDocuments</code> field of the <code>VerificationDetails</code> object.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Turkey</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must specify the <code>sector</code> in the <code>taxRegistrationEntry</code> object.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your <code>sector</code> is <code>Business</code>, <code>Individual</code>, or <code>Government</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specify the <code>taxOffice</code>. If your <code>sector</code> is <code>Individual</code>, don't enter this
     * value.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) Specify the <code>kepEmailId</code>. If your <code>sector</code> is <code>Individual</code>, don't
     * enter this value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Note:</b> In the <b>Tax Settings</b> page of the Billing console, <code>Government</code> appears as <b>Public
     * institutions</b>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * If your <code>sector</code> is <code>Business</code> and you're subject to KDV tax, you must specify your
     * industry in the <code>industries</code> field.
     * </p>
     * </li>
     * <li>
     * <p>
     * For <code>address</code>, you must specify <code>districtOrCounty</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Ukraine</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * The sector valid values are <code>Business</code> and <code>Individual</code>.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutTaxRegistrationRequest.Builder} avoiding the
     * need to create one manually via {@link PutTaxRegistrationRequest#builder()}
     * </p>
     *
     * @param putTaxRegistrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.taxsettings.model.PutTaxRegistrationRequest.Builder} to create a
     *        request.
     * @return Result of the PutTaxRegistration operation returned by the service.
     * @throws ValidationException
     *         The exception when the input doesn't pass validation for at least one of the input parameters.
     * @throws ConflictException
     *         The exception when the input is creating conflict with the given state.
     * @throws InternalServerException
     *         The exception thrown when an unexpected error occurs when processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TaxSettingsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TaxSettingsClient.PutTaxRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/taxsettings-2018-05-10/PutTaxRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutTaxRegistrationResponse putTaxRegistration(Consumer<PutTaxRegistrationRequest.Builder> putTaxRegistrationRequest)
            throws ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException,
            TaxSettingsException {
        return putTaxRegistration(PutTaxRegistrationRequest.builder().applyMutation(putTaxRegistrationRequest).build());
    }

    /**
     * Create a {@link TaxSettingsClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static TaxSettingsClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link TaxSettingsClient}.
     */
    static TaxSettingsClientBuilder builder() {
        return new DefaultTaxSettingsClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default TaxSettingsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
