/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object with your <code>accountId</code> and TRN information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountDetails implements SdkPojo, Serializable, ToCopyableBuilder<AccountDetails.Builder, AccountDetails> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(AccountDetails::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<AccountMetaData> ACCOUNT_META_DATA_FIELD = SdkField
            .<AccountMetaData> builder(MarshallingType.SDK_POJO).memberName("accountMetaData")
            .getter(getter(AccountDetails::accountMetaData)).setter(setter(Builder::accountMetaData))
            .constructor(AccountMetaData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountMetaData").build()).build();

    private static final SdkField<TaxInheritanceDetails> TAX_INHERITANCE_DETAILS_FIELD = SdkField
            .<TaxInheritanceDetails> builder(MarshallingType.SDK_POJO).memberName("taxInheritanceDetails")
            .getter(getter(AccountDetails::taxInheritanceDetails)).setter(setter(Builder::taxInheritanceDetails))
            .constructor(TaxInheritanceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taxInheritanceDetails").build())
            .build();

    private static final SdkField<TaxRegistrationWithJurisdiction> TAX_REGISTRATION_FIELD = SdkField
            .<TaxRegistrationWithJurisdiction> builder(MarshallingType.SDK_POJO).memberName("taxRegistration")
            .getter(getter(AccountDetails::taxRegistration)).setter(setter(Builder::taxRegistration))
            .constructor(TaxRegistrationWithJurisdiction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taxRegistration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            ACCOUNT_META_DATA_FIELD, TAX_INHERITANCE_DETAILS_FIELD, TAX_REGISTRATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final AccountMetaData accountMetaData;

    private final TaxInheritanceDetails taxInheritanceDetails;

    private final TaxRegistrationWithJurisdiction taxRegistration;

    private AccountDetails(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.accountMetaData = builder.accountMetaData;
        this.taxInheritanceDetails = builder.taxInheritanceDetails;
        this.taxRegistration = builder.taxRegistration;
    }

    /**
     * <p>
     * List of unique account identifiers.
     * </p>
     * 
     * @return List of unique account identifiers.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The meta data information associated with the account.
     * </p>
     * 
     * @return The meta data information associated with the account.
     */
    public final AccountMetaData accountMetaData() {
        return accountMetaData;
    }

    /**
     * <p>
     * Tax inheritance information associated with the account.
     * </p>
     * 
     * @return Tax inheritance information associated with the account.
     */
    public final TaxInheritanceDetails taxInheritanceDetails() {
        return taxInheritanceDetails;
    }

    /**
     * <p>
     * Your TRN information. Instead of having full legal address, here TRN information will have jurisdiction details
     * (for example, country code and state/region/province if applicable).
     * </p>
     * 
     * @return Your TRN information. Instead of having full legal address, here TRN information will have jurisdiction
     *         details (for example, country code and state/region/province if applicable).
     */
    public final TaxRegistrationWithJurisdiction taxRegistration() {
        return taxRegistration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(accountMetaData());
        hashCode = 31 * hashCode + Objects.hashCode(taxInheritanceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(taxRegistration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountDetails)) {
            return false;
        }
        AccountDetails other = (AccountDetails) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(accountMetaData(), other.accountMetaData())
                && Objects.equals(taxInheritanceDetails(), other.taxInheritanceDetails())
                && Objects.equals(taxRegistration(), other.taxRegistration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountDetails").add("AccountId", accountId())
                .add("AccountMetaData", accountMetaData() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TaxInheritanceDetails", taxInheritanceDetails())
                .add("TaxRegistration", taxRegistration() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "accountMetaData":
            return Optional.ofNullable(clazz.cast(accountMetaData()));
        case "taxInheritanceDetails":
            return Optional.ofNullable(clazz.cast(taxInheritanceDetails()));
        case "taxRegistration":
            return Optional.ofNullable(clazz.cast(taxRegistration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("accountMetaData", ACCOUNT_META_DATA_FIELD);
        map.put("taxInheritanceDetails", TAX_INHERITANCE_DETAILS_FIELD);
        map.put("taxRegistration", TAX_REGISTRATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountDetails, T> g) {
        return obj -> g.apply((AccountDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountDetails> {
        /**
         * <p>
         * List of unique account identifiers.
         * </p>
         * 
         * @param accountId
         *        List of unique account identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The meta data information associated with the account.
         * </p>
         * 
         * @param accountMetaData
         *        The meta data information associated with the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountMetaData(AccountMetaData accountMetaData);

        /**
         * <p>
         * The meta data information associated with the account.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccountMetaData.Builder} avoiding the
         * need to create one manually via {@link AccountMetaData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccountMetaData.Builder#build()} is called immediately and its
         * result is passed to {@link #accountMetaData(AccountMetaData)}.
         * 
         * @param accountMetaData
         *        a consumer that will call methods on {@link AccountMetaData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountMetaData(AccountMetaData)
         */
        default Builder accountMetaData(Consumer<AccountMetaData.Builder> accountMetaData) {
            return accountMetaData(AccountMetaData.builder().applyMutation(accountMetaData).build());
        }

        /**
         * <p>
         * Tax inheritance information associated with the account.
         * </p>
         * 
         * @param taxInheritanceDetails
         *        Tax inheritance information associated with the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taxInheritanceDetails(TaxInheritanceDetails taxInheritanceDetails);

        /**
         * <p>
         * Tax inheritance information associated with the account.
         * </p>
         * This is a convenience method that creates an instance of the {@link TaxInheritanceDetails.Builder} avoiding
         * the need to create one manually via {@link TaxInheritanceDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TaxInheritanceDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #taxInheritanceDetails(TaxInheritanceDetails)}.
         * 
         * @param taxInheritanceDetails
         *        a consumer that will call methods on {@link TaxInheritanceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taxInheritanceDetails(TaxInheritanceDetails)
         */
        default Builder taxInheritanceDetails(Consumer<TaxInheritanceDetails.Builder> taxInheritanceDetails) {
            return taxInheritanceDetails(TaxInheritanceDetails.builder().applyMutation(taxInheritanceDetails).build());
        }

        /**
         * <p>
         * Your TRN information. Instead of having full legal address, here TRN information will have jurisdiction
         * details (for example, country code and state/region/province if applicable).
         * </p>
         * 
         * @param taxRegistration
         *        Your TRN information. Instead of having full legal address, here TRN information will have
         *        jurisdiction details (for example, country code and state/region/province if applicable).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taxRegistration(TaxRegistrationWithJurisdiction taxRegistration);

        /**
         * <p>
         * Your TRN information. Instead of having full legal address, here TRN information will have jurisdiction
         * details (for example, country code and state/region/province if applicable).
         * </p>
         * This is a convenience method that creates an instance of the {@link TaxRegistrationWithJurisdiction.Builder}
         * avoiding the need to create one manually via {@link TaxRegistrationWithJurisdiction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TaxRegistrationWithJurisdiction.Builder#build()} is called
         * immediately and its result is passed to {@link #taxRegistration(TaxRegistrationWithJurisdiction)}.
         * 
         * @param taxRegistration
         *        a consumer that will call methods on {@link TaxRegistrationWithJurisdiction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taxRegistration(TaxRegistrationWithJurisdiction)
         */
        default Builder taxRegistration(Consumer<TaxRegistrationWithJurisdiction.Builder> taxRegistration) {
            return taxRegistration(TaxRegistrationWithJurisdiction.builder().applyMutation(taxRegistration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private AccountMetaData accountMetaData;

        private TaxInheritanceDetails taxInheritanceDetails;

        private TaxRegistrationWithJurisdiction taxRegistration;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountDetails model) {
            accountId(model.accountId);
            accountMetaData(model.accountMetaData);
            taxInheritanceDetails(model.taxInheritanceDetails);
            taxRegistration(model.taxRegistration);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final AccountMetaData.Builder getAccountMetaData() {
            return accountMetaData != null ? accountMetaData.toBuilder() : null;
        }

        public final void setAccountMetaData(AccountMetaData.BuilderImpl accountMetaData) {
            this.accountMetaData = accountMetaData != null ? accountMetaData.build() : null;
        }

        @Override
        public final Builder accountMetaData(AccountMetaData accountMetaData) {
            this.accountMetaData = accountMetaData;
            return this;
        }

        public final TaxInheritanceDetails.Builder getTaxInheritanceDetails() {
            return taxInheritanceDetails != null ? taxInheritanceDetails.toBuilder() : null;
        }

        public final void setTaxInheritanceDetails(TaxInheritanceDetails.BuilderImpl taxInheritanceDetails) {
            this.taxInheritanceDetails = taxInheritanceDetails != null ? taxInheritanceDetails.build() : null;
        }

        @Override
        public final Builder taxInheritanceDetails(TaxInheritanceDetails taxInheritanceDetails) {
            this.taxInheritanceDetails = taxInheritanceDetails;
            return this;
        }

        public final TaxRegistrationWithJurisdiction.Builder getTaxRegistration() {
            return taxRegistration != null ? taxRegistration.toBuilder() : null;
        }

        public final void setTaxRegistration(TaxRegistrationWithJurisdiction.BuilderImpl taxRegistration) {
            this.taxRegistration = taxRegistration != null ? taxRegistration.build() : null;
        }

        @Override
        public final Builder taxRegistration(TaxRegistrationWithJurisdiction taxRegistration) {
            this.taxRegistration = taxRegistration;
            return this;
        }

        @Override
        public AccountDetails build() {
            return new AccountDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
