/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The error object for representing failures in the <code>BatchDeleteTaxRegistration</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDeleteTaxRegistrationError implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchDeleteTaxRegistrationError.Builder, BatchDeleteTaxRegistrationError> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(BatchDeleteTaxRegistrationError::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("code")
            .getter(getter(BatchDeleteTaxRegistrationError::code)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(BatchDeleteTaxRegistrationError::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, CODE_FIELD,
            MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String code;

    private final String message;

    private BatchDeleteTaxRegistrationError(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.code = builder.code;
        this.message = builder.message;
    }

    /**
     * <p>
     * The unique account identifier for the account whose tax registration couldn't be deleted during the
     * <code>BatchDeleteTaxRegistration</code> operation.
     * </p>
     * 
     * @return The unique account identifier for the account whose tax registration couldn't be deleted during the
     *         <code>BatchDeleteTaxRegistration</code> operation.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The error code for an individual failure in BatchDeleteTaxRegistration operation.
     * </p>
     * 
     * @return The error code for an individual failure in BatchDeleteTaxRegistration operation.
     */
    public final String code() {
        return code;
    }

    /**
     * <p>
     * The error message for an individual failure in the <code>BatchDeleteTaxRegistration</code> operation.
     * </p>
     * 
     * @return The error message for an individual failure in the <code>BatchDeleteTaxRegistration</code> operation.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteTaxRegistrationError)) {
            return false;
        }
        BatchDeleteTaxRegistrationError other = (BatchDeleteTaxRegistrationError) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(code(), other.code())
                && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDeleteTaxRegistrationError").add("AccountId", accountId()).add("Code", code())
                .add("Message", message() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "code":
            return Optional.ofNullable(clazz.cast(code()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("code", CODE_FIELD);
        map.put("message", MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteTaxRegistrationError, T> g) {
        return obj -> g.apply((BatchDeleteTaxRegistrationError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchDeleteTaxRegistrationError> {
        /**
         * <p>
         * The unique account identifier for the account whose tax registration couldn't be deleted during the
         * <code>BatchDeleteTaxRegistration</code> operation.
         * </p>
         * 
         * @param accountId
         *        The unique account identifier for the account whose tax registration couldn't be deleted during the
         *        <code>BatchDeleteTaxRegistration</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The error code for an individual failure in BatchDeleteTaxRegistration operation.
         * </p>
         * 
         * @param code
         *        The error code for an individual failure in BatchDeleteTaxRegistration operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        /**
         * <p>
         * The error message for an individual failure in the <code>BatchDeleteTaxRegistration</code> operation.
         * </p>
         * 
         * @param message
         *        The error message for an individual failure in the <code>BatchDeleteTaxRegistration</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String code;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteTaxRegistrationError model) {
            accountId(model.accountId);
            code(model.code);
            message(model.message);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BatchDeleteTaxRegistrationError build() {
            return new BatchDeleteTaxRegistrationError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
