/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTaxRegistrationDocumentResponse extends TaxSettingsResponse implements
        ToCopyableBuilder<GetTaxRegistrationDocumentResponse.Builder, GetTaxRegistrationDocumentResponse> {
    private static final SdkField<String> DESTINATION_FILE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationFilePath").getter(getter(GetTaxRegistrationDocumentResponse::destinationFilePath))
            .setter(setter(Builder::destinationFilePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationFilePath").build())
            .build();

    private static final SdkField<String> PRESIGNED_S3_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("presignedS3Url").getter(getter(GetTaxRegistrationDocumentResponse::presignedS3Url))
            .setter(setter(Builder::presignedS3Url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("presignedS3Url").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_FILE_PATH_FIELD,
            PRESIGNED_S3_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String destinationFilePath;

    private final String presignedS3Url;

    private GetTaxRegistrationDocumentResponse(BuilderImpl builder) {
        super(builder);
        this.destinationFilePath = builder.destinationFilePath;
        this.presignedS3Url = builder.presignedS3Url;
    }

    /**
     * <p>
     * The file path of the Amazon S3 bucket where you want to download your tax document to.
     * </p>
     * 
     * @return The file path of the Amazon S3 bucket where you want to download your tax document to.
     */
    public final String destinationFilePath() {
        return destinationFilePath;
    }

    /**
     * <p>
     * The Amazon S3 presigned URL of the tax registration document.
     * </p>
     * 
     * @return The Amazon S3 presigned URL of the tax registration document.
     */
    public final String presignedS3Url() {
        return presignedS3Url;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(destinationFilePath());
        hashCode = 31 * hashCode + Objects.hashCode(presignedS3Url());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTaxRegistrationDocumentResponse)) {
            return false;
        }
        GetTaxRegistrationDocumentResponse other = (GetTaxRegistrationDocumentResponse) obj;
        return Objects.equals(destinationFilePath(), other.destinationFilePath())
                && Objects.equals(presignedS3Url(), other.presignedS3Url());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTaxRegistrationDocumentResponse").add("DestinationFilePath", destinationFilePath())
                .add("PresignedS3Url", presignedS3Url()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "destinationFilePath":
            return Optional.ofNullable(clazz.cast(destinationFilePath()));
        case "presignedS3Url":
            return Optional.ofNullable(clazz.cast(presignedS3Url()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("destinationFilePath", DESTINATION_FILE_PATH_FIELD);
        map.put("presignedS3Url", PRESIGNED_S3_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTaxRegistrationDocumentResponse, T> g) {
        return obj -> g.apply((GetTaxRegistrationDocumentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TaxSettingsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetTaxRegistrationDocumentResponse> {
        /**
         * <p>
         * The file path of the Amazon S3 bucket where you want to download your tax document to.
         * </p>
         * 
         * @param destinationFilePath
         *        The file path of the Amazon S3 bucket where you want to download your tax document to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationFilePath(String destinationFilePath);

        /**
         * <p>
         * The Amazon S3 presigned URL of the tax registration document.
         * </p>
         * 
         * @param presignedS3Url
         *        The Amazon S3 presigned URL of the tax registration document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder presignedS3Url(String presignedS3Url);
    }

    static final class BuilderImpl extends TaxSettingsResponse.BuilderImpl implements Builder {
        private String destinationFilePath;

        private String presignedS3Url;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTaxRegistrationDocumentResponse model) {
            super(model);
            destinationFilePath(model.destinationFilePath);
            presignedS3Url(model.presignedS3Url);
        }

        public final String getDestinationFilePath() {
            return destinationFilePath;
        }

        public final void setDestinationFilePath(String destinationFilePath) {
            this.destinationFilePath = destinationFilePath;
        }

        @Override
        public final Builder destinationFilePath(String destinationFilePath) {
            this.destinationFilePath = destinationFilePath;
            return this;
        }

        public final String getPresignedS3Url() {
            return presignedS3Url;
        }

        public final void setPresignedS3Url(String presignedS3Url) {
            this.presignedS3Url = presignedS3Url;
        }

        @Override
        public final Builder presignedS3Url(String presignedS3Url) {
            this.presignedS3Url = presignedS3Url;
            return this;
        }

        @Override
        public GetTaxRegistrationDocumentResponse build() {
            return new GetTaxRegistrationDocumentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
