/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Additional tax information associated with your TRN in Italy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ItalyAdditionalInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<ItalyAdditionalInfo.Builder, ItalyAdditionalInfo> {
    private static final SdkField<String> CIG_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cigNumber").getter(getter(ItalyAdditionalInfo::cigNumber)).setter(setter(Builder::cigNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cigNumber").build()).build();

    private static final SdkField<String> CUP_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cupNumber").getter(getter(ItalyAdditionalInfo::cupNumber)).setter(setter(Builder::cupNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cupNumber").build()).build();

    private static final SdkField<String> SDI_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sdiAccountId").getter(getter(ItalyAdditionalInfo::sdiAccountId)).setter(setter(Builder::sdiAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sdiAccountId").build()).build();

    private static final SdkField<String> TAX_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taxCode").getter(getter(ItalyAdditionalInfo::taxCode)).setter(setter(Builder::taxCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taxCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIG_NUMBER_FIELD,
            CUP_NUMBER_FIELD, SDI_ACCOUNT_ID_FIELD, TAX_CODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String cigNumber;

    private final String cupNumber;

    private final String sdiAccountId;

    private final String taxCode;

    private ItalyAdditionalInfo(BuilderImpl builder) {
        this.cigNumber = builder.cigNumber;
        this.cupNumber = builder.cupNumber;
        this.sdiAccountId = builder.sdiAccountId;
        this.taxCode = builder.taxCode;
    }

    /**
     * <p>
     * The tender procedure identification code.
     * </p>
     * 
     * @return The tender procedure identification code.
     */
    public final String cigNumber() {
        return cigNumber;
    }

    /**
     * <p>
     * Additional tax information to specify for a TRN in Italy. This is managed by the Interministerial Committee for
     * Economic Planning (CIPE) which characterizes every public investment project (Individual Project Code).
     * </p>
     * 
     * @return Additional tax information to specify for a TRN in Italy. This is managed by the Interministerial
     *         Committee for Economic Planning (CIPE) which characterizes every public investment project (Individual
     *         Project Code).
     */
    public final String cupNumber() {
        return cupNumber;
    }

    /**
     * <p>
     * Additional tax information to specify for a TRN in Italy. Use CodiceDestinatario to receive your invoices via web
     * service (API) or FTP.
     * </p>
     * 
     * @return Additional tax information to specify for a TRN in Italy. Use CodiceDestinatario to receive your invoices
     *         via web service (API) or FTP.
     */
    public final String sdiAccountId() {
        return sdiAccountId;
    }

    /**
     * <p>
     * List of service tax codes for your TRN in Italy. You can use your customer tax code as part of a VAT Group.
     * </p>
     * 
     * @return List of service tax codes for your TRN in Italy. You can use your customer tax code as part of a VAT
     *         Group.
     */
    public final String taxCode() {
        return taxCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cigNumber());
        hashCode = 31 * hashCode + Objects.hashCode(cupNumber());
        hashCode = 31 * hashCode + Objects.hashCode(sdiAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(taxCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ItalyAdditionalInfo)) {
            return false;
        }
        ItalyAdditionalInfo other = (ItalyAdditionalInfo) obj;
        return Objects.equals(cigNumber(), other.cigNumber()) && Objects.equals(cupNumber(), other.cupNumber())
                && Objects.equals(sdiAccountId(), other.sdiAccountId()) && Objects.equals(taxCode(), other.taxCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ItalyAdditionalInfo").add("CigNumber", cigNumber()).add("CupNumber", cupNumber())
                .add("SdiAccountId", sdiAccountId()).add("TaxCode", taxCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cigNumber":
            return Optional.ofNullable(clazz.cast(cigNumber()));
        case "cupNumber":
            return Optional.ofNullable(clazz.cast(cupNumber()));
        case "sdiAccountId":
            return Optional.ofNullable(clazz.cast(sdiAccountId()));
        case "taxCode":
            return Optional.ofNullable(clazz.cast(taxCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cigNumber", CIG_NUMBER_FIELD);
        map.put("cupNumber", CUP_NUMBER_FIELD);
        map.put("sdiAccountId", SDI_ACCOUNT_ID_FIELD);
        map.put("taxCode", TAX_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ItalyAdditionalInfo, T> g) {
        return obj -> g.apply((ItalyAdditionalInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ItalyAdditionalInfo> {
        /**
         * <p>
         * The tender procedure identification code.
         * </p>
         * 
         * @param cigNumber
         *        The tender procedure identification code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cigNumber(String cigNumber);

        /**
         * <p>
         * Additional tax information to specify for a TRN in Italy. This is managed by the Interministerial Committee
         * for Economic Planning (CIPE) which characterizes every public investment project (Individual Project Code).
         * </p>
         * 
         * @param cupNumber
         *        Additional tax information to specify for a TRN in Italy. This is managed by the Interministerial
         *        Committee for Economic Planning (CIPE) which characterizes every public investment project (Individual
         *        Project Code).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cupNumber(String cupNumber);

        /**
         * <p>
         * Additional tax information to specify for a TRN in Italy. Use CodiceDestinatario to receive your invoices via
         * web service (API) or FTP.
         * </p>
         * 
         * @param sdiAccountId
         *        Additional tax information to specify for a TRN in Italy. Use CodiceDestinatario to receive your
         *        invoices via web service (API) or FTP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sdiAccountId(String sdiAccountId);

        /**
         * <p>
         * List of service tax codes for your TRN in Italy. You can use your customer tax code as part of a VAT Group.
         * </p>
         * 
         * @param taxCode
         *        List of service tax codes for your TRN in Italy. You can use your customer tax code as part of a VAT
         *        Group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taxCode(String taxCode);
    }

    static final class BuilderImpl implements Builder {
        private String cigNumber;

        private String cupNumber;

        private String sdiAccountId;

        private String taxCode;

        private BuilderImpl() {
        }

        private BuilderImpl(ItalyAdditionalInfo model) {
            cigNumber(model.cigNumber);
            cupNumber(model.cupNumber);
            sdiAccountId(model.sdiAccountId);
            taxCode(model.taxCode);
        }

        public final String getCigNumber() {
            return cigNumber;
        }

        public final void setCigNumber(String cigNumber) {
            this.cigNumber = cigNumber;
        }

        @Override
        public final Builder cigNumber(String cigNumber) {
            this.cigNumber = cigNumber;
            return this;
        }

        public final String getCupNumber() {
            return cupNumber;
        }

        public final void setCupNumber(String cupNumber) {
            this.cupNumber = cupNumber;
        }

        @Override
        public final Builder cupNumber(String cupNumber) {
            this.cupNumber = cupNumber;
            return this;
        }

        public final String getSdiAccountId() {
            return sdiAccountId;
        }

        public final void setSdiAccountId(String sdiAccountId) {
            this.sdiAccountId = sdiAccountId;
        }

        @Override
        public final Builder sdiAccountId(String sdiAccountId) {
            this.sdiAccountId = sdiAccountId;
            return this;
        }

        public final String getTaxCode() {
            return taxCode;
        }

        public final void setTaxCode(String taxCode) {
            this.taxCode = taxCode;
        }

        @Override
        public final Builder taxCode(String taxCode) {
            this.taxCode = taxCode;
            return this;
        }

        @Override
        public ItalyAdditionalInfo build() {
            return new ItalyAdditionalInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
