/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSupplementalTaxRegistrationsResponse extends TaxSettingsResponse implements
        ToCopyableBuilder<ListSupplementalTaxRegistrationsResponse.Builder, ListSupplementalTaxRegistrationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListSupplementalTaxRegistrationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<SupplementalTaxRegistration>> TAX_REGISTRATIONS_FIELD = SdkField
            .<List<SupplementalTaxRegistration>> builder(MarshallingType.LIST)
            .memberName("taxRegistrations")
            .getter(getter(ListSupplementalTaxRegistrationsResponse::taxRegistrations))
            .setter(setter(Builder::taxRegistrations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taxRegistrations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SupplementalTaxRegistration> builder(MarshallingType.SDK_POJO)
                                            .constructor(SupplementalTaxRegistration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            TAX_REGISTRATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<SupplementalTaxRegistration> taxRegistrations;

    private ListSupplementalTaxRegistrationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.taxRegistrations = builder.taxRegistrations;
    }

    /**
     * <p>
     * The token to retrieve the next set of results.
     * </p>
     * 
     * @return The token to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TaxRegistrations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTaxRegistrations() {
        return taxRegistrations != null && !(taxRegistrations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of supplemental tax registrations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTaxRegistrations} method.
     * </p>
     * 
     * @return The list of supplemental tax registrations.
     */
    public final List<SupplementalTaxRegistration> taxRegistrations() {
        return taxRegistrations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTaxRegistrations() ? taxRegistrations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSupplementalTaxRegistrationsResponse)) {
            return false;
        }
        ListSupplementalTaxRegistrationsResponse other = (ListSupplementalTaxRegistrationsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasTaxRegistrations() == other.hasTaxRegistrations()
                && Objects.equals(taxRegistrations(), other.taxRegistrations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSupplementalTaxRegistrationsResponse").add("NextToken", nextToken())
                .add("TaxRegistrations", taxRegistrations() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "taxRegistrations":
            return Optional.ofNullable(clazz.cast(taxRegistrations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("taxRegistrations", TAX_REGISTRATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSupplementalTaxRegistrationsResponse, T> g) {
        return obj -> g.apply((ListSupplementalTaxRegistrationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TaxSettingsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListSupplementalTaxRegistrationsResponse> {
        /**
         * <p>
         * The token to retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The list of supplemental tax registrations.
         * </p>
         * 
         * @param taxRegistrations
         *        The list of supplemental tax registrations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taxRegistrations(Collection<SupplementalTaxRegistration> taxRegistrations);

        /**
         * <p>
         * The list of supplemental tax registrations.
         * </p>
         * 
         * @param taxRegistrations
         *        The list of supplemental tax registrations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taxRegistrations(SupplementalTaxRegistration... taxRegistrations);

        /**
         * <p>
         * The list of supplemental tax registrations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.taxsettings.model.SupplementalTaxRegistration.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.taxsettings.model.SupplementalTaxRegistration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.taxsettings.model.SupplementalTaxRegistration.Builder#build()} is
         * called immediately and its result is passed to {@link #taxRegistrations(List<SupplementalTaxRegistration>)}.
         * 
         * @param taxRegistrations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.taxsettings.model.SupplementalTaxRegistration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taxRegistrations(java.util.Collection<SupplementalTaxRegistration>)
         */
        Builder taxRegistrations(Consumer<SupplementalTaxRegistration.Builder>... taxRegistrations);
    }

    static final class BuilderImpl extends TaxSettingsResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<SupplementalTaxRegistration> taxRegistrations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSupplementalTaxRegistrationsResponse model) {
            super(model);
            nextToken(model.nextToken);
            taxRegistrations(model.taxRegistrations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SupplementalTaxRegistration.Builder> getTaxRegistrations() {
            List<SupplementalTaxRegistration.Builder> result = SupplementalTaxRegistrationListCopier
                    .copyToBuilder(this.taxRegistrations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTaxRegistrations(Collection<SupplementalTaxRegistration.BuilderImpl> taxRegistrations) {
            this.taxRegistrations = SupplementalTaxRegistrationListCopier.copyFromBuilder(taxRegistrations);
        }

        @Override
        public final Builder taxRegistrations(Collection<SupplementalTaxRegistration> taxRegistrations) {
            this.taxRegistrations = SupplementalTaxRegistrationListCopier.copy(taxRegistrations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taxRegistrations(SupplementalTaxRegistration... taxRegistrations) {
            taxRegistrations(Arrays.asList(taxRegistrations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taxRegistrations(Consumer<SupplementalTaxRegistration.Builder>... taxRegistrations) {
            taxRegistrations(Stream.of(taxRegistrations).map(c -> SupplementalTaxRegistration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSupplementalTaxRegistrationsResponse build() {
            return new ListSupplementalTaxRegistrationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
