/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Tax inheritance information associated with the account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TaxInheritanceDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<TaxInheritanceDetails.Builder, TaxInheritanceDetails> {
    private static final SdkField<String> INHERITANCE_OBTAINED_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inheritanceObtainedReason").getter(getter(TaxInheritanceDetails::inheritanceObtainedReason))
            .setter(setter(Builder::inheritanceObtainedReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inheritanceObtainedReason").build())
            .build();

    private static final SdkField<String> PARENT_ENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parentEntityId").getter(getter(TaxInheritanceDetails::parentEntityId))
            .setter(setter(Builder::parentEntityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentEntityId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INHERITANCE_OBTAINED_REASON_FIELD, PARENT_ENTITY_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String inheritanceObtainedReason;

    private final String parentEntityId;

    private TaxInheritanceDetails(BuilderImpl builder) {
        this.inheritanceObtainedReason = builder.inheritanceObtainedReason;
        this.parentEntityId = builder.parentEntityId;
    }

    /**
     * <p>
     * Tax inheritance reason information associated with the account.
     * </p>
     * 
     * @return Tax inheritance reason information associated with the account.
     */
    public final String inheritanceObtainedReason() {
        return inheritanceObtainedReason;
    }

    /**
     * <p>
     * Tax inheritance parent account information associated with the account.
     * </p>
     * 
     * @return Tax inheritance parent account information associated with the account.
     */
    public final String parentEntityId() {
        return parentEntityId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inheritanceObtainedReason());
        hashCode = 31 * hashCode + Objects.hashCode(parentEntityId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaxInheritanceDetails)) {
            return false;
        }
        TaxInheritanceDetails other = (TaxInheritanceDetails) obj;
        return Objects.equals(inheritanceObtainedReason(), other.inheritanceObtainedReason())
                && Objects.equals(parentEntityId(), other.parentEntityId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TaxInheritanceDetails").add("InheritanceObtainedReason", inheritanceObtainedReason())
                .add("ParentEntityId", parentEntityId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inheritanceObtainedReason":
            return Optional.ofNullable(clazz.cast(inheritanceObtainedReason()));
        case "parentEntityId":
            return Optional.ofNullable(clazz.cast(parentEntityId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("inheritanceObtainedReason", INHERITANCE_OBTAINED_REASON_FIELD);
        map.put("parentEntityId", PARENT_ENTITY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TaxInheritanceDetails, T> g) {
        return obj -> g.apply((TaxInheritanceDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TaxInheritanceDetails> {
        /**
         * <p>
         * Tax inheritance reason information associated with the account.
         * </p>
         * 
         * @param inheritanceObtainedReason
         *        Tax inheritance reason information associated with the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inheritanceObtainedReason(String inheritanceObtainedReason);

        /**
         * <p>
         * Tax inheritance parent account information associated with the account.
         * </p>
         * 
         * @param parentEntityId
         *        Tax inheritance parent account information associated with the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentEntityId(String parentEntityId);
    }

    static final class BuilderImpl implements Builder {
        private String inheritanceObtainedReason;

        private String parentEntityId;

        private BuilderImpl() {
        }

        private BuilderImpl(TaxInheritanceDetails model) {
            inheritanceObtainedReason(model.inheritanceObtainedReason);
            parentEntityId(model.parentEntityId);
        }

        public final String getInheritanceObtainedReason() {
            return inheritanceObtainedReason;
        }

        public final void setInheritanceObtainedReason(String inheritanceObtainedReason) {
            this.inheritanceObtainedReason = inheritanceObtainedReason;
        }

        @Override
        public final Builder inheritanceObtainedReason(String inheritanceObtainedReason) {
            this.inheritanceObtainedReason = inheritanceObtainedReason;
            return this;
        }

        public final String getParentEntityId() {
            return parentEntityId;
        }

        public final void setParentEntityId(String parentEntityId) {
            this.parentEntityId = parentEntityId;
        }

        @Override
        public final Builder parentEntityId(String parentEntityId) {
            this.parentEntityId = parentEntityId;
            return this;
        }

        @Override
        public TaxInheritanceDetails build() {
            return new TaxInheritanceDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
