/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Your TRN information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TaxRegistration implements SdkPojo, Serializable, ToCopyableBuilder<TaxRegistration.Builder, TaxRegistration> {
    private static final SdkField<AdditionalInfoResponse> ADDITIONAL_TAX_INFORMATION_FIELD = SdkField
            .<AdditionalInfoResponse> builder(MarshallingType.SDK_POJO).memberName("additionalTaxInformation")
            .getter(getter(TaxRegistration::additionalTaxInformation)).setter(setter(Builder::additionalTaxInformation))
            .constructor(AdditionalInfoResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalTaxInformation").build())
            .build();

    private static final SdkField<String> CERTIFIED_EMAIL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("certifiedEmailId").getter(getter(TaxRegistration::certifiedEmailId))
            .setter(setter(Builder::certifiedEmailId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certifiedEmailId").build()).build();

    private static final SdkField<Address> LEGAL_ADDRESS_FIELD = SdkField.<Address> builder(MarshallingType.SDK_POJO)
            .memberName("legalAddress").getter(getter(TaxRegistration::legalAddress)).setter(setter(Builder::legalAddress))
            .constructor(Address::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("legalAddress").build()).build();

    private static final SdkField<String> LEGAL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("legalName").getter(getter(TaxRegistration::legalName)).setter(setter(Builder::legalName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("legalName").build()).build();

    private static final SdkField<String> REGISTRATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registrationId").getter(getter(TaxRegistration::registrationId)).setter(setter(Builder::registrationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registrationId").build()).build();

    private static final SdkField<String> REGISTRATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registrationType").getter(getter(TaxRegistration::registrationTypeAsString))
            .setter(setter(Builder::registrationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registrationType").build()).build();

    private static final SdkField<String> SECTOR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("sector")
            .getter(getter(TaxRegistration::sectorAsString)).setter(setter(Builder::sector))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sector").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(TaxRegistration::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<List<TaxDocumentMetadata>> TAX_DOCUMENT_METADATAS_FIELD = SdkField
            .<List<TaxDocumentMetadata>> builder(MarshallingType.LIST)
            .memberName("taxDocumentMetadatas")
            .getter(getter(TaxRegistration::taxDocumentMetadatas))
            .setter(setter(Builder::taxDocumentMetadatas))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taxDocumentMetadatas").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TaxDocumentMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(TaxDocumentMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ADDITIONAL_TAX_INFORMATION_FIELD, CERTIFIED_EMAIL_ID_FIELD, LEGAL_ADDRESS_FIELD, LEGAL_NAME_FIELD,
            REGISTRATION_ID_FIELD, REGISTRATION_TYPE_FIELD, SECTOR_FIELD, STATUS_FIELD, TAX_DOCUMENT_METADATAS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AdditionalInfoResponse additionalTaxInformation;

    private final String certifiedEmailId;

    private final Address legalAddress;

    private final String legalName;

    private final String registrationId;

    private final String registrationType;

    private final String sector;

    private final String status;

    private final List<TaxDocumentMetadata> taxDocumentMetadatas;

    private TaxRegistration(BuilderImpl builder) {
        this.additionalTaxInformation = builder.additionalTaxInformation;
        this.certifiedEmailId = builder.certifiedEmailId;
        this.legalAddress = builder.legalAddress;
        this.legalName = builder.legalName;
        this.registrationId = builder.registrationId;
        this.registrationType = builder.registrationType;
        this.sector = builder.sector;
        this.status = builder.status;
        this.taxDocumentMetadatas = builder.taxDocumentMetadatas;
    }

    /**
     * <p>
     * Additional tax information associated with your TRN.
     * </p>
     * 
     * @return Additional tax information associated with your TRN.
     */
    public final AdditionalInfoResponse additionalTaxInformation() {
        return additionalTaxInformation;
    }

    /**
     * <p>
     * The email address to receive VAT invoices.
     * </p>
     * 
     * @return The email address to receive VAT invoices.
     */
    public final String certifiedEmailId() {
        return certifiedEmailId;
    }

    /**
     * <p>
     * The legal address associated with your TRN registration.
     * </p>
     * 
     * @return The legal address associated with your TRN registration.
     */
    public final Address legalAddress() {
        return legalAddress;
    }

    /**
     * <p>
     * The legal name associated with your TRN registration.
     * </p>
     * 
     * @return The legal name associated with your TRN registration.
     */
    public final String legalName() {
        return legalName;
    }

    /**
     * <p>
     * Your tax registration unique identifier.
     * </p>
     * 
     * @return Your tax registration unique identifier.
     */
    public final String registrationId() {
        return registrationId;
    }

    /**
     * <p>
     * Type of your tax registration. This can be either <code>VAT</code> or <code>GST</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #registrationType}
     * will return {@link TaxRegistrationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #registrationTypeAsString}.
     * </p>
     * 
     * @return Type of your tax registration. This can be either <code>VAT</code> or <code>GST</code>.
     * @see TaxRegistrationType
     */
    public final TaxRegistrationType registrationType() {
        return TaxRegistrationType.fromValue(registrationType);
    }

    /**
     * <p>
     * Type of your tax registration. This can be either <code>VAT</code> or <code>GST</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #registrationType}
     * will return {@link TaxRegistrationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #registrationTypeAsString}.
     * </p>
     * 
     * @return Type of your tax registration. This can be either <code>VAT</code> or <code>GST</code>.
     * @see TaxRegistrationType
     */
    public final String registrationTypeAsString() {
        return registrationType;
    }

    /**
     * <p>
     * The industry that describes your business. For business-to-business (B2B) customers, specify Business. For
     * business-to-consumer (B2C) customers, specify Individual. For business-to-government (B2G), specify Government.
     * Note that certain values may not applicable for the request country. Please refer to country specific information
     * in API document.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sector} will
     * return {@link Sector#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sectorAsString}.
     * </p>
     * 
     * @return The industry that describes your business. For business-to-business (B2B) customers, specify Business.
     *         For business-to-consumer (B2C) customers, specify Individual. For business-to-government (B2G), specify
     *         Government. Note that certain values may not applicable for the request country. Please refer to country
     *         specific information in API document.
     * @see Sector
     */
    public final Sector sector() {
        return Sector.fromValue(sector);
    }

    /**
     * <p>
     * The industry that describes your business. For business-to-business (B2B) customers, specify Business. For
     * business-to-consumer (B2C) customers, specify Individual. For business-to-government (B2G), specify Government.
     * Note that certain values may not applicable for the request country. Please refer to country specific information
     * in API document.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sector} will
     * return {@link Sector#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sectorAsString}.
     * </p>
     * 
     * @return The industry that describes your business. For business-to-business (B2B) customers, specify Business.
     *         For business-to-consumer (B2C) customers, specify Individual. For business-to-government (B2G), specify
     *         Government. Note that certain values may not applicable for the request country. Please refer to country
     *         specific information in API document.
     * @see Sector
     */
    public final String sectorAsString() {
        return sector;
    }

    /**
     * <p>
     * The status of your TRN. This can be either <code>Verified</code>, <code>Pending</code>, <code>Deleted</code>, or
     * <code>Rejected</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TaxRegistrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of your TRN. This can be either <code>Verified</code>, <code>Pending</code>,
     *         <code>Deleted</code>, or <code>Rejected</code>.
     * @see TaxRegistrationStatus
     */
    public final TaxRegistrationStatus status() {
        return TaxRegistrationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of your TRN. This can be either <code>Verified</code>, <code>Pending</code>, <code>Deleted</code>, or
     * <code>Rejected</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TaxRegistrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of your TRN. This can be either <code>Verified</code>, <code>Pending</code>,
     *         <code>Deleted</code>, or <code>Rejected</code>.
     * @see TaxRegistrationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the TaxDocumentMetadatas property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTaxDocumentMetadatas() {
        return taxDocumentMetadatas != null && !(taxDocumentMetadatas instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metadata for your tax document.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTaxDocumentMetadatas} method.
     * </p>
     * 
     * @return The metadata for your tax document.
     */
    public final List<TaxDocumentMetadata> taxDocumentMetadatas() {
        return taxDocumentMetadatas;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(additionalTaxInformation());
        hashCode = 31 * hashCode + Objects.hashCode(certifiedEmailId());
        hashCode = 31 * hashCode + Objects.hashCode(legalAddress());
        hashCode = 31 * hashCode + Objects.hashCode(legalName());
        hashCode = 31 * hashCode + Objects.hashCode(registrationId());
        hashCode = 31 * hashCode + Objects.hashCode(registrationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sectorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTaxDocumentMetadatas() ? taxDocumentMetadatas() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaxRegistration)) {
            return false;
        }
        TaxRegistration other = (TaxRegistration) obj;
        return Objects.equals(additionalTaxInformation(), other.additionalTaxInformation())
                && Objects.equals(certifiedEmailId(), other.certifiedEmailId())
                && Objects.equals(legalAddress(), other.legalAddress()) && Objects.equals(legalName(), other.legalName())
                && Objects.equals(registrationId(), other.registrationId())
                && Objects.equals(registrationTypeAsString(), other.registrationTypeAsString())
                && Objects.equals(sectorAsString(), other.sectorAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && hasTaxDocumentMetadatas() == other.hasTaxDocumentMetadatas()
                && Objects.equals(taxDocumentMetadatas(), other.taxDocumentMetadatas());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TaxRegistration").add("AdditionalTaxInformation", additionalTaxInformation())
                .add("CertifiedEmailId", certifiedEmailId()).add("LegalAddress", legalAddress()).add("LegalName", legalName())
                .add("RegistrationId", registrationId()).add("RegistrationType", registrationTypeAsString())
                .add("Sector", sectorAsString()).add("Status", statusAsString())
                .add("TaxDocumentMetadatas", hasTaxDocumentMetadatas() ? taxDocumentMetadatas() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "additionalTaxInformation":
            return Optional.ofNullable(clazz.cast(additionalTaxInformation()));
        case "certifiedEmailId":
            return Optional.ofNullable(clazz.cast(certifiedEmailId()));
        case "legalAddress":
            return Optional.ofNullable(clazz.cast(legalAddress()));
        case "legalName":
            return Optional.ofNullable(clazz.cast(legalName()));
        case "registrationId":
            return Optional.ofNullable(clazz.cast(registrationId()));
        case "registrationType":
            return Optional.ofNullable(clazz.cast(registrationTypeAsString()));
        case "sector":
            return Optional.ofNullable(clazz.cast(sectorAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "taxDocumentMetadatas":
            return Optional.ofNullable(clazz.cast(taxDocumentMetadatas()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("additionalTaxInformation", ADDITIONAL_TAX_INFORMATION_FIELD);
        map.put("certifiedEmailId", CERTIFIED_EMAIL_ID_FIELD);
        map.put("legalAddress", LEGAL_ADDRESS_FIELD);
        map.put("legalName", LEGAL_NAME_FIELD);
        map.put("registrationId", REGISTRATION_ID_FIELD);
        map.put("registrationType", REGISTRATION_TYPE_FIELD);
        map.put("sector", SECTOR_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("taxDocumentMetadatas", TAX_DOCUMENT_METADATAS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TaxRegistration, T> g) {
        return obj -> g.apply((TaxRegistration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TaxRegistration> {
        /**
         * <p>
         * Additional tax information associated with your TRN.
         * </p>
         * 
         * @param additionalTaxInformation
         *        Additional tax information associated with your TRN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalTaxInformation(AdditionalInfoResponse additionalTaxInformation);

        /**
         * <p>
         * Additional tax information associated with your TRN.
         * </p>
         * This is a convenience method that creates an instance of the {@link AdditionalInfoResponse.Builder} avoiding
         * the need to create one manually via {@link AdditionalInfoResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AdditionalInfoResponse.Builder#build()} is called immediately and
         * its result is passed to {@link #additionalTaxInformation(AdditionalInfoResponse)}.
         * 
         * @param additionalTaxInformation
         *        a consumer that will call methods on {@link AdditionalInfoResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalTaxInformation(AdditionalInfoResponse)
         */
        default Builder additionalTaxInformation(Consumer<AdditionalInfoResponse.Builder> additionalTaxInformation) {
            return additionalTaxInformation(AdditionalInfoResponse.builder().applyMutation(additionalTaxInformation).build());
        }

        /**
         * <p>
         * The email address to receive VAT invoices.
         * </p>
         * 
         * @param certifiedEmailId
         *        The email address to receive VAT invoices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certifiedEmailId(String certifiedEmailId);

        /**
         * <p>
         * The legal address associated with your TRN registration.
         * </p>
         * 
         * @param legalAddress
         *        The legal address associated with your TRN registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder legalAddress(Address legalAddress);

        /**
         * <p>
         * The legal address associated with your TRN registration.
         * </p>
         * This is a convenience method that creates an instance of the {@link Address.Builder} avoiding the need to
         * create one manually via {@link Address#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Address.Builder#build()} is called immediately and its result is
         * passed to {@link #legalAddress(Address)}.
         * 
         * @param legalAddress
         *        a consumer that will call methods on {@link Address.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #legalAddress(Address)
         */
        default Builder legalAddress(Consumer<Address.Builder> legalAddress) {
            return legalAddress(Address.builder().applyMutation(legalAddress).build());
        }

        /**
         * <p>
         * The legal name associated with your TRN registration.
         * </p>
         * 
         * @param legalName
         *        The legal name associated with your TRN registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder legalName(String legalName);

        /**
         * <p>
         * Your tax registration unique identifier.
         * </p>
         * 
         * @param registrationId
         *        Your tax registration unique identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationId(String registrationId);

        /**
         * <p>
         * Type of your tax registration. This can be either <code>VAT</code> or <code>GST</code>.
         * </p>
         * 
         * @param registrationType
         *        Type of your tax registration. This can be either <code>VAT</code> or <code>GST</code>.
         * @see TaxRegistrationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaxRegistrationType
         */
        Builder registrationType(String registrationType);

        /**
         * <p>
         * Type of your tax registration. This can be either <code>VAT</code> or <code>GST</code>.
         * </p>
         * 
         * @param registrationType
         *        Type of your tax registration. This can be either <code>VAT</code> or <code>GST</code>.
         * @see TaxRegistrationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaxRegistrationType
         */
        Builder registrationType(TaxRegistrationType registrationType);

        /**
         * <p>
         * The industry that describes your business. For business-to-business (B2B) customers, specify Business. For
         * business-to-consumer (B2C) customers, specify Individual. For business-to-government (B2G), specify
         * Government. Note that certain values may not applicable for the request country. Please refer to country
         * specific information in API document.
         * </p>
         * 
         * @param sector
         *        The industry that describes your business. For business-to-business (B2B) customers, specify Business.
         *        For business-to-consumer (B2C) customers, specify Individual. For business-to-government (B2G),
         *        specify Government. Note that certain values may not applicable for the request country. Please refer
         *        to country specific information in API document.
         * @see Sector
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Sector
         */
        Builder sector(String sector);

        /**
         * <p>
         * The industry that describes your business. For business-to-business (B2B) customers, specify Business. For
         * business-to-consumer (B2C) customers, specify Individual. For business-to-government (B2G), specify
         * Government. Note that certain values may not applicable for the request country. Please refer to country
         * specific information in API document.
         * </p>
         * 
         * @param sector
         *        The industry that describes your business. For business-to-business (B2B) customers, specify Business.
         *        For business-to-consumer (B2C) customers, specify Individual. For business-to-government (B2G),
         *        specify Government. Note that certain values may not applicable for the request country. Please refer
         *        to country specific information in API document.
         * @see Sector
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Sector
         */
        Builder sector(Sector sector);

        /**
         * <p>
         * The status of your TRN. This can be either <code>Verified</code>, <code>Pending</code>, <code>Deleted</code>,
         * or <code>Rejected</code>.
         * </p>
         * 
         * @param status
         *        The status of your TRN. This can be either <code>Verified</code>, <code>Pending</code>,
         *        <code>Deleted</code>, or <code>Rejected</code>.
         * @see TaxRegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaxRegistrationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of your TRN. This can be either <code>Verified</code>, <code>Pending</code>, <code>Deleted</code>,
         * or <code>Rejected</code>.
         * </p>
         * 
         * @param status
         *        The status of your TRN. This can be either <code>Verified</code>, <code>Pending</code>,
         *        <code>Deleted</code>, or <code>Rejected</code>.
         * @see TaxRegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaxRegistrationStatus
         */
        Builder status(TaxRegistrationStatus status);

        /**
         * <p>
         * The metadata for your tax document.
         * </p>
         * 
         * @param taxDocumentMetadatas
         *        The metadata for your tax document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taxDocumentMetadatas(Collection<TaxDocumentMetadata> taxDocumentMetadatas);

        /**
         * <p>
         * The metadata for your tax document.
         * </p>
         * 
         * @param taxDocumentMetadatas
         *        The metadata for your tax document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taxDocumentMetadatas(TaxDocumentMetadata... taxDocumentMetadatas);

        /**
         * <p>
         * The metadata for your tax document.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.taxsettings.model.TaxDocumentMetadata.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.taxsettings.model.TaxDocumentMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.taxsettings.model.TaxDocumentMetadata.Builder#build()} is called
         * immediately and its result is passed to {@link #taxDocumentMetadatas(List<TaxDocumentMetadata>)}.
         * 
         * @param taxDocumentMetadatas
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.taxsettings.model.TaxDocumentMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taxDocumentMetadatas(java.util.Collection<TaxDocumentMetadata>)
         */
        Builder taxDocumentMetadatas(Consumer<TaxDocumentMetadata.Builder>... taxDocumentMetadatas);
    }

    static final class BuilderImpl implements Builder {
        private AdditionalInfoResponse additionalTaxInformation;

        private String certifiedEmailId;

        private Address legalAddress;

        private String legalName;

        private String registrationId;

        private String registrationType;

        private String sector;

        private String status;

        private List<TaxDocumentMetadata> taxDocumentMetadatas = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TaxRegistration model) {
            additionalTaxInformation(model.additionalTaxInformation);
            certifiedEmailId(model.certifiedEmailId);
            legalAddress(model.legalAddress);
            legalName(model.legalName);
            registrationId(model.registrationId);
            registrationType(model.registrationType);
            sector(model.sector);
            status(model.status);
            taxDocumentMetadatas(model.taxDocumentMetadatas);
        }

        public final AdditionalInfoResponse.Builder getAdditionalTaxInformation() {
            return additionalTaxInformation != null ? additionalTaxInformation.toBuilder() : null;
        }

        public final void setAdditionalTaxInformation(AdditionalInfoResponse.BuilderImpl additionalTaxInformation) {
            this.additionalTaxInformation = additionalTaxInformation != null ? additionalTaxInformation.build() : null;
        }

        @Override
        public final Builder additionalTaxInformation(AdditionalInfoResponse additionalTaxInformation) {
            this.additionalTaxInformation = additionalTaxInformation;
            return this;
        }

        public final String getCertifiedEmailId() {
            return certifiedEmailId;
        }

        public final void setCertifiedEmailId(String certifiedEmailId) {
            this.certifiedEmailId = certifiedEmailId;
        }

        @Override
        public final Builder certifiedEmailId(String certifiedEmailId) {
            this.certifiedEmailId = certifiedEmailId;
            return this;
        }

        public final Address.Builder getLegalAddress() {
            return legalAddress != null ? legalAddress.toBuilder() : null;
        }

        public final void setLegalAddress(Address.BuilderImpl legalAddress) {
            this.legalAddress = legalAddress != null ? legalAddress.build() : null;
        }

        @Override
        public final Builder legalAddress(Address legalAddress) {
            this.legalAddress = legalAddress;
            return this;
        }

        public final String getLegalName() {
            return legalName;
        }

        public final void setLegalName(String legalName) {
            this.legalName = legalName;
        }

        @Override
        public final Builder legalName(String legalName) {
            this.legalName = legalName;
            return this;
        }

        public final String getRegistrationId() {
            return registrationId;
        }

        public final void setRegistrationId(String registrationId) {
            this.registrationId = registrationId;
        }

        @Override
        public final Builder registrationId(String registrationId) {
            this.registrationId = registrationId;
            return this;
        }

        public final String getRegistrationType() {
            return registrationType;
        }

        public final void setRegistrationType(String registrationType) {
            this.registrationType = registrationType;
        }

        @Override
        public final Builder registrationType(String registrationType) {
            this.registrationType = registrationType;
            return this;
        }

        @Override
        public final Builder registrationType(TaxRegistrationType registrationType) {
            this.registrationType(registrationType == null ? null : registrationType.toString());
            return this;
        }

        public final String getSector() {
            return sector;
        }

        public final void setSector(String sector) {
            this.sector = sector;
        }

        @Override
        public final Builder sector(String sector) {
            this.sector = sector;
            return this;
        }

        @Override
        public final Builder sector(Sector sector) {
            this.sector(sector == null ? null : sector.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TaxRegistrationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<TaxDocumentMetadata.Builder> getTaxDocumentMetadatas() {
            List<TaxDocumentMetadata.Builder> result = TaxDocumentMetadatasCopier.copyToBuilder(this.taxDocumentMetadatas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTaxDocumentMetadatas(Collection<TaxDocumentMetadata.BuilderImpl> taxDocumentMetadatas) {
            this.taxDocumentMetadatas = TaxDocumentMetadatasCopier.copyFromBuilder(taxDocumentMetadatas);
        }

        @Override
        public final Builder taxDocumentMetadatas(Collection<TaxDocumentMetadata> taxDocumentMetadatas) {
            this.taxDocumentMetadatas = TaxDocumentMetadatasCopier.copy(taxDocumentMetadatas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taxDocumentMetadatas(TaxDocumentMetadata... taxDocumentMetadatas) {
            taxDocumentMetadatas(Arrays.asList(taxDocumentMetadatas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taxDocumentMetadatas(Consumer<TaxDocumentMetadata.Builder>... taxDocumentMetadatas) {
            taxDocumentMetadatas(Stream.of(taxDocumentMetadatas).map(c -> TaxDocumentMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public TaxRegistration build() {
            return new TaxRegistration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
