/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The TRN information you provide when you add a new TRN, or update.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TaxRegistrationEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<TaxRegistrationEntry.Builder, TaxRegistrationEntry> {
    private static final SdkField<AdditionalInfoRequest> ADDITIONAL_TAX_INFORMATION_FIELD = SdkField
            .<AdditionalInfoRequest> builder(MarshallingType.SDK_POJO).memberName("additionalTaxInformation")
            .getter(getter(TaxRegistrationEntry::additionalTaxInformation)).setter(setter(Builder::additionalTaxInformation))
            .constructor(AdditionalInfoRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalTaxInformation").build())
            .build();

    private static final SdkField<String> CERTIFIED_EMAIL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("certifiedEmailId").getter(getter(TaxRegistrationEntry::certifiedEmailId))
            .setter(setter(Builder::certifiedEmailId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certifiedEmailId").build()).build();

    private static final SdkField<Address> LEGAL_ADDRESS_FIELD = SdkField.<Address> builder(MarshallingType.SDK_POJO)
            .memberName("legalAddress").getter(getter(TaxRegistrationEntry::legalAddress)).setter(setter(Builder::legalAddress))
            .constructor(Address::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("legalAddress").build()).build();

    private static final SdkField<String> LEGAL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("legalName").getter(getter(TaxRegistrationEntry::legalName)).setter(setter(Builder::legalName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("legalName").build()).build();

    private static final SdkField<String> REGISTRATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registrationId").getter(getter(TaxRegistrationEntry::registrationId))
            .setter(setter(Builder::registrationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registrationId").build()).build();

    private static final SdkField<String> REGISTRATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registrationType").getter(getter(TaxRegistrationEntry::registrationTypeAsString))
            .setter(setter(Builder::registrationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registrationType").build()).build();

    private static final SdkField<String> SECTOR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("sector")
            .getter(getter(TaxRegistrationEntry::sectorAsString)).setter(setter(Builder::sector))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sector").build()).build();

    private static final SdkField<VerificationDetails> VERIFICATION_DETAILS_FIELD = SdkField
            .<VerificationDetails> builder(MarshallingType.SDK_POJO).memberName("verificationDetails")
            .getter(getter(TaxRegistrationEntry::verificationDetails)).setter(setter(Builder::verificationDetails))
            .constructor(VerificationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("verificationDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ADDITIONAL_TAX_INFORMATION_FIELD, CERTIFIED_EMAIL_ID_FIELD, LEGAL_ADDRESS_FIELD, LEGAL_NAME_FIELD,
            REGISTRATION_ID_FIELD, REGISTRATION_TYPE_FIELD, SECTOR_FIELD, VERIFICATION_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AdditionalInfoRequest additionalTaxInformation;

    private final String certifiedEmailId;

    private final Address legalAddress;

    private final String legalName;

    private final String registrationId;

    private final String registrationType;

    private final String sector;

    private final VerificationDetails verificationDetails;

    private TaxRegistrationEntry(BuilderImpl builder) {
        this.additionalTaxInformation = builder.additionalTaxInformation;
        this.certifiedEmailId = builder.certifiedEmailId;
        this.legalAddress = builder.legalAddress;
        this.legalName = builder.legalName;
        this.registrationId = builder.registrationId;
        this.registrationType = builder.registrationType;
        this.sector = builder.sector;
        this.verificationDetails = builder.verificationDetails;
    }

    /**
     * <p>
     * Additional tax information associated with your TRN. You only need to specify this parameter if Amazon Web
     * Services collects any additional information for your country within <a>AdditionalInfoRequest</a>.
     * </p>
     * 
     * @return Additional tax information associated with your TRN. You only need to specify this parameter if Amazon
     *         Web Services collects any additional information for your country within <a>AdditionalInfoRequest</a>.
     */
    public final AdditionalInfoRequest additionalTaxInformation() {
        return additionalTaxInformation;
    }

    /**
     * <p>
     * The email address to receive VAT invoices.
     * </p>
     * 
     * @return The email address to receive VAT invoices.
     */
    public final String certifiedEmailId() {
        return certifiedEmailId;
    }

    /**
     * <p>
     * The legal address associated with your TRN.
     * </p>
     * <note>
     * <p>
     * If you're setting a TRN in Brazil for the CNPJ tax type, you don't need to specify the legal address.
     * </p>
     * <p>
     * For TRNs in other countries and for CPF tax types Brazil, you must specify the legal address.
     * </p>
     * </note>
     * 
     * @return The legal address associated with your TRN.</p> <note>
     *         <p>
     *         If you're setting a TRN in Brazil for the CNPJ tax type, you don't need to specify the legal address.
     *         </p>
     *         <p>
     *         For TRNs in other countries and for CPF tax types Brazil, you must specify the legal address.
     *         </p>
     */
    public final Address legalAddress() {
        return legalAddress;
    }

    /**
     * <p>
     * The legal name associated with your TRN.
     * </p>
     * <note>
     * <p>
     * If you're setting a TRN in Brazil, you don't need to specify the legal name. For TRNs in other countries, you
     * must specify the legal name.
     * </p>
     * </note>
     * 
     * @return The legal name associated with your TRN. </p> <note>
     *         <p>
     *         If you're setting a TRN in Brazil, you don't need to specify the legal name. For TRNs in other countries,
     *         you must specify the legal name.
     *         </p>
     */
    public final String legalName() {
        return legalName;
    }

    /**
     * <p>
     * Your tax registration unique identifier.
     * </p>
     * 
     * @return Your tax registration unique identifier.
     */
    public final String registrationId() {
        return registrationId;
    }

    /**
     * <p>
     * Your tax registration type. This can be either <code>VAT</code> or <code>GST</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #registrationType}
     * will return {@link TaxRegistrationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #registrationTypeAsString}.
     * </p>
     * 
     * @return Your tax registration type. This can be either <code>VAT</code> or <code>GST</code>.
     * @see TaxRegistrationType
     */
    public final TaxRegistrationType registrationType() {
        return TaxRegistrationType.fromValue(registrationType);
    }

    /**
     * <p>
     * Your tax registration type. This can be either <code>VAT</code> or <code>GST</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #registrationType}
     * will return {@link TaxRegistrationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #registrationTypeAsString}.
     * </p>
     * 
     * @return Your tax registration type. This can be either <code>VAT</code> or <code>GST</code>.
     * @see TaxRegistrationType
     */
    public final String registrationTypeAsString() {
        return registrationType;
    }

    /**
     * <p>
     * The industry that describes your business. For business-to-business (B2B) customers, specify Business. For
     * business-to-consumer (B2C) customers, specify Individual. For business-to-government (B2G), specify
     * Government.Note that certain values may not applicable for the request country. Please refer to country specific
     * information in API document.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sector} will
     * return {@link Sector#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sectorAsString}.
     * </p>
     * 
     * @return The industry that describes your business. For business-to-business (B2B) customers, specify Business.
     *         For business-to-consumer (B2C) customers, specify Individual. For business-to-government (B2G), specify
     *         Government.Note that certain values may not applicable for the request country. Please refer to country
     *         specific information in API document.
     * @see Sector
     */
    public final Sector sector() {
        return Sector.fromValue(sector);
    }

    /**
     * <p>
     * The industry that describes your business. For business-to-business (B2B) customers, specify Business. For
     * business-to-consumer (B2C) customers, specify Individual. For business-to-government (B2G), specify
     * Government.Note that certain values may not applicable for the request country. Please refer to country specific
     * information in API document.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sector} will
     * return {@link Sector#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sectorAsString}.
     * </p>
     * 
     * @return The industry that describes your business. For business-to-business (B2B) customers, specify Business.
     *         For business-to-consumer (B2C) customers, specify Individual. For business-to-government (B2G), specify
     *         Government.Note that certain values may not applicable for the request country. Please refer to country
     *         specific information in API document.
     * @see Sector
     */
    public final String sectorAsString() {
        return sector;
    }

    /**
     * <p>
     * Additional details needed to verify your TRN information in Brazil. You only need to specify this parameter when
     * you set a TRN in Brazil that is the CPF tax type.
     * </p>
     * <note>
     * <p>
     * Don't specify this parameter to set a TRN in Brazil of the CNPJ tax type or to set a TRN for another country.
     * </p>
     * </note>
     * 
     * @return Additional details needed to verify your TRN information in Brazil. You only need to specify this
     *         parameter when you set a TRN in Brazil that is the CPF tax type.</p> <note>
     *         <p>
     *         Don't specify this parameter to set a TRN in Brazil of the CNPJ tax type or to set a TRN for another
     *         country.
     *         </p>
     */
    public final VerificationDetails verificationDetails() {
        return verificationDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(additionalTaxInformation());
        hashCode = 31 * hashCode + Objects.hashCode(certifiedEmailId());
        hashCode = 31 * hashCode + Objects.hashCode(legalAddress());
        hashCode = 31 * hashCode + Objects.hashCode(legalName());
        hashCode = 31 * hashCode + Objects.hashCode(registrationId());
        hashCode = 31 * hashCode + Objects.hashCode(registrationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sectorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(verificationDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaxRegistrationEntry)) {
            return false;
        }
        TaxRegistrationEntry other = (TaxRegistrationEntry) obj;
        return Objects.equals(additionalTaxInformation(), other.additionalTaxInformation())
                && Objects.equals(certifiedEmailId(), other.certifiedEmailId())
                && Objects.equals(legalAddress(), other.legalAddress()) && Objects.equals(legalName(), other.legalName())
                && Objects.equals(registrationId(), other.registrationId())
                && Objects.equals(registrationTypeAsString(), other.registrationTypeAsString())
                && Objects.equals(sectorAsString(), other.sectorAsString())
                && Objects.equals(verificationDetails(), other.verificationDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TaxRegistrationEntry").add("AdditionalTaxInformation", additionalTaxInformation())
                .add("CertifiedEmailId", certifiedEmailId()).add("LegalAddress", legalAddress()).add("LegalName", legalName())
                .add("RegistrationId", registrationId()).add("RegistrationType", registrationTypeAsString())
                .add("Sector", sectorAsString()).add("VerificationDetails", verificationDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "additionalTaxInformation":
            return Optional.ofNullable(clazz.cast(additionalTaxInformation()));
        case "certifiedEmailId":
            return Optional.ofNullable(clazz.cast(certifiedEmailId()));
        case "legalAddress":
            return Optional.ofNullable(clazz.cast(legalAddress()));
        case "legalName":
            return Optional.ofNullable(clazz.cast(legalName()));
        case "registrationId":
            return Optional.ofNullable(clazz.cast(registrationId()));
        case "registrationType":
            return Optional.ofNullable(clazz.cast(registrationTypeAsString()));
        case "sector":
            return Optional.ofNullable(clazz.cast(sectorAsString()));
        case "verificationDetails":
            return Optional.ofNullable(clazz.cast(verificationDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("additionalTaxInformation", ADDITIONAL_TAX_INFORMATION_FIELD);
        map.put("certifiedEmailId", CERTIFIED_EMAIL_ID_FIELD);
        map.put("legalAddress", LEGAL_ADDRESS_FIELD);
        map.put("legalName", LEGAL_NAME_FIELD);
        map.put("registrationId", REGISTRATION_ID_FIELD);
        map.put("registrationType", REGISTRATION_TYPE_FIELD);
        map.put("sector", SECTOR_FIELD);
        map.put("verificationDetails", VERIFICATION_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TaxRegistrationEntry, T> g) {
        return obj -> g.apply((TaxRegistrationEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TaxRegistrationEntry> {
        /**
         * <p>
         * Additional tax information associated with your TRN. You only need to specify this parameter if Amazon Web
         * Services collects any additional information for your country within <a>AdditionalInfoRequest</a>.
         * </p>
         * 
         * @param additionalTaxInformation
         *        Additional tax information associated with your TRN. You only need to specify this parameter if Amazon
         *        Web Services collects any additional information for your country within <a>AdditionalInfoRequest</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalTaxInformation(AdditionalInfoRequest additionalTaxInformation);

        /**
         * <p>
         * Additional tax information associated with your TRN. You only need to specify this parameter if Amazon Web
         * Services collects any additional information for your country within <a>AdditionalInfoRequest</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link AdditionalInfoRequest.Builder} avoiding
         * the need to create one manually via {@link AdditionalInfoRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AdditionalInfoRequest.Builder#build()} is called immediately and
         * its result is passed to {@link #additionalTaxInformation(AdditionalInfoRequest)}.
         * 
         * @param additionalTaxInformation
         *        a consumer that will call methods on {@link AdditionalInfoRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalTaxInformation(AdditionalInfoRequest)
         */
        default Builder additionalTaxInformation(Consumer<AdditionalInfoRequest.Builder> additionalTaxInformation) {
            return additionalTaxInformation(AdditionalInfoRequest.builder().applyMutation(additionalTaxInformation).build());
        }

        /**
         * <p>
         * The email address to receive VAT invoices.
         * </p>
         * 
         * @param certifiedEmailId
         *        The email address to receive VAT invoices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certifiedEmailId(String certifiedEmailId);

        /**
         * <p>
         * The legal address associated with your TRN.
         * </p>
         * <note>
         * <p>
         * If you're setting a TRN in Brazil for the CNPJ tax type, you don't need to specify the legal address.
         * </p>
         * <p>
         * For TRNs in other countries and for CPF tax types Brazil, you must specify the legal address.
         * </p>
         * </note>
         * 
         * @param legalAddress
         *        The legal address associated with your TRN.</p> <note>
         *        <p>
         *        If you're setting a TRN in Brazil for the CNPJ tax type, you don't need to specify the legal address.
         *        </p>
         *        <p>
         *        For TRNs in other countries and for CPF tax types Brazil, you must specify the legal address.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder legalAddress(Address legalAddress);

        /**
         * <p>
         * The legal address associated with your TRN.
         * </p>
         * <note>
         * <p>
         * If you're setting a TRN in Brazil for the CNPJ tax type, you don't need to specify the legal address.
         * </p>
         * <p>
         * For TRNs in other countries and for CPF tax types Brazil, you must specify the legal address.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link Address.Builder} avoiding the
         * need to create one manually via {@link Address#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Address.Builder#build()} is called immediately and its result is
         * passed to {@link #legalAddress(Address)}.
         * 
         * @param legalAddress
         *        a consumer that will call methods on {@link Address.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #legalAddress(Address)
         */
        default Builder legalAddress(Consumer<Address.Builder> legalAddress) {
            return legalAddress(Address.builder().applyMutation(legalAddress).build());
        }

        /**
         * <p>
         * The legal name associated with your TRN.
         * </p>
         * <note>
         * <p>
         * If you're setting a TRN in Brazil, you don't need to specify the legal name. For TRNs in other countries, you
         * must specify the legal name.
         * </p>
         * </note>
         * 
         * @param legalName
         *        The legal name associated with your TRN. </p> <note>
         *        <p>
         *        If you're setting a TRN in Brazil, you don't need to specify the legal name. For TRNs in other
         *        countries, you must specify the legal name.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder legalName(String legalName);

        /**
         * <p>
         * Your tax registration unique identifier.
         * </p>
         * 
         * @param registrationId
         *        Your tax registration unique identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationId(String registrationId);

        /**
         * <p>
         * Your tax registration type. This can be either <code>VAT</code> or <code>GST</code>.
         * </p>
         * 
         * @param registrationType
         *        Your tax registration type. This can be either <code>VAT</code> or <code>GST</code>.
         * @see TaxRegistrationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaxRegistrationType
         */
        Builder registrationType(String registrationType);

        /**
         * <p>
         * Your tax registration type. This can be either <code>VAT</code> or <code>GST</code>.
         * </p>
         * 
         * @param registrationType
         *        Your tax registration type. This can be either <code>VAT</code> or <code>GST</code>.
         * @see TaxRegistrationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaxRegistrationType
         */
        Builder registrationType(TaxRegistrationType registrationType);

        /**
         * <p>
         * The industry that describes your business. For business-to-business (B2B) customers, specify Business. For
         * business-to-consumer (B2C) customers, specify Individual. For business-to-government (B2G), specify
         * Government.Note that certain values may not applicable for the request country. Please refer to country
         * specific information in API document.
         * </p>
         * 
         * @param sector
         *        The industry that describes your business. For business-to-business (B2B) customers, specify Business.
         *        For business-to-consumer (B2C) customers, specify Individual. For business-to-government (B2G),
         *        specify Government.Note that certain values may not applicable for the request country. Please refer
         *        to country specific information in API document.
         * @see Sector
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Sector
         */
        Builder sector(String sector);

        /**
         * <p>
         * The industry that describes your business. For business-to-business (B2B) customers, specify Business. For
         * business-to-consumer (B2C) customers, specify Individual. For business-to-government (B2G), specify
         * Government.Note that certain values may not applicable for the request country. Please refer to country
         * specific information in API document.
         * </p>
         * 
         * @param sector
         *        The industry that describes your business. For business-to-business (B2B) customers, specify Business.
         *        For business-to-consumer (B2C) customers, specify Individual. For business-to-government (B2G),
         *        specify Government.Note that certain values may not applicable for the request country. Please refer
         *        to country specific information in API document.
         * @see Sector
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Sector
         */
        Builder sector(Sector sector);

        /**
         * <p>
         * Additional details needed to verify your TRN information in Brazil. You only need to specify this parameter
         * when you set a TRN in Brazil that is the CPF tax type.
         * </p>
         * <note>
         * <p>
         * Don't specify this parameter to set a TRN in Brazil of the CNPJ tax type or to set a TRN for another country.
         * </p>
         * </note>
         * 
         * @param verificationDetails
         *        Additional details needed to verify your TRN information in Brazil. You only need to specify this
         *        parameter when you set a TRN in Brazil that is the CPF tax type.</p> <note>
         *        <p>
         *        Don't specify this parameter to set a TRN in Brazil of the CNPJ tax type or to set a TRN for another
         *        country.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verificationDetails(VerificationDetails verificationDetails);

        /**
         * <p>
         * Additional details needed to verify your TRN information in Brazil. You only need to specify this parameter
         * when you set a TRN in Brazil that is the CPF tax type.
         * </p>
         * <note>
         * <p>
         * Don't specify this parameter to set a TRN in Brazil of the CNPJ tax type or to set a TRN for another country.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link VerificationDetails.Builder}
         * avoiding the need to create one manually via {@link VerificationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VerificationDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #verificationDetails(VerificationDetails)}.
         * 
         * @param verificationDetails
         *        a consumer that will call methods on {@link VerificationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #verificationDetails(VerificationDetails)
         */
        default Builder verificationDetails(Consumer<VerificationDetails.Builder> verificationDetails) {
            return verificationDetails(VerificationDetails.builder().applyMutation(verificationDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AdditionalInfoRequest additionalTaxInformation;

        private String certifiedEmailId;

        private Address legalAddress;

        private String legalName;

        private String registrationId;

        private String registrationType;

        private String sector;

        private VerificationDetails verificationDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(TaxRegistrationEntry model) {
            additionalTaxInformation(model.additionalTaxInformation);
            certifiedEmailId(model.certifiedEmailId);
            legalAddress(model.legalAddress);
            legalName(model.legalName);
            registrationId(model.registrationId);
            registrationType(model.registrationType);
            sector(model.sector);
            verificationDetails(model.verificationDetails);
        }

        public final AdditionalInfoRequest.Builder getAdditionalTaxInformation() {
            return additionalTaxInformation != null ? additionalTaxInformation.toBuilder() : null;
        }

        public final void setAdditionalTaxInformation(AdditionalInfoRequest.BuilderImpl additionalTaxInformation) {
            this.additionalTaxInformation = additionalTaxInformation != null ? additionalTaxInformation.build() : null;
        }

        @Override
        public final Builder additionalTaxInformation(AdditionalInfoRequest additionalTaxInformation) {
            this.additionalTaxInformation = additionalTaxInformation;
            return this;
        }

        public final String getCertifiedEmailId() {
            return certifiedEmailId;
        }

        public final void setCertifiedEmailId(String certifiedEmailId) {
            this.certifiedEmailId = certifiedEmailId;
        }

        @Override
        public final Builder certifiedEmailId(String certifiedEmailId) {
            this.certifiedEmailId = certifiedEmailId;
            return this;
        }

        public final Address.Builder getLegalAddress() {
            return legalAddress != null ? legalAddress.toBuilder() : null;
        }

        public final void setLegalAddress(Address.BuilderImpl legalAddress) {
            this.legalAddress = legalAddress != null ? legalAddress.build() : null;
        }

        @Override
        public final Builder legalAddress(Address legalAddress) {
            this.legalAddress = legalAddress;
            return this;
        }

        public final String getLegalName() {
            return legalName;
        }

        public final void setLegalName(String legalName) {
            this.legalName = legalName;
        }

        @Override
        public final Builder legalName(String legalName) {
            this.legalName = legalName;
            return this;
        }

        public final String getRegistrationId() {
            return registrationId;
        }

        public final void setRegistrationId(String registrationId) {
            this.registrationId = registrationId;
        }

        @Override
        public final Builder registrationId(String registrationId) {
            this.registrationId = registrationId;
            return this;
        }

        public final String getRegistrationType() {
            return registrationType;
        }

        public final void setRegistrationType(String registrationType) {
            this.registrationType = registrationType;
        }

        @Override
        public final Builder registrationType(String registrationType) {
            this.registrationType = registrationType;
            return this;
        }

        @Override
        public final Builder registrationType(TaxRegistrationType registrationType) {
            this.registrationType(registrationType == null ? null : registrationType.toString());
            return this;
        }

        public final String getSector() {
            return sector;
        }

        public final void setSector(String sector) {
            this.sector = sector;
        }

        @Override
        public final Builder sector(String sector) {
            this.sector = sector;
            return this;
        }

        @Override
        public final Builder sector(Sector sector) {
            this.sector(sector == null ? null : sector.toString());
            return this;
        }

        public final VerificationDetails.Builder getVerificationDetails() {
            return verificationDetails != null ? verificationDetails.toBuilder() : null;
        }

        public final void setVerificationDetails(VerificationDetails.BuilderImpl verificationDetails) {
            this.verificationDetails = verificationDetails != null ? verificationDetails.build() : null;
        }

        @Override
        public final Builder verificationDetails(VerificationDetails verificationDetails) {
            this.verificationDetails = verificationDetails;
            return this;
        }

        @Override
        public TaxRegistrationEntry build() {
            return new TaxRegistrationEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
