/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTaxRegistrationResponse extends TaxSettingsResponse implements
        ToCopyableBuilder<GetTaxRegistrationResponse.Builder, GetTaxRegistrationResponse> {
    private static final SdkField<TaxRegistration> TAX_REGISTRATION_FIELD = SdkField
            .<TaxRegistration> builder(MarshallingType.SDK_POJO).memberName("taxRegistration")
            .getter(getter(GetTaxRegistrationResponse::taxRegistration)).setter(setter(Builder::taxRegistration))
            .constructor(TaxRegistration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taxRegistration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAX_REGISTRATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final TaxRegistration taxRegistration;

    private GetTaxRegistrationResponse(BuilderImpl builder) {
        super(builder);
        this.taxRegistration = builder.taxRegistration;
    }

    /**
     * <p>
     * TRN information of the account mentioned in the request.
     * </p>
     * 
     * @return TRN information of the account mentioned in the request.
     */
    public final TaxRegistration taxRegistration() {
        return taxRegistration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(taxRegistration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTaxRegistrationResponse)) {
            return false;
        }
        GetTaxRegistrationResponse other = (GetTaxRegistrationResponse) obj;
        return Objects.equals(taxRegistration(), other.taxRegistration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTaxRegistrationResponse")
                .add("TaxRegistration", taxRegistration() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taxRegistration":
            return Optional.ofNullable(clazz.cast(taxRegistration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("taxRegistration", TAX_REGISTRATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTaxRegistrationResponse, T> g) {
        return obj -> g.apply((GetTaxRegistrationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TaxSettingsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTaxRegistrationResponse> {
        /**
         * <p>
         * TRN information of the account mentioned in the request.
         * </p>
         * 
         * @param taxRegistration
         *        TRN information of the account mentioned in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taxRegistration(TaxRegistration taxRegistration);

        /**
         * <p>
         * TRN information of the account mentioned in the request.
         * </p>
         * This is a convenience method that creates an instance of the {@link TaxRegistration.Builder} avoiding the
         * need to create one manually via {@link TaxRegistration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TaxRegistration.Builder#build()} is called immediately and its
         * result is passed to {@link #taxRegistration(TaxRegistration)}.
         * 
         * @param taxRegistration
         *        a consumer that will call methods on {@link TaxRegistration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taxRegistration(TaxRegistration)
         */
        default Builder taxRegistration(Consumer<TaxRegistration.Builder> taxRegistration) {
            return taxRegistration(TaxRegistration.builder().applyMutation(taxRegistration).build());
        }
    }

    static final class BuilderImpl extends TaxSettingsResponse.BuilderImpl implements Builder {
        private TaxRegistration taxRegistration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTaxRegistrationResponse model) {
            super(model);
            taxRegistration(model.taxRegistration);
        }

        public final TaxRegistration.Builder getTaxRegistration() {
            return taxRegistration != null ? taxRegistration.toBuilder() : null;
        }

        public final void setTaxRegistration(TaxRegistration.BuilderImpl taxRegistration) {
            this.taxRegistration = taxRegistration != null ? taxRegistration.build() : null;
        }

        @Override
        public final Builder taxRegistration(TaxRegistration taxRegistration) {
            this.taxRegistration = taxRegistration;
            return this;
        }

        @Override
        public GetTaxRegistrationResponse build() {
            return new GetTaxRegistrationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
