/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Additional tax information in India.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IndiaAdditionalInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<IndiaAdditionalInfo.Builder, IndiaAdditionalInfo> {
    private static final SdkField<String> PAN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("pan")
            .getter(getter(IndiaAdditionalInfo::pan)).setter(setter(Builder::pan))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pan").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String pan;

    private IndiaAdditionalInfo(BuilderImpl builder) {
        this.pan = builder.pan;
    }

    /**
     * <p>
     * India pan information associated with the account.
     * </p>
     * 
     * @return India pan information associated with the account.
     */
    public final String pan() {
        return pan;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pan());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndiaAdditionalInfo)) {
            return false;
        }
        IndiaAdditionalInfo other = (IndiaAdditionalInfo) obj;
        return Objects.equals(pan(), other.pan());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IndiaAdditionalInfo").add("Pan", pan()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pan":
            return Optional.ofNullable(clazz.cast(pan()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("pan", PAN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IndiaAdditionalInfo, T> g) {
        return obj -> g.apply((IndiaAdditionalInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IndiaAdditionalInfo> {
        /**
         * <p>
         * India pan information associated with the account.
         * </p>
         * 
         * @param pan
         *        India pan information associated with the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pan(String pan);
    }

    static final class BuilderImpl implements Builder {
        private String pan;

        private BuilderImpl() {
        }

        private BuilderImpl(IndiaAdditionalInfo model) {
            pan(model.pan);
        }

        public final String getPan() {
            return pan;
        }

        public final void setPan(String pan) {
            this.pan = pan;
        }

        @Override
        public final Builder pan(String pan) {
            this.pan = pan;
            return this;
        }

        @Override
        public IndiaAdditionalInfo build() {
            return new IndiaAdditionalInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
