/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Additional tax information associated with your TRN in Spain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SpainAdditionalInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<SpainAdditionalInfo.Builder, SpainAdditionalInfo> {
    private static final SdkField<String> REGISTRATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registrationType").getter(getter(SpainAdditionalInfo::registrationTypeAsString))
            .setter(setter(Builder::registrationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registrationType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRATION_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String registrationType;

    private SpainAdditionalInfo(BuilderImpl builder) {
        this.registrationType = builder.registrationType;
    }

    /**
     * <p>
     * The registration type in Spain.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #registrationType}
     * will return {@link RegistrationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #registrationTypeAsString}.
     * </p>
     * 
     * @return The registration type in Spain.
     * @see RegistrationType
     */
    public final RegistrationType registrationType() {
        return RegistrationType.fromValue(registrationType);
    }

    /**
     * <p>
     * The registration type in Spain.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #registrationType}
     * will return {@link RegistrationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #registrationTypeAsString}.
     * </p>
     * 
     * @return The registration type in Spain.
     * @see RegistrationType
     */
    public final String registrationTypeAsString() {
        return registrationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(registrationTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpainAdditionalInfo)) {
            return false;
        }
        SpainAdditionalInfo other = (SpainAdditionalInfo) obj;
        return Objects.equals(registrationTypeAsString(), other.registrationTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SpainAdditionalInfo").add("RegistrationType", registrationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "registrationType":
            return Optional.ofNullable(clazz.cast(registrationTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("registrationType", REGISTRATION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SpainAdditionalInfo, T> g) {
        return obj -> g.apply((SpainAdditionalInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SpainAdditionalInfo> {
        /**
         * <p>
         * The registration type in Spain.
         * </p>
         * 
         * @param registrationType
         *        The registration type in Spain.
         * @see RegistrationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationType
         */
        Builder registrationType(String registrationType);

        /**
         * <p>
         * The registration type in Spain.
         * </p>
         * 
         * @param registrationType
         *        The registration type in Spain.
         * @see RegistrationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegistrationType
         */
        Builder registrationType(RegistrationType registrationType);
    }

    static final class BuilderImpl implements Builder {
        private String registrationType;

        private BuilderImpl() {
        }

        private BuilderImpl(SpainAdditionalInfo model) {
            registrationType(model.registrationType);
        }

        public final String getRegistrationType() {
            return registrationType;
        }

        public final void setRegistrationType(String registrationType) {
            this.registrationType = registrationType;
        }

        @Override
        public final Builder registrationType(String registrationType) {
            this.registrationType = registrationType;
            return this;
        }

        @Override
        public final Builder registrationType(RegistrationType registrationType) {
            this.registrationType(registrationType == null ? null : registrationType.toString());
            return this;
        }

        @Override
        public SpainAdditionalInfo build() {
            return new SpainAdditionalInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
