/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The tax exemption type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TaxExemptionType implements SdkPojo, Serializable,
        ToCopyableBuilder<TaxExemptionType.Builder, TaxExemptionType> {
    private static final SdkField<List<Authority>> APPLICABLE_JURISDICTIONS_FIELD = SdkField
            .<List<Authority>> builder(MarshallingType.LIST)
            .memberName("applicableJurisdictions")
            .getter(getter(TaxExemptionType::applicableJurisdictions))
            .setter(setter(Builder::applicableJurisdictions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicableJurisdictions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Authority> builder(MarshallingType.SDK_POJO)
                                            .constructor(Authority::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(TaxExemptionType::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(TaxExemptionType::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            APPLICABLE_JURISDICTIONS_FIELD, DESCRIPTION_FIELD, DISPLAY_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Authority> applicableJurisdictions;

    private final String description;

    private final String displayName;

    private TaxExemptionType(BuilderImpl builder) {
        this.applicableJurisdictions = builder.applicableJurisdictions;
        this.description = builder.description;
        this.displayName = builder.displayName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ApplicableJurisdictions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasApplicableJurisdictions() {
        return applicableJurisdictions != null && !(applicableJurisdictions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tax exemption's applicable jurisdictions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApplicableJurisdictions} method.
     * </p>
     * 
     * @return The tax exemption's applicable jurisdictions.
     */
    public final List<Authority> applicableJurisdictions() {
        return applicableJurisdictions;
    }

    /**
     * <p>
     * The tax exemption's type description.
     * </p>
     * 
     * @return The tax exemption's type description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The tax exemption's type display name.
     * </p>
     * 
     * @return The tax exemption's type display name.
     */
    public final String displayName() {
        return displayName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasApplicableJurisdictions() ? applicableJurisdictions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaxExemptionType)) {
            return false;
        }
        TaxExemptionType other = (TaxExemptionType) obj;
        return hasApplicableJurisdictions() == other.hasApplicableJurisdictions()
                && Objects.equals(applicableJurisdictions(), other.applicableJurisdictions())
                && Objects.equals(description(), other.description()) && Objects.equals(displayName(), other.displayName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TaxExemptionType")
                .add("ApplicableJurisdictions", hasApplicableJurisdictions() ? applicableJurisdictions() : null)
                .add("Description", description()).add("DisplayName", displayName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicableJurisdictions":
            return Optional.ofNullable(clazz.cast(applicableJurisdictions()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("applicableJurisdictions", APPLICABLE_JURISDICTIONS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TaxExemptionType, T> g) {
        return obj -> g.apply((TaxExemptionType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TaxExemptionType> {
        /**
         * <p>
         * The tax exemption's applicable jurisdictions.
         * </p>
         * 
         * @param applicableJurisdictions
         *        The tax exemption's applicable jurisdictions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicableJurisdictions(Collection<Authority> applicableJurisdictions);

        /**
         * <p>
         * The tax exemption's applicable jurisdictions.
         * </p>
         * 
         * @param applicableJurisdictions
         *        The tax exemption's applicable jurisdictions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicableJurisdictions(Authority... applicableJurisdictions);

        /**
         * <p>
         * The tax exemption's applicable jurisdictions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.taxsettings.model.Authority.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.taxsettings.model.Authority#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.taxsettings.model.Authority.Builder#build()} is called immediately and
         * its result is passed to {@link #applicableJurisdictions(List<Authority>)}.
         * 
         * @param applicableJurisdictions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.taxsettings.model.Authority.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicableJurisdictions(java.util.Collection<Authority>)
         */
        Builder applicableJurisdictions(Consumer<Authority.Builder>... applicableJurisdictions);

        /**
         * <p>
         * The tax exemption's type description.
         * </p>
         * 
         * @param description
         *        The tax exemption's type description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The tax exemption's type display name.
         * </p>
         * 
         * @param displayName
         *        The tax exemption's type display name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);
    }

    static final class BuilderImpl implements Builder {
        private List<Authority> applicableJurisdictions = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private String displayName;

        private BuilderImpl() {
        }

        private BuilderImpl(TaxExemptionType model) {
            applicableJurisdictions(model.applicableJurisdictions);
            description(model.description);
            displayName(model.displayName);
        }

        public final List<Authority.Builder> getApplicableJurisdictions() {
            List<Authority.Builder> result = AuthoritiesCopier.copyToBuilder(this.applicableJurisdictions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApplicableJurisdictions(Collection<Authority.BuilderImpl> applicableJurisdictions) {
            this.applicableJurisdictions = AuthoritiesCopier.copyFromBuilder(applicableJurisdictions);
        }

        @Override
        public final Builder applicableJurisdictions(Collection<Authority> applicableJurisdictions) {
            this.applicableJurisdictions = AuthoritiesCopier.copy(applicableJurisdictions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicableJurisdictions(Authority... applicableJurisdictions) {
            applicableJurisdictions(Arrays.asList(applicableJurisdictions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicableJurisdictions(Consumer<Authority.Builder>... applicableJurisdictions) {
            applicableJurisdictions(Stream.of(applicableJurisdictions).map(c -> Authority.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        public TaxExemptionType build() {
            return new TaxExemptionType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
