/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTaxInheritanceResponse extends TaxSettingsResponse implements
        ToCopyableBuilder<GetTaxInheritanceResponse.Builder, GetTaxInheritanceResponse> {
    private static final SdkField<String> HERITAGE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("heritageStatus").getter(getter(GetTaxInheritanceResponse::heritageStatusAsString))
            .setter(setter(Builder::heritageStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("heritageStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HERITAGE_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String heritageStatus;

    private GetTaxInheritanceResponse(BuilderImpl builder) {
        super(builder);
        this.heritageStatus = builder.heritageStatus;
    }

    /**
     * <p>
     * The tax inheritance status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #heritageStatus}
     * will return {@link HeritageStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #heritageStatusAsString}.
     * </p>
     * 
     * @return The tax inheritance status.
     * @see HeritageStatus
     */
    public final HeritageStatus heritageStatus() {
        return HeritageStatus.fromValue(heritageStatus);
    }

    /**
     * <p>
     * The tax inheritance status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #heritageStatus}
     * will return {@link HeritageStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #heritageStatusAsString}.
     * </p>
     * 
     * @return The tax inheritance status.
     * @see HeritageStatus
     */
    public final String heritageStatusAsString() {
        return heritageStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(heritageStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTaxInheritanceResponse)) {
            return false;
        }
        GetTaxInheritanceResponse other = (GetTaxInheritanceResponse) obj;
        return Objects.equals(heritageStatusAsString(), other.heritageStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTaxInheritanceResponse").add("HeritageStatus", heritageStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "heritageStatus":
            return Optional.ofNullable(clazz.cast(heritageStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("heritageStatus", HERITAGE_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTaxInheritanceResponse, T> g) {
        return obj -> g.apply((GetTaxInheritanceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TaxSettingsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTaxInheritanceResponse> {
        /**
         * <p>
         * The tax inheritance status.
         * </p>
         * 
         * @param heritageStatus
         *        The tax inheritance status.
         * @see HeritageStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HeritageStatus
         */
        Builder heritageStatus(String heritageStatus);

        /**
         * <p>
         * The tax inheritance status.
         * </p>
         * 
         * @param heritageStatus
         *        The tax inheritance status.
         * @see HeritageStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HeritageStatus
         */
        Builder heritageStatus(HeritageStatus heritageStatus);
    }

    static final class BuilderImpl extends TaxSettingsResponse.BuilderImpl implements Builder {
        private String heritageStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTaxInheritanceResponse model) {
            super(model);
            heritageStatus(model.heritageStatus);
        }

        public final String getHeritageStatus() {
            return heritageStatus;
        }

        public final void setHeritageStatus(String heritageStatus) {
            this.heritageStatus = heritageStatus;
        }

        @Override
        public final Builder heritageStatus(String heritageStatus) {
            this.heritageStatus = heritageStatus;
            return this;
        }

        @Override
        public final Builder heritageStatus(HeritageStatus heritageStatus) {
            this.heritageStatus(heritageStatus == null ? null : heritageStatus.toString());
            return this;
        }

        @Override
        public GetTaxInheritanceResponse build() {
            return new GetTaxInheritanceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
