/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Additional tax information associated with your TRN in Indonesia.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IndonesiaAdditionalInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<IndonesiaAdditionalInfo.Builder, IndonesiaAdditionalInfo> {
    private static final SdkField<String> DECISION_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("decisionNumber").getter(getter(IndonesiaAdditionalInfo::decisionNumber))
            .setter(setter(Builder::decisionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decisionNumber").build()).build();

    private static final SdkField<String> PPN_EXCEPTION_DESIGNATION_CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ppnExceptionDesignationCode")
            .getter(getter(IndonesiaAdditionalInfo::ppnExceptionDesignationCode))
            .setter(setter(Builder::ppnExceptionDesignationCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ppnExceptionDesignationCode")
                    .build()).build();

    private static final SdkField<String> TAX_REGISTRATION_NUMBER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taxRegistrationNumberType").getter(getter(IndonesiaAdditionalInfo::taxRegistrationNumberTypeAsString))
            .setter(setter(Builder::taxRegistrationNumberType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taxRegistrationNumberType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DECISION_NUMBER_FIELD,
            PPN_EXCEPTION_DESIGNATION_CODE_FIELD, TAX_REGISTRATION_NUMBER_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String decisionNumber;

    private final String ppnExceptionDesignationCode;

    private final String taxRegistrationNumberType;

    private IndonesiaAdditionalInfo(BuilderImpl builder) {
        this.decisionNumber = builder.decisionNumber;
        this.ppnExceptionDesignationCode = builder.ppnExceptionDesignationCode;
        this.taxRegistrationNumberType = builder.taxRegistrationNumberType;
    }

    /**
     * <p>
     * VAT-exempt customers have a Directorate General of Taxation (DGT) exemption letter or certificate (Surat
     * Keterangan Bebas) decision number. Non-collected VAT have a DGT letter or certificate (Surat Keterangan Tidak
     * Dipungut).
     * </p>
     * 
     * @return VAT-exempt customers have a Directorate General of Taxation (DGT) exemption letter or certificate (Surat
     *         Keterangan Bebas) decision number. Non-collected VAT have a DGT letter or certificate (Surat Keterangan
     *         Tidak Dipungut).
     */
    public final String decisionNumber() {
        return decisionNumber;
    }

    /**
     * <p>
     * Exception code if you are designated by Directorate General of Taxation (DGT) as a VAT collector, non-collected
     * VAT, or VAT-exempt customer.
     * </p>
     * 
     * @return Exception code if you are designated by Directorate General of Taxation (DGT) as a VAT collector,
     *         non-collected VAT, or VAT-exempt customer.
     */
    public final String ppnExceptionDesignationCode() {
        return ppnExceptionDesignationCode;
    }

    /**
     * <p>
     * The tax registration number type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #taxRegistrationNumberType} will return {@link IndonesiaTaxRegistrationNumberType#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #taxRegistrationNumberTypeAsString}.
     * </p>
     * 
     * @return The tax registration number type.
     * @see IndonesiaTaxRegistrationNumberType
     */
    public final IndonesiaTaxRegistrationNumberType taxRegistrationNumberType() {
        return IndonesiaTaxRegistrationNumberType.fromValue(taxRegistrationNumberType);
    }

    /**
     * <p>
     * The tax registration number type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #taxRegistrationNumberType} will return {@link IndonesiaTaxRegistrationNumberType#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #taxRegistrationNumberTypeAsString}.
     * </p>
     * 
     * @return The tax registration number type.
     * @see IndonesiaTaxRegistrationNumberType
     */
    public final String taxRegistrationNumberTypeAsString() {
        return taxRegistrationNumberType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(decisionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(ppnExceptionDesignationCode());
        hashCode = 31 * hashCode + Objects.hashCode(taxRegistrationNumberTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndonesiaAdditionalInfo)) {
            return false;
        }
        IndonesiaAdditionalInfo other = (IndonesiaAdditionalInfo) obj;
        return Objects.equals(decisionNumber(), other.decisionNumber())
                && Objects.equals(ppnExceptionDesignationCode(), other.ppnExceptionDesignationCode())
                && Objects.equals(taxRegistrationNumberTypeAsString(), other.taxRegistrationNumberTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IndonesiaAdditionalInfo").add("DecisionNumber", decisionNumber())
                .add("PpnExceptionDesignationCode", ppnExceptionDesignationCode())
                .add("TaxRegistrationNumberType", taxRegistrationNumberTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "decisionNumber":
            return Optional.ofNullable(clazz.cast(decisionNumber()));
        case "ppnExceptionDesignationCode":
            return Optional.ofNullable(clazz.cast(ppnExceptionDesignationCode()));
        case "taxRegistrationNumberType":
            return Optional.ofNullable(clazz.cast(taxRegistrationNumberTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("decisionNumber", DECISION_NUMBER_FIELD);
        map.put("ppnExceptionDesignationCode", PPN_EXCEPTION_DESIGNATION_CODE_FIELD);
        map.put("taxRegistrationNumberType", TAX_REGISTRATION_NUMBER_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IndonesiaAdditionalInfo, T> g) {
        return obj -> g.apply((IndonesiaAdditionalInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IndonesiaAdditionalInfo> {
        /**
         * <p>
         * VAT-exempt customers have a Directorate General of Taxation (DGT) exemption letter or certificate (Surat
         * Keterangan Bebas) decision number. Non-collected VAT have a DGT letter or certificate (Surat Keterangan Tidak
         * Dipungut).
         * </p>
         * 
         * @param decisionNumber
         *        VAT-exempt customers have a Directorate General of Taxation (DGT) exemption letter or certificate
         *        (Surat Keterangan Bebas) decision number. Non-collected VAT have a DGT letter or certificate (Surat
         *        Keterangan Tidak Dipungut).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decisionNumber(String decisionNumber);

        /**
         * <p>
         * Exception code if you are designated by Directorate General of Taxation (DGT) as a VAT collector,
         * non-collected VAT, or VAT-exempt customer.
         * </p>
         * 
         * @param ppnExceptionDesignationCode
         *        Exception code if you are designated by Directorate General of Taxation (DGT) as a VAT collector,
         *        non-collected VAT, or VAT-exempt customer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ppnExceptionDesignationCode(String ppnExceptionDesignationCode);

        /**
         * <p>
         * The tax registration number type.
         * </p>
         * 
         * @param taxRegistrationNumberType
         *        The tax registration number type.
         * @see IndonesiaTaxRegistrationNumberType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndonesiaTaxRegistrationNumberType
         */
        Builder taxRegistrationNumberType(String taxRegistrationNumberType);

        /**
         * <p>
         * The tax registration number type.
         * </p>
         * 
         * @param taxRegistrationNumberType
         *        The tax registration number type.
         * @see IndonesiaTaxRegistrationNumberType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndonesiaTaxRegistrationNumberType
         */
        Builder taxRegistrationNumberType(IndonesiaTaxRegistrationNumberType taxRegistrationNumberType);
    }

    static final class BuilderImpl implements Builder {
        private String decisionNumber;

        private String ppnExceptionDesignationCode;

        private String taxRegistrationNumberType;

        private BuilderImpl() {
        }

        private BuilderImpl(IndonesiaAdditionalInfo model) {
            decisionNumber(model.decisionNumber);
            ppnExceptionDesignationCode(model.ppnExceptionDesignationCode);
            taxRegistrationNumberType(model.taxRegistrationNumberType);
        }

        public final String getDecisionNumber() {
            return decisionNumber;
        }

        public final void setDecisionNumber(String decisionNumber) {
            this.decisionNumber = decisionNumber;
        }

        @Override
        public final Builder decisionNumber(String decisionNumber) {
            this.decisionNumber = decisionNumber;
            return this;
        }

        public final String getPpnExceptionDesignationCode() {
            return ppnExceptionDesignationCode;
        }

        public final void setPpnExceptionDesignationCode(String ppnExceptionDesignationCode) {
            this.ppnExceptionDesignationCode = ppnExceptionDesignationCode;
        }

        @Override
        public final Builder ppnExceptionDesignationCode(String ppnExceptionDesignationCode) {
            this.ppnExceptionDesignationCode = ppnExceptionDesignationCode;
            return this;
        }

        public final String getTaxRegistrationNumberType() {
            return taxRegistrationNumberType;
        }

        public final void setTaxRegistrationNumberType(String taxRegistrationNumberType) {
            this.taxRegistrationNumberType = taxRegistrationNumberType;
        }

        @Override
        public final Builder taxRegistrationNumberType(String taxRegistrationNumberType) {
            this.taxRegistrationNumberType = taxRegistrationNumberType;
            return this;
        }

        @Override
        public final Builder taxRegistrationNumberType(IndonesiaTaxRegistrationNumberType taxRegistrationNumberType) {
            this.taxRegistrationNumberType(taxRegistrationNumberType == null ? null : taxRegistrationNumberType.toString());
            return this;
        }

        @Override
        public IndonesiaAdditionalInfo build() {
            return new IndonesiaAdditionalInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
