/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchPutTaxRegistrationResponse extends TaxSettingsResponse implements
        ToCopyableBuilder<BatchPutTaxRegistrationResponse.Builder, BatchPutTaxRegistrationResponse> {
    private static final SdkField<List<BatchPutTaxRegistrationError>> ERRORS_FIELD = SdkField
            .<List<BatchPutTaxRegistrationError>> builder(MarshallingType.LIST)
            .memberName("errors")
            .getter(getter(BatchPutTaxRegistrationResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchPutTaxRegistrationError> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchPutTaxRegistrationError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(BatchPutTaxRegistrationResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERRORS_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<BatchPutTaxRegistrationError> errors;

    private final String status;

    private BatchPutTaxRegistrationResponse(BuilderImpl builder) {
        super(builder);
        this.errors = builder.errors;
        this.status = builder.status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of errors for the accounts the TRN information could not be added or updated to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return List of errors for the accounts the TRN information could not be added or updated to.
     */
    public final List<BatchPutTaxRegistrationError> errors() {
        return errors;
    }

    /**
     * <p>
     * The status of your TRN stored in the system after processing. Based on the validation occurring on the TRN, the
     * status can be <code>Verified</code>, <code>Pending</code> or <code>Rejected</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TaxRegistrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of your TRN stored in the system after processing. Based on the validation occurring on the
     *         TRN, the status can be <code>Verified</code>, <code>Pending</code> or <code>Rejected</code>.
     * @see TaxRegistrationStatus
     */
    public final TaxRegistrationStatus status() {
        return TaxRegistrationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of your TRN stored in the system after processing. Based on the validation occurring on the TRN, the
     * status can be <code>Verified</code>, <code>Pending</code> or <code>Rejected</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TaxRegistrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of your TRN stored in the system after processing. Based on the validation occurring on the
     *         TRN, the status can be <code>Verified</code>, <code>Pending</code> or <code>Rejected</code>.
     * @see TaxRegistrationStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPutTaxRegistrationResponse)) {
            return false;
        }
        BatchPutTaxRegistrationResponse other = (BatchPutTaxRegistrationResponse) obj;
        return hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchPutTaxRegistrationResponse").add("Errors", hasErrors() ? errors() : null)
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("errors", ERRORS_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchPutTaxRegistrationResponse, T> g) {
        return obj -> g.apply((BatchPutTaxRegistrationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TaxSettingsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchPutTaxRegistrationResponse> {
        /**
         * <p>
         * List of errors for the accounts the TRN information could not be added or updated to.
         * </p>
         * 
         * @param errors
         *        List of errors for the accounts the TRN information could not be added or updated to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<BatchPutTaxRegistrationError> errors);

        /**
         * <p>
         * List of errors for the accounts the TRN information could not be added or updated to.
         * </p>
         * 
         * @param errors
         *        List of errors for the accounts the TRN information could not be added or updated to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(BatchPutTaxRegistrationError... errors);

        /**
         * <p>
         * List of errors for the accounts the TRN information could not be added or updated to.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.taxsettings.model.BatchPutTaxRegistrationError.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.taxsettings.model.BatchPutTaxRegistrationError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.taxsettings.model.BatchPutTaxRegistrationError.Builder#build()} is
         * called immediately and its result is passed to {@link #errors(List<BatchPutTaxRegistrationError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.taxsettings.model.BatchPutTaxRegistrationError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<BatchPutTaxRegistrationError>)
         */
        Builder errors(Consumer<BatchPutTaxRegistrationError.Builder>... errors);

        /**
         * <p>
         * The status of your TRN stored in the system after processing. Based on the validation occurring on the TRN,
         * the status can be <code>Verified</code>, <code>Pending</code> or <code>Rejected</code>.
         * </p>
         * 
         * @param status
         *        The status of your TRN stored in the system after processing. Based on the validation occurring on the
         *        TRN, the status can be <code>Verified</code>, <code>Pending</code> or <code>Rejected</code>.
         * @see TaxRegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaxRegistrationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of your TRN stored in the system after processing. Based on the validation occurring on the TRN,
         * the status can be <code>Verified</code>, <code>Pending</code> or <code>Rejected</code>.
         * </p>
         * 
         * @param status
         *        The status of your TRN stored in the system after processing. Based on the validation occurring on the
         *        TRN, the status can be <code>Verified</code>, <code>Pending</code> or <code>Rejected</code>.
         * @see TaxRegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaxRegistrationStatus
         */
        Builder status(TaxRegistrationStatus status);
    }

    static final class BuilderImpl extends TaxSettingsResponse.BuilderImpl implements Builder {
        private List<BatchPutTaxRegistrationError> errors = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchPutTaxRegistrationResponse model) {
            super(model);
            errors(model.errors);
            status(model.status);
        }

        public final List<BatchPutTaxRegistrationError.Builder> getErrors() {
            List<BatchPutTaxRegistrationError.Builder> result = BatchPutTaxRegistrationErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchPutTaxRegistrationError.BuilderImpl> errors) {
            this.errors = BatchPutTaxRegistrationErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchPutTaxRegistrationError> errors) {
            this.errors = BatchPutTaxRegistrationErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchPutTaxRegistrationError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchPutTaxRegistrationError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> BatchPutTaxRegistrationError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TaxRegistrationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public BatchPutTaxRegistrationResponse build() {
            return new BatchPutTaxRegistrationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
