/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.taxsettings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Additional tax information to specify for a TRN in Vietnam.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VietnamAdditionalInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<VietnamAdditionalInfo.Builder, VietnamAdditionalInfo> {
    private static final SdkField<String> ELECTRONIC_TRANSACTION_CODE_NUMBER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("electronicTransactionCodeNumber")
            .getter(getter(VietnamAdditionalInfo::electronicTransactionCodeNumber))
            .setter(setter(Builder::electronicTransactionCodeNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("electronicTransactionCodeNumber")
                    .build()).build();

    private static final SdkField<String> ENTERPRISE_IDENTIFICATION_NUMBER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("enterpriseIdentificationNumber")
            .getter(getter(VietnamAdditionalInfo::enterpriseIdentificationNumber))
            .setter(setter(Builder::enterpriseIdentificationNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enterpriseIdentificationNumber")
                    .build()).build();

    private static final SdkField<String> PAYMENT_VOUCHER_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("paymentVoucherNumber").getter(getter(VietnamAdditionalInfo::paymentVoucherNumber))
            .setter(setter(Builder::paymentVoucherNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("paymentVoucherNumber").build())
            .build();

    private static final SdkField<String> PAYMENT_VOUCHER_NUMBER_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("paymentVoucherNumberDate").getter(getter(VietnamAdditionalInfo::paymentVoucherNumberDate))
            .setter(setter(Builder::paymentVoucherNumberDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("paymentVoucherNumberDate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ELECTRONIC_TRANSACTION_CODE_NUMBER_FIELD, ENTERPRISE_IDENTIFICATION_NUMBER_FIELD, PAYMENT_VOUCHER_NUMBER_FIELD,
            PAYMENT_VOUCHER_NUMBER_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String electronicTransactionCodeNumber;

    private final String enterpriseIdentificationNumber;

    private final String paymentVoucherNumber;

    private final String paymentVoucherNumberDate;

    private VietnamAdditionalInfo(BuilderImpl builder) {
        this.electronicTransactionCodeNumber = builder.electronicTransactionCodeNumber;
        this.enterpriseIdentificationNumber = builder.enterpriseIdentificationNumber;
        this.paymentVoucherNumber = builder.paymentVoucherNumber;
        this.paymentVoucherNumberDate = builder.paymentVoucherNumberDate;
    }

    /**
     * <p>
     * The electronic transaction code number on the tax return document. This field must be provided for successful API
     * operation.
     * </p>
     * 
     * @return The electronic transaction code number on the tax return document. This field must be provided for
     *         successful API operation.
     */
    public final String electronicTransactionCodeNumber() {
        return electronicTransactionCodeNumber;
    }

    /**
     * <p>
     * The enterprise identification number for tax registration. This field must be provided for successful API
     * operation.
     * </p>
     * 
     * @return The enterprise identification number for tax registration. This field must be provided for successful API
     *         operation.
     */
    public final String enterpriseIdentificationNumber() {
        return enterpriseIdentificationNumber;
    }

    /**
     * <p>
     * The payment voucher number on the tax return payment document. This field must be provided for successful API
     * operation.
     * </p>
     * 
     * @return The payment voucher number on the tax return payment document. This field must be provided for successful
     *         API operation.
     */
    public final String paymentVoucherNumber() {
        return paymentVoucherNumber;
    }

    /**
     * <p>
     * The date on the tax return payment document. This field must be provided for successful API operation.
     * </p>
     * 
     * @return The date on the tax return payment document. This field must be provided for successful API operation.
     */
    public final String paymentVoucherNumberDate() {
        return paymentVoucherNumberDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(electronicTransactionCodeNumber());
        hashCode = 31 * hashCode + Objects.hashCode(enterpriseIdentificationNumber());
        hashCode = 31 * hashCode + Objects.hashCode(paymentVoucherNumber());
        hashCode = 31 * hashCode + Objects.hashCode(paymentVoucherNumberDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VietnamAdditionalInfo)) {
            return false;
        }
        VietnamAdditionalInfo other = (VietnamAdditionalInfo) obj;
        return Objects.equals(electronicTransactionCodeNumber(), other.electronicTransactionCodeNumber())
                && Objects.equals(enterpriseIdentificationNumber(), other.enterpriseIdentificationNumber())
                && Objects.equals(paymentVoucherNumber(), other.paymentVoucherNumber())
                && Objects.equals(paymentVoucherNumberDate(), other.paymentVoucherNumberDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VietnamAdditionalInfo")
                .add("ElectronicTransactionCodeNumber", electronicTransactionCodeNumber())
                .add("EnterpriseIdentificationNumber", enterpriseIdentificationNumber())
                .add("PaymentVoucherNumber", paymentVoucherNumber()).add("PaymentVoucherNumberDate", paymentVoucherNumberDate())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "electronicTransactionCodeNumber":
            return Optional.ofNullable(clazz.cast(electronicTransactionCodeNumber()));
        case "enterpriseIdentificationNumber":
            return Optional.ofNullable(clazz.cast(enterpriseIdentificationNumber()));
        case "paymentVoucherNumber":
            return Optional.ofNullable(clazz.cast(paymentVoucherNumber()));
        case "paymentVoucherNumberDate":
            return Optional.ofNullable(clazz.cast(paymentVoucherNumberDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("electronicTransactionCodeNumber", ELECTRONIC_TRANSACTION_CODE_NUMBER_FIELD);
        map.put("enterpriseIdentificationNumber", ENTERPRISE_IDENTIFICATION_NUMBER_FIELD);
        map.put("paymentVoucherNumber", PAYMENT_VOUCHER_NUMBER_FIELD);
        map.put("paymentVoucherNumberDate", PAYMENT_VOUCHER_NUMBER_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VietnamAdditionalInfo, T> g) {
        return obj -> g.apply((VietnamAdditionalInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VietnamAdditionalInfo> {
        /**
         * <p>
         * The electronic transaction code number on the tax return document. This field must be provided for successful
         * API operation.
         * </p>
         * 
         * @param electronicTransactionCodeNumber
         *        The electronic transaction code number on the tax return document. This field must be provided for
         *        successful API operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder electronicTransactionCodeNumber(String electronicTransactionCodeNumber);

        /**
         * <p>
         * The enterprise identification number for tax registration. This field must be provided for successful API
         * operation.
         * </p>
         * 
         * @param enterpriseIdentificationNumber
         *        The enterprise identification number for tax registration. This field must be provided for successful
         *        API operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enterpriseIdentificationNumber(String enterpriseIdentificationNumber);

        /**
         * <p>
         * The payment voucher number on the tax return payment document. This field must be provided for successful API
         * operation.
         * </p>
         * 
         * @param paymentVoucherNumber
         *        The payment voucher number on the tax return payment document. This field must be provided for
         *        successful API operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paymentVoucherNumber(String paymentVoucherNumber);

        /**
         * <p>
         * The date on the tax return payment document. This field must be provided for successful API operation.
         * </p>
         * 
         * @param paymentVoucherNumberDate
         *        The date on the tax return payment document. This field must be provided for successful API operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paymentVoucherNumberDate(String paymentVoucherNumberDate);
    }

    static final class BuilderImpl implements Builder {
        private String electronicTransactionCodeNumber;

        private String enterpriseIdentificationNumber;

        private String paymentVoucherNumber;

        private String paymentVoucherNumberDate;

        private BuilderImpl() {
        }

        private BuilderImpl(VietnamAdditionalInfo model) {
            electronicTransactionCodeNumber(model.electronicTransactionCodeNumber);
            enterpriseIdentificationNumber(model.enterpriseIdentificationNumber);
            paymentVoucherNumber(model.paymentVoucherNumber);
            paymentVoucherNumberDate(model.paymentVoucherNumberDate);
        }

        public final String getElectronicTransactionCodeNumber() {
            return electronicTransactionCodeNumber;
        }

        public final void setElectronicTransactionCodeNumber(String electronicTransactionCodeNumber) {
            this.electronicTransactionCodeNumber = electronicTransactionCodeNumber;
        }

        @Override
        public final Builder electronicTransactionCodeNumber(String electronicTransactionCodeNumber) {
            this.electronicTransactionCodeNumber = electronicTransactionCodeNumber;
            return this;
        }

        public final String getEnterpriseIdentificationNumber() {
            return enterpriseIdentificationNumber;
        }

        public final void setEnterpriseIdentificationNumber(String enterpriseIdentificationNumber) {
            this.enterpriseIdentificationNumber = enterpriseIdentificationNumber;
        }

        @Override
        public final Builder enterpriseIdentificationNumber(String enterpriseIdentificationNumber) {
            this.enterpriseIdentificationNumber = enterpriseIdentificationNumber;
            return this;
        }

        public final String getPaymentVoucherNumber() {
            return paymentVoucherNumber;
        }

        public final void setPaymentVoucherNumber(String paymentVoucherNumber) {
            this.paymentVoucherNumber = paymentVoucherNumber;
        }

        @Override
        public final Builder paymentVoucherNumber(String paymentVoucherNumber) {
            this.paymentVoucherNumber = paymentVoucherNumber;
            return this;
        }

        public final String getPaymentVoucherNumberDate() {
            return paymentVoucherNumberDate;
        }

        public final void setPaymentVoucherNumberDate(String paymentVoucherNumberDate) {
            this.paymentVoucherNumberDate = paymentVoucherNumberDate;
        }

        @Override
        public final Builder paymentVoucherNumberDate(String paymentVoucherNumberDate) {
            this.paymentVoucherNumberDate = paymentVoucherNumberDate;
            return this;
        }

        @Override
        public VietnamAdditionalInfo build() {
            return new VietnamAdditionalInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
