/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.smoketest;

import com.google.inject.Inject;
import cucumber.api.java.en.And;
import cucumber.api.java.en.Then;
import cucumber.api.java.en.When;
import cucumber.runtime.java.guice.ScenarioScoped;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.AmazonWebServiceClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.smoketest.ReflectionUtils;
import software.amazon.awssdk.util.Classes;

@ScenarioScoped
public class AwsCucumberStepdefs {
    private AmazonWebServiceClient client;
    private String packageName;
    private Object result;
    private AmazonServiceException exception;

    @Inject
    public AwsCucumberStepdefs(AmazonWebServiceClient client) {
        this.client = client;
        this.client.setRegion(Region.US_EAST_1);
        Class httpClientClass = Classes.childClassOf(AmazonWebServiceClient.class, (Object)this.client);
        this.packageName = httpClientClass.getPackage().getName();
    }

    @When(value="^I call the \"(.*?)\" API$")
    public void whenICallTheApi(String operation) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.call(operation, null);
    }

    @When(value="^I call the \"(.*?)\" API with:$")
    public void whenICallTheApi(String operation, Map<String, String> args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.call(operation, args);
    }

    @When(value="^I attempt to call the \"(.+?)\" API with:$")
    public void whenIAttemptToCallApi(String operation, Map<String, String> args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.attemptCall(operation, args);
    }

    @Then(value="^the response should contain a \"([^\"]*)\"$")
    public void theResponseShouldContainA(String memberName) throws Throwable {
        String[] path = memberName.split("[.]");
        Object member = ReflectionUtils.getByPath(this.result, Arrays.asList(path));
        Assert.assertNotNull((Object)member);
    }

    @Then(value="^the value at \"(.*?)\" should be a list")
    public void thenTheValueAtShouldBeAList(String memberName) {
        String[] path = memberName.split("[.]");
        Object member = ReflectionUtils.getByPath(this.result, Arrays.asList(path));
        Assert.assertTrue((boolean)(member instanceof List));
    }

    @Then(value="^the value at \"(.*?)\" should be a map")
    public void thenTheValueAtShouldBeAMap(String memberName) {
        String[] path = memberName.split("[.]");
        Object member = ReflectionUtils.getByPath(this.result, Arrays.asList(path));
        Assert.assertTrue((boolean)(member instanceof Map));
    }

    @Then(value="^I expect the response error code to be \"(.+?)\"$")
    public void thenIExpectResponseErrorCode(String expected) {
        Assert.assertNotNull((Object)this.exception);
        Assert.assertTrue((boolean)(this.exception instanceof AmazonServiceException));
        String actual = this.exception.getErrorCode();
        Assert.assertEquals((String)("Error code doesn't match. Expected : " + expected + ". Actual :" + actual), (Object)expected, (Object)actual);
    }

    @And(value="^I expect the response error message to include:$")
    public void andIExpectTheResponseErrorMessageInclude(String expected) {
        Assert.assertNotNull((Object)this.exception);
        Assert.assertTrue((boolean)(this.exception instanceof AmazonServiceException));
        String actual = this.exception.getErrorMessage().toLowerCase();
        Assert.assertTrue((String)("Error message doesn't match. Expected : " + expected + ". Actual :" + actual), (boolean)actual.contains(expected.toLowerCase()));
    }

    private void attemptCall(String operation, Map<String, String> args) throws IllegalAccessException, IllegalArgumentException {
        try {
            this.call(operation, args);
        }
        catch (InvocationTargetException ite) {
            this.exception = (AmazonServiceException)ite.getCause();
        }
    }

    private void call(String operation, Map<String, String> args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        String requestClassName = this.packageName + ".model." + operation + "Request";
        String operationMethodName = operation.substring(0, 1).toLowerCase() + operation.substring(1);
        Class requestClass = ReflectionUtils.loadClass(this.getClass(), requestClassName);
        Object requestObject = ReflectionUtils.newInstance(requestClass, new Object[0]);
        if (args != null && !args.isEmpty()) {
            for (Map.Entry<String, String> entry : args.entrySet()) {
                String key = entry.getKey().substring(0, 1).toUpperCase() + entry.getKey().substring(1);
                Object value = this.convertTo(ReflectionUtils.getParameterTypes(requestObject, Arrays.asList(key)), entry.getValue());
                ReflectionUtils.setByPath(requestObject, value, Arrays.asList(key));
            }
        }
        Method method = ReflectionUtils.findMethod(this.client, operationMethodName, requestClass);
        this.result = method.invoke((Object)this.client, requestObject);
    }

    private Object convertTo(Class<?> type, String value) {
        if (type.equals(Integer.class)) {
            return Integer.valueOf(value);
        }
        if (type.equals(Boolean.class)) {
            return Boolean.valueOf(value);
        }
        if (type.equals(List.class)) {
            return Arrays.asList(value);
        }
        return value;
    }

    static class ServiceConfig {
        private String serviceInterfaceName;
        private String sourcePackageName;

        ServiceConfig() {
        }

        public String getServiceInterfaceName() {
            return this.serviceInterfaceName;
        }

        public void setServiceInterfaceName(String serviceInterfaceName) {
            this.serviceInterfaceName = serviceInterfaceName;
        }

        public String getSourcePackageName() {
            return this.sourcePackageName;
        }

        public void setSourcePackageName(String sourcePackageName) {
            this.sourcePackageName = sourcePackageName;
        }
    }
}

