/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.waiters;

import java.util.ArrayList;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterState;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
class CompositeAcceptor<OutputT, ErrorT extends RuntimeException> {
    private List<WaiterAcceptor<OutputT, ErrorT>> acceptors = new ArrayList<WaiterAcceptor<OutputT, ErrorT>>();

    CompositeAcceptor(List<WaiterAcceptor<OutputT, ErrorT>> acceptors) {
        this.acceptors = (List)Validate.paramNotNull(acceptors, (String)"acceptors");
    }

    public List<WaiterAcceptor<OutputT, ErrorT>> getAcceptors() {
        return this.acceptors;
    }

    public WaiterState accepts(OutputT response) {
        for (WaiterAcceptor<OutputT, OutputT> waiterAcceptor : this.acceptors) {
            if (!waiterAcceptor.matches(response)) continue;
            return waiterAcceptor.getState();
        }
        return WaiterState.RETRY;
    }

    public WaiterState accepts(ErrorT exception) {
        for (WaiterAcceptor<OutputT, ErrorT> acceptor : this.acceptors) {
            if (!acceptor.matches(exception)) continue;
            return acceptor.getState();
        }
        throw exception;
    }
}

