/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.waiters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.core.waiters.PollingStrategy;
import software.amazon.awssdk.core.waiters.SdkFunction;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterImpl;

@SdkProtectedApi
public class WaiterBuilder<InputT, OutputT, ErrorT extends RuntimeException> {
    private SdkFunction<InputT, OutputT> sdkFunction;
    private List<WaiterAcceptor<OutputT, ErrorT>> acceptors = new ArrayList<WaiterAcceptor<OutputT, ErrorT>>();
    private PollingStrategy defaultPollingStrategy;
    private ExecutorService executorService;

    public WaiterBuilder<InputT, OutputT, ErrorT> withSdkFunction(SdkFunction<InputT, OutputT> sdkFunction) {
        this.sdkFunction = sdkFunction;
        return this;
    }

    public WaiterBuilder<InputT, OutputT, ErrorT> withAcceptors(WaiterAcceptor<OutputT, ErrorT> ... acceptors) {
        Collections.addAll(this.acceptors, acceptors);
        return this;
    }

    public WaiterBuilder<InputT, OutputT, ErrorT> withDefaultPollingStrategy(PollingStrategy pollingStrategy) {
        this.defaultPollingStrategy = pollingStrategy;
        return this;
    }

    public WaiterBuilder<InputT, OutputT, ErrorT> withExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public List<WaiterAcceptor<OutputT, ErrorT>> getAcceptor() {
        return this.acceptors;
    }

    public SdkFunction<InputT, OutputT> getSdkFunction() {
        return this.sdkFunction;
    }

    PollingStrategy getDefaultPollingStrategy() {
        return this.defaultPollingStrategy;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public Waiter<InputT> build() {
        return new WaiterImpl(this);
    }
}

